/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.updateapplication;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.LayoutStyle;
import net.numericalchameleon.gui.dialogs.updateapplication.AppUpdateInterface;

public class AppUpdateDialog
extends JDialog {
    private final AppUpdateInterface appUpdateInterface;
    private final ResourceBundle rb;
    private JButton closeButton;
    private JButton homepageButton;
    private JButton offlineUpdateButton;
    private JButton onlineUpdateButton;

    public AppUpdateDialog(AppUpdateInterface appUpdateInterface) {
        super(appUpdateInterface.getFrame(), true);
        this.appUpdateInterface = appUpdateInterface;
        this.rb = appUpdateInterface.getResourceBundle();
        this.initComponents();
        this.setLocationRelativeTo(appUpdateInterface.getFrame());
        this.setVisible(true);
    }

    private void initComponents() {
        this.onlineUpdateButton = new JButton();
        this.offlineUpdateButton = new JButton();
        this.homepageButton = new JButton();
        this.closeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.rb.getString("GUI.General.Update"));
        this.onlineUpdateButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/earth.png")));
        this.onlineUpdateButton.setText(this.rb.getString("GUI.AppUpdater.onlineUpdate"));
        this.onlineUpdateButton.setEnabled(false);
        this.onlineUpdateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppUpdateDialog.this.onlineUpdateButtonActionPerformed(evt);
            }
        });
        this.offlineUpdateButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/disk-black.png")));
        this.offlineUpdateButton.setText(this.rb.getString("GUI.AppUpdater.offlineUpdate"));
        this.offlineUpdateButton.setEnabled(false);
        this.offlineUpdateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppUpdateDialog.this.offlineUpdateButtonActionPerformed(evt);
            }
        });
        this.homepageButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix24x24/home.png")));
        this.homepageButton.setText(this.rb.getString("GUI.AppUpdater.homepage"));
        this.homepageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppUpdateDialog.this.homepageButtonActionPerformed(evt);
            }
        });
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/close.png")));
        this.closeButton.setText(this.rb.getString("GUI.General.Close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppUpdateDialog.this.closeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.onlineUpdateButton, -1, -1, Short.MAX_VALUE).addComponent(this.offlineUpdateButton, -1, 300, Short.MAX_VALUE).addComponent(this.homepageButton, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.closeButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.onlineUpdateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.offlineUpdateButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.homepageButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 102, Short.MAX_VALUE).addComponent(this.closeButton).addContainerGap()));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void callUpdater(String[] jvmOptions, String jarfile, String[] progargs) throws Exception {
        URL[] urls = new URL[]{new File(jarfile).toURI().toURL()};
        URLClassLoader child = new URLClassLoader(urls, this.getClass().getClassLoader());
        Class<?> classToLoad = Class.forName("net.numericalchameleon.updater.Tools", true, child);
        Class[] declaredParams = new Class[]{String[].class, String.class, String[].class};
        Method method = classToLoad.getDeclaredMethod("startJarApplication", declaredParams);
        Object[] invokeParams = new Object[]{jvmOptions, jarfile, progargs};
        method.invoke(classToLoad.newInstance(), invokeParams);
    }

    private void onlineUpdateButtonActionPerformed(ActionEvent evt) {
        this.appUpdateInterface.saveWork();
        this.appUpdateInterface.dontPanic();
        this.appUpdateInterface.prepareHardExit();
        try {
            String[] jvmOptions = new String[]{"-Xmx16m"};
            String[] args = new String[]{"http://localhost/update.properties"};
            this.callUpdater(jvmOptions, "updater.jar", args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.appUpdateInterface.hardExit();
    }

    private void offlineUpdateButtonActionPerformed(ActionEvent evt) {
    }

    private void homepageButtonActionPerformed(ActionEvent evt) {
        this.appUpdateInterface.goToWebPage("download.html");
    }
}

