/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.listgenerator;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jonelo.sugar.gui.GeneralGUI;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.gui.common.interfaces.DialogInterface;
import net.numericalchameleon.gui.dialogs.listgenerator.ListGeneratorCluster;
import net.numericalchameleon.util.calendarlistformats.DtcmListFormat;
import net.numericalchameleon.util.calendarlistformats.ICalendarListFormat;
import net.numericalchameleon.util.calendarlistformats.OutlookListFormat;
import net.numericalchameleon.util.calendarlistformats.TWikiCalendarListFormat;
import net.numericalchameleon.util.calendarlistformats.VCalendarListFormat;
import net.numericalchameleon.util.calendarlistformats.XCalendarListFormat;

public class ListGeneratorDialog
extends JDialog {
    private final ListGeneratorCluster multipleNoticeCluster;
    private final ResourceBundle rb;
    private JRadioButton allTargetsRadioButton;
    private ButtonGroup buttonGroup;
    private JButton cancelButton;
    private JLabel endLabel;
    private JTextField endTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JComboBox listFormatComboBox;
    private JPanel listFormatPanel;
    private JPanel listPanel;
    private JRadioButton multipleTargetsRadioButton;
    private JButton okButton;
    private JRadioButton oneTargetRadioButton;
    private JLabel startLabel;
    private JTextField startTextField;
    private JLabel stepLabel;
    private JTextField stepTextField;

    public ListGeneratorDialog(DialogInterface parent, boolean modal, ListGeneratorCluster mnc) {
        super(parent.getFrame(), modal);
        this.rb = parent.getResourceBundle();
        this.multipleNoticeCluster = mnc;
        if (parent.getFrame().isUndecorated()) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
        }
        this.initComponents();
        this.buttonGroup.add(this.oneTargetRadioButton);
        this.buttonGroup.add(this.multipleTargetsRadioButton);
        this.buttonGroup.add(this.allTargetsRadioButton);
        this.allTargetsRadioButton.setSelected(this.multipleNoticeCluster.getTargets() == 2);
        this.multipleTargetsRadioButton.setSelected(this.multipleNoticeCluster.getTargets() == 1);
        this.oneTargetRadioButton.setSelected(this.multipleNoticeCluster.getTargets() == 2);
        this.startTextField.setText(mnc.getStartValue().toString().replace('.', CategoryObject.getDecSep()));
        this.endTextField.setText(mnc.getEndValue().toString().replace('.', CategoryObject.getDecSep()));
        this.stepTextField.setText(mnc.getStepValue().toString().replace('.', CategoryObject.getDecSep()));
        if (!mnc.isListFormatVisible()) {
            this.listFormatPanel.setVisible(false);
            this.pack();
        }
        this.setLocationRelativeTo(parent.getFrame());
        ComponentOrientation ce = ComponentOrientation.getOrientation(Locale.getDefault());
        if (!ce.isLeftToRight()) {
            GeneralGUI.applyOrientation(this.listPanel, ce);
        }
        this.setVisible(true);
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.listPanel = new JPanel();
        this.jPanel4 = new JPanel();
        this.startLabel = new JLabel();
        this.endLabel = new JLabel();
        this.stepLabel = new JLabel();
        this.stepTextField = new JTextField();
        this.startTextField = new JTextField();
        this.endTextField = new JTextField();
        this.jPanel5 = new JPanel();
        this.oneTargetRadioButton = new JRadioButton();
        this.multipleTargetsRadioButton = new JRadioButton();
        this.allTargetsRadioButton = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.listFormatPanel = new JPanel();
        this.listFormatComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.setTitle(this.rb.getString("GUI.List.Title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ListGeneratorDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.listPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel4.setBorder(BorderFactory.createEtchedBorder());
        this.startLabel.setText(this.rb.getString("GUI.List.Start.Label"));
        this.endLabel.setText(this.rb.getString("GUI.List.End.Label"));
        this.stepLabel.setText(this.rb.getString("GUI.List.Step.Label"));
        this.startTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ListGeneratorDialog.this.startTextFieldKeyReleased(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stepLabel).addComponent(this.endLabel).addComponent(this.startLabel)).addGap(10, 10, 10).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stepTextField, -1, 231, Short.MAX_VALUE).addComponent(this.startTextField, -1, 231, Short.MAX_VALUE).addComponent(this.endTextField, -1, 231, Short.MAX_VALUE)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startTextField, -2, -1, -2).addComponent(this.startLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.endLabel).addComponent(this.endTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stepTextField, -2, -1, -2).addComponent(this.stepLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel5.setBorder(BorderFactory.createEtchedBorder());
        this.oneTargetRadioButton.setSelected(true);
        this.oneTargetRadioButton.setText(this.rb.getString("GUI.List.CalculateForOneTarget.Label"));
        this.oneTargetRadioButton.setToolTipText("all target units");
        this.oneTargetRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ListGeneratorDialog.this.oneTargetRadioButtonItemStateChanged(evt);
            }
        });
        this.multipleTargetsRadioButton.setText(this.rb.getString("GUI.List.CalculateForMultipleTargets.Label"));
        this.multipleTargetsRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ListGeneratorDialog.this.multipleTargetsRadioButtonItemStateChanged(evt);
            }
        });
        this.allTargetsRadioButton.setText(this.rb.getString("GUI.List.CalculateForAllTargets.Label"));
        this.allTargetsRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ListGeneratorDialog.this.allTargetsRadioButtonItemStateChanged(evt);
            }
        });
        this.jLabel1.setText(this.rb.getString("GUI.List.CalculateFor.Label"));
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.allTargetsRadioButton).addComponent(this.oneTargetRadioButton).addComponent(this.jLabel1).addComponent(this.multipleTargetsRadioButton)).addContainerGap(121, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.oneTargetRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.multipleTargetsRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.allTargetsRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.listFormatPanel.setBorder(BorderFactory.createEtchedBorder());
        this.listFormatComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Default", "iCalendar (RFC 5545)", "dtcm (CDE)", "Outlook", "vCalendar", "xCal", "TWiki/Foswiki Calendar"}));
        this.jLabel2.setText(this.rb.getString("GUI.List.Format.Label"));
        GroupLayout listFormatPanelLayout = new GroupLayout(this.listFormatPanel);
        this.listFormatPanel.setLayout(listFormatPanelLayout);
        listFormatPanelLayout.setHorizontalGroup(listFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(listFormatPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.listFormatComboBox, 0, 225, Short.MAX_VALUE).addContainerGap()));
        listFormatPanelLayout.setVerticalGroup(listFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(listFormatPanelLayout.createSequentialGroup().addContainerGap().addGroup(listFormatPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.listFormatComboBox, -2, -1, -2).addComponent(this.jLabel2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/close.png")));
        this.cancelButton.setText(this.rb.getString("GUI.General.Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListGeneratorDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/ok.png")));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListGeneratorDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout listPanelLayout = new GroupLayout(this.listPanel);
        this.listPanel.setLayout(listPanelLayout);
        listPanelLayout.setHorizontalGroup(listPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(listPanelLayout.createSequentialGroup().addContainerGap(166, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.jPanel4, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.listFormatPanel, -1, -1, Short.MAX_VALUE));
        listPanelLayout.setVerticalGroup(listPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(listPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.listFormatPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(listPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.listPanel, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.listPanel, -1, -1, Short.MAX_VALUE));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void multipleTargetsRadioButtonItemStateChanged(ItemEvent evt) {
        this.multipleNoticeCluster.setTargets(1);
    }

    private void startTextFieldKeyReleased(KeyEvent evt) {
        this.endTextField.setText(this.startTextField.getText());
    }

    private void allTargetsRadioButtonItemStateChanged(ItemEvent evt) {
        this.multipleNoticeCluster.setTargets(2);
    }

    private void oneTargetRadioButtonItemStateChanged(ItemEvent evt) {
        this.multipleNoticeCluster.setTargets(0);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.multipleNoticeCluster.setSuccess(false);
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        try {
            this.multipleNoticeCluster.setStartValue(new BigDecimal(this.startTextField.getText().trim().replace(CategoryObject.getDecSep(), '.')));
            this.multipleNoticeCluster.setEndValue(new BigDecimal(this.endTextField.getText().trim().replace(CategoryObject.getDecSep(), '.')));
            this.multipleNoticeCluster.setStepValue(new BigDecimal(this.stepTextField.getText().trim().replace(CategoryObject.getDecSep(), '.')));
            this.multipleNoticeCluster.setSuccess(true);
            if (this.multipleNoticeCluster.isListFormatVisible()) {
                if (this.listFormatComboBox.getSelectedItem().equals("dtcm (CDE)")) {
                    this.multipleNoticeCluster.setListFormat(new DtcmListFormat());
                } else if (this.listFormatComboBox.getSelectedItem().equals("Outlook")) {
                    this.multipleNoticeCluster.setListFormat(new OutlookListFormat());
                } else if (this.listFormatComboBox.getSelectedItem().equals("vCalendar")) {
                    this.multipleNoticeCluster.setListFormat(new VCalendarListFormat());
                } else if (this.listFormatComboBox.getSelectedItem().equals("iCalendar (RFC 5545)")) {
                    this.multipleNoticeCluster.setListFormat(new ICalendarListFormat());
                } else if (this.listFormatComboBox.getSelectedItem().equals("xCal")) {
                    this.multipleNoticeCluster.setListFormat(new XCalendarListFormat());
                } else if (this.listFormatComboBox.getSelectedItem().equals("TWiki/Foswiki Calendar")) {
                    this.multipleNoticeCluster.setListFormat(new TWikiCalendarListFormat());
                } else {
                    this.multipleNoticeCluster.setListFormat(null);
                }
            }
            this.closeDialog();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Number Format Error");
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

