/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jonelo.sugar.gui.GeneralGUI;
import jonelo.sugar.gui.MyListModel;
import jonelo.sugar.gui.PropertiesMetalTheme;
import jonelo.sugar.io.GeneralIO;
import jonelo.sugar.util.GeneralProgram;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.data.i18n.ResBundleRecord;
import net.numericalchameleon.data.i18n.ResBundles;
import net.numericalchameleon.gui.common.LookAndFeel;
import net.numericalchameleon.gui.dialogs.config.ConfigDialogInterface;
import net.numericalchameleon.gui.dialogs.config.LangListRenderer;

public class ConfigDialog
extends JDialog {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    private final ResourceBundle rb;
    private final Properties userProps;
    private final Vector themesVector;
    private final List<ResBundleRecord> languageList;
    private final Frame parent;
    private final Properties backupUserProps;
    private final ConfigDialogInterface configDialogInterface;
    private LangListRenderer langListRenderer;
    private JCheckBox alwaysOnTopCheckBox;
    private JRadioButton aquaRadioButton;
    private JCheckBox askBeforeExitCheckBox;
    private JCheckBox audioNotificationCheckBox;
    private JCheckBox backupCatAndUnitCheckBox;
    private JCheckBox boldFontCheckBox;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JPanel centerPanel;
    private JPanel exitOptionsPanel;
    private JCheckBox frameDecorationCheckBox;
    private JRadioButton gtkRadioButton;
    private JLabel jLabel2;
    private JPanel jPanel2;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JRadioButton kunststoffRadioButton;
    private ButtonGroup lafButtonGroup;
    private JLabel langInfoLabel;
    private JList langList;
    private JPanel languagePanel;
    private JPanel lnfPanel;
    private JPanel lookAndFeelPanel;
    private JRadioButton macRadioButton;
    private JRadioButton metalRadioButton;
    private JRadioButton metalThemesEnabledRadioButton;
    private JRadioButton metouiaRadioButton;
    private JRadioButton motifRadioButton;
    private JRadioButton nimbusRadioButton;
    private JRadioButton nimrodRadioButton;
    private JRadioButton oceanRadioButton;
    private JButton okButton;
    private JPanel optionsPanel;
    private JTabbedPane optionsTabbedPane;
    private JRadioButton plasticRadioButton;
    private JButton restoreButton;
    private JCheckBox restoreCatAndUnitCheckBox;
    private JCheckBox showExitAnimationCheckBox;
    private JCheckBox showToolTipsCheckBox;
    private JPanel southPanel;
    private JCheckBox splashScreenCheckBox;
    private JRadioButton squarenessRadioButton;
    private JPanel startOptionsPanel;
    private JRadioButton systemRadioButton;
    private JList themesList;
    private JPanel themesPanel;
    private JScrollPane themesScrollPane;
    private JLabel toolTipDelayLabel;
    private JSlider toolTipSlider;
    private JTabbedPane uiTabbedPane;
    private JRadioButton windowsRadioButton;

    public ConfigDialog(ConfigDialogInterface configInterface) {
        super(configInterface.getFrame(), true);
        this.configDialogInterface = configInterface;
        this.rb = configInterface.getResourceBundle();
        this.parent = configInterface.getFrame();
        this.userProps = configInterface.getUserProps();
        this.backupUserProps = new Properties();
        GeneralIO.copyProperties(this.userProps, this.backupUserProps);
        if (this.parent.isUndecorated()) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
        }
        this.setTitle(this.rb.getString("GUI.Options.Title"));
        this.themesVector = this.readThemes();
        ResBundles languages = new ResBundles();
        this.languageList = languages.getList();
        this.initComponents();
        this.postInitComponents();
        String selectedTheme = this.userProps.getProperty("theme", "Default.theme");
        this.themesList.setSelectedValue(selectedTheme, true);
        if (LookAndFeel.isJavaLookAndFeel(this.userProps.getProperty("lnf", ""))) {
            this.frameDecorationCheckBox.setEnabled(true);
        } else {
            this.userProps.setProperty("decoration", "native");
        }
        this.alwaysOnTopCheckBox.setEnabled(true);
        this.audioNotificationCheckBox.setEnabled(true);
        this.boldFontCheckBox.setEnabled(true);
        ComponentOrientation componentOrientation = configInterface.getAppComponentOrientation();
        if (!componentOrientation.isLeftToRight()) {
            GeneralGUI.applyOrientation(this.centerPanel, componentOrientation);
        }
        this.updateGUIfromProps(this.userProps);
        this.setLocationRelativeTo(this.parent);
    }

    private Vector readThemes() {
        boolean debug = false;
        if (debug) {
            System.out.print("Reading Themes ... ");
        }
        try {
            String myHome = "../data/themes/";
            Vector vector = this.configDialogInterface.isJavaWebStart() ? GeneralIO.readFromJarInVector(ConfigDialog.class, "/data/themes/javawebstart.list") : GeneralIO.ls(myHome, ".theme");
            if (vector == null) {
                throw new Exception("No themes found in " + myHome);
            }
            if (debug) {
                System.out.println("OK.");
            }
            return vector;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("ERROR11: " + e.getMessage());
            return null;
        }
    }

    private void updateGUIfromProps(Properties props) {
        this.langList.setSelectedIndex(Integer.parseInt(props.getProperty("languageIndex", "1")));
        this.backupCatAndUnitCheckBox.setSelected(props.getProperty("backupCatAndUnit", FALSE).equals(TRUE));
        this.restoreCatAndUnitCheckBox.setSelected(props.getProperty("restoreCatAndUnit", FALSE).equals(TRUE));
        this.updateLookAndFeelFromProperties(props);
        this.frameDecorationCheckBox.setSelected(props.getProperty("decoration", "native").equals("java"));
        this.showToolTipsCheckBox.setSelected(props.getProperty("tooltips", TRUE).equals(TRUE));
        try {
            this.toolTipSlider.setValue(Integer.parseInt(props.getProperty("tooltips.delay", "750")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.setShowToolTipsCheckBoxText();
        this.alwaysOnTopCheckBox.setSelected(props.getProperty("alwaysOnTop", FALSE).equals(TRUE));
        this.askBeforeExitCheckBox.setSelected(props.getProperty("askBeforeExit", TRUE).equals(TRUE));
        this.showExitAnimationCheckBox.setSelected(props.getProperty("exitAnimation", FALSE).equals(TRUE));
        if (LookAndFeel.isJavaThemeSupported(props.getProperty("lnf", ""))) {
            this.updateWithTheme(props.getProperty("theme", null));
        }
        this.audioNotificationCheckBox.setSelected(props.getProperty("audioNotification", FALSE).equals(TRUE));
        this.updateAudio();
        this.boldFontCheckBox.setSelected(props.getProperty("boldFont", FALSE).equals(TRUE));
        this.updateGUI();
        this.splashScreenCheckBox.setSelected(props.getProperty("splashScreen", TRUE).equals(TRUE));
    }

    private void updateAudio() {
        LookAndFeel.setAudioFeedback(this.audioNotificationCheckBox.isSelected());
    }

    private void updateFont() {
        UIManager.put("swing.boldMetal", this.boldFontCheckBox.isSelected());
        try {
            UIManager.setLookAndFeel(UIManager.getLookAndFeel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateGUI();
    }

    private void updatePropertiesFromGUI(Properties props) {
        props.setProperty("decoration", this.frameDecorationCheckBox.isSelected() ? "java" : "native");
        props.setProperty("tooltips", this.showToolTipsCheckBox.isSelected() ? TRUE : FALSE);
        props.setProperty("askBeforeExit", this.askBeforeExitCheckBox.isSelected() ? TRUE : FALSE);
        props.setProperty("alwaysOnTop", this.alwaysOnTopCheckBox.isSelected() ? TRUE : FALSE);
        props.setProperty("exitAnimation", this.showExitAnimationCheckBox.isSelected() ? TRUE : FALSE);
        props.setProperty("tooltips.delay", Integer.toString(this.toolTipSlider.getValue()));
        props.setProperty("audioNotification", this.audioNotificationCheckBox.isSelected() ? TRUE : FALSE);
        props.setProperty("boldFont", this.boldFontCheckBox.isSelected() ? TRUE : FALSE);
        props.setProperty("backupCatAndUnit", this.backupCatAndUnitCheckBox.isSelected() ? TRUE : FALSE);
        props.setProperty("restoreCatAndUnit", this.restoreCatAndUnitCheckBox.isSelected() ? TRUE : FALSE);
        props.setProperty("splashScreen", this.splashScreenCheckBox.isSelected() ? TRUE : FALSE);
        if (!this.langList.isSelectionEmpty()) {
            props.setProperty("language", ((ResBundleRecord)this.langList.getSelectedValue()).getLanguage());
            props.setProperty("country", ((ResBundleRecord)this.langList.getSelectedValue()).getCountry());
            props.setProperty("help", ((ResBundleRecord)this.langList.getSelectedValue()).getHelp());
            props.setProperty("languageIndex", Integer.toString(this.langList.getSelectedIndex()));
        }
    }

    private void restore() {
        GeneralIO.copyProperties(this.backupUserProps, this.userProps);
        this.updateGUIfromProps(this.userProps);
    }

    private void postInitComponents() {
        this.lafButtonGroup.add(this.aquaRadioButton);
        this.lafButtonGroup.add(this.gtkRadioButton);
        this.lafButtonGroup.add(this.macRadioButton);
        this.lafButtonGroup.add(this.metalRadioButton);
        this.lafButtonGroup.add(this.motifRadioButton);
        this.lafButtonGroup.add(this.nimbusRadioButton);
        this.lafButtonGroup.add(this.oceanRadioButton);
        this.lafButtonGroup.add(this.windowsRadioButton);
        this.lafButtonGroup.add(this.systemRadioButton);
        this.lafButtonGroup.add(this.kunststoffRadioButton);
        this.lafButtonGroup.add(this.metouiaRadioButton);
        this.lafButtonGroup.add(this.plasticRadioButton);
        this.lafButtonGroup.add(this.squarenessRadioButton);
        this.lafButtonGroup.add(this.nimrodRadioButton);
        this.lafButtonGroup.add(this.metalThemesEnabledRadioButton);
        this.aquaRadioButton.setEnabled(GeneralGUI.isLookAndFeelAvailable("apple.laf.AquaLookAndFeel"));
        this.gtkRadioButton.setEnabled(GeneralGUI.isLookAndFeelAvailable("com.sun.java.swing.plaf.gtk.GTKLookAndFeel"));
        this.motifRadioButton.setEnabled(GeneralGUI.isLookAndFeelAvailable("com.sun.java.swing.plaf.motif.MotifLookAndFeel"));
        this.windowsRadioButton.setEnabled(GeneralGUI.isLookAndFeelAvailable("com.sun.java.swing.plaf.windows.WindowsLookAndFeel"));
        this.macRadioButton.setEnabled(GeneralGUI.isLookAndFeelAvailable("com.sun.java.swing.plaf.mac.MacLookAndFeel"));
        this.oceanRadioButton.setEnabled(GeneralProgram.isSupportFor("1.5"));
        this.nimbusRadioButton.setEnabled(GeneralProgram.isSupportFor("1.6"));
        this.setRenderers();
        this.updateLookAndFeelFromProperties(this.userProps);
    }

    private void setRenderers() {
        if (this.langListRenderer == null) {
            this.langListRenderer = new LangListRenderer();
        }
        this.langList.setCellRenderer(this.langListRenderer);
    }

    private void updateLookAndFeelFromProperties(Properties props) {
        if (props.getProperty("lnf", "").equals("aqua")) {
            this.aquaRadioButton.setSelected(true);
            this.boldFontCheckBox.setEnabled(false);
        } else if (props.getProperty("lnf", "").equals("gtk")) {
            this.gtkRadioButton.setSelected(true);
            this.boldFontCheckBox.setEnabled(false);
        } else if (props.getProperty("lnf", "").equals("mac")) {
            this.macRadioButton.setSelected(true);
            this.boldFontCheckBox.setEnabled(false);
        } else if (props.getProperty("lnf", "").equals("metal_default")) {
            this.metalRadioButton.setSelected(true);
            this.boldFontCheckBox.setEnabled(false);
        } else if (props.getProperty("lnf", "").equals("motif")) {
            this.motifRadioButton.setSelected(true);
            this.boldFontCheckBox.setEnabled(false);
        } else if (props.getProperty("lnf", "").equals("metal")) {
            this.metalThemesEnabledRadioButton.setSelected(true);
            this.boldFontCheckBox.setEnabled(true);
        } else if (props.getProperty("lnf", "").equals("metal_ocean")) {
            this.oceanRadioButton.setSelected(true);
            this.boldFontCheckBox.setEnabled(true);
        } else if (props.getProperty("lnf", "").equals("windows")) {
            this.windowsRadioButton.setSelected(true);
            this.boldFontCheckBox.setEnabled(false);
        } else if (props.getProperty("lnf", "").equals("kunststoff")) {
            this.kunststoffRadioButton.setSelected(true);
            this.boldFontCheckBox.setEnabled(false);
        } else if (props.getProperty("lnf", "").equals("metouia")) {
            this.metouiaRadioButton.setSelected(true);
            this.boldFontCheckBox.setEnabled(false);
        } else if (props.getProperty("lnf", "").equals("plastic")) {
            this.plasticRadioButton.setSelected(true);
            this.boldFontCheckBox.setEnabled(false);
        } else if (props.getProperty("lnf", "").equals("squareness")) {
            this.squarenessRadioButton.setSelected(true);
            this.boldFontCheckBox.setEnabled(false);
        } else if (props.getProperty("lnf", "").equals("nimrod")) {
            this.nimrodRadioButton.setSelected(true);
            this.boldFontCheckBox.setEnabled(false);
        } else if (props.getProperty("lnf", "").equals("nimbus")) {
            this.nimbusRadioButton.setSelected(true);
            this.boldFontCheckBox.setEnabled(false);
        } else if (props.getProperty("lnf", "").equals("system")) {
            this.systemRadioButton.setSelected(true);
            this.boldFontCheckBox.setEnabled(false);
        }
    }

    private void initComponents() {
        this.lafButtonGroup = new ButtonGroup();
        this.jPanel5 = new JPanel();
        this.southPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.restoreButton = new JButton();
        this.cancelButton = new JButton();
        this.centerPanel = new JPanel();
        this.optionsTabbedPane = new JTabbedPane();
        this.lnfPanel = new JPanel();
        this.uiTabbedPane = new JTabbedPane();
        this.startOptionsPanel = new JPanel();
        this.splashScreenCheckBox = new JCheckBox();
        this.restoreCatAndUnitCheckBox = new JCheckBox();
        this.languagePanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.langList = new JList();
        this.jLabel2 = new JLabel();
        this.langInfoLabel = new JLabel();
        this.lookAndFeelPanel = new JPanel();
        this.themesPanel = new JPanel();
        this.themesScrollPane = new JScrollPane();
        this.themesList = new JList();
        this.kunststoffRadioButton = new JRadioButton();
        this.metalThemesEnabledRadioButton = new JRadioButton();
        this.metouiaRadioButton = new JRadioButton();
        this.nimrodRadioButton = new JRadioButton();
        this.plasticRadioButton = new JRadioButton();
        this.squarenessRadioButton = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.aquaRadioButton = new JRadioButton();
        this.gtkRadioButton = new JRadioButton();
        this.macRadioButton = new JRadioButton();
        this.motifRadioButton = new JRadioButton();
        this.nimbusRadioButton = new JRadioButton();
        this.oceanRadioButton = new JRadioButton();
        this.metalRadioButton = new JRadioButton();
        this.systemRadioButton = new JRadioButton();
        this.windowsRadioButton = new JRadioButton();
        this.optionsPanel = new JPanel();
        this.frameDecorationCheckBox = new JCheckBox();
        this.alwaysOnTopCheckBox = new JCheckBox();
        this.audioNotificationCheckBox = new JCheckBox();
        this.showToolTipsCheckBox = new JCheckBox();
        this.toolTipDelayLabel = new JLabel();
        this.toolTipSlider = new JSlider();
        this.boldFontCheckBox = new JCheckBox();
        this.exitOptionsPanel = new JPanel();
        this.backupCatAndUnitCheckBox = new JCheckBox();
        this.showExitAnimationCheckBox = new JCheckBox();
        this.askBeforeExitCheckBox = new JCheckBox();
        this.setTitle(this.rb.getString("GUI.General.Preferences"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ConfigDialog.this.closeDialog(evt);
            }
        });
        this.jPanel5.setMinimumSize(new Dimension(600, 480));
        this.jPanel5.setPreferredSize(new Dimension(600, 480));
        this.jPanel5.setLayout(new BorderLayout());
        this.southPanel.setLayout(new BorderLayout());
        this.okButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/ok.png")));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.restoreButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/undo.png")));
        this.restoreButton.setText(this.rb.getString("GUI.General.Restore"));
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.restoreButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.restoreButton);
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/close.png")));
        this.cancelButton.setText(this.rb.getString("GUI.General.Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.southPanel.add((Component)this.buttonPanel, "East");
        this.jPanel5.add((Component)this.southPanel, "South");
        this.centerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.centerPanel.setMinimumSize(new Dimension(100, 99));
        this.centerPanel.setPreferredSize(new Dimension(100, 99));
        this.centerPanel.setLayout(new BorderLayout());
        this.splashScreenCheckBox.setText(this.rb.getString("GUI.Config.ShowSplashscreen"));
        this.restoreCatAndUnitCheckBox.setText(this.rb.getString("GUI.Config.RestoreMemorizedCategoryAndUnitOnStartup"));
        GroupLayout startOptionsPanelLayout = new GroupLayout(this.startOptionsPanel);
        this.startOptionsPanel.setLayout(startOptionsPanelLayout);
        startOptionsPanelLayout.setHorizontalGroup(startOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(startOptionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(startOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.splashScreenCheckBox).addComponent(this.restoreCatAndUnitCheckBox)).addContainerGap(279, Short.MAX_VALUE)));
        startOptionsPanelLayout.setVerticalGroup(startOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(startOptionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.splashScreenCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.restoreCatAndUnitCheckBox).addContainerGap(290, Short.MAX_VALUE)));
        this.uiTabbedPane.addTab(this.rb.getString("GUI.Config.StartOptions"), new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/clapperboard.png")), this.startOptionsPanel);
        this.langList.setModel(new MyListModel(this.languageList));
        this.langList.setSelectionMode(0);
        this.langList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ConfigDialog.this.langListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.langList);
        this.jLabel2.setText(this.rb.getString("GUI.Text.ChangingTheLanguageRequiresAProgramRestart"));
        this.langInfoLabel.setVerticalAlignment(1);
        GroupLayout languagePanelLayout = new GroupLayout(this.languagePanel);
        this.languagePanel.setLayout(languagePanelLayout);
        languagePanelLayout.setHorizontalGroup(languagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(languagePanelLayout.createSequentialGroup().addContainerGap().addGroup(languagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(languagePanelLayout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 278, -2).addGap(18, 18, 18).addComponent(this.langInfoLabel, -1, 250, Short.MAX_VALUE)).addComponent(this.jLabel2)).addContainerGap()));
        languagePanelLayout.setVerticalGroup(languagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, languagePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(languagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 301, Short.MAX_VALUE).addComponent(this.langInfoLabel, -1, 301, Short.MAX_VALUE)).addContainerGap()));
        this.uiTabbedPane.addTab(this.rb.getString("GUI.General.Language"), new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/locale-alternate.png")), this.languagePanel);
        this.themesPanel.setBorder(BorderFactory.createTitledBorder(this.rb.getString("GUI.Config.LookAndFeel.Alternatives")));
        this.themesList.setModel(GeneralGUI.getListModel(this.themesVector));
        this.themesList.setSelectionMode(0);
        this.themesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ConfigDialog.this.themesListMouseClicked(evt);
            }
        });
        this.themesScrollPane.setViewportView(this.themesList);
        this.kunststoffRadioButton.setText("Kunststoff");
        this.kunststoffRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.kunststoffRadioButtonItemStateChanged(evt);
            }
        });
        this.metalThemesEnabledRadioButton.setText("Metal");
        this.metalThemesEnabledRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.metalThemesEnabledRadioButtonItemStateChanged(evt);
            }
        });
        this.metouiaRadioButton.setText("Metouia");
        this.metouiaRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.metouiaRadioButtonItemStateChanged(evt);
            }
        });
        this.nimrodRadioButton.setText("NimROD");
        this.nimrodRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.nimrodRadioButtonItemStateChanged(evt);
            }
        });
        this.plasticRadioButton.setText("Plastic");
        this.plasticRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.plasticRadioButtonItemStateChanged(evt);
            }
        });
        this.squarenessRadioButton.setText("Squareness");
        this.squarenessRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.squarenessRadioButtonItemStateChanged(evt);
            }
        });
        GroupLayout themesPanelLayout = new GroupLayout(this.themesPanel);
        this.themesPanel.setLayout(themesPanelLayout);
        themesPanelLayout.setHorizontalGroup(themesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(themesPanelLayout.createSequentialGroup().addContainerGap().addGroup(themesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.kunststoffRadioButton).addComponent(this.metalThemesEnabledRadioButton).addComponent(this.metouiaRadioButton).addComponent(this.nimrodRadioButton).addComponent(this.plasticRadioButton).addComponent(this.squarenessRadioButton)).addGap(4, 4, 4).addComponent(this.themesScrollPane, -1, 243, Short.MAX_VALUE).addContainerGap()));
        themesPanelLayout.setVerticalGroup(themesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(themesPanelLayout.createSequentialGroup().addGroup(themesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(themesPanelLayout.createSequentialGroup().addComponent(this.kunststoffRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.metalThemesEnabledRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.metouiaRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nimrodRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plasticRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.squarenessRadioButton)).addComponent(this.themesScrollPane, -1, 280, Short.MAX_VALUE)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(this.rb.getString("GUI.Config.LookAndFeel.Standards")));
        this.aquaRadioButton.setText("Aqua (Mac OS X)");
        this.aquaRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.aquaRadioButtonItemStateChanged(evt);
            }
        });
        this.gtkRadioButton.setText("GTK+ 2.0 (Linux/Unix)");
        this.gtkRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.gtkRadioButtonItemStateChanged(evt);
            }
        });
        this.macRadioButton.setText("Mac (Mac OS)");
        this.macRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.macRadioButtonItemStateChanged(evt);
            }
        });
        this.motifRadioButton.setText("Motif");
        this.motifRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.motifRadioButtonItemStateChanged(evt);
            }
        });
        this.nimbusRadioButton.setText("Nimubs (Java 6u10+)");
        this.nimbusRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.nimbusRadioButtonItemStateChanged(evt);
            }
        });
        this.oceanRadioButton.setText("Ocean");
        this.oceanRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.oceanRadioButtonItemStateChanged(evt);
            }
        });
        this.metalRadioButton.setText("Steel");
        this.metalRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.metalRadioButtonItemStateChanged(evt);
            }
        });
        this.systemRadioButton.setText("System");
        this.systemRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.systemRadioButtonItemStateChanged(evt);
            }
        });
        this.windowsRadioButton.setText("Windows");
        this.windowsRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.windowsRadioButtonItemStateChanged(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.aquaRadioButton).addComponent(this.gtkRadioButton).addComponent(this.macRadioButton).addComponent(this.motifRadioButton).addComponent(this.oceanRadioButton).addComponent(this.nimbusRadioButton).addComponent(this.metalRadioButton).addComponent(this.systemRadioButton).addComponent(this.windowsRadioButton)).addContainerGap(25, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.aquaRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gtkRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.macRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.motifRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nimbusRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.oceanRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.metalRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.systemRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.windowsRadioButton).addContainerGap(90, Short.MAX_VALUE)));
        GroupLayout lookAndFeelPanelLayout = new GroupLayout(this.lookAndFeelPanel);
        this.lookAndFeelPanel.setLayout(lookAndFeelPanelLayout);
        lookAndFeelPanelLayout.setHorizontalGroup(lookAndFeelPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lookAndFeelPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.themesPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        lookAndFeelPanelLayout.setVerticalGroup(lookAndFeelPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lookAndFeelPanelLayout.createSequentialGroup().addContainerGap().addGroup(lookAndFeelPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.themesPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.uiTabbedPane.addTab(this.rb.getString("GUI.Config.LookAndFeel"), new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/t-shirt.png")), this.lookAndFeelPanel, "");
        this.frameDecorationCheckBox.setText(this.rb.getString("GUI.Options.FrameDecoration"));
        this.frameDecorationCheckBox.setToolTipText(this.rb.getString("GUI.Options.RequiresManualRestart"));
        this.frameDecorationCheckBox.setEnabled(false);
        this.frameDecorationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.frameDecorationCheckBoxActionPerformed(evt);
            }
        });
        this.alwaysOnTopCheckBox.setText(this.rb.getString("GUI.Config.WindowAlwaysOnTop"));
        this.audioNotificationCheckBox.setText(this.rb.getString("GUI.Config.AuditoryFeedback"));
        this.audioNotificationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.audioNotificationCheckBoxActionPerformed(evt);
            }
        });
        this.showToolTipsCheckBox.setText(this.rb.getString("GUI.Options.ShowToolTips"));
        this.showToolTipsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.showToolTipsCheckBoxActionPerformed(evt);
            }
        });
        this.toolTipDelayLabel.setText(this.rb.getString("GUI.Options.TooltipDelayInMs"));
        this.toolTipSlider.setMajorTickSpacing(500);
        this.toolTipSlider.setMaximum(3000);
        this.toolTipSlider.setPaintTicks(true);
        this.toolTipSlider.setValue(750);
        this.toolTipSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ConfigDialog.this.toolTipSliderStateChanged(evt);
            }
        });
        this.boldFontCheckBox.setText(this.rb.getString("GUI.Config.BoldFont"));
        this.boldFontCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConfigDialog.this.boldFontCheckBoxItemStateChanged(evt);
            }
        });
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.frameDecorationCheckBox).addComponent(this.alwaysOnTopCheckBox).addComponent(this.showToolTipsCheckBox).addGroup(optionsPanelLayout.createSequentialGroup().addGap(21, 21, 21).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toolTipSlider, -2, -1, -2).addComponent(this.toolTipDelayLabel))).addComponent(this.audioNotificationCheckBox).addComponent(this.boldFontCheckBox)).addContainerGap(339, Short.MAX_VALUE)));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.frameDecorationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alwaysOnTopCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showToolTipsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toolTipDelayLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toolTipSlider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.audioNotificationCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.boldFontCheckBox).addContainerGap(159, Short.MAX_VALUE)));
        this.uiTabbedPane.addTab(this.rb.getString("GUI.Config.GraphicalOptions"), new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/t-shirt-print.png")), this.optionsPanel, "");
        this.backupCatAndUnitCheckBox.setText(this.rb.getString("GUI.Config.MemorizeTheLatestSelectedCategoryAndUnitOnExit"));
        this.showExitAnimationCheckBox.setText(this.rb.getString("GUI.Options.ShowExitAnimation"));
        this.askBeforeExitCheckBox.setText(this.rb.getString("GUI.Options.AskBeforeExit"));
        GroupLayout exitOptionsPanelLayout = new GroupLayout(this.exitOptionsPanel);
        this.exitOptionsPanel.setLayout(exitOptionsPanelLayout);
        exitOptionsPanelLayout.setHorizontalGroup(exitOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exitOptionsPanelLayout.createSequentialGroup().addContainerGap().addGroup(exitOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.askBeforeExitCheckBox).addComponent(this.backupCatAndUnitCheckBox).addComponent(this.showExitAnimationCheckBox)).addContainerGap(271, Short.MAX_VALUE)));
        exitOptionsPanelLayout.setVerticalGroup(exitOptionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(exitOptionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.askBeforeExitCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backupCatAndUnitCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showExitAnimationCheckBox).addContainerGap(267, Short.MAX_VALUE)));
        this.uiTabbedPane.addTab(this.rb.getString("GUI.Config.ExitOptions"), new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/headstone-rip.png")), this.exitOptionsPanel);
        GroupLayout lnfPanelLayout = new GroupLayout(this.lnfPanel);
        this.lnfPanel.setLayout(lnfPanelLayout);
        lnfPanelLayout.setHorizontalGroup(lnfPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lnfPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.uiTabbedPane).addContainerGap()));
        lnfPanelLayout.setVerticalGroup(lnfPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lnfPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.uiTabbedPane).addContainerGap()));
        this.optionsTabbedPane.addTab(this.rb.getString("GUI.General.UserInterface"), new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix32x32/gui.png")), this.lnfPanel);
        this.centerPanel.add((Component)this.optionsTabbedPane, "Center");
        this.jPanel5.add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.jPanel5, "Center");
        this.pack();
    }

    private void boldFontCheckBoxItemStateChanged(ItemEvent evt) {
        this.updateFont();
    }

    private void audioNotificationCheckBoxActionPerformed(ActionEvent evt) {
        this.updateAudio();
    }

    private void aquaRadioButtonItemStateChanged(ItemEvent evt) {
        this.boldFontCheckBox.setEnabled(false);
        LookAndFeel.setLookAndFeel("apple.laf.AquaLookAndFeel");
        this.standardLnfChanged("aqua");
    }

    private void gtkRadioButtonItemStateChanged(ItemEvent evt) {
        this.boldFontCheckBox.setEnabled(false);
        LookAndFeel.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        this.standardLnfChanged("gtk");
    }

    private void metalRadioButtonItemStateChanged(ItemEvent evt) {
        this.boldFontCheckBox.setEnabled(true);
        LookAndFeel.setMetalTheme(LookAndFeel.getDefaultMetalTheme());
        this.themedLnfChanged("metal_default", null);
    }

    private void macRadioButtonItemStateChanged(ItemEvent evt) {
        this.boldFontCheckBox.setEnabled(false);
        LookAndFeel.setLookAndFeel("com.sun.java.swing.plaf.mac.MacLookAndFeel");
        this.standardLnfChanged("mac");
    }

    private void motifRadioButtonItemStateChanged(ItemEvent evt) {
        this.boldFontCheckBox.setEnabled(false);
        LookAndFeel.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        this.standardLnfChanged("motif");
    }

    private void oceanRadioButtonItemStateChanged(ItemEvent evt) {
        this.boldFontCheckBox.setEnabled(true);
        LookAndFeel.setMetalTheme(LookAndFeel.getOceanTheme());
        this.themedLnfChanged("metal_ocean", null);
    }

    private void windowsRadioButtonItemStateChanged(ItemEvent evt) {
        this.boldFontCheckBox.setEnabled(false);
        LookAndFeel.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        this.standardLnfChanged("windows");
    }

    private void systemRadioButtonItemStateChanged(ItemEvent evt) {
        this.boldFontCheckBox.setEnabled(false);
        LookAndFeel.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        this.standardLnfChanged("system");
    }

    private void themesListMouseClicked(MouseEvent evt) {
        this.boldFontCheckBox.setEnabled(false);
        int index = this.themesList.locationToIndex(evt.getPoint());
        this.updateWithTheme((String)this.themesVector.get(index));
    }

    private void kunststoffRadioButtonItemStateChanged(ItemEvent evt) {
        this.boldFontCheckBox.setEnabled(false);
        String t = this.userProps.getProperty("theme", "Kunststoff.theme");
        PropertiesMetalTheme metalTheme = new PropertiesMetalTheme(this.getClass().getResourceAsStream("/data/themes/" + t));
        LookAndFeel.setKunststoffTheme(metalTheme);
        this.themedLnfChanged("kunststoff", t);
    }

    private void metalThemesEnabledRadioButtonItemStateChanged(ItemEvent evt) {
        this.boldFontCheckBox.setEnabled(false);
        String t = this.userProps.getProperty("theme", "Default.theme");
        PropertiesMetalTheme metalTheme = new PropertiesMetalTheme(this.getClass().getResourceAsStream("/data/themes/" + t));
        LookAndFeel.setMetalTheme(metalTheme);
        this.themedLnfChanged("metal", t);
    }

    private void metouiaRadioButtonItemStateChanged(ItemEvent evt) {
        this.boldFontCheckBox.setEnabled(false);
        String t = this.userProps.getProperty("theme", "Metouia.theme");
        PropertiesMetalTheme metalTheme = new PropertiesMetalTheme(this.getClass().getResourceAsStream("/data/themes/" + t));
        LookAndFeel.setMetouiaTheme(metalTheme);
        this.themedLnfChanged("metouia", t);
    }

    private void nimrodRadioButtonItemStateChanged(ItemEvent evt) {
        this.boldFontCheckBox.setEnabled(false);
        String t = this.userProps.getProperty("theme", "Nimrod.theme");
        PropertiesMetalTheme metalTheme = new PropertiesMetalTheme(this.getClass().getResourceAsStream("/data/themes/" + t));
        LookAndFeel.setNimrodTheme(metalTheme);
        this.themedLnfChanged("nimrod", t);
    }

    private void plasticRadioButtonItemStateChanged(ItemEvent evt) {
        this.boldFontCheckBox.setEnabled(false);
        LookAndFeel.setPlasticLnf();
        this.themedLnfChanged("plastic", null);
    }

    private void squarenessRadioButtonItemStateChanged(ItemEvent evt) {
        this.boldFontCheckBox.setEnabled(false);
        LookAndFeel.setSquarenessLnf();
        this.themedLnfChanged("squareness", null);
    }

    private void frameDecorationCheckBoxActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, this.rb.getString("GUI.Options.FrameDecorationMessage"), this.rb.getString("GUI.Options.FrameDecoration"), 1);
    }

    private void showToolTipsCheckBoxActionPerformed(ActionEvent evt) {
        this.toolTipSlider.setValue(750);
    }

    private void toolTipSliderStateChanged(ChangeEvent evt) {
        this.setShowToolTipsCheckBoxText();
    }

    public void updateGUI() {
        SwingUtilities.updateComponentTreeUI(this.getRootPane());
        this.configDialogInterface.updateGUI();
    }

    public void themedLnfChanged(String lnfCode, String themeCode) {
        boolean themeSupport = themeCode != null;
        this.userProps.setProperty("lnf", lnfCode);
        if (themeSupport) {
            this.userProps.setProperty("theme", themeCode);
        }
        this.updateGUI();
        this.themesScrollPane.setVisible(themeSupport);
        if (themeSupport) {
            this.themesList.setSelectedValue(themeCode, true);
        }
    }

    private void standardLnfChanged(String lnfCode) {
        this.userProps.setProperty("lnf", lnfCode);
        this.updateGUI();
        if (this.userProps.getProperty("decoration", "native").equals("java")) {
            JOptionPane.showMessageDialog(this, this.rb.getString("GUI.Options.FrameDecorationMessage"), "", 2);
        }
    }

    private void updateWithTheme(String theme) {
        if (theme == null) {
            return;
        }
        PropertiesMetalTheme metalTheme = new PropertiesMetalTheme(this.getClass().getResourceAsStream("/data/themes/" + theme));
        this.themesList.setSelectedValue(theme, true);
        this.userProps.setProperty("theme", theme);
        if (this.userProps.getProperty("lnf", "").equals("metal")) {
            LookAndFeel.setMetalTheme(metalTheme);
        } else if (this.userProps.getProperty("lnf", "").equals("kunststoff")) {
            LookAndFeel.setKunststoffTheme(metalTheme);
        } else if (this.userProps.getProperty("lnf", "").equals("metouia")) {
            LookAndFeel.setMetouiaTheme(metalTheme);
        } else if (this.userProps.getProperty("lnf", "").equals("nimrod")) {
            LookAndFeel.setNimrodTheme(metalTheme);
        }
        this.updateGUI();
        this.themesList.setSelectedValue(theme, true);
    }

    private void setShowToolTipsCheckBoxText() {
        if (this.toolTipSlider.getValue() == 0) {
            this.showToolTipsCheckBox.setText(this.rb.getString("GUI.Options.ShowTooltipsImmediately"));
        } else {
            this.showToolTipsCheckBox.setText(GeneralString.message(this.rb.getString("GUI.Options.ShowTooltipsAfterXms"), this.toolTipSlider.getValue()));
        }
    }

    private void restoreButtonActionPerformed(ActionEvent evt) {
        this.restore();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.updatePropertiesFromGUI(this.userProps);
        if (!this.userProps.getProperty("languageIndex", "1").equals(this.backupUserProps.getProperty("languageIndex", "1"))) {
            this.userProps.setProperty("restart", TRUE);
        }
        this.userProps.setProperty("save", TRUE);
        this.closeDialog(null);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.restore();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void nimbusRadioButtonItemStateChanged(ItemEvent evt) {
        LookAndFeel.setNimbusLookAndFeel();
        this.standardLnfChanged("nimbus");
    }

    private void langListValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            JList list = (JList)evt.getSource();
            ResBundleRecord lang = (ResBundleRecord)this.langList.getSelectedValue();
            this.updateLangInfoLabel(lang);
        }
    }

    private void updateLangInfoLabel(ResBundleRecord lang) {
        this.langInfoLabel.setText(lang.getHTML());
    }
}

