/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.calendarchooser;

import com.toedter.calendar.JCalendar;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import jonelo.sugar.gui.GUIHelper;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.gui.common.interfaces.DialogInterface;
import net.numericalchameleon.gui.dialogs.calendarchooser.CalendarChooserInterface;

public class CalendarChooserDialog
extends JDialog {
    private final ResourceBundle rb;
    private final TimeZone timezone;
    private final CalendarChooserInterface calendarChooserInterface;
    private JPanel calendarPanel;
    private JButton cancelButton;
    private JLabel dateLabel;
    private JButton daysButton;
    private JPanel labelPanel;
    private JButton monthsButton;
    private JCalendar myCalendar;
    private JButton okButton;
    private JButton quarterButton;
    private JButton todayButton;
    private JButton weekOfYearButton;
    private JButton weeksButton;
    private JButton wikipediaButton;
    private JButton yearsButton;

    public CalendarChooserDialog(DialogInterface dialogInterface, CalendarChooserInterface calendarChooserInterface) {
        super(dialogInterface.getFrame(), true);
        this.calendarChooserInterface = calendarChooserInterface;
        this.rb = dialogInterface.getResourceBundle();
        this.timezone = calendarChooserInterface.getTimeZone();
        if (dialogInterface.getFrame().isUndecorated()) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
        }
        this.initComponents();
        this.myCalendar.setCalendar(calendarChooserInterface.getCalcandar());
        this.setLocationRelativeTo(dialogInterface.getFrame());
        this.setVisible(true);
    }

    private void initComponents() {
        this.calendarPanel = new JPanel();
        this.myCalendar = new JCalendar();
        this.labelPanel = new JPanel();
        this.dateLabel = new JLabel();
        this.daysButton = new JButton();
        this.weeksButton = new JButton();
        this.yearsButton = new JButton();
        this.todayButton = new JButton();
        this.weekOfYearButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.monthsButton = new JButton();
        this.quarterButton = new JButton();
        this.wikipediaButton = new JButton();
        this.setTitle(this.rb.getString("GUI.General.DatePicker"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CalendarChooserDialog.this.closeDialog(evt);
            }
        });
        this.calendarPanel.setBorder(BorderFactory.createBevelBorder(0));
        JComboBox jcb = (JComboBox)this.myCalendar.getMonthChooser().getComboBox();
        jcb.setMaximumRowCount(12);
        this.myCalendar.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CalendarChooserDialog.this.myCalendarPropertyChange(evt);
            }
        });
        GroupLayout calendarPanelLayout = new GroupLayout(this.calendarPanel);
        this.calendarPanel.setLayout(calendarPanelLayout);
        calendarPanelLayout.setHorizontalGroup(calendarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calendarPanelLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.myCalendar, -1, 265, Short.MAX_VALUE).addContainerGap()));
        calendarPanelLayout.setVerticalGroup(calendarPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calendarPanelLayout.createSequentialGroup().addContainerGap().addComponent((Component)this.myCalendar, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.labelPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.updateLabel(this.myCalendar.getCalendar());
        this.labelPanel.add(this.dateLabel);
        this.daysButton.setText(this.rb.getString("Calendar.plusMinusDays"));
        this.daysButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarChooserDialog.this.daysButtonActionPerformed(evt);
            }
        });
        this.weeksButton.setText(this.rb.getString("Calendar.plusMinusWeeks"));
        this.weeksButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarChooserDialog.this.weeksButtonActionPerformed(evt);
            }
        });
        ResourceBundle bundle = ResourceBundle.getBundle("data/lang/resource");
        this.yearsButton.setText(bundle.getString("Calendar.plusMinusYears"));
        this.yearsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarChooserDialog.this.yearsButtonActionPerformed(evt);
            }
        });
        this.todayButton.setText(this.rb.getString("GUI.General.Today"));
        this.todayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarChooserDialog.this.todayButtonActionPerformed(evt);
            }
        });
        this.weekOfYearButton.setText(this.rb.getString("Calendar.weekOfYear"));
        this.weekOfYearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarChooserDialog.this.weekOfYearButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/close.png")));
        this.cancelButton.setText(this.rb.getString("GUI.General.Close"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarChooserDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/ok.png")));
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarChooserDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.monthsButton.setText(bundle.getString("Calendar.plusMinusMonths"));
        this.monthsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarChooserDialog.this.monthsButtonActionPerformed(evt);
            }
        });
        this.quarterButton.setText(this.rb.getString("Calendar.plusMinusQuarters"));
        this.quarterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarChooserDialog.this.quarterButtonActionPerformed(evt);
            }
        });
        this.wikipediaButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/wikipedia.png")));
        this.wikipediaButton.setText("Wikipedia");
        this.wikipediaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CalendarChooserDialog.this.wikipediaButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.todayButton, -1, 120, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.weeksButton, -1, 120, Short.MAX_VALUE).addComponent(this.monthsButton, -1, 120, Short.MAX_VALUE).addComponent(this.quarterButton, -1, 120, Short.MAX_VALUE).addComponent(this.yearsButton, -1, 120, Short.MAX_VALUE).addComponent(this.daysButton, -1, 120, Short.MAX_VALUE).addComponent(this.wikipediaButton, GroupLayout.Alignment.TRAILING, -1, 120, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.weekOfYearButton, -1, 120, Short.MAX_VALUE))).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.calendarPanel, -1, -1, Short.MAX_VALUE).addComponent(this.labelPanel, -1, 289, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.todayButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.weekOfYearButton).addGap(30, 30, 30).addComponent(this.daysButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.weeksButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.monthsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.quarterButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yearsButton)).addComponent(this.calendarPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.labelPanel, -2, -1, -2).addComponent(this.wikipediaButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void quarterButtonActionPerformed(ActionEvent evt) {
        this.buttonActionPerformed("Calendar.plusMinusQuarters", 2, 3);
    }

    private void myCalendarPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("calendar")) {
            Calendar cal = (Calendar)evt.getNewValue();
            this.updateLabel(cal);
            this.myCalendar.setCalendar(cal);
        }
    }

    private void buttonActionPerformed(String dialogTextID, int field) {
        this.buttonActionPerformed(dialogTextID, field, 1, false, false);
    }

    private void buttonActionPerformed(String dialogTextID, int field, int factor) {
        this.buttonActionPerformed(dialogTextID, field, factor, false, false);
    }

    private void buttonActionPerformed(String dialogTextID, int field, int factor, boolean initWithField, boolean setRatherThanAdd) {
        String s;
        Calendar cal = this.myCalendar.getCalendar();
        while ((s = JOptionPane.showInputDialog(this, this.rb.getString(dialogTextID), initWithField ? String.valueOf(cal.get(3)) : String.valueOf("+1"))) != null) {
            try {
                if (s.startsWith("+")) {
                    s = s.substring(1, s.length());
                }
                int val = Integer.parseInt(s.trim());
                if (setRatherThanAdd) {
                    cal.set(field, val * factor);
                } else {
                    cal.add(field, val * factor);
                }
                this.myCalendar.setCalendar(cal);
                this.updateLabel(cal);
            }
            catch (NumberFormatException e) {
                s = null;
            }
            if (s == null) continue;
        }
    }

    private void yearsButtonActionPerformed(ActionEvent evt) {
        this.buttonActionPerformed("Calendar.plusMinusYears", 1);
    }

    private void monthsButtonActionPerformed(ActionEvent evt) {
        this.buttonActionPerformed("Calendar.plusMinusMonths", 2);
    }

    private void weeksButtonActionPerformed(ActionEvent evt) {
        this.buttonActionPerformed("Calendar.plusMinusWeeks", 5, 7);
    }

    private void daysButtonActionPerformed(ActionEvent evt) {
        this.buttonActionPerformed("Calendar.plusMinusDays", 5);
    }

    private void weekOfYearButtonActionPerformed(ActionEvent evt) {
        this.buttonActionPerformed("Calendar.weekOfYear", 3, 1, true, true);
    }

    private void updateLabel(Calendar calendar) {
        DateFormat df = DateFormat.getDateInstance(0, this.myCalendar.getLocale());
        df.setTimeZone(this.timezone);
        this.dateLabel.setText(df.format(calendar.getTime()));
    }

    private void todayButtonActionPerformed(ActionEvent evt) {
        this.myCalendar.setCalendar((Calendar)new GregorianCalendar(this.timezone));
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.calendarChooserInterface.setCancelled(true);
        this.closeDialog(null);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Calendar cal = this.myCalendar.getCalendar();
        this.calendarChooserInterface.getCalcandar().set(cal.get(1), cal.get(2), cal.get(5));
        this.calendarChooserInterface.setCancelled(false);
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void wikipediaButtonActionPerformed(ActionEvent evt) {
        Calendar cal = this.myCalendar.getCalendar();
        String language = Locale.getDefault().getLanguage();
        String address = GeneralString.wikipediaLinkFromDate(cal, language);
        try {
            GUIHelper.openInBrowser(address);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

