/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.dialogs.bookmarks;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jonelo.sugar.gui.GeneralGUI;
import jonelo.sugar.util.GeneralString;
import net.numericalchameleon.data.Bookmark;
import net.numericalchameleon.data.Category;
import net.numericalchameleon.gui.dialogs.bookmarks.BookmarkInfoPanel;
import net.numericalchameleon.gui.dialogs.bookmarks.BookmarksInterface;
import net.numericalchameleon.gui.dialogs.bookmarks.BookmarksModel;

public class BookmarksDialog
extends JDialog {
    private BookmarksModel bookmarks;
    private BookmarksModel bookmarksBackup;
    private HashMap<String, Category> categoriesHashtable;
    private ResourceBundle rb;
    private BookmarksInterface bookmarkInterface;
    private JPanel bookmarkPanel;
    private JList bookmarksList;
    private JButton bottomButton;
    private JButton cancelButton;
    private JLabel countLabel;
    private JButton downButton;
    private JButton goButton;
    private JButton infoButton;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    private JButton renameButton;
    private JButton restoreButton;
    private JButton saveCloseButton;
    private JButton topButton;
    private JButton upButton;

    public BookmarksDialog(BookmarksInterface bookmarkInterface) {
        super(bookmarkInterface.getFrame(), false);
        if (bookmarkInterface.getFrame().isUndecorated()) {
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(1);
        }
        this.rb = bookmarkInterface.getResourceBundle();
        this.setTitle(this.rb.getString("GUI.Menu.Favorites.Manage"));
        this.bookmarkInterface = bookmarkInterface;
        this.bookmarks = bookmarkInterface.getBookmarks();
        this.bookmarksBackup = (BookmarksModel)this.bookmarks.clone();
        try {
            this.bookmarksBackup.read();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        this.categoriesHashtable = bookmarkInterface.getCategoryHashMap();
        this.initComponents();
        this.updateCountLabel();
        this.bookmarksList.setModel(this.bookmarks);
        if (this.bookmarks.getSize() > 0) {
            int index = this.bookmarks.getSize() - 1;
            this.bookmarksList.setSelectedIndex(index);
            this.bookmarksList.ensureIndexIsVisible(index);
        }
        this.setLocationRelativeTo(bookmarkInterface.getFrame());
        ComponentOrientation ce = ComponentOrientation.getOrientation(Locale.getDefault());
        if (!ce.isLeftToRight()) {
            GeneralGUI.applyOrientation(this.bookmarkPanel, ce);
        }
        this.cancelButton.requestFocus();
        this.setVisible(true);
    }

    private void initComponents() {
        this.bookmarkPanel = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel5 = new JPanel();
        this.countLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.bookmarksList = new JList();
        this.jPanel4 = new JPanel();
        this.topButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.bottomButton = new JButton();
        this.infoButton = new JButton();
        this.renameButton = new JButton();
        this.removeButton = new JButton();
        this.goButton = new JButton();
        this.jPanel2 = new JPanel();
        this.restoreButton = new JButton();
        this.saveCloseButton = new JButton();
        this.cancelButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                BookmarksDialog.this.closeDialog(evt);
            }
        });
        this.bookmarkPanel.setLayout(new GridBagLayout());
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel3.setMinimumSize(new Dimension(300, 300));
        this.jPanel3.setPreferredSize(new Dimension(300, 300));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new BorderLayout());
        this.countLabel.setText("0 Favorites");
        this.jPanel5.add((Component)this.countLabel, "West");
        this.jPanel3.add((Component)this.jPanel5, "South");
        this.bookmarksList.setSelectionMode(0);
        this.bookmarksList.setVisibleRowCount(12);
        this.bookmarksList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BookmarksDialog.this.bookmarksListMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.bookmarksList);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.bookmarkPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel4.setLayout(new GridBagLayout());
        this.topButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/go-top.png")));
        this.topButton.setText(this.rb.getString("GUI.Bookmarks.GoTop"));
        this.topButton.setHorizontalAlignment(2);
        this.topButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksDialog.this.topButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.topButton, gridBagConstraints);
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/go-up.png")));
        this.upButton.setText(this.rb.getString("GUI.Bookmarks.Up"));
        this.upButton.setHorizontalAlignment(2);
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksDialog.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/go-down.png")));
        this.downButton.setText(this.rb.getString("GUI.Bookmarks.Down"));
        this.downButton.setHorizontalAlignment(2);
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksDialog.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.downButton, gridBagConstraints);
        this.bottomButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/go-bottom.png")));
        this.bottomButton.setText(this.rb.getString("GUI.Bookmarks.GoBottom"));
        this.bottomButton.setHorizontalAlignment(2);
        this.bottomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksDialog.this.bottomButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.bottomButton, gridBagConstraints);
        this.infoButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/info.png")));
        this.infoButton.setText(this.rb.getString("GUI.Bookmarks.Info"));
        this.infoButton.setHorizontalAlignment(2);
        this.infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksDialog.this.infoButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.infoButton, gridBagConstraints);
        this.renameButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/editor.png")));
        this.renameButton.setText(this.rb.getString("GUI.Bookmarks.Rename"));
        this.renameButton.setHorizontalAlignment(2);
        this.renameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksDialog.this.renameButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.renameButton, gridBagConstraints);
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/trash-empty.png")));
        this.removeButton.setText(this.rb.getString("GUI.Bookmarks.Remove"));
        this.removeButton.setHorizontalAlignment(2);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksDialog.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        this.jPanel4.add((Component)this.removeButton, gridBagConstraints);
        this.goButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/go-next.png")));
        this.goButton.setText(this.rb.getString("GUI.Bookmarks.GoTo"));
        this.goButton.setHorizontalAlignment(2);
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksDialog.this.goButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.goButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        this.bookmarkPanel.add((Component)this.jPanel4, gridBagConstraints);
        this.getContentPane().add((Component)this.bookmarkPanel, "Center");
        this.jPanel2.setLayout(new FlowLayout(2));
        this.restoreButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/undo.png")));
        this.restoreButton.setText(this.rb.getString("GUI.General.Restore"));
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksDialog.this.restoreButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.restoreButton);
        this.saveCloseButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/save.png")));
        this.saveCloseButton.setText(this.rb.getString("GUI.Bookmarks.SaveAndClose"));
        this.saveCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksDialog.this.saveCloseButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.saveCloseButton);
        this.cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/close.png")));
        this.cancelButton.setText(this.rb.getString("GUI.General.Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BookmarksDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.cancelButton);
        this.getContentPane().add((Component)this.jPanel2, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 568) / 2, (screenSize.height - 514) / 2, 568, 514);
    }

    private void bottomButtonActionPerformed(ActionEvent evt) {
        if (!this.bookmarksList.isSelectionEmpty()) {
            int pos;
            for (pos = this.bookmarksList.getSelectedIndex(); pos < this.bookmarks.getSize() - 1; ++pos) {
                this.change(pos, pos + 1);
            }
            this.bookmarksList.ensureIndexIsVisible(pos);
        }
    }

    private void topButtonActionPerformed(ActionEvent evt) {
        if (!this.bookmarksList.isSelectionEmpty()) {
            int pos;
            for (pos = this.bookmarksList.getSelectedIndex(); pos > 0; --pos) {
                this.change(pos, pos - 1);
            }
            this.bookmarksList.ensureIndexIsVisible(pos);
        }
    }

    public void updateList() {
        this.bookmarksList.setSelectedIndex(this.bookmarks.getSize() - 1);
        this.bookmarksList.ensureIndexIsVisible(this.bookmarks.getSize() - 1);
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        block3: {
            if (!this.bookmarksList.isSelectionEmpty()) {
                try {
                    this.bookmarkInterface.visitBookmark((Bookmark)this.bookmarks.get(this.bookmarksList.getSelectedIndex()));
                }
                catch (Exception e) {
                    int result = JOptionPane.showConfirmDialog(this, this.rb.getString("GUI.Bookmarks.Dialog.BookmarkOutdatedRemove"), this.rb.getString("GUI.Bookmarks.Dialog.BookmarkOutdatedRemove"), 1, 3, new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix32x32/face-surprise.png")));
                    if (result != 0) break block3;
                    this.removeButtonActionPerformed(null);
                }
            }
        }
    }

    private void infoButtonActionPerformed(ActionEvent evt) {
        if (!this.bookmarksList.isSelectionEmpty()) {
            int pos = this.bookmarksList.getSelectedIndex();
            Bookmark bookmark = (Bookmark)this.bookmarks.get(pos);
            BookmarkInfoPanel bookmarkInfoPanel = new BookmarkInfoPanel(this.rb);
            this.fillPanel(bookmarkInfoPanel, bookmark);
            JOptionPane.showMessageDialog(this, bookmarkInfoPanel, "Info", -1);
        }
    }

    private void bookmarksListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.goButtonActionPerformed(null);
        }
    }

    private void fillPanel(BookmarkInfoPanel bookmarkInfoPanel, Bookmark bookmark) {
        bookmarkInfoPanel.getCategoryLabel().setIcon(new ImageIcon(this.getClass().getResource("/data/icons/categories/" + bookmark.getCategory().toLowerCase() + ".png")));
        bookmarkInfoPanel.getCategoryLabel().setText(this.categoriesHashtable.get(bookmark.getCategory()).getString());
        bookmarkInfoPanel.getSourceLabel().setText(bookmark.getSourceDescription());
        bookmarkInfoPanel.getSourceLabel().setIcon(new ImageIcon(this.getClass().getResource("/data/icons/flags/" + bookmark.getSourceCountry() + ".png")));
        bookmarkInfoPanel.getTargetLabel().setText(bookmark.getTargetDescription());
        bookmarkInfoPanel.getTargetLabel().setIcon(new ImageIcon(this.getClass().getResource("/data/icons/flags/" + bookmark.getTargetCountry() + ".png")));
    }

    private void renameButtonActionPerformed(ActionEvent evt) {
        if (!this.bookmarksList.isSelectionEmpty()) {
            String input = null;
            boolean end = false;
            int pos = this.bookmarksList.getSelectedIndex();
            Bookmark bookmark = (Bookmark)this.bookmarks.get(pos);
            BookmarkInfoPanel bookmarkInfoPanel = new BookmarkInfoPanel(this.rb);
            this.fillPanel(bookmarkInfoPanel, bookmark);
            while (!end) {
                input = (String)JOptionPane.showInputDialog(this, bookmarkInfoPanel, this.rb.getString("GUI.Bookmarks.Rename"), -1, null, null, bookmark.getDescription());
                if (input != null) {
                    if (input.equals("") || input.indexOf("##") != -1) continue;
                    bookmark.setDescription(input);
                    this.bookmarks.set(pos, bookmark);
                    end = true;
                    continue;
                }
                end = true;
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.bookmarks.copyFrom(this.bookmarksBackup);
        this.saveCloseButtonActionPerformed(evt);
        this.closeDialog(null);
    }

    private void saveCloseButtonActionPerformed(ActionEvent evt) {
        try {
            this.bookmarks.save();
        }
        catch (IOException ioe) {
            System.err.println(ioe);
        }
        this.closeDialog(null);
    }

    private void restoreButtonActionPerformed(ActionEvent evt) {
        this.bookmarks.copyFrom(this.bookmarksBackup);
        this.updateCountLabel();
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/trash-empty.png")));
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int pos;
        if (!this.bookmarksList.isSelectionEmpty() && (pos = this.bookmarksList.getSelectedIndex()) < this.bookmarks.getSize() - 1) {
            this.change(pos, pos + 1);
            this.bookmarksList.ensureIndexIsVisible(pos + 1);
        }
    }

    public void updateCountLabel() {
        this.countLabel.setText(GeneralString.message(this.bookmarks.getSize() == 1 ? this.rb.getString("GUI.Bookmarks.Favorite") : this.rb.getString("GUI.Bookmarks.Favorites"), this.bookmarks.getSize()));
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        if (!this.bookmarksList.isSelectionEmpty()) {
            int pos = this.bookmarksList.getSelectedIndex();
            this.bookmarks.remove(pos);
            if (pos == this.bookmarks.getSize()) {
                --pos;
            }
            if (this.bookmarks.getSize() > 0) {
                this.bookmarksList.setSelectedIndex(pos);
            }
            this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/net/numericalchameleon/icons/pix16x16/trash-full.png")));
            this.updateCountLabel();
        }
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int pos;
        if (!this.bookmarksList.isSelectionEmpty() && (pos = this.bookmarksList.getSelectedIndex()) > 0) {
            this.change(pos, pos - 1);
            this.bookmarksList.ensureIndexIsVisible(pos - 1);
        }
    }

    private void change(int oldpos, int newpos) {
        Object backup = this.bookmarks.get(newpos);
        this.bookmarks.set(newpos, this.bookmarks.get(oldpos));
        this.bookmarks.set(oldpos, backup);
        this.bookmarksList.setSelectedIndex(newpos);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
        this.bookmarkInterface.releaseBookmarksDialog();
    }
}

