/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.gui.common;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.DesertBlue;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODTheme;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.plaf.metal.OceanTheme;
import jonelo.sugar.gui.PropertiesMetalTheme;
import net.beeger.squareness.SquarenessLookAndFeel;
import net.numericalchameleon.gui.common.LookAndFeelProperties;
import net.sourceforge.mlf.metouia.MetouiaLookAndFeel;

public class LookAndFeel {
    private static MetalTheme oceanTheme = null;
    private static DefaultMetalTheme defaultMetalTheme = null;
    private static SquarenessLookAndFeel slnf = null;
    private static PlasticXPLookAndFeel plnf = null;
    private static NimRODLookAndFeel nlnf = null;
    private static MetouiaLookAndFeel mlnf = null;
    private static KunststoffLookAndFeel klnf = null;

    public static MetalTheme getOceanTheme() {
        return oceanTheme;
    }

    public static DefaultMetalTheme getDefaultMetalTheme() {
        return defaultMetalTheme;
    }

    public static void setLookAndFeel(String lookAndFeel) {
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.println(e);
        }
    }

    public static void setLookAndFeelBasedOnPreferences(LookAndFeelProperties props) {
        LookAndFeel.setBoldFont(props.isBoldFontWanted());
        LookAndFeel.setAudioFeedback(props.isAudioFeedbackWanted());
        String lnf = props.getPreferredLnF();
        String theme = props.getPreferredTheme();
        if (lnf.equals("kunststoff")) {
            LookAndFeel.setKunststoffTheme(new PropertiesMetalTheme(LookAndFeel.class.getResourceAsStream("/data/themes/" + theme)));
        } else if (lnf.equals("metal")) {
            LookAndFeel.setMetalTheme(new PropertiesMetalTheme(LookAndFeel.class.getResourceAsStream("/data/themes/" + theme)));
        } else if (lnf.equals("metouia")) {
            LookAndFeel.setMetouiaTheme(new PropertiesMetalTheme(LookAndFeel.class.getResourceAsStream("/data/themes/" + theme)));
        } else if (lnf.equals("nimrod")) {
            LookAndFeel.setNimrodTheme(new PropertiesMetalTheme(LookAndFeel.class.getResourceAsStream("/data/themes/" + theme)));
        } else if (lnf.equals("plastic")) {
            LookAndFeel.setPlasticLnf();
        } else if (lnf.equals("mac")) {
            LookAndFeel.setLookAndFeel("com.sun.java.swing.plaf.mac.MacLookAndFeel");
        } else if (lnf.equals("aqua")) {
            LookAndFeel.setLookAndFeel("apple.laf.AquaLookAndFeel");
        } else if (lnf.equals("motif")) {
            LookAndFeel.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        } else if (lnf.equals("windows")) {
            LookAndFeel.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        } else if (lnf.equals("metal_default")) {
            LookAndFeel.setMetalTheme(LookAndFeel.getDefaultMetalTheme());
        } else if (lnf.equals("metal_ocean")) {
            LookAndFeel.setMetalTheme(LookAndFeel.getOceanTheme());
        } else if (lnf.equals("squareness")) {
            LookAndFeel.setSquarenessLnf();
        } else if (lnf.equals("nimbus")) {
            LookAndFeel.setNimbusLookAndFeel();
        } else if (lnf.equals("system")) {
            LookAndFeel.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
    }

    public static void setNimbusLookAndFeel() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException e) {
            System.err.println(e);
        }
    }

    public static javax.swing.LookAndFeel getSquarenessLookAndFeel() {
        if (slnf == null) {
            slnf = new SquarenessLookAndFeel();
        }
        return slnf;
    }

    public static void setSquarenessLnf() {
        try {
            UIManager.setLookAndFeel(LookAndFeel.getSquarenessLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.println(e);
        }
    }

    public static javax.swing.LookAndFeel getPlasticLookAndFeel() {
        if (plnf == null) {
            plnf = new PlasticXPLookAndFeel();
        }
        return plnf;
    }

    public static void setPlasticLnf() {
        try {
            PlasticLookAndFeel.setPlasticTheme((PlasticTheme)new DesertBlue());
            UIManager.setLookAndFeel(LookAndFeel.getPlasticLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.println(e);
        }
    }

    public static NimRODLookAndFeel getNimrodLookAndFeel() {
        if (nlnf == null) {
            nlnf = new NimRODLookAndFeel();
        }
        return nlnf;
    }

    public static void setNimrodLnf() {
        try {
            LookAndFeel.getNimrodLookAndFeel();
            NimRODLookAndFeel.setCurrentTheme((MetalTheme)new NimRODTheme());
            UIManager.setLookAndFeel((javax.swing.LookAndFeel)LookAndFeel.getNimrodLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.println(e);
        }
    }

    public static void setAudioFeedback(boolean b) {
        UIManager.put("AuditoryCues.playList", b ? UIManager.get("AuditoryCues.allAuditoryCues") : UIManager.get("AuditoryCues.noAuditoryCues"));
    }

    public static void setBoldFont(boolean b) {
        UIManager.put("swing.boldMetal", b);
    }

    public static void setNimrodTheme(MetalTheme theme) {
        try {
            LookAndFeel.getNimrodLookAndFeel();
            NimRODLookAndFeel.setCurrentTheme((MetalTheme)theme);
            UIManager.setLookAndFeel((javax.swing.LookAndFeel)LookAndFeel.getNimrodLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.println(e);
        }
    }

    public static void setMetalTheme(MetalTheme theme) {
        try {
            MetalLookAndFeel.setCurrentTheme(theme);
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.println(e);
        }
    }

    public static MetouiaLookAndFeel getMetouiaLookAndFeel() {
        if (mlnf == null) {
            mlnf = new MetouiaLookAndFeel();
        }
        return mlnf;
    }

    public static void setMetouiaTheme(MetalTheme theme) {
        try {
            UIManager.setLookAndFeel((javax.swing.LookAndFeel)LookAndFeel.getMetouiaLookAndFeel());
            if (theme != null) {
                LookAndFeel.getMetouiaLookAndFeel();
                MetouiaLookAndFeel.setCurrentTheme((MetalTheme)theme);
            }
            UIManager.setLookAndFeel((javax.swing.LookAndFeel)LookAndFeel.getMetouiaLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.println(e);
        }
    }

    public static KunststoffLookAndFeel getKunststoffLookAndFeel() {
        if (klnf == null) {
            klnf = new KunststoffLookAndFeel();
        }
        return klnf;
    }

    public static void setKunststoffTheme(MetalTheme theme) {
        try {
            if (theme != null) {
                LookAndFeel.getKunststoffLookAndFeel();
                KunststoffLookAndFeel.setCurrentTheme((MetalTheme)theme);
            }
            UIManager.setLookAndFeel((javax.swing.LookAndFeel)LookAndFeel.getKunststoffLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            System.err.println(e);
        }
    }

    public static boolean isJavaLookAndFeel(String lookAndFeel) {
        return !lookAndFeel.equals("native");
    }

    public static boolean isJavaThemeSupported(String lookAndFeel) {
        return lookAndFeel.equals("kunststoff") || lookAndFeel.equals("metal") || lookAndFeel.equals("metal_default") || lookAndFeel.equals("metouia") || lookAndFeel.equals("nimrod");
    }

    static {
        defaultMetalTheme = new DefaultMetalTheme();
        oceanTheme = new OceanTheme();
    }
}

