/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.data;

import java.util.StringTokenizer;
import net.numericalchameleon.data.Category;
import net.numericalchameleon.data.Unit;

public class Bookmark {
    public static final String DELIM = "##";
    private String language;
    private String country;
    private String description;
    private String value;
    private final String category;
    private final String sourceDescription;
    private final String sourceCountry;
    private final String targetDescription;
    private final String targetCountry;

    public Bookmark(Category category, Unit sourceUnit, Unit targetUnit) {
        this.language = "en";
        this.country = "US";
        this.category = category.getName();
        this.sourceDescription = sourceUnit.getString();
        this.sourceCountry = sourceUnit.getIcon();
        this.targetDescription = targetUnit.getString();
        this.targetCountry = targetUnit.getIcon();
        this.description = this.sourceDescription + " -> " + this.targetDescription;
        this.value = "";
    }

    public Bookmark(Bookmark bookmark) {
        this.language = bookmark.language;
        this.country = bookmark.country;
        this.description = bookmark.description;
        this.category = bookmark.category;
        this.sourceDescription = bookmark.sourceDescription;
        this.sourceCountry = bookmark.sourceCountry;
        this.targetDescription = bookmark.targetDescription;
        this.targetCountry = bookmark.targetCountry;
        this.value = bookmark.value;
    }

    public Bookmark(String string) {
        StringTokenizer st = new StringTokenizer(string, DELIM);
        this.language = st.nextToken();
        this.country = st.nextToken();
        this.description = st.nextToken();
        this.category = st.nextToken();
        this.sourceDescription = st.nextToken();
        this.sourceCountry = st.nextToken();
        this.targetDescription = st.nextToken();
        this.targetCountry = st.nextToken();
        this.value = st.hasMoreTokens() ? st.nextToken() : "";
    }

    public String toString() {
        return this.description;
    }

    public String getBookmarkAsString() {
        return this.language + DELIM + this.country + DELIM + this.description + DELIM + this.category + DELIM + this.sourceDescription + DELIM + this.sourceCountry + DELIM + this.targetDescription + DELIM + this.targetCountry + DELIM + this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSourceDescription() {
        return this.sourceDescription;
    }

    public String getSourceCountry() {
        return this.sourceCountry;
    }

    public String getTargetDescription() {
        return this.targetDescription;
    }

    public String getTargetCountry() {
        return this.targetCountry;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountry() {
        return this.country;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }
}

