/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;
import net.numericalchameleon.util.spokentime.EnglishTime;
import net.numericalchameleon.util.spokentime.GermanTime;
import net.numericalchameleon.util.spokentime.SpokenTime;
import net.numericalchameleon.util.spokentime.Time;

public class CategorySpokenTime
extends CategoryObject {
    private static final int _TRANSFER = -1;
    private static final int _TIME24H = -24;
    private static final int _TIME12H = -12;
    private static String INVALID;
    private static String TIME24H;
    private static String TIME12H;
    private final ArrayList<Unit> sourceUnits;
    private final ArrayList<Unit> targetUnits;
    private final Unit defaultSourceUnit;
    private final Unit defaultTargetUnit;
    private final Unit transferUnit;
    private final ArrayList<SpokenTime> modules;
    private SpokenTime currentModule;

    public CategorySpokenTime(CategoryInterface categoryInterface) {
        this.rb = categoryInterface.getResourceBundle();
        INVALID = this.localize("Moduls.sourceInvalid", "Source is invalid");
        TIME24H = this.localize("Moduls.time24h", "Time (24h) [HH:MM]");
        TIME12H = this.localize("Moduls.time12h", "Time (12h) [HH:MM am/pm]");
        this.setOneway(true);
        this.modules = new ArrayList();
        this.transferUnit = new Unit(-1);
        this.sourceUnits = new ArrayList();
        this.sourceUnits.add(new Unit(-24, TIME24H, "int"));
        this.sourceUnits.add(new Unit(-12, TIME12H, "int"));
        this.defaultSourceUnit = this.sourceUnits.get(0);
        this.targetUnits = new ArrayList();
        int index = 0;
        this.targetUnits.add(new Unit(index++, this.localize("Language.us", "English") + " (12h, colloquial)", "us"));
        this.modules.add(new EnglishTime(EnglishTime.HourclockType.HOURCLOCK12_COLLOQUIAL_US));
        this.targetUnits.add(new Unit(index++, this.localize("Language.us", "English") + " (24h, military)", "us"));
        this.modules.add(new EnglishTime(EnglishTime.HourclockType.HOURCLOCK24_MILITARY_US));
        this.targetUnits.add(new Unit(index++, this.localize("Language.gb", "English") + " (12h, colloquial)", "gb"));
        this.modules.add(new EnglishTime(EnglishTime.HourclockType.HOURCLOCK12_COLLOQUIAL_UK));
        this.targetUnits.add(new Unit(index++, this.localize("Language.gb", "English") + " (24h, military)", "gb"));
        this.modules.add(new EnglishTime(EnglishTime.HourclockType.HOURCLOCK24_MILITARY_UK));
        this.targetUnits.add(new Unit(index++, this.localize("Language.de", "German") + " (12h, umgangssprachlich, Variante 1)", "de"));
        this.modules.add(new GermanTime(GermanTime.HourclockType.HOURCLOCK12_VARIANT1_DE));
        this.targetUnits.add(new Unit(index++, this.localize("Language.de", "German") + " (12h, umgangssprachlich, Variante 2)", "de"));
        this.modules.add(new GermanTime(GermanTime.HourclockType.HOURCLOCK12_VARIANT2_DE));
        this.targetUnits.add(new Unit(index++, this.localize("Language.de", "German") + " (12h, umgangssprachlich, Variante 3)", "de"));
        this.modules.add(new GermanTime(GermanTime.HourclockType.HOURCLOCK12_VARIANT3_DE));
        this.targetUnits.add(new Unit(index++, this.localize("Language.de", "German") + " (12h, umgangssprachlich, Variante 4)", "de"));
        this.modules.add(new GermanTime(GermanTime.HourclockType.HOURCLOCK12_VARIANT4_DE));
        this.targetUnits.add(new Unit(index++, this.localize("Language.de", "German") + " (12h, umgangssprachlich, Variante 5)", "de"));
        this.modules.add(new GermanTime(GermanTime.HourclockType.HOURCLOCK12_VARIANT0_DE));
        this.targetUnits.add(new Unit(index++, this.localize("Language.de", "German") + " (24h, Standard)", "de"));
        this.modules.add(new GermanTime(GermanTime.HourclockType.HOURCLOCK24_DE));
        this.targetUnits.add(new Unit(index++, this.localize("Language.de", "German") + " (24h, f\u00f6rmlich)", "de"));
        this.modules.add(new GermanTime(GermanTime.HourclockType.HOURCLOCK24_FORMAL_DE));
        this.targetUnits.add(new Unit(index++, this.localize("Language.de", "German") + " (24h, milit\u00e4risch)", "de"));
        this.modules.add(new GermanTime(GermanTime.HourclockType.HOURCLOCK24_MILITARY_DE));
        this.targetUnits.add(new Unit(index++, this.localize("Language.de", "German") + " (12h, umgangssprachlich)", "ch"));
        this.modules.add(new GermanTime(GermanTime.HourclockType.HOURCLOCK12_VARIANT1_CH));
        this.targetUnits.add(new Unit(index++, this.localize("Language.de", "German") + " (24h, Standard)", "ch"));
        this.modules.add(new GermanTime(GermanTime.HourclockType.HOURCLOCK24_CH));
        this.targetUnits.add(new Unit(index++, this.localize("Language.de", "German") + " (24h, f\u00f6rmlich)", "ch"));
        this.modules.add(new GermanTime(GermanTime.HourclockType.HOURCLOCK24_FORMAL_CH));
        this.targetUnits.add(new Unit(index++, this.localize("Language.de", "German") + " (24h, milit\u00e4risch)", "ch"));
        this.modules.add(new GermanTime(GermanTime.HourclockType.HOURCLOCK24_MILITARY_CH));
        this.defaultTargetUnit = this.targetUnits.get(0);
    }

    @Override
    public String getInitialValue() {
        GregorianCalendar gc = new GregorianCalendar();
        int hours = gc.get(11);
        int minutes = gc.get(12);
        return String.format("%02d:%02d", hours, minutes);
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.sourceUnits;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.targetUnits;
    }

    @Override
    public int getSourceDefault() {
        return 0;
    }

    public Unit getDefaultSourceUnit() {
        return this.defaultSourceUnit;
    }

    @Override
    public int getTargetDefault() {
        return 0;
    }

    public Unit getDefaultTargetUnit() {
        return this.defaultTargetUnit;
    }

    @Override
    public void play(Unit unit) throws Exception {
        int index = unit.getId();
        if (this.input != null && this.input.length() != 0) {
            this.currentModule = this.modules.get(index);
            String dir = this.currentModule.getSoundDir();
            if (dir != null) {
                URL url = this.getClass().getResource("/data/sounds/" + dir);
                if (url == null) {
                    throw new Exception("not supported");
                }
            } else {
                throw new Exception("not supported");
            }
            this.currentModule.play();
        }
    }

    @Override
    public void stopPlaying() {
        if (this.currentModule != null) {
            this.currentModule.stopPlaying();
        }
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.sourceUnits.get(s);
        Unit targetUnit = this.targetUnits.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        Time time;
        int sid = sourceUnit.getId();
        int tid = targetUnit.getId();
        switch (sid) {
            case -1: {
                try {
                    time = Time.parse(this.input, 10);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException(INVALID);
                }
            }
            case -24: {
                try {
                    time = Time.parse(this.input, 24);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException(INVALID);
                }
            }
            case -12: {
                try {
                    time = Time.parse(this.input, 12);
                    break;
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException(INVALID);
                }
            }
            default: {
                throw new IllegalArgumentException("internal error");
            }
        }
        switch (tid) {
            case -1: {
                return Time.format(time, 10);
            }
            case -24: {
                return Time.format(time, 24);
            }
            case -12: {
                return Time.format(time, 12);
            }
        }
        this.currentModule = this.modules.get(tid);
        this.currentModule.setTime(time.getHours(), time.getMinutes());
        return this.currentModule.timeInWords();
    }

    @Override
    public String addValue(BigDecimal plus, int sourceindex) throws Exception {
        Unit sourceUnit = this.sourceUnits.get(sourceindex);
        return this.addValue(plus, sourceUnit);
    }

    public String addValue(BigDecimal plus, Unit sourceUnit) throws Exception {
        if (this.input == null || this.input.length() == 0) {
            this.input = "0";
            this.input = this.getOutput(this.transferUnit, sourceUnit);
        }
        String temp = this.getOutput(sourceUnit, this.transferUnit);
        try {
            Time time = Time.parse(temp, 10);
            time.addMinutes(plus.intValue());
            this.input = Time.format(time, 10);
            return this.getOutput(this.transferUnit, sourceUnit);
        }
        catch (Exception e) {
            throw new Exception(INVALID);
        }
    }

    @Override
    public String setValue(BigDecimal big, int sourceIndex) throws Exception {
        Unit sourceUnit = this.sourceUnits.get(sourceIndex);
        return this.setValue(big, sourceUnit);
    }

    public String setValue(BigDecimal big, Unit sourceUnit) throws Exception {
        this.setInput(big.toPlainString());
        return this.getOutput(this.transferUnit, sourceUnit);
    }

    @Override
    public String getTransferValue(int sourceIndex) throws Exception {
        Unit sourceUnit = this.sourceUnits.get(sourceIndex);
        return this.getOutput(sourceUnit, this.transferUnit);
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        return this.getOutput(sourceUnit, this.transferUnit);
    }

    @Override
    public String getCard() {
        return "timeCard";
    }
}

