/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;
import net.numericalchameleon.util.spokennumbers.DutchNumber;
import net.numericalchameleon.util.spokennumbers.EsperantoNumber;
import net.numericalchameleon.util.spokennumbers.FinnishNumber;
import net.numericalchameleon.util.spokennumbers.FrenchBelgiumNumber;
import net.numericalchameleon.util.spokennumbers.FrenchNumber;
import net.numericalchameleon.util.spokennumbers.FrenchSwitzerlandNumber;
import net.numericalchameleon.util.spokennumbers.GermanNumber;
import net.numericalchameleon.util.spokennumbers.GermanSwitzerlandNumber;
import net.numericalchameleon.util.spokennumbers.HungarianNumber;
import net.numericalchameleon.util.spokennumbers.IndianHindiNumber;
import net.numericalchameleon.util.spokennumbers.IndianTamilNumber;
import net.numericalchameleon.util.spokennumbers.ItalianNumber;
import net.numericalchameleon.util.spokennumbers.JapaneseNumber;
import net.numericalchameleon.util.spokennumbers.KlingonNumber;
import net.numericalchameleon.util.spokennumbers.LatinNumber;
import net.numericalchameleon.util.spokennumbers.MorseCodeNumber;
import net.numericalchameleon.util.spokennumbers.PolishNumber;
import net.numericalchameleon.util.spokennumbers.PortugueseBrazilNumber;
import net.numericalchameleon.util.spokennumbers.PortugueseNumber;
import net.numericalchameleon.util.spokennumbers.RomanianNumber;
import net.numericalchameleon.util.spokennumbers.RussianNumber;
import net.numericalchameleon.util.spokennumbers.SpanishNumber;
import net.numericalchameleon.util.spokennumbers.SpokenNumber;
import net.numericalchameleon.util.spokennumbers.SwedishNumber;
import net.numericalchameleon.util.spokennumbers.TonganNumber;
import net.numericalchameleon.util.spokennumbers.TouchtoneNumber;
import net.numericalchameleon.util.spokennumbers.TurkishNumber;
import net.numericalchameleon.util.spokennumbers.UKEnglishNumber;
import net.numericalchameleon.util.spokennumbers.USEnglishNumber;

public class CategorySpokenNumbers
extends CategoryObject {
    public static final String CODE = "SPOKENNUMBERS";
    private static final int _TRANSFER = -1;
    private static String INVALID;
    private static String DECIMAL;
    private final ArrayList<Unit> sourceUnits;
    private final ArrayList<Unit> targetUnits;
    private final Unit defaultSourceUnit;
    private final Unit defaultTargetUnit;
    private final Unit transferUnit;
    private final ArrayList<SpokenNumber> modules;
    private SpokenNumber currentModule;

    public CategorySpokenNumbers(CategoryInterface clusterInterface) {
        this.rb = clusterInterface.getResourceBundle();
        INVALID = this.localize("Moduls.sourceInvalid", "Source is invalid");
        DECIMAL = this.localize("Moduls.decimalName", "Decimal");
        this.setOneway(true);
        this.modules = new ArrayList();
        this.transferUnit = new Unit(-1);
        this.sourceUnits = new ArrayList();
        this.sourceUnits.add(new Unit(0, DECIMAL, "int"));
        this.defaultSourceUnit = this.sourceUnits.get(0);
        this.targetUnits = new ArrayList();
        int index = 0;
        this.targetUnits.add(new Unit(index++, this.localize("Language.us", "English (US)"), "us"));
        this.modules.add(new USEnglishNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.gb", "English (UK)"), "gb"));
        this.modules.add(new UKEnglishNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.fr", "French (France)"), "fr"));
        this.modules.add(new FrenchNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.es", "Spanish"), "es"));
        this.modules.add(new SpanishNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.de", "German"), "de"));
        this.modules.add(new GermanNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.de_CH", "German (Switzerland)"), "ch"));
        this.modules.add(new GermanSwitzerlandNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.fr_CH", "French (Switzerland)"), "ch"));
        this.modules.add(new FrenchSwitzerlandNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.it", "Italian"), "it"));
        this.modules.add(new ItalianNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.fi", "Finnish"), "fi"));
        this.modules.add(new FinnishNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.in_hindi", "Hindi"), "in"));
        this.modules.add(new IndianHindiNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.in_tamil", "Tamil"), "in"));
        this.modules.add(new IndianTamilNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.hu", "Hungarian"), "hu"));
        this.modules.add(new HungarianNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.se", "Swedish"), "se"));
        this.modules.add(new SwedishNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.tr", "Turkish"), "tr"));
        this.modules.add(new TurkishNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.pl", "Polish"), "pl"));
        this.modules.add(new PolishNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.br", "Portuguese (Brazil)"), "br"));
        this.modules.add(new PortugueseBrazilNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.pt", "Portuguese"), "pt"));
        this.modules.add(new PortugueseNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.ro", "Romanian"), "ro"));
        this.modules.add(new RomanianNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.ru", "Russian"), "ru"));
        this.modules.add(new RussianNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.jp", "Japanese"), "jp"));
        this.modules.add(new JapaneseNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.nl", "Dutch"), "nl"));
        this.modules.add(new DutchNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.fr_BE", "French (Belgium)"), "be"));
        this.modules.add(new FrenchBelgiumNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.to", "Tongan"), "to"));
        this.modules.add(new TonganNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.esp", "Esperanto"), "esp"));
        this.modules.add(new EsperantoNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.klingon", "Klingon"), "startrek"));
        this.modules.add(new KlingonNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.lat", "Latin"), "int"));
        this.modules.add(new LatinNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.morsecode", "Morsecode"), "int"));
        this.modules.add(new MorseCodeNumber());
        this.targetUnits.add(new Unit(index++, this.localize("Language.telephone", "Telephone"), "int"));
        this.modules.add(new TouchtoneNumber());
        this.defaultTargetUnit = this.targetUnits.get(0);
    }

    @Override
    public String getInitialValue() {
        return "0";
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.sourceUnits;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.targetUnits;
    }

    @Override
    public void play(Unit unit) throws Exception {
        int index = unit.getId();
        if (this.input != null && this.input.length() != 0) {
            this.currentModule = this.modules.get(index);
            String dir = this.currentModule.getSoundDir();
            if (dir != null) {
                URL url = this.getClass().getResource("/data/sounds/" + dir);
                if (url == null) {
                    throw new Exception("not supported");
                }
            } else {
                throw new Exception("not supported");
            }
            this.currentModule.play();
        }
    }

    @Override
    public void stopPlaying() {
        if (this.currentModule != null) {
            this.currentModule.stopPlaying();
        }
    }

    @Override
    public void setNumberType(int numberType) {
        for (SpokenNumber module : this.modules) {
            module.setNumberType(numberType);
        }
    }

    public Unit getDefaultSourceUnit() {
        return this.defaultSourceUnit;
    }

    public Unit getDefaultTargetUnit() {
        return this.defaultTargetUnit;
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.sourceUnits.get(s);
        Unit targetUnit = this.targetUnits.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        int tid = targetUnit.getId();
        try {
            BigInteger bigInteger = new BigDecimal(this.input).toBigInteger();
        }
        catch (Exception e) {
            throw new Exception(INVALID);
        }
        this.currentModule = this.modules.get(tid);
        this.currentModule.setNumber(this.input);
        return this.currentModule.toString();
    }

    @Override
    public String addValue(BigDecimal plus, int sourceindex) throws Exception {
        Unit sourceUnit = this.sourceUnits.get(sourceindex);
        return this.addValue(plus, sourceUnit);
    }

    public String addValue(BigDecimal plus, Unit sourceUnit) throws Exception {
        BigInteger big;
        if (this.input == null || this.input.length() == 0) {
            this.input = "0";
        }
        try {
            big = new BigDecimal(this.input).toBigInteger();
        }
        catch (Exception e) {
            throw new Exception(INVALID);
        }
        big = big.add(plus.toBigInteger());
        return big.toString();
    }

    @Override
    public String setValue(BigDecimal big, int sourceindex) throws Exception {
        this.setInput(big.toPlainString());
        return this.input;
    }

    @Override
    public String getTransferValue(int s) throws Exception {
        Unit sourceUnit = this.sourceUnits.get(s);
        return this.getTransferValue(sourceUnit);
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        BigInteger big;
        try {
            big = new BigDecimal(this.input).toBigInteger();
        }
        catch (Exception e) {
            throw new Exception(INVALID);
        }
        return big.toString();
    }

    @Override
    public String getCard() {
        return "soundCard";
    }
}

