/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;

public class CategoryColor
extends CategoryObject {
    private static final int _RGB_dec = 0;
    private static final int _RRGGBB_hex = 1;
    private static final int _R_G_B_dec = 2;
    private static final int _HSB_dec = 3;
    private static String INVALID;
    private final ArrayList<Unit> units;
    private final Unit defaultSourceUnit;
    private final Unit defaultTargetUnit;
    private final Unit transferUnit;

    public CategoryColor(CategoryInterface categroyInterface) {
        this.rb = categroyInterface.getResourceBundle();
        INVALID = this.localize("Moduls.sourceInvalid", "Source is invalid");
        this.units = new ArrayList();
        this.units.add(new Unit(0, "RGB (dec)", "int"));
        this.units.add(new Unit(1, "RRGGBB (hex)", "int"));
        this.units.add(new Unit(2, "R, G, B (dec)", "int"));
        this.units.add(new Unit(3, "H, S, B (dec)", "int"));
        this.transferUnit = this.units.get(0);
        this.defaultSourceUnit = this.units.get(0);
        this.defaultTargetUnit = this.units.get(2);
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.units;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.units;
    }

    @Override
    public int getSourceDefault() {
        return 0;
    }

    public Unit getDefaultSourceUnit() {
        return this.defaultSourceUnit;
    }

    @Override
    public int getTargetDefault() {
        return 2;
    }

    public Unit getDefaultTargetUnit() {
        return this.defaultTargetUnit;
    }

    @Override
    public int getPreferredPrecision() {
        return -1;
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.units.get(s);
        Unit targetUnit = this.units.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        int sid = sourceUnit.getId();
        int tid = targetUnit.getId();
        long value = 0L;
        switch (sid) {
            case 0: {
                try {
                    value = Long.valueOf(this.input, 10);
                    if (value < 0L || value > 0xFFFFFFL) {
                        throw new Exception();
                    }
                    break;
                }
                catch (Exception e) {
                    throw new Exception(INVALID);
                }
            }
            case 1: {
                try {
                    value = Long.valueOf(this.input, 16);
                    if (value < 0L || value > 0xFFFFFFL) {
                        throw new Exception();
                    }
                    break;
                }
                catch (Exception e) {
                    throw new Exception(INVALID);
                }
            }
            case 2: {
                StringTokenizer st;
                try {
                    ArrayList<Integer> tokens = new ArrayList<Integer>();
                    st = new StringTokenizer(this.input, ",");
                    while (st.hasMoreTokens()) {
                        tokens.add(Integer.valueOf(st.nextToken().trim(), 10));
                    }
                    if (tokens.size() != 3) {
                        throw new Exception();
                    }
                    Color c = new Color((Integer)tokens.get(0), (Integer)tokens.get(1), (Integer)tokens.get(2));
                    value = (long)c.getRGB() & 0xFFFFFFL;
                    break;
                }
                catch (Exception e) {
                    throw new Exception(INVALID);
                }
            }
            case 3: {
                StringTokenizer st;
                try {
                    float[] f = new float[3];
                    st = new StringTokenizer(this.input, ",");
                    if (st.hasMoreTokens()) {
                        f[0] = Float.valueOf(st.nextToken().trim()).floatValue();
                        if (f[0] > 359.0f) {
                            throw new Exception(INVALID + " (H > 359)");
                        }
                    } else {
                        throw new Exception(INVALID);
                    }
                    f[0] = f[0] / 359.0f;
                    if (st.hasMoreTokens()) {
                        f[1] = Float.valueOf(st.nextToken().trim()).floatValue();
                        if (f[1] > 100.0f) {
                            throw new Exception(INVALID + " (S > 100)");
                        }
                    } else {
                        throw new Exception(INVALID);
                    }
                    f[1] = f[1] / 100.0f;
                    if (st.hasMoreTokens()) {
                        f[2] = Float.valueOf(st.nextToken().trim()).floatValue();
                        if (f[2] > 100.0f) {
                            throw new Exception(INVALID + " (B > 100)");
                        }
                    } else {
                        throw new Exception(INVALID);
                    }
                    f[2] = f[2] / 100.0f;
                    if (st.hasMoreTokens()) {
                        throw new Exception();
                    }
                    int color = Color.HSBtoRGB(f[0], f[1], f[2]);
                    value = (long)color & 0xFFFFFFL;
                    break;
                }
                catch (Exception e) {
                    throw new Exception(e.getMessage());
                }
            }
        }
        switch (tid) {
            case 0: {
                return Long.toString(value);
            }
            case 1: {
                String temp = Long.toHexString(value & 0xFFFFFFL).toUpperCase();
                if (temp.length() == 5) {
                    return "0" + temp;
                }
                return temp;
            }
            case 2: {
                Color c = new Color((int)value);
                return c.getRed() + ", " + c.getGreen() + ", " + c.getBlue();
            }
            case 3: {
                Color c = new Color((int)value);
                float[] f = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
                return Math.round(f[0] * 359.0f) + ", " + Math.round(f[1] * 100.0f) + ", " + Math.round(f[2] * 100.0f);
            }
        }
        return null;
    }

    @Override
    public String addValue(BigDecimal plus, int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.addValue(plus, sourceUnit);
    }

    public String addValue(BigDecimal plus, Unit sourceUnit) throws Exception {
        if (this.input == null || this.input.length() == 0) {
            this.input = "0";
            this.input = this.getOutput(this.transferUnit, sourceUnit);
        }
        String temp = this.getOutput(sourceUnit, this.transferUnit);
        BigDecimal big = new BigDecimal(temp);
        big = big.add(plus);
        return this.setValue(big, sourceUnit);
    }

    @Override
    public String setValue(BigDecimal big, int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.setValue(big, sourceUnit);
    }

    public String setValue(BigDecimal big, Unit sourceUnit) throws Exception {
        this.setInput(big.toPlainString());
        return this.getOutput(this.transferUnit, sourceUnit);
    }

    @Override
    public String getTransferValue(int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.getTransferValue(sourceUnit);
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        return this.getOutput(sourceUnit, this.transferUnit);
    }

    @Override
    public String getCard() {
        return "colCard";
    }
}

