/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.GregorianCalendar;
import fi.joensuu.joyds1.calendar.IslamicCalendar;
import fi.joensuu.joyds1.calendar.MayanCalendar;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;

public class CategoryCalendarSystems
extends CategoryObject {
    private static final int _TRANSFER = -1;
    private static final int _GREGORIAN = 0;
    private static final int _MAYAN = 1;
    private static final int _ISLAMIC = 2;
    private static String INVALID;
    private static Pattern patternGreg;
    private static Pattern patternMaya;
    private static Pattern patternIslamic;
    private final ArrayList<Unit> units;
    private final Unit defaultSourceUnit;
    private final Unit defaultTargetUnit;
    private final Unit transferUnit;
    private final Unit internalCalcUnit;

    public CategoryCalendarSystems(CategoryInterface categoryInterface) {
        this.rb = categoryInterface.getResourceBundle();
        INVALID = this.localize("Moduls.sourceInvalid", "Source is invalid");
        this.units = new ArrayList();
        this.units.add(new Unit(0, this.localize("Calendars.gregorianCalendar", "Gregorian Calendar"), "int"));
        this.units.add(new Unit(1, this.localize("Calendars.mayaCalendarLongCount", "Maya Calendar (long count)"), "int"));
        this.units.add(new Unit(2, this.localize("Calendars.islamicCalendar", "Islamic Calendar"), "int"));
        this.transferUnit = new Unit(-1);
        this.defaultSourceUnit = this.units.get(0);
        this.internalCalcUnit = this.units.get(0);
        this.defaultTargetUnit = this.units.get(2);
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.units;
    }

    public Unit getDefaultSourceUnit() {
        return this.defaultSourceUnit;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.units;
    }

    @Override
    public int getSourceDefault() {
        return 0;
    }

    @Override
    public int getTargetDefault() {
        return 2;
    }

    public Unit getDefaultTargetUnit() {
        return this.defaultTargetUnit;
    }

    public boolean isSpecialDefaultValue() {
        return true;
    }

    @Override
    public String getInitialValue() {
        return new GregorianCalendar().toString();
    }

    @Override
    public boolean isScientificSupported() {
        return false;
    }

    @Override
    public int getPreferredPrecision() {
        return -1;
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.units.get(s);
        Unit targetUnit = this.units.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        int sid = sourceUnit.getId();
        int tid = targetUnit.getId();
        GregorianCalendar calendar = new GregorianCalendar();
        switch (sid) {
            case -1: {
                int value = Integer.parseInt(this.input);
                int year = value / 10000;
                int month = value / 100 - year * 100;
                int day = value % 100;
                calendar.set(year, month, day);
                break;
            }
            case 0: {
                CategoryCalendarSystems.set((Calendar)calendar, this.input);
                break;
            }
            case 1: {
                Matcher matcher;
                if (patternMaya == null) {
                    patternMaya = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)$");
                }
                if ((matcher = patternMaya.matcher(this.input)).find()) {
                    int[] longCount = new int[5];
                    for (int i = 0; i < 5; ++i) {
                        longCount[i] = Integer.parseInt(matcher.group(i + 1));
                    }
                    MayanCalendar maya = new MayanCalendar(longCount[0], longCount[1], longCount[2], longCount[3], longCount[4]);
                    calendar.set((Calendar)maya);
                    break;
                }
                throw new IllegalArgumentException(INVALID);
            }
            case 2: {
                Matcher matcher;
                if (patternIslamic == null) {
                    patternIslamic = Pattern.compile("^(\\d+)-(\\d+)-(\\d+)$");
                }
                if ((matcher = patternIslamic.matcher(this.input)).find()) {
                    int[] tokens = new int[3];
                    for (int i = 0; i < 3; ++i) {
                        tokens[i] = Integer.parseInt(matcher.group(i + 1));
                    }
                    IslamicCalendar islamic = new IslamicCalendar(tokens[0], tokens[1], tokens[2]);
                    calendar.set((Calendar)islamic);
                    break;
                }
                throw new IllegalArgumentException(INVALID);
            }
        }
        switch (tid) {
            case -1: {
                return String.format("%04d%02d%02d", calendar.getYear(), calendar.getMonth(), calendar.getDay());
            }
            case 0: {
                return calendar.toString();
            }
            case 1: {
                try {
                    MayanCalendar maya = new MayanCalendar((Calendar)calendar);
                    return maya.toString();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(INVALID);
                }
            }
            case 2: {
                try {
                    IslamicCalendar islamic = new IslamicCalendar((Calendar)calendar);
                    return islamic.toString();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(INVALID);
                }
            }
        }
        return null;
    }

    @Override
    public String addValue(BigDecimal plus, int sourceindex) throws Exception {
        Unit sourceUnit = this.units.get(sourceindex);
        return this.addValue(plus, sourceUnit);
    }

    public String addValue(BigDecimal plus, Unit sourceUnit) throws Exception {
        if (this.input == null || this.input.length() == 0) {
            this.input = this.getInitialValue();
            this.input = this.getOutput(this.internalCalcUnit, sourceUnit);
        }
        GregorianCalendar cal = new GregorianCalendar();
        CategoryCalendarSystems.set((Calendar)cal, this.getOutput(sourceUnit, this.internalCalcUnit));
        int addDays = plus.toBigInteger().intValue();
        if (addDays == 0) {
            addDays = 1;
        }
        cal.addDays(addDays);
        this.setInput(cal.toString());
        return this.getOutput(this.internalCalcUnit, sourceUnit);
    }

    private static void set(Calendar calendar, String input) throws IllegalArgumentException {
        Matcher matcher;
        if (patternGreg == null) {
            patternGreg = Pattern.compile("^([-]??\\d+)\\-(\\d+)\\-(\\d+)$");
        }
        if (!(matcher = patternGreg.matcher(input)).find()) {
            throw new IllegalArgumentException(INVALID);
        }
        int year = Integer.parseInt(matcher.group(1));
        int month = Integer.parseInt(matcher.group(2));
        int day = Integer.parseInt(matcher.group(3));
        calendar.set(year, month, day);
    }

    @Override
    public String setValue(BigDecimal big, int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.setValue(big, sourceUnit);
    }

    public String setValue(BigDecimal big, Unit sourceUnit) throws Exception {
        this.setInput(big.toPlainString());
        return this.getOutput(this.transferUnit, sourceUnit);
    }

    @Override
    public String getTransferValue(int sourceIndex) throws Exception {
        Unit sourceUnit = this.units.get(sourceIndex);
        return this.getTransferValue(sourceUnit);
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        return this.getOutput(sourceUnit, this.transferUnit);
    }

    @Override
    public String getCard() {
        return "emptyCard";
    }
}

