/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.categories;

import java.math.BigDecimal;
import java.util.ArrayList;
import net.numericalchameleon.categories.CategoryInterface;
import net.numericalchameleon.categories.CategoryObject;
import net.numericalchameleon.data.Unit;

public class CategoryAlphaPhone
extends CategoryObject {
    private final ArrayList<Unit> sourceUnits;
    private final ArrayList<Unit> targetUnits;
    private final Unit defaultSourceUnit;
    private final Unit defaultTargetUnit;
    private final Unit transferUnit;
    private static final int TRANSFER = -1;

    public CategoryAlphaPhone(CategoryInterface clusterInterface) {
        this.rb = clusterInterface.getResourceBundle();
        this.sourceUnits = new ArrayList();
        this.sourceUnits.add(new Unit(0, this.localize("AlphaPhone.alphaName", "Phone# (alphanumerical)"), "int"));
        this.targetUnits = new ArrayList();
        this.targetUnits.add(new Unit(0, this.localize("AlphaPhone.numName", "Phone# (numerical)"), "int"));
        this.transferUnit = new Unit(-1);
        this.defaultSourceUnit = this.sourceUnits.get(0);
        this.defaultTargetUnit = this.targetUnits.get(0);
    }

    @Override
    public ArrayList<Unit> getSourceUnits() {
        return this.sourceUnits;
    }

    @Override
    public ArrayList<Unit> getTargetUnits() {
        return this.targetUnits;
    }

    @Override
    public int getSourceDefault() {
        return 0;
    }

    public Unit getDefaultSourceUnit() {
        return this.defaultSourceUnit;
    }

    @Override
    public int getTargetDefault() {
        return 0;
    }

    public Unit getDefaultTargetUnit() {
        return this.defaultTargetUnit;
    }

    @Override
    public int getPreferredPrecision() {
        return -1;
    }

    @Override
    public boolean isOneway() {
        return true;
    }

    @Override
    public boolean isPlusMinusSupported() {
        return false;
    }

    @Override
    public String getOutput(int s, int t) throws Exception {
        Unit sourceUnit = this.sourceUnits.get(s);
        Unit targetUnit = this.targetUnits.get(t);
        return this.getOutput(sourceUnit, targetUnit);
    }

    @Override
    public String getOutput(Unit sourceUnit, Unit targetUnit) throws Exception {
        int tid = targetUnit.getId();
        StringBuilder sb = new StringBuilder();
        String inputlc = this.input.toLowerCase();
        block11: for (int i = 0; i < inputlc.length(); ++i) {
            char c = inputlc.charAt(i);
            switch (c) {
                case 'a': 
                case 'b': 
                case 'c': {
                    sb.append('2');
                    continue block11;
                }
                case 'd': 
                case 'e': 
                case 'f': {
                    sb.append('3');
                    continue block11;
                }
                case 'g': 
                case 'h': 
                case 'i': {
                    sb.append('4');
                    continue block11;
                }
                case 'j': 
                case 'k': 
                case 'l': {
                    sb.append('5');
                    continue block11;
                }
                case 'm': 
                case 'n': 
                case 'o': {
                    sb.append('6');
                    continue block11;
                }
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': {
                    sb.append('7');
                    continue block11;
                }
                case 't': 
                case 'u': 
                case 'v': {
                    sb.append('8');
                    continue block11;
                }
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    sb.append('9');
                    continue block11;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    sb.append(c);
                    continue block11;
                }
                default: {
                    if (tid == -1) continue block11;
                    sb.append(this.input.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String addValue(BigDecimal plus, int sourceIndex) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getInitialValue() {
        return "555-HELP";
    }

    @Override
    public String setValue(BigDecimal big, int sourceIndex) throws Exception {
        throw new UnsupportedOperationException();
    }

    public String setValue(BigDecimal big, Unit sourceUnit) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTransferValue(int sourceindex) throws Exception {
        Unit sourceUnit = this.sourceUnits.get(sourceindex);
        return this.getOutput(sourceUnit, this.transferUnit);
    }

    @Override
    public String getTransferValue(Unit sourceUnit) throws Exception {
        return this.getOutput(sourceUnit, this.transferUnit);
    }

    @Override
    public String getCard() {
        return "emptyCard";
    }
}

