/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import java.awt.Color;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;

public class NimRODTheme
extends DefaultMetalTheme {
    public static final int DEFAULT_MENU_OPACITY = 195;
    public static final int DEFAULT_FRAME_OPACITY = 180;
    private ColorUIResource primary1 = new ColorUIResource(229, 171, 0);
    private ColorUIResource primary2 = new ColorUIResource(239, 181, 0);
    private ColorUIResource primary3 = new ColorUIResource(249, 191, 0);
    private ColorUIResource secondary1 = new ColorUIResource(173, 171, 137);
    private ColorUIResource secondary2 = new ColorUIResource(183, 181, 147);
    private ColorUIResource secondary3 = new ColorUIResource(193, 191, 157);
    private ColorUIResource black = new ColorUIResource(0, 0, 0);
    private ColorUIResource white = new ColorUIResource(255, 255, 255);
    private FontUIResource font = new FontUIResource("SansSerif", 0, 12);
    private FontUIResource boldFont = new FontUIResource("SansSerif", 1, 12);
    private int opacidadMenu = 195;
    private int opacidadFrame = 180;

    public NimRODTheme() {
    }

    public NimRODTheme(String nomFich) {
        Properties props = new Properties();
        InputStream res = null;
        try {
            res = new FileInputStream(nomFich);
        }
        catch (Exception ex) {
            nomFich = "/" + nomFich;
            res = this.getClass().getResourceAsStream(nomFich);
        }
        if (res != null) {
            try {
                props.load(res);
                ((InputStream)res).close();
                this.initFromProps(props);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
    }

    public NimRODTheme(URL url) {
        Properties props = new Properties();
        InputStream res = null;
        try {
            URLConnection con = url.openConnection();
            res = con.getInputStream();
            props.load(res);
            res.close();
            this.initFromProps(props);
        }
        catch (Exception ex) {
            return;
        }
    }

    private void initFromProps(Properties props) {
        this.setPrimary1(Color.decode(props.getProperty("nimrodlf.p1")));
        this.setPrimary2(Color.decode(props.getProperty("nimrodlf.p2")));
        this.setPrimary3(Color.decode(props.getProperty("nimrodlf.p3")));
        this.setSecondary1(Color.decode(props.getProperty("nimrodlf.s1")));
        this.setSecondary2(Color.decode(props.getProperty("nimrodlf.s2")));
        this.setSecondary3(Color.decode(props.getProperty("nimrodlf.s3")));
        this.setWhite(Color.decode(props.getProperty("nimrodlf.w")));
        this.setBlack(Color.decode(props.getProperty("nimrodlf.b")));
        this.setMenuOpacity(Integer.parseInt(props.getProperty("nimrodlf.menuOpacity")));
        this.setFrameOpacity(Integer.parseInt(props.getProperty("nimrodlf.frameOpacity")));
        if (props.getProperty("nimrodlf.font") != null) {
            this.setFont(Font.decode(props.getProperty("nimrodlf.font")));
        }
    }

    public NimRODTheme(Color base) {
        this.setPrimary(base);
    }

    public NimRODTheme(Color prim, Color sec) {
        this.setPrimary(prim);
        this.setSecondary(sec);
    }

    @Override
    public String getName() {
        return "NimROD Theme";
    }

    @Override
    protected ColorUIResource getPrimary1() {
        return this.primary1;
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return this.primary2;
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return this.primary3;
    }

    @Override
    protected ColorUIResource getSecondary1() {
        return this.secondary1;
    }

    @Override
    protected ColorUIResource getSecondary2() {
        return this.secondary2;
    }

    @Override
    protected ColorUIResource getSecondary3() {
        return this.secondary3;
    }

    @Override
    protected ColorUIResource getBlack() {
        return this.black;
    }

    @Override
    protected ColorUIResource getWhite() {
        return this.white;
    }

    public void setPrimary(Color selection) {
        int r = selection.getRed();
        int g = selection.getGreen();
        int b = selection.getBlue();
        this.primary1 = new ColorUIResource(new Color(r > 20 ? r - 20 : 0, g > 20 ? g - 20 : 0, b > 20 ? b - 20 : 0));
        this.primary2 = new ColorUIResource(new Color(r > 10 ? r - 10 : 0, g > 10 ? g - 10 : 0, b > 10 ? b - 10 : 0));
        this.primary3 = new ColorUIResource(selection);
    }

    public void setSecondary(Color background) {
        int r = background.getRed();
        int g = background.getGreen();
        int b = background.getBlue();
        this.secondary1 = new ColorUIResource(new Color(r > 20 ? r - 20 : 0, g > 20 ? g - 20 : 0, b > 20 ? b - 20 : 0));
        this.secondary2 = new ColorUIResource(new Color(r > 10 ? r - 10 : 0, g > 10 ? g - 10 : 0, b > 10 ? b - 10 : 0));
        this.secondary3 = new ColorUIResource(background);
    }

    public void setPrimary1(Color col) {
        this.primary1 = new ColorUIResource(col);
    }

    public void setPrimary2(Color col) {
        this.primary2 = new ColorUIResource(col);
    }

    public void setPrimary3(Color col) {
        this.primary3 = new ColorUIResource(col);
    }

    public void setSecondary1(Color col) {
        this.secondary1 = new ColorUIResource(col);
    }

    public void setSecondary2(Color col) {
        this.secondary2 = new ColorUIResource(col);
    }

    public void setSecondary3(Color col) {
        this.secondary3 = new ColorUIResource(col);
    }

    public void setBlack(Color col) {
        this.black = new ColorUIResource(col);
    }

    public void setWhite(Color col) {
        this.white = new ColorUIResource(col);
    }

    public void setOpacity(int val) {
        this.setMenuOpacity(val);
    }

    public int getOpacity() {
        return this.getMenuOpacity();
    }

    public void setMenuOpacity(int val) {
        if (val < 0 || val > 255) {
            throw new NumberFormatException("MenuOpacity out of range [0,255]: " + val);
        }
        this.opacidadMenu = val;
    }

    public int getMenuOpacity() {
        return this.opacidadMenu;
    }

    public void setFrameOpacity(int val) {
        if (val < 0 || val > 255) {
            throw new NumberFormatException("MenuOpacity out of range [0,255]: " + val);
        }
        this.opacidadFrame = val;
    }

    public int getFrameOpacity() {
        return this.opacidadFrame;
    }

    public void setFont(Font ff) {
        this.font = new FontUIResource(ff);
        this.boldFont = new FontUIResource(ff.deriveFont(1));
    }

    @Override
    public FontUIResource getControlTextFont() {
        return this.font;
    }

    @Override
    public FontUIResource getMenuTextFont() {
        return this.font;
    }

    @Override
    public FontUIResource getSubTextFont() {
        return this.font;
    }

    @Override
    public FontUIResource getSystemTextFont() {
        return this.boldFont;
    }

    @Override
    public FontUIResource getUserTextFont() {
        return this.font;
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        return this.boldFont;
    }

    public String toString() {
        StringBuffer cad = new StringBuffer();
        cad.append("nimrodlf.p1=" + this.encode(this.primary1) + "\n");
        cad.append("nimrodlf.p2=" + this.encode(this.primary2) + "\n");
        cad.append("nimrodlf.p3=" + this.encode(this.primary3) + "\n");
        cad.append("nimrodlf.s1=" + this.encode(this.secondary1) + "\n");
        cad.append("nimrodlf.s2=" + this.encode(this.secondary2) + "\n");
        cad.append("nimrodlf.s3=" + this.encode(this.secondary3) + "\n");
        cad.append("nimrodlf.w=" + this.encode(this.white) + "\n");
        cad.append("nimrodlf.b=" + this.encode(this.black) + "\n");
        cad.append("nimrodlf.menuOpacity=" + this.opacidadMenu + "\n");
        cad.append("nimrodlf.frameOpacity=" + this.opacidadFrame + "\n");
        cad.append("nimrodlf.font=" + this.encode(this.font) + "\n");
        return cad.toString();
    }

    protected String encode(Font ff) {
        StringBuilder res = new StringBuilder();
        res.append(ff.getName() + "-");
        if (ff.isPlain()) {
            res.append("PLAIN-");
        } else if (ff.isBold() && ff.isItalic()) {
            res.append("BOLDITALIC-");
        } else if (ff.isBold()) {
            res.append("BOLD-");
        } else if (ff.isItalic()) {
            res.append("ITALIC-");
        }
        res.append(ff.getSize());
        return res.toString();
    }

    protected String encode(Color col) {
        String r = Integer.toHexString(col.getRed()).toUpperCase();
        String g = Integer.toHexString(col.getGreen()).toUpperCase();
        String b = Integer.toHexString(col.getBlue()).toUpperCase();
        return "#" + (r.length() == 1 ? "0" + r : r) + (g.length() == 1 ? "0" + g : g) + (b.length() == 1 ? "0" + b : b);
    }
}

