/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.GradientTheme;
import com.incors.plaf.kunststoff.KunststoffGradientTheme;
import com.incors.plaf.kunststoff.KunststoffTheme;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class KunststoffLookAndFeel
extends MetalLookAndFeel {
    private static GradientTheme gradientTheme;
    private static boolean isInstalled;
    private static boolean themeHasBeenSet;

    public KunststoffLookAndFeel() {
        if (!isInstalled) {
            UIManager.installLookAndFeel(new UIManager.LookAndFeelInfo("Kunststoff", "com.incors.plaf.kunststoff.KunststoffLookAndFeel"));
            isInstalled = true;
        }
    }

    public String getID() {
        return "Kunststoff";
    }

    public String getName() {
        return "Kunststoff";
    }

    public String getDescription() {
        return "Kunststoff Look&Feel 2.0.3. Developed by INCORS GmbH and contributors, 2001-2004. Published under the Lesser GNU Public Licence.";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        this.putDefault(uIDefaults, "ButtonUI");
        this.putDefault(uIDefaults, "ToggleButtonUI");
        this.putDefault(uIDefaults, "ComboBoxUI");
        this.putDefault(uIDefaults, "TabbedPaneUI");
        this.putDefault(uIDefaults, "TextFieldUI");
        this.putDefault(uIDefaults, "PasswordFieldUI");
        this.putDefault(uIDefaults, "ListUI");
        this.putDefault(uIDefaults, "TreeUI");
        this.putDefault(uIDefaults, "ToolBarUI");
        this.putDefault(uIDefaults, "MenuBarUI");
        this.putDefault(uIDefaults, "MenuUI");
        this.putDefault(uIDefaults, "ScrollBarUI");
        this.putDefault(uIDefaults, "ProgressBarUI");
        this.putDefault(uIDefaults, "TableHeaderUI");
        this.putDefault(uIDefaults, "InternalFrameUI");
    }

    protected void putDefault(UIDefaults uIDefaults, String string) {
        try {
            String string2 = "com.incors.plaf.kunststoff.Kunststoff" + string;
            uIDefaults.put(string, string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void createDefaultTheme() {
        if (!themeHasBeenSet) {
            KunststoffLookAndFeel.setCurrentTheme(new KunststoffTheme());
        }
        if (gradientTheme == null) {
            gradientTheme = new KunststoffGradientTheme();
        }
    }

    public static void setCurrentGradientTheme(GradientTheme gradientTheme) {
        if (gradientTheme == null) {
            throw new NullPointerException("Gradient Theme cannot have null value");
        }
        KunststoffLookAndFeel.gradientTheme = gradientTheme;
    }

    public static void setCurrentTheme(MetalTheme metalTheme) {
        MetalLookAndFeel.setCurrentTheme(metalTheme);
        themeHasBeenSet = true;
    }

    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
        super.initSystemColorDefaults(uIDefaults);
        uIDefaults.put("textHighlight", KunststoffUtilities.getTranslucentColorUIResource(KunststoffLookAndFeel.getTextHighlightColor(), 128));
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        uIDefaults.put("SplitPane.dividerSize", new Integer(8));
        String string = "/javax/swing/plaf/metal/";
        Object[] objectArray = (Object[])uIDefaults.get("AuditoryCues.allAuditoryCues");
        if (objectArray != null) {
            Object[] objectArray2 = new String[objectArray.length * 2];
            for (int i = 0; i < objectArray.length; ++i) {
                Object object;
                objectArray2[2 * i] = object = objectArray[i];
                objectArray2[2 * i + 1] = string + uIDefaults.getString(object);
            }
            uIDefaults.putDefaults(objectArray2);
        }
    }

    public static ColorUIResource getComponentGradientColorReflection() {
        return gradientTheme.getComponentGradientColorReflection();
    }

    public static ColorUIResource getComponentGradientColorShadow() {
        return gradientTheme.getComponentGradientColorShadow();
    }

    public static ColorUIResource getTextComponentGradientColorReflection() {
        return gradientTheme.getTextComponentGradientColorReflection();
    }

    public static ColorUIResource getTextComponentGradientColorShadow() {
        return gradientTheme.getTextComponentGradientColorShadow();
    }

    public static int getBackgroundGradientShadow() {
        return gradientTheme.getBackgroundGradientShadow();
    }

    static {
        isInstalled = false;
        themeHasBeenSet = false;
    }
}

