/*
 * Decompiled with CFR 0.152.
 */
package uk.me.jstott.jcoord;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.jstott.jcoord.CoordinateSystem;
import uk.me.jstott.jcoord.LatLng;
import uk.me.jstott.jcoord.UTMRef;
import uk.me.jstott.jcoord.datum.WGS84Datum;

public class MGRSRef
extends CoordinateSystem {
    private int utmZoneNumber;
    private char utmZoneChar;
    private char eastingID;
    private char northingID;
    private int easting;
    private int northing;
    private int precision;
    private boolean isBessel;
    public static final int PRECISION_10000M = 10000;
    public static final int PRECISION_1000M = 1000;
    public static final int PRECISION_100M = 100;
    public static final int PRECISION_10M = 10;
    public static final int PRECISION_1M = 1;
    private static final char[] northingIDs = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V'};

    public MGRSRef(UTMRef uTMRef) {
        this(uTMRef, false);
    }

    public MGRSRef(UTMRef uTMRef, boolean bl) {
        super(WGS84Datum.getInstance());
        int n = uTMRef.getLngZone();
        int n2 = (n - 1) % 6 + 1;
        int n3 = (int)Math.floor(uTMRef.getEasting() / 100000.0) + 8 * ((n2 - 1) % 3);
        int n4 = (int)Math.floor(uTMRef.getNorthing() % 2000000.0 / 100000.0);
        if (n3 > 8) {
            ++n3;
        }
        if (n3 > 14) {
            ++n3;
        }
        char c = (char)(n3 + 64);
        if (n2 % 2 == 0) {
            n4 += 5;
        }
        if (bl) {
            n4 += 10;
        }
        if (n4 > 19) {
            n4 -= 20;
        }
        char c2 = northingIDs[n4];
        this.utmZoneNumber = n;
        this.utmZoneChar = uTMRef.getLatZone();
        this.eastingID = c;
        this.northingID = c2;
        this.easting = (int)Math.round(uTMRef.getEasting()) % 100000;
        this.northing = (int)Math.round(uTMRef.getNorthing()) % 100000;
        this.precision = 1;
        this.isBessel = bl;
    }

    public MGRSRef(int n, char c, char c2, char c3, int n2, int n3, int n4) throws IllegalArgumentException {
        this(n, c, c2, c3, n2, n3, n4, false);
    }

    public MGRSRef(int n, char c, char c2, char c3, int n2, int n3, int n4, boolean bl) throws IllegalArgumentException {
        super(WGS84Datum.getInstance());
        if (n < 1 || n > 60) {
            throw new IllegalArgumentException("Invalid utmZoneNumber (" + n + ")");
        }
        if (c < 'A' || c > 'Z') {
            throw new IllegalArgumentException("Invalid utmZoneChar (" + c + ")");
        }
        if (c2 < 'A' || c2 > 'Z' || c2 == 'I' || c2 == 'O') {
            throw new IllegalArgumentException("Invalid eastingID (" + c2 + ")");
        }
        if (c3 < 'A' || c3 > 'Z' || c3 == 'I' || c3 == 'O') {
            throw new IllegalArgumentException("Invalid northingID (" + c3 + ")");
        }
        if (n2 < 0 || n2 > 99999) {
            throw new IllegalArgumentException("Invalid easting (" + n2 + ")");
        }
        if (n3 < 0 || n3 > 99999) {
            throw new IllegalArgumentException("Invalid northing (" + n3 + ")");
        }
        if (n4 != 1 && n4 != 10 && n4 != 100 && n4 != 1000 && n4 != 10000) {
            throw new IllegalArgumentException("Invalid precision (" + n4 + ")");
        }
        this.utmZoneNumber = n;
        this.utmZoneChar = c;
        this.eastingID = c2;
        this.northingID = c3;
        this.easting = n2;
        this.northing = n3;
        this.precision = n4;
        this.isBessel = bl;
    }

    public MGRSRef(String string) throws IllegalArgumentException {
        this(string, false);
    }

    public MGRSRef(String string, boolean bl) throws IllegalArgumentException {
        super(WGS84Datum.getInstance());
        Pattern pattern = Pattern.compile("(\\d{1,2})([C-X&&[^IO]])([A-Z&&[^IO]])([A-Z&&[^IO]])(\\d{2,10})");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid MGRS reference (" + string + ")");
        }
        this.utmZoneNumber = Integer.parseInt(matcher.group(1));
        this.utmZoneChar = matcher.group(2).charAt(0);
        this.eastingID = matcher.group(3).charAt(0);
        this.northingID = matcher.group(4).charAt(0);
        String string2 = matcher.group(5);
        int n = string2.length();
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Invalid MGRS reference (" + string + ")");
        }
        this.precision = (int)Math.pow(10.0, 5 - n / 2);
        this.easting = Integer.parseInt(string2.substring(0, n / 2)) * this.precision;
        this.northing = Integer.parseInt(string2.substring(n / 2)) * this.precision;
    }

    public UTMRef toUTMRef() {
        int n = (this.utmZoneNumber - 1) % 6 + 1;
        int n2 = this.eastingID - 65;
        if (n2 > 15) {
            --n2;
        }
        if (n2 > 9) {
            --n2;
        }
        int n3 = (this.easting + (n2 % 8 + 1) * 100000) % 1000000;
        int n4 = this.northingID - 64;
        if (n4 > 15) {
            --n4;
        }
        if (n4 > 9) {
            --n4;
        }
        if (n % 2 == 0) {
            n4 -= 5;
        }
        if (n4 < 0) {
            n4 += 16;
        }
        int n5 = 0;
        boolean bl = n % 2 == 0;
        switch (this.utmZoneChar) {
            case 'Q': {
                if ((bl || this.northingID >= 'T') && (!bl || this.northingID >= 'C' && this.northingID <= 'E')) break;
                n5 += 2000000;
                break;
            }
            case 'R': {
                n5 += 2000000;
                break;
            }
            case 'S': {
                if (!bl && this.northingID < 'R' || bl && this.northingID > 'E') {
                    n5 += 4000000;
                    break;
                }
                n5 += 2000000;
                break;
            }
            case 'T': {
                n5 += 4000000;
                break;
            }
            case 'U': {
                if (!bl && this.northingID < 'P' || bl && this.northingID < 'U') {
                    n5 += 6000000;
                    break;
                }
                n5 += 4000000;
                break;
            }
            case 'V': 
            case 'W': {
                n5 += 6000000;
                break;
            }
            case 'X': {
                n5 += 8000000;
            }
        }
        return new UTMRef(this.utmZoneNumber, this.utmZoneChar, n3, (double)(n5 += 100000 * (n4 - 1) + this.northing));
    }

    @Override
    public LatLng toLatLng() {
        return this.toUTMRef().toLatLng();
    }

    public String toString() {
        return this.toString(this.precision);
    }

    public String toString(int n) {
        if (n != 1 && n != 10 && n != 100 && n != 1000 && n != 10000) {
            throw new IllegalArgumentException("Precision (" + n + ") must be 1m, 10m, 100m, 1000m or 10000m");
        }
        int n2 = (int)Math.floor(this.easting / n);
        int n3 = (int)Math.floor(this.northing / n);
        int n4 = 5;
        switch (n) {
            case 10: {
                n4 = 4;
                break;
            }
            case 100: {
                n4 = 3;
                break;
            }
            case 1000: {
                n4 = 2;
                break;
            }
            case 10000: {
                n4 = 1;
            }
        }
        String string = Integer.toString(n2);
        for (int i = n4 - string.length(); i > 0; --i) {
            string = "0" + string;
        }
        String string2 = Integer.toString(n3);
        for (int i = n4 - string2.length(); i > 0; --i) {
            string2 = "0" + string2;
        }
        String string3 = "";
        if (this.utmZoneNumber < 10) {
            string3 = "0";
        }
        return string3 + this.utmZoneNumber + Character.toString(this.utmZoneChar) + Character.toString(this.eastingID) + Character.toString(this.northingID) + string + string2;
    }

    public int getEasting() {
        return this.easting;
    }

    public char getEastingID() {
        return this.eastingID;
    }

    public boolean isBessel() {
        return this.isBessel;
    }

    public int getNorthing() {
        return this.northing;
    }

    public char getNorthingID() {
        return this.northingID;
    }

    public int getPrecision() {
        return this.precision;
    }

    public char getUtmZoneChar() {
        return this.utmZoneChar;
    }

    public int getUtmZoneNumber() {
        return this.utmZoneNumber;
    }
}

