/*
 * Decompiled with CFR 0.152.
 */
package uk.me.jstott.jcoord;

import uk.me.jstott.jcoord.CoordinateSystem;
import uk.me.jstott.jcoord.LatLng;
import uk.me.jstott.jcoord.Util;
import uk.me.jstott.jcoord.datum.Ireland1965Datum;
import uk.me.jstott.jcoord.ellipsoid.Ellipsoid;

public class IrishRef
extends CoordinateSystem {
    private double easting;
    private double northing;
    public static final double SCALE_FACTOR = 1.000035;
    public static final double FALSE_ORIGIN_LATITUDE = 53.5;
    public static final double FALSE_ORIGIN_LONGITUDE = -8.0;
    public static final double FALSE_ORIGIN_EASTING = 200000.0;
    public static final double FALSE_ORIGIN_NORTHING = 250000.0;

    public IrishRef(double d, double d2) throws IllegalArgumentException {
        super(Ireland1965Datum.getInstance());
        this.setEasting(d);
        this.setNorthing(d2);
    }

    public IrishRef(String string) throws IllegalArgumentException {
        super(Ireland1965Datum.getInstance());
        char c = string.charAt(0);
        int n = Integer.parseInt(string.substring(1, 4)) * 100;
        int n2 = Integer.parseInt(string.substring(4, 7)) * 100;
        if (c > 'I') {
            c = (char)(c - '\u0001');
        }
        double d = (c - 65) % 5 * 100000;
        double d2 = (4.0 - Math.floor((c - 65) / 5)) * 100000.0;
        this.setEasting((double)n + d);
        this.setNorthing((double)n2 + d2);
    }

    public IrishRef(LatLng latLng) {
        super(Ireland1965Datum.getInstance());
        Ellipsoid ellipsoid = this.getDatum().getReferenceEllipsoid();
        double d = 250000.0;
        double d2 = 200000.0;
        double d3 = Math.toRadians(53.5);
        double d4 = Math.toRadians(-8.0);
        double d5 = ellipsoid.getSemiMajorAxis() * 1.000035;
        double d6 = ellipsoid.getSemiMinorAxis() * 1.000035;
        double d7 = ellipsoid.getEccentricitySquared();
        double d8 = Math.toRadians(latLng.getLatitude());
        double d9 = Math.toRadians(latLng.getLongitude());
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = (d5 - d6) / (d5 + d6);
        double d13 = d5 * Math.pow(1.0 - d7 * Util.sinSquared(d8), -0.5);
        double d14 = d5 * (1.0 - d7) * Math.pow(1.0 - d7 * Util.sinSquared(d8), -1.5);
        double d15 = d13 / d14 - 1.0;
        double d16 = d6 * ((1.0 + d12 + 1.25 * d12 * d12 + 1.25 * d12 * d12 * d12) * (d8 - d3) - (3.0 * d12 + 3.0 * d12 * d12 + 2.625 * d12 * d12 * d12) * Math.sin(d8 - d3) * Math.cos(d8 + d3) + (1.875 * d12 * d12 + 1.875 * d12 * d12 * d12) * Math.sin(2.0 * (d8 - d3)) * Math.cos(2.0 * (d8 + d3)) - 1.4583333333333333 * d12 * d12 * d12 * Math.sin(3.0 * (d8 - d3)) * Math.cos(3.0 * (d8 + d3)));
        double d17 = d16 + d;
        double d18 = d13 / 2.0 * Math.sin(d8) * Math.cos(d8);
        double d19 = d13 / 24.0 * Math.sin(d8) * Math.pow(Math.cos(d8), 3.0) * (5.0 - Util.tanSquared(d8) + 9.0 * d15);
        double d20 = d13 / 720.0 * Math.sin(d8) * Math.pow(Math.cos(d8), 5.0) * (61.0 - 58.0 * Util.tanSquared(d8) + Math.pow(Math.tan(d8), 4.0));
        double d21 = d13 * Math.cos(d8);
        double d22 = d13 / 6.0 * Math.pow(Math.cos(d8), 3.0) * (d13 / d14 - Util.tanSquared(d8));
        double d23 = d13 / 120.0 * Math.pow(Math.cos(d8), 5.0) * (5.0 - 18.0 * Util.tanSquared(d8) + Math.pow(Math.tan(d8), 4.0) + 14.0 * d15 - 58.0 * Util.tanSquared(d8) * d15);
        d11 = d17 + d18 * Math.pow(d9 - d4, 2.0) + d19 * Math.pow(d9 - d4, 4.0) + d20 * Math.pow(d9 - d4, 6.0);
        d10 = d2 + d21 * (d9 - d4) + d22 * Math.pow(d9 - d4, 3.0) + d23 * Math.pow(d9 - d4, 5.0);
        this.setEasting(d10);
        this.setNorthing(d11);
    }

    public String toString() {
        return "(" + this.easting + ", " + this.northing + ")";
    }

    public String toSixFigureString() {
        int n = (int)Math.floor(this.easting / 100000.0);
        int n2 = (int)Math.floor(this.northing / 100000.0);
        int n3 = 4 - n2;
        int n4 = 65 + 5 * n3 + n;
        if (n4 >= 73) {
            ++n4;
        }
        String string = Character.toString((char)n4);
        int n5 = (int)Math.floor((this.easting - (double)(100000 * n)) / 100.0);
        int n6 = (int)Math.floor((this.northing - (double)(100000 * n2)) / 100.0);
        String string2 = "" + n5;
        if (n5 < 100) {
            string2 = "0" + string2;
        }
        if (n5 < 10) {
            string2 = "0" + string2;
        }
        String string3 = "" + n6;
        if (n6 < 100) {
            string3 = "0" + string3;
        }
        if (n6 < 10) {
            string3 = "0" + string3;
        }
        return string + string2 + string3;
    }

    @Override
    public LatLng toLatLng() {
        double d = 250000.0;
        double d2 = 200000.0;
        double d3 = Math.toRadians(53.5);
        double d4 = Math.toRadians(-8.0);
        double d5 = this.getDatum().getReferenceEllipsoid().getSemiMajorAxis();
        double d6 = this.getDatum().getReferenceEllipsoid().getSemiMinorAxis();
        double d7 = this.getDatum().getReferenceEllipsoid().getEccentricitySquared();
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = this.easting;
        double d11 = this.northing;
        double d12 = (d5 - d6) / (d5 + d6);
        double d13 = 0.0;
        double d14 = (d11 - d) / (d5 * 1.000035) + d3;
        do {
            d13 = d6 * 1.000035 * ((1.0 + d12 + 1.25 * d12 * d12 + 1.25 * d12 * d12 * d12) * (d14 - d3) - (3.0 * d12 + 3.0 * d12 * d12 + 2.625 * d12 * d12 * d12) * Math.sin(d14 - d3) * Math.cos(d14 + d3) + (1.875 * d12 * d12 + 1.875 * d12 * d12 * d12) * Math.sin(2.0 * (d14 - d3)) * Math.cos(2.0 * (d14 + d3)) - 1.4583333333333333 * d12 * d12 * d12 * Math.sin(3.0 * (d14 - d3)) * Math.cos(3.0 * (d14 + d3)));
            d14 += (d11 - d - d13) / (d5 * 1.000035);
        } while (d11 - d - d13 >= 0.001);
        double d15 = d5 * 1.000035 * Math.pow(1.0 - d7 * Util.sinSquared(d14), -0.5);
        double d16 = d5 * 1.000035 * (1.0 - d7) * Math.pow(1.0 - d7 * Util.sinSquared(d14), -1.5);
        double d17 = d15 / d16 - 1.0;
        double d18 = Math.tan(d14) / (2.0 * d16 * d15);
        double d19 = Math.tan(d14) / (24.0 * d16 * Math.pow(d15, 3.0)) * (5.0 + 3.0 * Util.tanSquared(d14) + d17 - 9.0 * Util.tanSquared(d14) * d17);
        double d20 = Math.tan(d14) / (720.0 * d16 * Math.pow(d15, 5.0)) * (61.0 + 90.0 * Util.tanSquared(d14) + 45.0 * Util.tanSquared(d14) * Util.tanSquared(d14));
        double d21 = Util.sec(d14) / d15;
        double d22 = Util.sec(d14) / (6.0 * d15 * d15 * d15) * (d15 / d16 + 2.0 * Util.tanSquared(d14));
        double d23 = Util.sec(d14) / (120.0 * Math.pow(d15, 5.0)) * (5.0 + 28.0 * Util.tanSquared(d14) + 24.0 * Util.tanSquared(d14) * Util.tanSquared(d14));
        double d24 = Util.sec(d14) / (5040.0 * Math.pow(d15, 7.0)) * (61.0 + 662.0 * Util.tanSquared(d14) + 1320.0 * Util.tanSquared(d14) * Util.tanSquared(d14) + 720.0 * Util.tanSquared(d14) * Util.tanSquared(d14) * Util.tanSquared(d14));
        d8 = d14 - d18 * Math.pow(d10 - d2, 2.0) + d19 * Math.pow(d10 - d2, 4.0) - d20 * Math.pow(d10 - d2, 6.0);
        d9 = d4 + d21 * (d10 - d2) - d22 * Math.pow(d10 - d2, 3.0) + d23 * Math.pow(d10 - d2, 5.0) - d24 * Math.pow(d10 - d2, 7.0);
        return new LatLng(Math.toDegrees(d8), Math.toDegrees(d9));
    }

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }

    public void setEasting(double d) throws IllegalArgumentException {
        if (d < 0.0 || d >= 400000.0) {
            throw new IllegalArgumentException("Easting (" + d + ") is invalid. Must be greather than or equal to 0.0 and " + "less than 400000.0.");
        }
        this.easting = d;
    }

    public void setNorthing(double d) throws IllegalArgumentException {
        if (d < 0.0 || d > 500000.0) {
            throw new IllegalArgumentException("Northing (" + d + ") is invalid. Must be greather than or equal to 0.0 and less " + "than or equal to 500000.0.");
        }
        this.northing = d;
    }
}

