/*
 * Decompiled with CFR 0.152.
 */
package net.numericalchameleon.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.Serializable;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class Dice
extends JComponent
implements Serializable {
    private int value;
    private Random random;
    private static final Color BACKGROUND_COLOR = UIManager.getColor("control");
    public static final Color DICE_DEFAULT_COLOR = new Color(231, 233, 229);
    private Color DICE_BASE_COLOR = DICE_DEFAULT_COLOR;
    private Color DICE_BRIGTH_COLOR = Dice.createBrighterColor(this.DICE_BASE_COLOR);
    private Color DICE_DARK_COLOR = Dice.createDarkerColor(this.DICE_BASE_COLOR);
    private static final Color DOT_COLOR_DARKEST = Color.black;
    private static final Color DOT_COLOR_BRIGHTEST = new Color(192, 192, 192);
    private static final Color DOT_COLOR_MID = new Color(64, 64, 64);
    static final long serialVersionUID = 1692502012748353331L;

    public static void main(String[] stringArray) {
        Dice dice = new Dice();
        JFrame jFrame = new JFrame("Dice Demo");
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)dice, "Center");
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private static Color createBrighterColor(Color color) {
        return Dice.createModifiedColor(color, 1.1);
    }

    private static Color createDarkerColor(Color color) {
        return Dice.createModifiedColor(color, 0.77);
    }

    private static Color createModifiedColor(Color color, double d) {
        return new Color(Dice.multiplyWith255Max(color.getRed(), d), Dice.multiplyWith255Max(color.getGreen(), d), Dice.multiplyWith255Max(color.getBlue(), d));
    }

    private static int multiplyWith255Max(int n, double d) {
        int n2 = (int)((double)n * d);
        return n2 > 255 ? 255 : n2;
    }

    public Dice() {
        this.init();
    }

    public Dice(int n) {
        this.init(n);
    }

    private void init() {
        this.random = new Random();
        this.setValue(this.getRandomValueForDice());
    }

    private void init(int n) {
        this.random = new Random();
        this.setValue(n);
    }

    public void setRandomColor() {
        int[] nArray = new int[3];
        try {
            for (int i = 0; i < 3; ++i) {
                nArray[i] = this.random.nextInt(254) + 1;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
        }
        this.setColor(new Color(nArray[0], nArray[1], nArray[2]));
    }

    public void setColor(Color color) {
        this.DICE_BASE_COLOR = color;
        this.DICE_BRIGTH_COLOR = Dice.createBrighterColor(this.DICE_BASE_COLOR);
        this.DICE_DARK_COLOR = Dice.createDarkerColor(this.DICE_BASE_COLOR);
        this.repaint();
    }

    public Color getColor() {
        return this.DICE_BASE_COLOR;
    }

    public void setValue(int n) {
        if (n < 1 || n > 6) {
            throw new IllegalArgumentException("Value for dice must be in the range [1..6], it was " + n);
        }
        this.value = n;
    }

    public int getValue() {
        return this.value;
    }

    public void roll() {
        this.setValue(this.getRandomValueForDice());
        this.repaint();
    }

    private int getRandomValueForDice() {
        int n = 0;
        try {
            n = this.random.nextInt(6) + 1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
        }
        return n;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(96, 96);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Dimension dimension = this.getSize();
        int n = Math.max(0, dimension.width - 10);
        int n2 = Math.max(0, dimension.height - 10);
        int n3 = Math.min(n, n2);
        int n4 = (dimension.width - n3) / 2;
        int n5 = (dimension.height - n3) / 2;
        DiceBounds diceBounds = new DiceBounds(n4, n5, n3, n3);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintBackground(graphics2D);
        this.paintRawDice(graphics2D, diceBounds);
        this.paintDots(graphics2D, diceBounds);
    }

    private void paintBackground(Graphics2D graphics2D) {
        graphics2D.setColor(BACKGROUND_COLOR);
        graphics2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
    }

    private void paintDots(Graphics2D graphics2D, DiceBounds diceBounds) {
        switch (this.value) {
            case 1: {
                this.paintDot(graphics2D, 1, 1, diceBounds);
                break;
            }
            case 2: {
                this.paintDot(graphics2D, 0, 0, diceBounds);
                this.paintDot(graphics2D, 2, 2, diceBounds);
                break;
            }
            case 3: {
                this.paintDot(graphics2D, 0, 0, diceBounds);
                this.paintDot(graphics2D, 1, 1, diceBounds);
                this.paintDot(graphics2D, 2, 2, diceBounds);
                break;
            }
            case 4: {
                this.paintDot(graphics2D, 0, 0, diceBounds);
                this.paintDot(graphics2D, 2, 0, diceBounds);
                this.paintDot(graphics2D, 0, 2, diceBounds);
                this.paintDot(graphics2D, 2, 2, diceBounds);
                break;
            }
            case 5: {
                this.paintDot(graphics2D, 0, 0, diceBounds);
                this.paintDot(graphics2D, 2, 0, diceBounds);
                this.paintDot(graphics2D, 0, 2, diceBounds);
                this.paintDot(graphics2D, 2, 2, diceBounds);
                this.paintDot(graphics2D, 1, 1, diceBounds);
                break;
            }
            case 6: {
                this.paintDot(graphics2D, 0, 0, diceBounds);
                this.paintDot(graphics2D, 0, 1, diceBounds);
                this.paintDot(graphics2D, 2, 1, diceBounds);
                this.paintDot(graphics2D, 2, 0, diceBounds);
                this.paintDot(graphics2D, 0, 2, diceBounds);
                this.paintDot(graphics2D, 2, 2, diceBounds);
            }
        }
    }

    private void paintDot(Graphics2D graphics2D, int n, int n2, DiceBounds diceBounds) {
        int n3 = diceBounds.getWidth() * 13 / 90;
        int n4 = diceBounds.getHeight() * 13 / 90;
        int n5 = diceBounds.getWidth() * 21 / 90;
        int n6 = diceBounds.getHeight() * 21 / 90;
        int n7 = diceBounds.getInsetX() + n * n5 + (diceBounds.getWidth() - n5 * 2) / 2 - n3 / 2;
        int n8 = diceBounds.getInsetY() + n2 * n6 + (diceBounds.getHeight() - n6 * 2) / 2 - n4 / 2;
        graphics2D.setColor(DOT_COLOR_DARKEST);
        graphics2D.fillArc(n7, n8, n3, n4, 0, 360);
        graphics2D.setPaint(new GradientPaint(n7 + 1 + (n3 - 2) / 2, n8 + 1 + (n4 - 2) / 2, DOT_COLOR_MID, n7 + 1 + (n3 - 2) / 4, n8 + 1 + (n4 - 2) / 4, DOT_COLOR_BRIGHTEST, true));
        graphics2D.fillArc(n7 + 1, n8 + 1, n3 - 2, n4 - 2, 285, 30);
    }

    private void paintRawDice(Graphics2D graphics2D, DiceBounds diceBounds) {
        int n = (int)((double)diceBounds.getWidth() / 7.5);
        int n2 = (int)((double)diceBounds.getHeight() / 7.5);
        int n3 = diceBounds.getWidth() * 7 / 9;
        int n4 = diceBounds.getHeight() * 7 / 9;
        int n5 = diceBounds.getWidth() / 45;
        int n6 = diceBounds.getHeight() / 45;
        graphics2D.setPaint(new GradientPaint((float)((double)diceBounds.getInsetX() + (double)diceBounds.getWidth() / 3.6), diceBounds.getInsetY(), this.DICE_BRIGTH_COLOR, diceBounds.getInsetX() + diceBounds.getWidth() / 3, diceBounds.getInsetY() + diceBounds.getHeight(), this.DICE_DARK_COLOR));
        graphics2D.fillRoundRect(diceBounds.getInsetX(), diceBounds.getInsetY(), diceBounds.getWidth(), diceBounds.getHeight(), n, n2);
        graphics2D.setColor(this.DICE_BASE_COLOR);
        graphics2D.fillRoundRect(diceBounds.getInsetX() + n5, diceBounds.getInsetY() + n6, diceBounds.getWidth() - n5 * 2, diceBounds.getHeight() - n6 * 2, n3, n4);
    }

    private static final class DiceBounds {
        private int insetX;
        private int insetY;
        private int width;
        private int height;

        public DiceBounds(int n, int n2, int n3, int n4) {
            this.insetX = n;
            this.insetY = n2;
            this.width = n3;
            this.height = n4;
        }

        public int getInsetX() {
            return this.insetX;
        }

        public int getInsetY() {
            return this.insetY;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

