/*
 * Decompiled with CFR 0.152.
 */
package jonelo.sugar.io;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class GeneralIO {
    public static final String ERROR_DIRNOTFOUND = "Error.DirNotFound";
    public static final String ERROR_NOTADIR = "Error.NotADirectory";
    public static final String ERROR_READDIR = "Error.CanNotReadDirectory";
    public static String ERROR_CLIPBOARD_EMPTY = "Clipboard is empty.";
    public static String ERROR_CLIPBOARD_ISNOTTEXT = "Content of clipboard isn't text.";

    public static Vector ls(String directory, String suffix) throws Exception {
        return GeneralIO.ls(directory, suffix, true);
    }

    public static Vector ls(String directory, String suffix, boolean withSuffix) throws Exception {
        File present = new File(directory);
        if (!present.exists()) {
            throw new Exception("Error.DirNotFound " + directory);
        }
        if (!present.isDirectory()) {
            throw new Exception("Error.NotADirectory " + directory);
        }
        if (!present.canRead()) {
            throw new Exception("Error.CanNotReadDirectory " + directory);
        }
        Vector<String> v = new Vector<String>();
        Object[] dirlist = present.list();
        Arrays.sort(dirlist);
        for (int ind = 0; dirlist != null && ind < dirlist.length; ++ind) {
            File entry = new File(present, (String)dirlist[ind]);
            if (!entry.isFile() || !((String)dirlist[ind]).endsWith(suffix)) continue;
            if (withSuffix) {
                v.add(entry.getName());
                continue;
            }
            v.add(entry.getName().substring(0, entry.getName().length() - suffix.length()));
        }
        if (v.size() == 0) {
            v = null;
        }
        return v;
    }

    public static Vector readFromJarInVector(Class myclass, String filename, String charsetName) throws Exception {
        String thisLine;
        Vector<String> v = new Vector<String>();
        InputStream is = myclass.getResourceAsStream(filename);
        BufferedReader br = new BufferedReader(new InputStreamReader(is, charsetName));
        StringBuilder sb = new StringBuilder();
        while ((thisLine = br.readLine()) != null) {
            v.add(thisLine);
        }
        br.close();
        return v;
    }

    public static Vector readFromJarInVector(Class myclass, String filename) throws Exception {
        return GeneralIO.readFromJarInVector(myclass, filename, "ISO-8859-1");
    }

    public static void setClipboard(String s) {
        if (s != null) {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection content = new StringSelection(s);
            cb.setContents(content, null);
        }
    }

    public static String getClipboard() throws Exception {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        String s = null;
        Transferable content = cb.getContents(null);
        if (content == null) {
            throw new Exception(ERROR_CLIPBOARD_EMPTY);
        }
        try {
            s = (String)content.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            throw new Exception(ERROR_CLIPBOARD_ISNOTTEXT);
        }
        return s;
    }

    public static void copyProperties(Properties fromProps, Properties toProps) {
        Enumeration<?> enumeration = fromProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            toProps.setProperty(key, fromProps.getProperty(key));
        }
    }
}

