/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import net.beeger.squareness.SquarenessLookAndFeel;

public class SquarenessButtonPainter {
    public static void paintButton(Graphics graphics, AbstractButton abstractButton) {
        Color color = graphics.getColor();
        ButtonModel buttonModel = abstractButton.getModel();
        Insets insets = SquarenessButtonPainter.getInnermostOpaqueBorderInsets(abstractButton.getBorder(), abstractButton);
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        boolean bl = (Boolean)abstractButton.getClientProperty("SquarenessRollover");
        if (insets.top == 0 && insets.bottom == 0 && insets.right == 0 && insets.left == 0 && abstractButton.getBackground() instanceof UIResource) {
            SquarenessButtonPainter.paintBorderlessButton(graphics, abstractButton);
        } else if (abstractButton.isEnabled() && (bl || buttonModel.isArmed() && buttonModel.isPressed() || abstractButton.hasFocus() || abstractButton.isSelected())) {
            boolean bl2 = buttonModel.isArmed() && buttonModel.isPressed() || abstractButton.isSelected() && !bl;
            SquarenessButtonPainter.paintNormalButton(graphics, insets, abstractButton, bl2);
        } else if (abstractButton.getParent() != null && abstractButton.getParent() instanceof JToolBar && ((JToolBar)abstractButton.getParent()).getClientProperty("JToolBar.isRollover") != null && ((Boolean)((JToolBar)abstractButton.getParent()).getClientProperty("JToolBar.isRollover")).booleanValue()) {
            SquarenessButtonPainter.paintBorderlessButton(graphics, abstractButton);
        }
        graphics.setColor(color);
    }

    private static void paintNormalButton(Graphics graphics, Insets insets, AbstractButton abstractButton, boolean bl) {
        graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor());
        graphics.fillRect(insets.left, insets.top, abstractButton.getWidth() - insets.right, abstractButton.getHeight() - insets.bottom);
        if (bl) {
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundShadowColor());
            graphics.fillRect(insets.left, insets.top, 2, abstractButton.getHeight() - insets.bottom);
            graphics.fillRect(insets.left, insets.top, abstractButton.getWidth() - insets.right, 2);
        }
    }

    private static void paintBorderlessButton(Graphics graphics, AbstractButton abstractButton) {
        graphics.setColor(abstractButton.getParent() != null ? abstractButton.getParent().getBackground() : SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        graphics.fillRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
    }

    private static Insets getInnermostOpaqueBorderInsets(Border border, JComponent jComponent) {
        Insets insets = null;
        if (border != null) {
            if (border instanceof CompoundBorder) {
                CompoundBorder compoundBorder = (CompoundBorder)border;
                Insets insets2 = SquarenessButtonPainter.getInnermostOpaqueBorderInsets(compoundBorder.getInsideBorder(), jComponent);
                if (insets2 != null) {
                    insets = new Insets(0, 0, 0, 0);
                    SquarenessButtonPainter.addInsets(insets, compoundBorder.getOutsideBorder().getBorderInsets(jComponent));
                    SquarenessButtonPainter.addInsets(insets, insets2);
                } else {
                    insets2 = SquarenessButtonPainter.getInnermostOpaqueBorderInsets(compoundBorder.getOutsideBorder(), jComponent);
                    if (insets2 != null) {
                        insets = new Insets(0, 0, 0, 0);
                        SquarenessButtonPainter.addInsets(insets, insets2);
                    }
                }
            } else if (border.isBorderOpaque()) {
                insets = border.getBorderInsets(jComponent);
            }
        }
        return insets;
    }

    private static void addInsets(Insets insets, Insets insets2) {
        insets.top += insets2.top;
        insets.bottom += insets2.bottom;
        insets.right += insets2.right;
        insets.left += insets2.left;
    }
}

