/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.test;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.GregorianCalendar;
import fi.joensuu.joyds1.calendar.format.DateParser;
import fi.joensuu.joyds1.calendar.format.DateParserException;
import java.util.Locale;
import java.util.Scanner;

public class TestDateParserException {
    public static void main(String[] stringArray) {
        try {
            System.out.println("Test 1. There should be three errors.");
            TestDateParserException.test1("1 January 200x", DateParser.What.DMY);
            TestDateParserException.test1("1 Januarx 2004", DateParser.What.DMY);
            TestDateParserException.test1("x January 2004", DateParser.What.DMY);
            System.out.println("Test 2. There should be no errors.");
            TestDateParserException.test2("1 January 2004  31 January 2004", DateParser.What.DMY);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void test1(String string, DateParser.What what) throws DateParserException {
        try {
            Scanner scanner = new Scanner(string);
            DateParser dateParser = DateParser.createEuropeanDateParser(new GregorianCalendar(), scanner, Locale.UK, what);
            Calendar calendar = dateParser.parse();
            System.out.println(calendar.toString());
        }
        catch (DateParserException dateParserException) {
            System.out.println("Error in date parsing. Parsed date components were:");
            for (int i = 0; i < dateParserException.size(); ++i) {
                System.out.println("i=" + i + " " + dateParserException.getParsed()[i]);
            }
            System.out.println("");
        }
        catch (Exception exception) {
            System.out.println("You should never see this error message.");
        }
    }

    private static void test2(String string, DateParser.What what) throws DateParserException {
        try {
            Scanner scanner = new Scanner(string);
            DateParser dateParser = DateParser.createEuropeanDateParser(new GregorianCalendar(), scanner, Locale.UK, what);
            Calendar calendar = null;
            while ((calendar = dateParser.parse()) != null) {
                System.out.println(calendar.toString());
            }
        }
        catch (DateParserException dateParserException) {
            for (int i = 0; i < dateParserException.size(); ++i) {
                System.out.println(dateParserException.getParsed()[i]);
            }
        }
    }
}

