/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.nepali;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Scanner;

final class NepaliCalendarTableGenerator {
    private static final int FIRST = 2390653;
    private static final int N = 420;
    private static final int M = 13;
    private static final int[][] m = new int[420][13];

    NepaliCalendarTableGenerator() {
    }

    public static final void main(String[] stringArray) {
        try {
            Scanner scanner = new Scanner(new BufferedReader(new FileReader(stringArray[0])));
            for (int i = 0; i < 420; ++i) {
                for (int j = 1; j < 13; ++j) {
                    NepaliCalendarTableGenerator.m[i][j] = scanner.nextInt();
                }
            }
            FileWriter fileWriter = new FileWriter("Table.java");
            NepaliCalendarTableGenerator.printCopyright(fileWriter);
            fileWriter.write("\n\n");
            fileWriter.write("// This class has been generated by NepaliCalendarTableGenerator.\n");
            fileWriter.write("// Do not edit.\n\n");
            fileWriter.write("package fi.joensuu.joyds1.calendar.nepali;\n\n");
            fileWriter.write("public final class Table {\n\n");
            fileWriter.write("// We must use inner classes because of the 64 kB limit on code size.\n\n");
            NepaliCalendarTableGenerator.print(m, "m", "Length of months.", "Months", (Writer)fileWriter);
            int[][] nArray = NepaliCalendarTableGenerator.makeC(m);
            NepaliCalendarTableGenerator.print(nArray, "c", "Cumulative length of months.", "CumulativeMonths", (Writer)fileWriter);
            int[] nArray2 = NepaliCalendarTableGenerator.cy(nArray);
            NepaliCalendarTableGenerator.print(nArray2, "y", "Number of days from the start of calendar to the end of previous of year.", "Years", (Writer)fileWriter);
            fileWriter.write("}");
            ((Writer)fileWriter).close();
        }
        catch (Throwable throwable) {
            System.out.println(throwable.toString());
        }
    }

    private static final int[][] makeC(int[][] nArray) {
        int[][] nArray2 = new int[nArray.length][nArray[0].length];
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 1; j < nArray[0].length; ++j) {
                nArray2[i][j] = nArray2[i][j - 1] + nArray[i][j];
            }
        }
        return nArray2;
    }

    private static final void print(int[] nArray, String string, String string2, String string3, Writer writer) throws IOException {
        writer.write("public static final class " + string3 + " {\n");
        writer.write("  /** " + string2 + " */\n");
        writer.write("  public static final int " + string + "[] = {\n");
        int n = 1890;
        int n2 = 1833;
        for (int i = 0; i < nArray.length; ++i) {
            writer.write("    " + Integer.toString(nArray[i]) + ", // Nepali year " + n + ", Gregorian year " + n2 + "/" + (n2 + 1) + ".\n");
            ++n;
            ++n2;
        }
        writer.write("  };\n");
        writer.write("}\n");
    }

    private static final void print(int[][] nArray, String string, String string2, String string3, Writer writer) throws IOException {
        writer.write("public static final class " + string3 + " {\n");
        writer.write("  /** " + string2 + " */\n");
        writer.write("  public static final int " + string + "[][] = {\n");
        int n = 1890;
        int n2 = 1833;
        for (int i = 0; i < nArray.length; ++i) {
            writer.write("    {");
            for (int j = 0; j < nArray[i].length; ++j) {
                writer.write(Integer.toString(nArray[i][j]));
                if (j >= nArray[i].length - 1) continue;
                writer.write(", ");
            }
            writer.write("}, // Nepali year " + n + ", Gregorian year " + n2 + "/" + (n2 + 1) + ".\n");
            ++n;
            ++n2;
        }
        writer.write("  };\n");
        writer.write("}\n");
    }

    private static final int[] makeY(int[][] nArray) {
        int[] nArray2 = new int[nArray.length];
        nArray2[0] = 2390653;
        for (int i = 1; i < nArray.length; ++i) {
            nArray2[i] = nArray2[i - 1] + nArray[i - 1][12];
        }
        return nArray2;
    }

    private static final int[] cy(int[][] nArray) {
        int n;
        int[] nArray2 = NepaliCalendarTableGenerator.makeY(nArray);
        int[] nArray3 = new int[nArray2.length];
        for (n = 1; n < nArray2.length; ++n) {
            nArray3[n] = nArray2[n] - nArray2[n - 1];
        }
        for (n = 1; n < nArray2.length; ++n) {
            int n2 = n;
            nArray3[n2] = nArray3[n2] + nArray3[n - 1];
        }
        return nArray3;
    }

    private static final void printCopyright(Writer writer) throws IOException {
        writer.write("/* Copyright (C) 2009 Hannu V\u00e4is\u00e4nen\n");
        writer.write(" \n");
        writer.write("This library is free software; you can redistribute it and/or modify\n");
        writer.write("it under the terms of the GNU General Public License as published by\n");
        writer.write("the Free Software Foundation; either version 2, or (at your option)\n");
        writer.write("any later version.\n");
        writer.write("  \n");
        writer.write("This library is distributed in the hope that it will be useful, but\n");
        writer.write("WITHOUT.WRITE ANY WARRANTY; without even the implied warranty of\n");
        writer.write("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n");
        writer.write("General Public License for more details.\n");
        writer.write(" \n");
        writer.write("You should have received a copy of the GNU General Public License\n");
        writer.write("along with this library; see the file COPYING.  If not, write to the\n");
        writer.write("Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA\n");
        writer.write("02111-1307 USA.\n");
        writer.write("\n");
        writer.write("Linking this library statically or dynamically with other modules is\n");
        writer.write("making a combined work based on this library.  Thus, the terms and\n");
        writer.write("conditions of the GNU General Public License cover the whole\n");
        writer.write("combination. */\n");
    }
}

