/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.jcalendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.CalendarMath;
import fi.joensuu.joyds1.calendar.Resources;
import fi.joensuu.joyds1.calendar.format.DateFormat;
import javax.swing.AbstractSpinnerModel;

class SpinnerCalendarModel
extends AbstractSpinnerModel {
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DAY = 3;
    private Calendar calendar;
    private final Calendar minimum;
    private final Calendar maximum;
    private String value;
    private final int stepSize;
    private final DateFormat format;

    public SpinnerCalendarModel(Calendar calendar, Calendar calendar2, Calendar calendar3, int n, DateFormat dateFormat) {
        if (calendar == null) {
            throw new IllegalArgumentException("value == null");
        }
        if (calendar2 != null && calendar.compareTo(calendar2) < 0) {
            throw new IllegalArgumentException("minimum > value");
        }
        if (calendar3 != null && calendar.compareTo(calendar3) > 0) {
            throw new IllegalArgumentException("value > maximum");
        }
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException(Resources.getString("stepSize"));
        }
        if (dateFormat == null) {
            throw new IllegalArgumentException("format == null");
        }
        this.calendar = (Calendar)calendar.clone();
        this.minimum = calendar2;
        this.maximum = calendar3;
        this.value = dateFormat.format(calendar);
        this.stepSize = n;
        this.format = dateFormat;
    }

    @Override
    public Object getNextValue() {
        if (this.maximum == null || this.calendar.compareTo(this.maximum) < 0) {
            this.add(1);
            this.value = this.format.format(this.calendar);
            return this.value;
        }
        return null;
    }

    @Override
    public Object getPreviousValue() {
        if (this.minimum == null || this.calendar.compareTo(this.minimum) > 0) {
            this.add(-1);
            this.value = this.format.format(this.calendar);
            return this.value;
        }
        return null;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object object) {
        this.value = (String)object;
        this.calendar = this.format.parse(this.value, this.calendar);
        this.fireStateChanged();
    }

    private void add(int n) {
        switch (this.stepSize) {
            case 1: {
                CalendarMath.addYears(this.calendar, n, false);
                break;
            }
            case 2: {
                CalendarMath.addMonths(this.calendar, n, false);
                break;
            }
            case 3: {
                this.calendar.addDays(n);
                break;
            }
            default: {
                throw new IllegalArgumentException(Resources.getString("stepSize"));
            }
        }
    }
}

