/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.jcalendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.GregorianCalendar;
import fi.joensuu.joyds1.calendar.format.DateFormatSymbols;
import fi.joensuu.joyds1.calendar.jcalendar.JDayChooser;
import fi.joensuu.joyds1.calendar.jcalendar.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class JMonthChooser
extends JPanel
implements ItemListener,
AdjustmentListener {
    private Locale locale;
    private int month;
    private int oldScrollBarValue = 0;
    private JDayChooser dayChooser = null;
    private JYearChooser yearChooser = null;
    private JComboBox comboBox;
    private JScrollBar scrollBar;
    private boolean initialized = false;
    private boolean localInitialize = false;
    private Calendar calendar;
    private DateFormatSymbols format;
    public static final int RIGHT_SPINNER = 0;
    public static final int LEFT_SPINNER = 1;
    public static final int NO_SPINNER = 2;
    private static final long serialVersionUID = 1L;

    public JMonthChooser(Calendar calendar, DateFormatSymbols dateFormatSymbols) {
        this(calendar, dateFormatSymbols, 0);
    }

    public JMonthChooser(Calendar calendar, DateFormatSymbols dateFormatSymbols, int n) {
        this.calendar = calendar;
        this.format = dateFormatSymbols;
        this.setLayout(new BorderLayout());
        this.comboBox = new JComboBox();
        this.comboBox.addItemListener(this);
        this.dayChooser = null;
        this.initNames();
        this.add((Component)this.comboBox, "Center");
        if (n != 2) {
            this.scrollBar = new JScrollBar(1, 0, 0, -10000, 10000);
            this.scrollBar.setPreferredSize(new Dimension(this.scrollBar.getPreferredSize().width, this.getPreferredSize().height));
            this.scrollBar.setVisibleAmount(0);
            this.scrollBar.addAdjustmentListener(this);
            if (n == 0) {
                this.add((Component)this.scrollBar, "East");
            } else {
                this.add((Component)this.scrollBar, "West");
            }
        }
        this.initialized = true;
        this.setMonth(calendar.getMonth());
    }

    public void initNames() {
        this.localInitialize = true;
        if (this.comboBox.getItemCount() == this.calendar.getLastMonthOfYear(this.calendar.getYear())) {
            this.comboBox.removeAllItems();
        }
        for (int i = 1; i <= this.calendar.getLastMonthOfYear(this.calendar.getYear()); ++i) {
            this.comboBox.addItem(this.format.getMonthName(false, i));
        }
        this.localInitialize = false;
        this.comboBox.setSelectedIndex(this.month - 1);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.comboBox.getSelectedIndex();
        if (n >= 0) {
            this.setMonth(n + 1, false);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        boolean bl = true;
        int n = adjustmentEvent.getValue();
        if (n > this.oldScrollBarValue) {
            bl = false;
        }
        this.oldScrollBarValue = n;
        int n2 = this.getMonth();
        int n3 = this.calendar.getLastMonthOfYear(this.calendar.getYear());
        if (bl) {
            if (++n2 == n3 + 1) {
                n2 = 1;
                if (this.yearChooser != null) {
                    int n4 = this.yearChooser.getYear();
                    this.yearChooser.setYear(++n4);
                }
            }
        } else if (--n2 == 0) {
            n2 = n3;
            if (this.yearChooser != null) {
                int n5 = this.yearChooser.getYear();
                this.yearChooser.setYear(--n5);
            }
        }
        this.setMonth(n2);
    }

    private void setMonth(int n, boolean bl) {
        if (!this.initialized || this.localInitialize) {
            return;
        }
        int n2 = this.month;
        this.month = n;
        if (bl) {
            this.comboBox.setSelectedIndex(this.month - 1);
        }
        if (this.dayChooser != null) {
            this.dayChooser.setMonth(this.month);
        }
        this.firePropertyChange("month", n2, this.month);
    }

    public void setMonth(int n) {
        this.setMonth(n, true);
    }

    public int getMonth() {
        return this.month;
    }

    public void setDayChooser(JDayChooser jDayChooser) {
        this.dayChooser = jDayChooser;
    }

    public void setYearChooser(JYearChooser jYearChooser) {
        this.yearChooser = jYearChooser;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        if (!this.initialized) {
            super.setLocale(locale);
        } else {
            this.locale = locale;
            this.initNames();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.comboBox.setEnabled(bl);
        if (this.scrollBar != null) {
            this.scrollBar.setEnabled(bl);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("MonthChooser");
        jFrame.getContentPane().add(new JMonthChooser(new GregorianCalendar(), new DateFormatSymbols()));
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

