/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar.chinese;

import fi.joensuu.joyds1.calendar.chinese.MoonPhase;
import fi.joensuu.joyds1.calendar.chinese.Novas;
import fi.joensuu.joyds1.calendar.chinese.SolarTerm;
import java.util.Vector;

public final class LunarYear {
    public double[] vterms = new double[24];
    public double lastnew;
    public double lastmon;
    public Vector<Double> vmoons = new Vector();
    public Vector<Double> vmonth = new Vector();
    public double nextnew;

    public final double lunarYear(int n) {
        int n2;
        int n3;
        double d = SolarTerm.solarterm(n, this.vterms);
        double d2 = d + 0.5;
        d2 = (double)((int)d2) + 0.5;
        double d3 = Novas.julian_date(n, 12, 31, 23.999);
        this.vmoons = MoonPhase.moonPhases(d2, d3, 0);
        this.vmonth.setSize(this.vmoons.size());
        if (this.IsNormalYear(this.vterms[23], this.vmoons)) {
            n3 = 12;
            for (n2 = 0; n2 < this.vmoons.size(); ++n2) {
                this.vmonth.set(n2, Double.valueOf(n3));
                if (n3 == 12) {
                    n3 = 0;
                }
                ++n3;
            }
            if (n3 == 1) {
                double[] dArray = new double[24];
                double d4 = SolarTerm.solarterm(n + 1, dArray);
                d2 = d4 + 0.5;
                d3 = Novas.julian_date(n + 1, 12, 31, 23.999);
                Vector<Double> vector = MoonPhase.moonPhases(d2 = (double)((int)d2) + 0.5, d3, 0);
                if (!this.IsNormalYear(dArray[23], vector) && !this.IsZhongQiInMonth(vector.get(0), vector.get(1), dArray)) {
                    this.vmonth.set(this.vmonth.size() - 1, 11.5);
                }
            }
        } else {
            n3 = 0;
            int n4 = 11;
            for (int i = 0; i < this.vmoons.size() - 1; ++i) {
                if (n3 != 0 || this.IsZhongQiInMonth(this.vmoons.get(i), this.vmoons.get(i + 1), this.vterms)) {
                    this.vmonth.set(i, Double.valueOf(++n4));
                } else {
                    this.vmonth.set(i, (double)n4 + 0.5);
                    n3 = 1;
                }
                if (n4 != 12) continue;
                n4 = 0;
            }
            this.vmonth.set(this.vmonth.size() - 1, Double.valueOf(n4 + 1));
        }
        if (this.vmoons.get(0) < Novas.julian_date(n, 1, 1, 0.0)) {
            this.lastnew = Math.floor(this.vmoons.get(0) + 0.5);
            this.lastmon = this.vmonth.get(0);
            this.vmoons.removeElementAt(0);
            this.vmonth.removeElementAt(0);
        } else {
            Vector<Double> vector = MoonPhase.moonPhases(this.vmoons.get(0) - 35.0, this.vmoons.get(0) - 25.0, 0);
            LunarYear.TrimHour(vector);
            this.lastnew = vector.get(vector.size() - 1);
            this.lastmon = 11.0;
        }
        Vector<Double> vector = MoonPhase.moonPhases(this.vmoons.get(this.vmoons.size() - 1) + 25.0, this.vmoons.get(this.vmoons.size() - 1) + 35.0, 0);
        LunarYear.TrimHour(vector);
        this.nextnew = vector.get(vector.size() - 1);
        LunarYear.TrimHour(this.vmoons);
        LunarYear.TrimHour(this.vterms);
        if ((int)(this.lastmon + 0.9) != (int)this.lastmon && Novas.julian_date(n, 1, 1, 12.0) < this.vmoons.get(0)) {
            return 0.5;
        }
        n2 = 2;
        for (int i = 0; i < this.vmoons.size(); ++i) {
            if ((int)(this.vmonth.get(i) + 0.9) == this.vmonth.get(i).intValue()) continue;
            double d5 = 0.0;
            while (n2 <= 12) {
                double d6;
                d5 = Novas.julian_date(n, n2, 1, 12.0);
                if (!(d6 < this.vmoons.get(i))) break;
                ++n2;
            }
            if (n2 == 13) {
                return 12.0;
            }
            if (i != this.vmoons.size() - 1 && d5 < this.vmoons.get(i + 1)) {
                return (double)n2 - 0.5;
            }
            return (double)n2 - 1.0;
        }
        return 0.0;
    }

    private final boolean IsNormalYear(double d, Vector<Double> vector) {
        int n = 0;
        double d2 = d + 0.5;
        d2 = (double)((int)d2) + 0.5;
        for (int i = 0; i < vector.size() && vector.get(i) < d2; ++i) {
            ++n;
        }
        switch (n) {
            case 12: {
                return true;
            }
            case 13: {
                return false;
            }
        }
        throw new IllegalArgumentException("Variable nmonth is not 12 or 13 (is " + n + ").");
    }

    private final boolean IsZhongQiInMonth(double d, double d2, double[] dArray) {
        d -= 0.5;
        d = (double)((int)d) + 0.5;
        d2 -= 0.5;
        d2 = (double)((int)d2) + 0.5;
        for (int i = 1; i < dArray.length; i += 2) {
            if (dArray[i] >= d && dArray[i] <= d2) {
                return true;
            }
            if (!(dArray[i] >= d2)) continue;
            return false;
        }
        return false;
    }

    private static final void TrimHour(Vector<Double> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            vector.set(i, Double.valueOf(Math.round(vector.get(i))));
        }
    }

    private static final void TrimHour(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.round(dArray[i]);
        }
    }

    public static void main(String[] stringArray) {
        LunarYear lunarYear = new LunarYear();
        for (int i = 1; i <= 2100; ++i) {
            double d = lunarYear.lunarYear(i);
            System.out.println(i + " " + d + " " + lunarYear.lastnew + " " + lunarYear.lastmon + " " + lunarYear.nextnew);
        }
    }
}

