/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.OldWorldCalendar;
import java.util.Arrays;
import java.util.GregorianCalendar;

public class IslamicCalendar
extends OldWorldCalendar {
    private static final int[] cumulative_days_in_leap_year = new int[]{0, 30, 59, 89, 118, 148, 177, 207, 236, 266, 295, 325, 355};
    private static final int[] cumulative_days_in_ordinary_year = new int[]{0, 30, 59, 89, 118, 148, 177, 207, 236, 266, 295, 325, 354};
    private static final int[] days_in_month_in_leap_year = new int[]{0, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 30};
    private static final int[] days_in_month_in_ordinary_year = new int[]{0, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29, 30, 29};
    private static final int[] cumulative_length_of_year = new int[]{0, 354, 709, 1063, 1417, 1772, 2126, 2481, 2835, 3189, 3544, 3898, 4252, 4607, 4961, 5315, 5670, 6024, 6379, 6733, 7087, 7442, 7796, 8150, 8505, 8859, 9214, 9568, 9922, 10277, 10631};
    private static final int D30 = cumulative_length_of_year[30];
    public static final int FIRST_JULIAN_DAY = IslamicCalendar.date2jdn_julian(622, 7, 16);
    private static final long serialVersionUID = 1L;

    public IslamicCalendar() {
        this(IslamicCalendar.getToday());
    }

    public IslamicCalendar(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public IslamicCalendar(int n, int n2) {
        this.set(n, n2);
    }

    public IslamicCalendar(int n) {
        this.set(n);
    }

    public IslamicCalendar(Calendar calendar) {
        this.set(calendar);
    }

    public IslamicCalendar(GregorianCalendar gregorianCalendar) {
        this.set(gregorianCalendar);
    }

    @Override
    protected void jdn2date(int n) {
        if (n < FIRST_JULIAN_DAY) {
            throw new IllegalArgumentException("IslamicCalendar jdn2date (int n)");
        }
        int n2 = n - FIRST_JULIAN_DAY;
        int n3 = n2 / D30;
        int n4 = n2 + 1 - n3 * D30;
        this.year = Arrays.binarySearch(cumulative_length_of_year, n4);
        if (this.year < 0) {
            this.year = -this.year - 1;
        }
        this.doy2date(this.year + 30 * n3, n4 - cumulative_length_of_year[this.year - 1]);
    }

    @Override
    protected int date2jdn(int n, int n2, int n3) {
        int n4 = (n - 1) / 30;
        int n5 = n - 30 * n4;
        return FIRST_JULIAN_DAY + D30 * n4 + cumulative_length_of_year[n5 - 1] + this.getCumulativeDays(n, n2 - 1) + n3 - 1;
    }

    @Override
    protected void doy2date(int n, int n2) {
        this.year = n;
        int n3 = Math.min(5, (n2 - 1) / 59);
        int n4 = (n2 - 1 - 59 * n3) / 30;
        this.month = 2 * n3 + n4 + 1;
        this.day = n2 - cumulative_days_in_ordinary_year[this.month - 1];
        if (!this.isDate(this.year, this.month, this.day)) {
            throw new IllegalArgumentException("IslamicCalendar doy2date this.year=" + this.year + " this.month=" + this.month + " this.day=" + this.day + " doy=" + n2);
        }
    }

    @Override
    protected int getCumulativeDays(int n, int n2) {
        return this.isLeapYear(n) ? cumulative_days_in_leap_year[n2] : cumulative_days_in_ordinary_year[n2];
    }

    @Override
    public boolean isLeapYear(int n) {
        switch (n % 30) {
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 26: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getLengthOfMonth(int n, int n2) {
        return this.isLeapYear(n) ? days_in_month_in_leap_year[n2] : days_in_month_in_ordinary_year[n2];
    }

    @Override
    public int getFirstJulianDay() {
        return FIRST_JULIAN_DAY;
    }
}

