/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.JulianGregorianCalendar;
import fi.joensuu.joyds1.calendar.OldWorldCalendar;
import java.util.GregorianCalendar;

public class IndianCalendar
extends OldWorldCalendar {
    private static final int[] cumulative_days_in_leap_year = new int[]{0, 31, 62, 93, 124, 155, 186, 216, 246, 276, 306, 336, 366};
    private static final int[] cumulative_days_in_ordinary_year = new int[]{0, 30, 61, 92, 123, 154, 185, 215, 245, 275, 305, 335, 365};
    private static final int[] days_in_month_in_leap_year = new int[]{0, 31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 30};
    private static final int[] days_in_month_in_ordinary_year = new int[]{0, 30, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 30};
    public static final int FIRST_JULIAN_DAY = IndianCalendar.date2jdn_gregorian(79, 3, 22);
    private static final int D21 = 7670;
    private static final long serialVersionUID = 1L;

    public IndianCalendar() {
        this(IndianCalendar.getToday());
    }

    public IndianCalendar(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public IndianCalendar(int n, int n2) {
        this.set(n, n2);
    }

    public IndianCalendar(int n) {
        this.set(n);
    }

    public IndianCalendar(Calendar calendar) {
        this.set(calendar);
    }

    public IndianCalendar(GregorianCalendar gregorianCalendar) {
        this.set(gregorianCalendar);
    }

    @Override
    protected void jdn2date(int n) {
        int n2;
        int n3;
        if (n < FIRST_JULIAN_DAY) {
            throw new IllegalArgumentException("IndianCalendar jdn2date (int n)");
        }
        int n4 = n - FIRST_JULIAN_DAY;
        int n5 = n4 / 146097;
        int n6 = IndianCalendar.amod(n4 + 1, 146097);
        int n7 = n6 - 36524 * (n3 = Math.min(3, (n6 - 1) / 36524));
        if (n7 <= (n2 = 7670 + (n3 < 3 ? 365 : 366))) {
            this.jdn2ymd(400 * n5 + 100 * n3 - 2, n7 + 729);
        } else {
            this.jdn2ymd(400 * n5 + 100 * n3 + 22, n7 - n2 - 1);
        }
    }

    @Override
    protected int date2jdn(int n, int n2, int n3) {
        return FIRST_JULIAN_DAY - 1 + 365 * (n - 1) + ((n + 1) / 4 - (n + 77) / 100 + (n + 77) / 400) + this.getCumulativeDays(n, n2 - 1) + n3;
    }

    @Override
    protected void doy2date(int n, int n2) {
        if (!this.isDate(n, n2)) {
            throw new IllegalArgumentException("IndianCalendar doy2date year=" + n + " doy=" + n2);
        }
        this.year = n;
        this.month = n2 <= this.getCumulativeDays(this.year, 1) ? 1 : (n2 <= this.getCumulativeDays(this.year, 6) ? (n2 - this.getCumulativeDays(this.year, 1) - 1) / 31 + 2 : (n2 - this.getCumulativeDays(this.year, 6) - 1) / 30 + 7);
        this.day = n2 - this.getCumulativeDays(this.year, this.month - 1);
        if (!this.isDate(this.year, this.month, this.day)) {
            throw new IllegalArgumentException("IndianCalendar doy2date this.year=" + this.year + " this.month=" + this.month + " this.day=" + this.day + " doy=" + n2);
        }
    }

    @Override
    protected int getCumulativeDays(int n, int n2) {
        return this.isLeapYear(n) ? cumulative_days_in_leap_year[n2] : cumulative_days_in_ordinary_year[n2];
    }

    @Override
    public boolean isLeapYear(int n) {
        return JulianGregorianCalendar.is_leap_year_gregorian(n + 78);
    }

    @Override
    public int getLengthOfMonth(int n, int n2) {
        return this.isLeapYear(n) ? days_in_month_in_leap_year[n2] : days_in_month_in_ordinary_year[n2];
    }

    @Override
    public int getFirstJulianDay() {
        return FIRST_JULIAN_DAY;
    }
}

