/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.HinduSolarCalendar;
import fi.joensuu.joyds1.calendar.YMD;
import java.util.GregorianCalendar;

public class HinduLunarCalendar
extends YMD {
    public static final int FIRST_JULIAN_DAY = HinduLunarCalendar.date2jdn_julian(-3101, 2, 18);
    private static final double LUNAR_SIDEREAL_MONTH = 27.321674162683866;
    private static final double LUNAR_SYNODIC_MONTH = 29.53058794607172;
    private boolean leapMonth;
    private static final long serialVersionUID = 1L;

    public HinduLunarCalendar() {
        this(HinduLunarCalendar.getToday());
    }

    public HinduLunarCalendar(int n, int n2, int n3, boolean bl) {
        this.set(n, n2, n3, bl);
    }

    public HinduLunarCalendar(int n, int n2) {
        this.set(n, n2);
    }

    public HinduLunarCalendar(int n) {
        this.set(n);
    }

    public HinduLunarCalendar(Calendar calendar) {
        this.set(calendar);
    }

    public HinduLunarCalendar(GregorianCalendar gregorianCalendar) {
        this.set(gregorianCalendar);
    }

    @Override
    protected void jdn2date(int n) {
        if (n < FIRST_JULIAN_DAY) {
            throw new IllegalArgumentException("HinduLunarCalendar jdn2date (int n) " + n);
        }
        double d = n - FIRST_JULIAN_DAY;
        double d2 = d + 0.25;
        double d3 = HinduLunarCalendar.newMoon(d2);
        double d4 = d3 + 29.53058794607172;
        this.day = HinduLunarCalendar.lunarPhase(d2);
        this.month = HinduLunarCalendar.amod(1 + HinduSolarCalendar.zodiac(d3), 12);
        this.leapMonth = HinduSolarCalendar.zodiac(d3) == HinduSolarCalendar.zodiac(d4);
        double d5 = d4 + (this.isLeapMonth() ? 29.53058794607172 : 0.0);
        this.year = (int)(d5 / 365.2587564814815);
    }

    protected int date2jdn(int n, int n2, int n3, boolean bl) {
        int n4 = (int)Math.floor((double)n * 365.2587564814815) + (int)Math.floor((double)(n2 - 2) * 29.53058794607172) + FIRST_JULIAN_DAY;
        int n5 = n4 + 70;
        int n6 = n4;
        while (n4 <= n5) {
            n6 = n4 + n5 >> 1;
            int n7 = HinduLunarCalendar.compare(n6 + 1, n, n2, n3, bl);
            if (n7 == 0) {
                return n6 + 1;
            }
            if (n7 > 0) {
                n5 = n6 - 1;
                continue;
            }
            n4 = ++n6;
        }
        if (HinduLunarCalendar.isEqual(n6, n, n2, n3, bl)) {
            return n6;
        }
        throw new IllegalArgumentException("date2jdn(" + n + "," + n2 + "," + n3 + "," + bl + ")");
    }

    @Override
    protected int date2jdn() {
        return this.date2jdn(this.year, this.month, this.day, this.leapMonth);
    }

    private static final boolean isEqual(int n, int n2, int n3, int n4, boolean bl) {
        HinduLunarCalendar hinduLunarCalendar = new HinduLunarCalendar(n);
        return ((Calendar)hinduLunarCalendar).getYear() == n2 && ((Calendar)hinduLunarCalendar).getMonth() == n3 && ((Calendar)hinduLunarCalendar).getDay() == n4 && ((Calendar)hinduLunarCalendar).isLeapMonth() == bl;
    }

    @Override
    public boolean isDate(int n, int n2, int n3, boolean bl) {
        try {
            new HinduLunarCalendar(n, n2, n3, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    @Override
    public void set(int n) {
        this.jdn2date(n);
        this.jdn = n;
    }

    @Override
    public void set(int n, int n2, int n3, boolean bl) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.leapMonth = bl;
        this.jdn = this.date2jdn(this.getYear(), this.getMonth(), this.getDay(), this.isLeapMonth());
    }

    @Override
    public void set(int n, int n2) {
        this.doy2date(n, n2);
    }

    @Override
    protected boolean ok(String string) {
        if (this.isDate(this.getYear(), this.getMonth(), this.getDay(), this.isLeapMonth())) {
            return true;
        }
        throw new IllegalArgumentException(string + ":\n" + " year=" + this.getYear() + " month=" + this.getMonth() + " day=" + this.getDay() + " jdn=" + this.getJulianDayNumber() + " leapMonth=" + this.isLeapMonth());
    }

    @Override
    protected void doy2date(int n, int n2) {
        if (!this.isDate(n, n2)) {
            throw new IllegalArgumentException("HinduLunarCalendar doy2date year=" + n + " doy=" + n2);
        }
        Calendar calendar = this.getFirstDateOfMonth(n, this.getFirstMonthOfYear(n));
        this.set(calendar.getJulianDayNumber() + n2 - 1);
    }

    @Override
    public boolean isLeapMonth() {
        return this.leapMonth;
    }

    @Override
    public int getLengthOfYear(int n) {
        Calendar calendar = this.getFirstDateOfMonth(n, this.getFirstMonthOfYear(n));
        Calendar calendar2 = this.getLastDateOfMonth(n, this.getLastMonthOfYear(n));
        return calendar2.getJulianDayNumber() - calendar.getJulianDayNumber() + 1;
    }

    @Override
    public int getLengthOfMonth(int n, int n2, boolean bl) {
        int n3 = this.getFirstDayOfMonth(n, n2, bl);
        HinduLunarCalendar hinduLunarCalendar = new HinduLunarCalendar(n, n2, n3, bl);
        int n4 = 0;
        do {
            ++n4;
            hinduLunarCalendar.addDays(1);
        } while (n2 == ((Calendar)hinduLunarCalendar).getMonth() && bl == ((Calendar)hinduLunarCalendar).isLeapMonth());
        return n4;
    }

    @Override
    public int getFirstDayOfMonth(int n, int n2, boolean bl) {
        int n3 = 1;
        while (!this.isDate(n, n2, n3, bl)) {
            if (n3 > 30) {
                throw new IllegalArgumentException("getFirstDayOfMonth (" + n + "," + n2 + "," + bl + ")");
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public int getLastDayOfMonth(int n, int n2, boolean bl) {
        int n3 = 30;
        while (!this.isDate(n, n2, n3, bl)) {
            if (n3 <= 0) {
                throw new IllegalArgumentException("getLastDayOfMonth (" + n + "," + n2 + "," + bl + ")");
            }
            --n3;
        }
        return n3;
    }

    @Override
    public int getFirstMonthOfYear(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("getFirstMonthOfYear(" + n + ")");
        }
        return n == 0 ? 2 : 1;
    }

    @Override
    public int getLastMonthOfYear(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("getLastMonthOfYear(" + n + ")");
        }
        return 12;
    }

    @Override
    public boolean isLeapYear(int n) {
        int n2 = this.getFirstMonthOfYear(n);
        int n3 = this.getLastMonthOfYear(n);
        for (int i = n2; i <= n3; ++i) {
            Calendar calendar = this.getFirstDateOfMonth(n, i);
            if (!calendar.isLeapMonth()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLeapYear() {
        return this.isLeapYear(this.getYear());
    }

    protected int date2doy() {
        Calendar calendar = this.getFirstDateOfMonth(this.getYear(), this.getFirstMonthOfYear(this.year));
        return this.getJulianDayNumber() - calendar.getJulianDayNumber() + 1;
    }

    private static final double lunarLongitude(double d) {
        return HinduLunarCalendar.mod(d / 27.321674162683866, 1.0) * 360.0;
    }

    private static final int lunarPhase(double d) {
        return (int)(1.0 + HinduLunarCalendar.mod(HinduLunarCalendar.lunarLongitude(d) - HinduSolarCalendar.solarLongitude(d), 360.0) / 12.0);
    }

    private static final double newMoon(double d) {
        return d - HinduLunarCalendar.mod(d, 29.53058794607172);
    }

    @Override
    public int getFirstJulianDay() {
        return FIRST_JULIAN_DAY;
    }

    private static final boolean preceeds(int n, int n2, int n3, int n4, boolean bl) {
        HinduLunarCalendar hinduLunarCalendar = new HinduLunarCalendar(n);
        return ((Calendar)hinduLunarCalendar).getYear() < n2 || ((Calendar)hinduLunarCalendar).getYear() == n2 && (((Calendar)hinduLunarCalendar).getMonth() < n3 || ((Calendar)hinduLunarCalendar).getMonth() == n3 && (((Calendar)hinduLunarCalendar).isLeapMonth() && !bl || ((Calendar)hinduLunarCalendar).isLeapMonth() == bl && ((Calendar)hinduLunarCalendar).getDay() < n4));
    }

    private static final int compare(int n, int n2, int n3, int n4, boolean bl) {
        HinduLunarCalendar hinduLunarCalendar = new HinduLunarCalendar(n);
        if (((Calendar)hinduLunarCalendar).getYear() == n2 && ((Calendar)hinduLunarCalendar).getMonth() == n3 && ((Calendar)hinduLunarCalendar).getDay() == n4 && ((Calendar)hinduLunarCalendar).isLeapMonth() == bl) {
            return 0;
        }
        if (((Calendar)hinduLunarCalendar).getYear() < n2 || ((Calendar)hinduLunarCalendar).getYear() == n2 && (((Calendar)hinduLunarCalendar).getMonth() < n3 || ((Calendar)hinduLunarCalendar).getMonth() == n3 && (((Calendar)hinduLunarCalendar).isLeapMonth() && !bl || ((Calendar)hinduLunarCalendar).isLeapMonth() == bl && ((Calendar)hinduLunarCalendar).getDay() < n4))) {
            return -1;
        }
        return 1;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.leapMonth;
    }

    private final Calendar getFirstDateOfMonth(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        try {
            n3 = this.getFirstDayOfMonth(n, n2, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            n4 = this.getFirstDayOfMonth(n, n2, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return HinduLunarCalendar.getDate(n, n2, n3, n4, true);
    }

    private final Calendar getLastDateOfMonth(int n, int n2) {
        int n3 = -1;
        int n4 = -1;
        try {
            n3 = this.getLastDayOfMonth(n, n2, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            n4 = this.getLastDayOfMonth(n, n2, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return HinduLunarCalendar.getDate(n, n2, n3, n4, false);
    }

    private static final Calendar getDate(int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        if (n3 < 0 && n4 < 0) {
            throw new IllegalArgumentException("getDate: (day1 < 0) && (day2 < 0) year=" + n + " month=" + n2);
        }
        if (n3 > 0 && n4 < 0) {
            return new HinduLunarCalendar(n, n2, n3, true);
        }
        if (n3 < 0 && n4 > 0) {
            return new HinduLunarCalendar(n, n2, n4, false);
        }
        HinduLunarCalendar hinduLunarCalendar = new HinduLunarCalendar(n, n2, n3, true);
        HinduLunarCalendar hinduLunarCalendar2 = new HinduLunarCalendar(n, n2, n4, false);
        int n6 = n5 = bl ? hinduLunarCalendar.compareTo(hinduLunarCalendar2) : hinduLunarCalendar2.compareTo(hinduLunarCalendar);
        if (n5 < 0) {
            return hinduLunarCalendar;
        }
        if (n5 > 0) {
            return hinduLunarCalendar2;
        }
        throw new IllegalArgumentException("getDate");
    }
}

