/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.JulianGregorianCalendar;

class GregorianCalendarGenerator
extends JulianGregorianCalendar {
    private final int lastJulianYear;
    private final int lastJulianMonth;
    private final int lastJulianDay;
    private final int firstGregorianYear;
    private final int firstGregorianMonth;
    private final int firstGregorianDay;
    private final int numberOfDeletedDays;
    private final int[] lengthOfMonthInChangeoverYear;
    private final int[] cumulativeDaysInChangeoverYear;
    private final int LAST_JULIAN_DAY_OF_YEAR;
    private final int J_LAST;
    private final int[] firstDayOfMonthInChangeoverYear;
    private final int[] lastDayOfMonthInChangeoverYear;
    private static final long serialVersionUID = 1L;

    protected GregorianCalendarGenerator(int n, int n2, int n3, int n4, int n5, int n6) {
        this.lastJulianYear = n;
        this.lastJulianMonth = n2;
        this.lastJulianDay = n3;
        this.firstGregorianYear = n4;
        this.firstGregorianMonth = n5;
        this.firstGregorianDay = n6;
        if (GregorianCalendarGenerator.compare(this.lastJulianYear, this.lastJulianMonth, this.lastJulianDay, this.firstGregorianYear, this.firstGregorianMonth, this.firstGregorianDay) >= 0) {
            throw new IllegalArgumentException("GregorianCalendarGenerator compare");
        }
        if (this.lastJulianYear != this.firstGregorianYear) {
            if (this.lastJulianYear + 1 != this.firstGregorianYear) {
                throw new IllegalArgumentException("GregorianCalendarGenerator lastJulianYear");
            }
            if (this.lastJulianMonth != 12) {
                throw new IllegalArgumentException("GregorianCalendarGenerator lastJulianMonth");
            }
            if (this.lastJulianDay != 31) {
                throw new IllegalArgumentException("GregorianCalendarGenerator lastJulianDay");
            }
            if (this.firstGregorianMonth != 1) {
                throw new IllegalArgumentException("GregorianCalendarGenerator firstGregorianMonth");
            }
            this.lengthOfMonthInChangeoverYear = this.length();
            this.cumulativeDaysInChangeoverYear = this.cdays();
            this.LAST_JULIAN_DAY_OF_YEAR = 0;
        } else {
            this.lengthOfMonthInChangeoverYear = this.length();
            this.cumulativeDaysInChangeoverYear = this.cdays();
            this.LAST_JULIAN_DAY_OF_YEAR = this.cumulativeDaysInChangeoverYear[n2 - 1] + n3;
        }
        this.firstDayOfMonthInChangeoverYear = this.first();
        this.lastDayOfMonthInChangeoverYear = this.last();
        this.J_LAST = GregorianCalendarGenerator.date2jdn_julian(this.lastJulianYear, this.lastJulianMonth, this.lastJulianDay);
        this.numberOfDeletedDays = GregorianCalendarGenerator.date2jdn_julian(this.firstGregorianYear, this.firstGregorianMonth, this.firstGregorianDay) - this.J_LAST - 1;
    }

    @Override
    public final int getISOWeekNumber() {
        return GregorianCalendarGenerator.getISOWeekNumber(this.getJulianDayNumber(), this.getYear(), this.firstGregorianYear + 1);
    }

    @Override
    public boolean isDate(int n, int n2, int n3) {
        if (n == this.lastJulianYear && n2 == this.lastJulianMonth || n == this.firstGregorianYear && n2 == this.firstGregorianMonth) {
            if (this.lastJulianYear == this.firstGregorianYear && this.lastJulianMonth == this.firstGregorianMonth) {
                return 1 <= n3 && n3 <= this.lastJulianDay || this.firstGregorianDay <= n3 && n3 <= GregorianCalendarGenerator.days_in_month(this.isLeapYear(n), n2);
            }
            return this.firstDayOfMonthInChangeoverYear[n2] <= n3 && n3 <= this.lastDayOfMonthInChangeoverYear[n2];
        }
        return this.ok_date(n, n2, n3);
    }

    @Override
    protected void jdn2date(int n) {
        if (n > this.J_LAST) {
            this.jdn2date_gregorian(n);
        } else {
            this.jdn2date_julian(n);
        }
        this.ok("GregorianCalendarGenerator.jdn2date");
    }

    @Override
    protected int date2jdn(int n, int n2, int n3) {
        if (GregorianCalendarGenerator.compare(n, n2, n3, this.lastJulianYear, this.lastJulianMonth, this.lastJulianDay) > 0) {
            return GregorianCalendarGenerator.date2jdn_gregorian(n, n2, n3);
        }
        return GregorianCalendarGenerator.date2jdn_julian(n, n2, n3);
    }

    @Override
    protected void doy2date(int n, int n2) {
        if (n == this.firstGregorianYear && n2 > this.LAST_JULIAN_DAY_OF_YEAR) {
            this.doy2date(this.isLeapYear(n), n, n2 + this.numberOfDeletedDays);
        } else {
            this.doy2date(this.isLeapYear(n), n, n2);
        }
    }

    @Override
    protected int date2doy() {
        int n = GregorianCalendarGenerator.date2doy(this.isLeapYear(this.getYear()), this.getMonth(), this.getDay());
        if (this.getYear() == this.firstGregorianYear && n > this.LAST_JULIAN_DAY_OF_YEAR) {
            return n - this.numberOfDeletedDays;
        }
        return n;
    }

    @Override
    protected int getCumulativeDays(int n, int n2) {
        if (n == this.firstGregorianYear) {
            return this.cumulativeDaysInChangeoverYear[n2];
        }
        if (this.isLeapYear(n)) {
            return cumulative_days_in_leap_year[n2];
        }
        return cumulative_days_in_ordinary_year[n2];
    }

    @Override
    public boolean isLeapYear(int n) {
        if (n > this.firstGregorianYear) {
            return GregorianCalendarGenerator.is_leap_year_gregorian(n);
        }
        if (n == this.firstGregorianYear) {
            if (this.firstGregorianMonth == 1) {
                return GregorianCalendarGenerator.is_leap_year_gregorian(n);
            }
            if (this.firstGregorianMonth == 2) {
                return false;
            }
        }
        return GregorianCalendarGenerator.is_leap_year_julian(n);
    }

    @Override
    public int getLengthOfMonth(int n, int n2) {
        if (n == this.firstGregorianYear) {
            return this.lengthOfMonthInChangeoverYear[n2];
        }
        return GregorianCalendarGenerator.days_in_month(this.isLeapYear(n), n2);
    }

    @Override
    public int getFirstDayOfMonth(int n, int n2) {
        if (n == this.firstGregorianYear) {
            return this.firstDayOfMonthInChangeoverYear[n2];
        }
        return 1;
    }

    @Override
    public int getLastDayOfMonth(int n, int n2) {
        if (n == this.firstGregorianYear) {
            return this.lastDayOfMonthInChangeoverYear[n2];
        }
        return GregorianCalendarGenerator.days_in_month(this.isLeapYear(n), n2);
    }

    private final int[] cdays() {
        int[] nArray = new int[13];
        for (int i = 1; i < nArray.length; ++i) {
            nArray[i] = nArray[i - 1] + this.lengthOfMonthInChangeoverYear[i];
        }
        return nArray;
    }

    private final int[] first() {
        int[] nArray = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        if (this.lastJulianMonth != this.firstGregorianMonth) {
            nArray[this.firstGregorianMonth] = this.firstGregorianDay;
        }
        return nArray;
    }

    private final int[] last() {
        int[] nArray = new int[13];
        for (int i = 1; i <= 12; ++i) {
            nArray[i] = GregorianCalendarGenerator.days_in_month(this.isLeapYear(this.firstGregorianYear), i);
        }
        if (this.lastJulianMonth != this.firstGregorianMonth) {
            nArray[this.lastJulianMonth] = this.lastJulianDay;
        }
        return nArray;
    }

    private final int[] length() {
        int[] nArray = new int[13];
        for (int i = 1; i <= 12; ++i) {
            nArray[i] = GregorianCalendarGenerator.days_in_month(this.isLeapYear(this.firstGregorianYear), i);
        }
        if (this.lastJulianYear != this.firstGregorianYear) {
            int n = this.firstGregorianMonth;
            nArray[n] = nArray[n] - (this.firstGregorianDay - 1);
        } else if (this.lastJulianMonth == this.firstGregorianMonth) {
            int n = this.firstGregorianMonth;
            nArray[n] = nArray[n] - (this.firstGregorianDay - this.lastJulianDay - 1);
        } else {
            nArray[this.lastJulianMonth] = this.lastJulianDay;
            int n = this.firstGregorianMonth;
            nArray[n] = nArray[n] - (this.firstGregorianDay - 1);
        }
        return nArray;
    }
}

