/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.GregorianCalendar;
import fi.joensuu.joyds1.calendar.YMD;
import fi.joensuu.joyds1.calendar.chinese.LunarYear;
import java.util.Vector;

public class ChineseCalendar
extends YMD {
    public static final int FIRST_JULIAN_DAY = ChineseCalendar.date2jdn_gregorian(1646, 2, 16);
    private int savedYear = Integer.MIN_VALUE;
    private double leapMonthNumber = 0.0;
    private final Calendar g = new GregorianCalendar();
    private final LunarYear y = new LunarYear();
    private int cycle;
    private boolean leapMonth;
    private static final long serialVersionUID = 1L;

    public ChineseCalendar() {
        this(ChineseCalendar.getToday());
    }

    public ChineseCalendar(int n, int n2, int n3, int n4, boolean bl) {
        this.set(n, n2, n3, n4, bl);
    }

    public ChineseCalendar(int n) {
        this.set(n);
    }

    public ChineseCalendar(Calendar calendar) {
        this.set(calendar);
    }

    public ChineseCalendar(java.util.GregorianCalendar gregorianCalendar) {
        this.set(gregorianCalendar);
    }

    @Override
    protected void jdn2date(int n) {
        if (n < FIRST_JULIAN_DAY) {
            throw new IllegalArgumentException("ChineseCalendar jdn2date (int n)");
        }
        this.g.set(n);
        if (this.g.getYear() != this.savedYear) {
            this.leapMonthNumber = this.y.lunarYear(this.g.getYear());
            this.savedYear = this.g.getYear();
        }
        this.cycle = ChineseCalendar.getCycle(this.g.getYear());
        this.year = ChineseCalendar.getYearWithinCycle(this.g.getYear());
        if (n >= ChineseCalendar.findStartOfChineseYear(this.y)) {
            ++this.year;
            if (this.year > 60) {
                this.year = 1;
                ++this.cycle;
            }
        }
        if ((double)n < this.y.vmoons.get(0)) {
            this.month = (int)this.y.lastmon;
            this.leapMonth = (double)this.month != this.y.lastmon;
            this.day = n - (int)this.y.lastnew + 1;
        } else {
            int n2 = ChineseCalendar.find(this.y.vmoons, n);
            this.month = this.y.vmonth.get(n2).intValue();
            this.leapMonth = (double)this.month != this.y.vmonth.get(n2);
            this.day = n - this.y.vmoons.get(n2).intValue() + 1;
        }
    }

    private int date2jdn(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = Math.max(FIRST_JULIAN_DAY, ChineseCalendar.f(n, n2, n3, n4) - 17);
        int n6 = n5 + 35;
        int n7 = n5;
        while (n5 <= n6) {
            n7 = n5 + n6 >> 1;
            int n8 = ChineseCalendar.compare(n7 + 1, n, n2, n3, n4, bl);
            if (n8 == 0) {
                return n7 + 1;
            }
            if (n8 > 0) {
                n6 = n7 - 1;
                continue;
            }
            n5 = ++n7;
        }
        if (ChineseCalendar.compare(n7, n, n2, n3, n4, bl) == 0) {
            return n7;
        }
        ChineseCalendar chineseCalendar = new ChineseCalendar(n7);
        throw new IllegalArgumentException("\ndate2jdn(" + n + "," + n2 + "," + n3 + "," + n4 + "," + bl + ")" + "\n" + ((Calendar)chineseCalendar).toString() + " " + chineseCalendar.getJulianDayNumber() + " mid=" + n7);
    }

    @Override
    protected int date2jdn() {
        return this.date2jdn(this.cycle, this.year, this.month, this.day, this.leapMonth);
    }

    @Override
    public void set(int n) {
        this.jdn2date(n);
        this.jdn = n;
    }

    @Override
    public void set(int n, int n2, int n3, int n4, boolean bl) {
        this.cycle = n;
        this.year = n2;
        this.month = n3;
        this.day = n4;
        this.leapMonth = bl;
        this.jdn = this.date2jdn(n, n2, n3, n4, bl);
    }

    @Override
    protected boolean ok(String string) {
        if (this.isDate(this.getCycle(), this.getYear(), this.getMonth(), this.getDay(), this.isLeapMonth())) {
            return true;
        }
        throw new IllegalArgumentException(string + ":\n" + " cycle=" + this.getCycle() + " year=" + this.getYear() + " month=" + this.getMonth() + " day=" + this.getDay() + " jdn=" + this.getJulianDayNumber() + " leapMonth=" + this.isLeapMonth());
    }

    @Override
    public boolean isDate(int n, int n2, int n3, int n4, boolean bl) {
        try {
            new ChineseCalendar(n, n2, n3, n4, bl);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getCycle() + "-" + this.getYear() + "-" + this.getMonth() + "-" + this.getDay() + "-" + this.isLeapMonth();
    }

    @Override
    public int getLengthOfYear(int n, int n2) {
        Calendar calendar = this.getFirstDateOfMonth(n, n2, this.getFirstMonthOfYear(n2));
        Calendar calendar2 = this.getLastDateOfMonth(n, n2, this.getLastMonthOfYear(n2));
        return calendar2.getJulianDayNumber() - calendar.getJulianDayNumber() + 1;
    }

    @Override
    public int getLengthOfMonth(int n, int n2, int n3, boolean bl) {
        return this.getLastDayOfMonth(n, n2, n3, bl);
    }

    @Override
    public int getFirstDayOfMonth(int n, int n2, int n3, boolean bl) {
        if (this.isDate(n, n2, n3, 1, bl)) {
            return 1;
        }
        throw new IllegalArgumentException("int getFirstDayOfMonth (int cycle, int year, int month, boolean leapMonth)");
    }

    @Override
    public int getLastDayOfMonth(int n, int n2, int n3, boolean bl) {
        if (this.isDate(n, n2, n3, 30, bl)) {
            return 30;
        }
        if (this.isDate(n, n2, n3, 29, bl)) {
            return 29;
        }
        throw new IllegalArgumentException("int getFirstDayOfMonth (int cycle, int year, int month, boolean leapMonth)");
    }

    @Override
    public int getFirstMonthOfYear(int n, int n2) {
        return 1;
    }

    @Override
    public int getLastMonthOfYear(int n, int n2) {
        return 12;
    }

    @Override
    public int getCycle() {
        return this.cycle;
    }

    @Override
    public boolean isLeapMonth() {
        return this.leapMonth;
    }

    @Override
    public int getFirstJulianDay() {
        return FIRST_JULIAN_DAY;
    }

    private static final int findStartOfChineseYear(LunarYear lunarYear) {
        for (int i = 0; i < lunarYear.vmonth.size(); ++i) {
            if (lunarYear.vmonth.get(i) != 1.0) continue;
            return lunarYear.vmoons.get(i).intValue();
        }
        throw new IllegalArgumentException("Not.first.year");
    }

    private static final int getCycle(int n) {
        return (int)Math.ceil((double)(n + 2637) / 60.0);
    }

    private static final int getYearWithinCycle(int n) {
        int n2 = (n - 1984) % 60;
        if (n2 < 0) {
            n2 += 60;
        }
        return n2 + 1;
    }

    private static final int find(Vector<Double> vector, double d) {
        if (d >= vector.get(vector.size() - 1)) {
            return vector.size() - 1;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!(d < vector.get(i))) continue;
            return i - 1;
        }
        return -1;
    }

    private static final int compare(int n, int n2, int n3, int n4, int n5, boolean bl) {
        ChineseCalendar chineseCalendar = new ChineseCalendar(n);
        if (((Calendar)chineseCalendar).getCycle() == n2 && ((Calendar)chineseCalendar).getYear() == n3 && ((Calendar)chineseCalendar).getMonth() == n4 && ((Calendar)chineseCalendar).getDay() == n5 && ((Calendar)chineseCalendar).isLeapMonth() == bl) {
            return 0;
        }
        if (((Calendar)chineseCalendar).getCycle() < n2 || ((Calendar)chineseCalendar).getCycle() == n2 && (((Calendar)chineseCalendar).getYear() < n3 || ((Calendar)chineseCalendar).getYear() == n3 && (((Calendar)chineseCalendar).getMonth() < n4 || ((Calendar)chineseCalendar).getMonth() == n4 && (!((Calendar)chineseCalendar).isLeapMonth() && bl || ((Calendar)chineseCalendar).isLeapMonth() == bl && ((Calendar)chineseCalendar).getDay() < n5)))) {
            return -1;
        }
        return 1;
    }

    private static final int f(int n, int n2, int n3, int n4) {
        return (int)Math.rint(735641.557486 + 21914.529254 * (double)n + 365.238216 * (double)n2 + 30.641213 * (double)n3 + 0.998199 * (double)n4);
    }

    private final Calendar getFirstDateOfMonth(int n, int n2, int n3) {
        int n4 = -1;
        int n5 = -1;
        try {
            n4 = this.getFirstDayOfMonth(n, n2, n3, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            n5 = this.getFirstDayOfMonth(n, n2, n3, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ChineseCalendar.getDate(n, n2, n3, n4, n5, true);
    }

    private final Calendar getLastDateOfMonth(int n, int n2, int n3) {
        int n4 = -1;
        int n5 = -1;
        try {
            n4 = this.getLastDayOfMonth(n, n2, n3, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            n5 = this.getLastDayOfMonth(n, n2, n3, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return ChineseCalendar.getDate(n, n2, n3, n4, n5, false);
    }

    private static final Calendar getDate(int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        if (n4 < 0 && n5 < 0) {
            throw new IllegalArgumentException("getDate: (day1 < 0) && (day2 < 0) year=" + n2 + " month=" + n3);
        }
        if (n4 > 0 && n5 < 0) {
            return new ChineseCalendar(n, n2, n3, n4, true);
        }
        if (n4 < 0 && n5 > 0) {
            return new ChineseCalendar(n, n2, n3, n5, false);
        }
        ChineseCalendar chineseCalendar = new ChineseCalendar(n, n2, n3, n4, true);
        ChineseCalendar chineseCalendar2 = new ChineseCalendar(n, n2, n3, n5, false);
        int n7 = n6 = bl ? chineseCalendar.compareTo(chineseCalendar2) : chineseCalendar2.compareTo(chineseCalendar);
        if (n6 < 0) {
            return chineseCalendar;
        }
        if (n6 > 0) {
            return chineseCalendar2;
        }
        throw new IllegalArgumentException("getDate");
    }
}

