/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;

public final class CalendarMath {
    public static final void setYear(Calendar calendar, int n, boolean bl) {
        if (calendar.isDate(n, calendar.getMonth(), calendar.getDay())) {
            calendar.set(n, calendar.getMonth(), calendar.getDay());
        } else {
            if (bl) {
                throw new IllegalArgumentException(calendar.toString() + " year=" + n);
            }
            CalendarMath.set(calendar, n, calendar.getMonth(), calendar.getDay());
        }
    }

    public static final void setMonth(Calendar calendar, int n, boolean bl) {
        if (calendar.isDate(calendar.getYear(), n, calendar.getDay())) {
            calendar.set(calendar.getYear(), n, calendar.getDay());
        } else {
            if (bl) {
                throw new IllegalArgumentException(calendar.toString() + " month=" + n);
            }
            CalendarMath.set(calendar, calendar.getYear(), n, calendar.getDay());
        }
    }

    public static final void setDay(Calendar calendar, int n, boolean bl) {
        if (calendar.isDate(calendar.getYear(), calendar.getMonth(), n)) {
            calendar.set(calendar.getYear(), calendar.getMonth(), n);
        } else {
            if (bl) {
                throw new IllegalArgumentException(calendar.toString() + " day=" + n);
            }
            CalendarMath.set(calendar, calendar.getYear(), calendar.getMonth(), n);
        }
    }

    private static void set(Calendar calendar, int n, int n2, int n3) {
        if (calendar.isDate(n, n2, n3)) {
            throw new IllegalArgumentException("set (Calendar, int, int, int) called with a legal date.");
        }
        Calendar calendar2 = Calendar.getFirstDate(calendar);
        if (Calendar.compare(n, n2, n3, calendar2.getYear(), calendar2.getMonth(), calendar2.getDay()) < 0) {
            throw new IllegalArgumentException("Date is before the start of this calendar year=" + n + " month=" + n2 + " day=" + n3);
        }
        int n4 = Math.min(Math.max(n2, 1), calendar.getLastMonthOfYear(n));
        int n5 = calendar.getFirstDayOfMonth(n, n4);
        int n6 = calendar.getLastDayOfMonth(n, n4);
        if (n3 > n6) {
            calendar.set(n, n4, n6);
        } else if (n3 < n5) {
            calendar.set(n, n4, n5);
        } else {
            for (int i = n3 + 1; i <= n6; ++i) {
                if (!calendar.isDate(n, n4, i)) continue;
                calendar.set(n, n4, i);
                return;
            }
            throw new IllegalArgumentException("CalendarMath setMonth calendar=" + calendar.toString() + " year=" + n + " month=" + n2 + " day=" + n3);
        }
    }

    private static void set(Calendar calendar, int n, int n2, int n3, boolean bl) {
        if (calendar.isDate(n, n2, n3)) {
            calendar.set(n, n2, n3);
        } else {
            if (bl) {
                throw new IllegalArgumentException(n + "-" + n2 + "-" + n3);
            }
            CalendarMath.set(calendar, n, n2, n3);
        }
    }

    public static final void addYears(Calendar calendar, int n, boolean bl) {
        CalendarMath.setYear(calendar, calendar.getYear() + n, bl);
    }

    public static final void addMonths(Calendar calendar, int n, boolean bl) {
        int n2;
        int n3 = calendar.getYear();
        if (n >= 0) {
            while (n2 > calendar.getLastMonthOfYear(n3)) {
                n2 -= calendar.getLastMonthOfYear(n3);
                ++n3;
            }
        } else {
            for (n2 = calendar.getMonth() + n; n2 <= 0; n2 += calendar.getLastMonthOfYear(--n3)) {
            }
        }
        CalendarMath.set(calendar, n3, n2, calendar.getDay(), bl);
    }

    private CalendarMath() {
    }
}

