/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.CalendarFromString;
import fi.joensuu.joyds1.calendar.GregorianCalendar;
import fi.joensuu.joyds1.calendar.MayanCalendar;
import fi.joensuu.joyds1.calendar.Resources;
import java.io.Serializable;
import java.util.Locale;

public abstract class Calendar
implements Cloneable,
Comparable,
Serializable {
    protected int jdn;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static final int SUNDAY = 7;
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    public static final int UNDECIMBER = 13;
    private static final long serialVersionUID = 1L;

    public int getCycle() {
        throw new UnsupportedOperationException("getCycle");
    }

    public int getYear() {
        throw new UnsupportedOperationException("getYear");
    }

    public int getMonth() {
        throw new UnsupportedOperationException("getMonth");
    }

    public int getDay() {
        throw new UnsupportedOperationException("getDay");
    }

    public int getJulianDayNumber() {
        return this.jdn;
    }

    public int getDayOfWeek() {
        throw new UnsupportedOperationException("getDayOfWeek");
    }

    public int getISOWeekNumber() {
        throw new UnsupportedOperationException("getISOWeekNumber");
    }

    public int getISOYear() {
        throw new UnsupportedOperationException("getISOYear");
    }

    public int getDayOfYear() {
        throw new UnsupportedOperationException("getDayOfYear");
    }

    public boolean isLeapYear() {
        throw new UnsupportedOperationException("isLeapYear");
    }

    public boolean isLeapMonth() {
        throw new UnsupportedOperationException("isLeapMonth");
    }

    public boolean isDate(int n, int n2, int n3) {
        throw new UnsupportedOperationException("isDate (int year, int month, int day)");
    }

    public boolean isDate(int n, int n2, int n3, boolean bl) {
        throw new UnsupportedOperationException("isDate (int year, int month, int day, boolean leapMonth)");
    }

    public boolean isDate(int n, int n2, int n3, int n4, boolean bl) {
        throw new UnsupportedOperationException("isDate (int cycle, int year, int month, int day, boolean leapMonth)");
    }

    public boolean isDate(int n, int n2) {
        throw new UnsupportedOperationException("isDate (int year, int doy)");
    }

    public void set(int n, int n2, int n3) {
        throw new UnsupportedOperationException("set (int year, int month, int day)");
    }

    public void set(int n, int n2, int n3, boolean bl) {
        throw new UnsupportedOperationException("set (int year, int month, int day, boolean leapMonth)");
    }

    public void set(int n, int n2, int n3, int n4, boolean bl) {
        throw new UnsupportedOperationException("set (int cycle, int year, int month, int day, boolean leapMonth)");
    }

    public void set(int n, int n2) {
        throw new UnsupportedOperationException("set (int year, int doy)");
    }

    public void set(java.util.GregorianCalendar gregorianCalendar) {
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5));
        this.set(gregorianCalendar2.getJulianDayNumber());
    }

    public void set(int n) {
        this.jdn2date(n);
        this.jdn = n;
        this.ok("Calendar set (int jd)");
    }

    public void set(Calendar calendar) {
        this.set(calendar.getJulianDayNumber());
    }

    public int compareTo(Object object) {
        return this.compareTo(object);
    }

    public int compareTo(Calendar calendar) {
        return this.getJulianDayNumber() - calendar.getJulianDayNumber();
    }

    public void addDays(int n) {
        this.set(this.getJulianDayNumber() + n);
    }

    public abstract String toString();

    public static final Calendar getToday() {
        java.util.GregorianCalendar gregorianCalendar = new java.util.GregorianCalendar();
        return new GregorianCalendar(gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public java.util.GregorianCalendar toJavaUtilGregorianCalendar() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getJulianDayNumber());
        return new java.util.GregorianCalendar(gregorianCalendar.getYear(), gregorianCalendar.getMonth() - 1, gregorianCalendar.getDay(), 0, 0, 0);
    }

    public boolean equals(Object object) {
        return object instanceof Calendar && this.getJulianDayNumber() == ((Calendar)object).getJulianDayNumber();
    }

    public int hashCode() {
        long l = this.getJulianDayNumber();
        return (int)(l & 0xFFFFFFFFL ^ l >> 32);
    }

    protected abstract boolean ok(String var1);

    protected abstract void jdn2date(int var1);

    protected abstract int date2jdn();

    public boolean isLeapYear(int n) {
        throw new UnsupportedOperationException("isLeapYear (int year)");
    }

    public int getLengthOfYear(int n) {
        throw new UnsupportedOperationException("getLengthOfYear (int year)");
    }

    public int getLengthOfMonth(int n, int n2) {
        throw new UnsupportedOperationException("getLengthOfMonth (int year, int month");
    }

    public int getLengthOfMonth(int n, int n2, boolean bl) {
        throw new UnsupportedOperationException("getLengthOfMonth (int year, int month, boolean leapMonth");
    }

    public int getFirstDayOfMonth(int n, int n2) {
        throw new UnsupportedOperationException("getFirstDayOfMonth (int year, int month)");
    }

    public int getFirstDayOfMonth(int n, int n2, boolean bl) {
        throw new UnsupportedOperationException("getFirstDayOfMonth (int year, int month, boolean leapMonth)");
    }

    public int getLastDayOfMonth(int n, int n2) {
        throw new UnsupportedOperationException("getLastDayOfMonth (int year, int month)");
    }

    public int getLastDayOfMonth(int n, int n2, boolean bl) {
        throw new UnsupportedOperationException("getLastDayOfMonth (int year, int month, boolean leapMonth)");
    }

    public int getFirstMonthOfYear(int n) {
        throw new UnsupportedOperationException("getFirstMonthOfYear (int year)");
    }

    public int getLastMonthOfYear(int n) {
        throw new UnsupportedOperationException("getLastMonthOfYear (int year)");
    }

    public int getLengthOfYear(int n, int n2) {
        throw new UnsupportedOperationException("getLengthOfYear (int cycle, int year)");
    }

    public int getLengthOfMonth(int n, int n2, int n3, boolean bl) {
        throw new UnsupportedOperationException("getLengthOfMonth (int cycle, int year, int month, boolean leapMonth");
    }

    public int getFirstDayOfMonth(int n, int n2, int n3, boolean bl) {
        throw new UnsupportedOperationException("getFirstDayOfMonth (int cycle, int year, int month, boolean leapMonth)");
    }

    public int getLastDayOfMonth(int n, int n2, int n3, boolean bl) {
        throw new UnsupportedOperationException("getLastDayOfMonth (int cycle, int year, int month, boolean leapMonth)");
    }

    public int getFirstMonthOfYear(int n, int n2) {
        throw new UnsupportedOperationException("getFirstMonthOfYear (int cycle, int year)");
    }

    public int getLastMonthOfYear(int n, int n2) {
        throw new UnsupportedOperationException("getLastMonthOfYear (int cycle, int year)");
    }

    protected int getCumulativeDays(int n, int n2) {
        throw new UnsupportedOperationException("getCumulativeDays (int year, int month)");
    }

    protected void doy2date(int n, int n2) {
        throw new UnsupportedOperationException("doy2date (int year, int doy)");
    }

    protected int date2jdn(int n, int n2, int n3) {
        throw new UnsupportedOperationException("date2jdn (int year, int month, int day)");
    }

    public int getBaktun() {
        throw new UnsupportedOperationException("getBaktun");
    }

    public int getKatun() {
        throw new UnsupportedOperationException("getKatun");
    }

    public int getTun() {
        throw new UnsupportedOperationException("getTun");
    }

    public int getUinal() {
        throw new UnsupportedOperationException("getUinal");
    }

    public int getKin() {
        throw new UnsupportedOperationException("getKin");
    }

    public boolean isDate(int n, int n2, int n3, int n4, int n5) {
        throw new UnsupportedOperationException("isDate (int baktun, ...");
    }

    public void set(int n, int n2, int n3, int n4, int n5) {
        throw new UnsupportedOperationException("set (int baktun, ...");
    }

    public int getHaabDay() {
        throw new UnsupportedOperationException("getHaabDay");
    }

    public int getHaabMonth() {
        throw new UnsupportedOperationException("getHaabMonth");
    }

    public int getTzolkinDay() {
        throw new UnsupportedOperationException("getTzolkinDay");
    }

    public int getTzolkinMonth() {
        throw new UnsupportedOperationException("getTzolkinMonth");
    }

    public abstract int getFirstJulianDay();

    public final int getFirstYear() {
        Calendar calendar = (Calendar)this.clone();
        calendar.set(this.getFirstJulianDay());
        return calendar.getYear();
    }

    protected static final int amod(int n, int n2) {
        return 1 + (n - 1) % n2;
    }

    protected static final int date2jdn_julian(int n, int n2, int n3) {
        int n4 = (14 - n2) / 12;
        int n5 = n + 4800 - n4;
        int n6 = n2 + 12 * n4 - 3;
        return n3 + (153 * n6 + 2) / 5 + n5 * 365 + n5 / 4 - 32083;
    }

    protected static final int date2jdn_gregorian(int n, int n2, int n3) {
        int n4 = (14 - n2) / 12;
        int n5 = n + 4800 - n4;
        int n6 = n2 + 12 * n4 - 3;
        return n3 + (153 * n6 + 2) / 5 + n5 * 365 + n5 / 4 - n5 / 100 + n5 / 400 - 32045;
    }

    static final int compare(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n < n4) {
            return -1;
        }
        if (n > n4) {
            return 1;
        }
        if (n2 < n5) {
            return -1;
        }
        if (n2 > n5) {
            return 1;
        }
        return n3 - n6;
    }

    public static final Calendar getFirstDate(Calendar calendar) {
        if (calendar.getClass().getName().compareTo("fi.joensuu.joyds1.calendar.MayanCalendar") == 0) {
            return new MayanCalendar(584283);
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(calendar.getFirstJulianDay());
        return calendar2;
    }

    protected static final double mod(double d, double d2) {
        return d - d2 * Math.floor(d / d2);
    }

    public static final Calendar getInstance(Locale locale) {
        try {
            return CalendarFromString.getCalendar(Resources.getBundle(locale).getString("DefaultCalendar"));
        }
        catch (Throwable throwable) {
            throw new RuntimeException("getInstance(Locale)", throwable);
        }
    }

    public static final Calendar getInstance() {
        try {
            return CalendarFromString.getInstance(Resources.getString("DefaultCalendar"));
        }
        catch (Throwable throwable) {
            throw new RuntimeException("getInstance", throwable);
        }
    }
}

