/*
 * Decompiled with CFR 0.152.
 */
package fi.joensuu.joyds1.calendar;

import fi.joensuu.joyds1.calendar.Calendar;
import fi.joensuu.joyds1.calendar.JulianGregorianCalendar;
import fi.joensuu.joyds1.calendar.OldWorldCalendar;
import java.util.GregorianCalendar;

public class BahaiCalendar
extends OldWorldCalendar {
    private static final int[] cumulative_days_in_leap_year = new int[]{0, 19, 38, 57, 76, 95, 114, 133, 152, 171, 190, 209, 228, 247, 266, 285, 304, 323, 342, 347, 366};
    private static final int[] cumulative_days_in_ordinary_year = new int[]{0, 19, 38, 57, 76, 95, 114, 133, 152, 171, 190, 209, 228, 247, 266, 285, 304, 323, 342, 346, 365};
    private static final int[] days_in_month_in_leap_year = new int[]{0, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 5, 19};
    private static final int[] days_in_month_in_ordinary_year = new int[]{0, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 19, 4, 19};
    public static final int FIRST_JULIAN_DAY = BahaiCalendar.date2jdn_gregorian(1844, 3, 21);
    private static final int M18 = cumulative_days_in_ordinary_year[18];
    private static final long serialVersionUID = 1L;

    public BahaiCalendar() {
        this(BahaiCalendar.getToday());
    }

    public BahaiCalendar(int n, int n2, int n3) {
        this.set(n, n2, n3);
    }

    public BahaiCalendar(int n, int n2) {
        this.set(n, n2);
    }

    public BahaiCalendar(int n) {
        this.set(n);
    }

    public BahaiCalendar(Calendar calendar) {
        this.set(calendar);
    }

    public BahaiCalendar(GregorianCalendar gregorianCalendar) {
        this.set(gregorianCalendar);
    }

    @Override
    protected void jdn2date(int n) {
        if (n < FIRST_JULIAN_DAY) {
            throw new IllegalArgumentException("BahaiCalendar jdn2date (int n)");
        }
        this.jdn2ymd(0, n - FIRST_JULIAN_DAY);
    }

    @Override
    protected int date2jdn(int n, int n2, int n3) {
        return FIRST_JULIAN_DAY - 1 + 365 * (n - 1) + (n - 1) / 4 - (n - 1) / 100 + (n - 1) / 400 + this.getCumulativeDays(n, n2 - 1) + n3;
    }

    @Override
    protected void doy2date(int n, int n2) {
        if (!this.isDate(n, n2)) {
            throw new IllegalArgumentException("doy2date year=" + n + " doy=" + n2);
        }
        this.year = n;
        this.month = n2 <= M18 ? (n2 - 1) / 19 + 1 : (n2 <= this.getCumulativeDays(n, 19) ? 19 : 20);
        this.day = n2 - this.getCumulativeDays(this.year, this.month - 1);
        if (!this.isDate(this.year, this.month, this.day)) {
            throw new IllegalArgumentException("BahaiCalendar doy2date this.year=" + this.year + " this.month=" + this.month + " this.day=" + this.day + " doy=" + n2);
        }
    }

    @Override
    protected int getCumulativeDays(int n, int n2) {
        return this.isLeapYear(n) ? cumulative_days_in_leap_year[n2] : cumulative_days_in_ordinary_year[n2];
    }

    @Override
    public boolean isLeapYear(int n) {
        return JulianGregorianCalendar.is_leap_year_gregorian(n);
    }

    @Override
    public int getLengthOfMonth(int n, int n2) {
        return this.isLeapYear(n) ? days_in_month_in_leap_year[n2] : days_in_month_in_ordinary_year[n2];
    }

    @Override
    public int getLastMonthOfYear(int n) {
        return 20;
    }

    @Override
    public int getFirstJulianDay() {
        return FIRST_JULIAN_DAY;
    }
}

