/*
 * Decompiled with CFR 0.152.
 */
package mmguiclient;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import mmguiclient.MMFrame;
import mmguiclient.MMimageResource;

public class MMpicture
extends Panel
implements MouseListener,
KeyListener,
FocusListener {
    protected Image m_image;
    MMFrame m_frame;
    boolean m_clickable;
    boolean m_focus;

    public MMpicture(MMFrame mMFrame, String string) {
        this.m_frame = mMFrame;
        this.setLayout(null);
        this.display(string);
        this.addMouseListener(this);
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.setClickable(true);
        this.m_focus = false;
    }

    public void setClickable(boolean bl) {
        this.m_clickable = bl;
    }

    public void display(String string) {
        try {
            this.m_image = new MMimageResource().getImage(string);
        }
        catch (Exception exception) {}
        this.invalidate();
        this.repaint();
    }

    public void display(Image image) {
        try {
            this.m_image = image;
        }
        catch (Exception exception) {}
        this.invalidate();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        if (this.m_image != null) {
            graphics.drawImage(this.m_image, 1, 1, this);
        }
        if (this.m_clickable && this.m_focus) {
            graphics.setColor(Color.blue);
            Dimension dimension = this.getSize();
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.m_clickable) {
            return;
        }
        int n = this.m_frame.getMode();
        this.m_frame.m_toolbar.setMode(n + 1);
        this.requestFocus();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!this.m_clickable) {
            return;
        }
        int n = keyEvent.getKeyCode();
        keyEvent.consume();
        if (n == 9) {
            if ((keyEvent.getModifiers() & 1) > 0) {
                this.m_frame.m_inputLine.requestFocus();
                return;
            }
            this.transferFocus();
            return;
        }
        if (n != 10 && n != 32) {
            return;
        }
        int n2 = this.m_frame.getMode();
        this.m_frame.m_toolbar.setMode(n2 + 1);
        this.requestFocus();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public boolean isFocusTraversable() {
        return this.m_clickable;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!this.m_clickable) {
            return;
        }
        this.m_frame.m_focusHolder = null;
        this.m_focus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.m_clickable) {
            return;
        }
        this.m_focus = false;
        this.repaint();
    }
}

