/*
 * Decompiled with CFR 0.152.
 */
package mmguiclient;

import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.TextComponent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import mmguiclient.IParameters;
import mmguiclient.MMFrame;
import mmguiclient.MMfield;

public class MMmenu
extends MenuBar
implements IParameters,
ItemListener {
    Menu m_file;
    Menu m_edit;
    Menu m_settings;
    Menu m_help;
    CheckboxMenuItem m_si;
    CheckboxMenuItem m_cgse;
    MenuItem m_helpHelp;
    MenuItem m_helpAbout;
    Menu m_history;
    MenuItem m_save;
    MenuItem m_saveAs;
    MenuItem m_printLog;
    MenuItem m_printGraph;
    MenuItem m_paste;
    MenuItem m_host;
    MenuItem m_browser;
    MenuItem m_importMacro;
    MenuItem m_exportMacro;
    CheckboxMenuItem m_hint;
    CheckboxMenuItem m_autoSave;
    int m_system;
    String[] m_list;
    int m_length;
    String m_clipboard;
    MMFrame m_frame;

    public MMmenu(MMFrame mMFrame) {
        this.m_frame = mMFrame;
        ResourceBundle resourceBundle = this.m_frame.m_resource;
        this.m_file = new Menu(resourceBundle.getString("file"));
        this.m_edit = new Menu(resourceBundle.getString("edit"));
        this.m_settings = new Menu(resourceBundle.getString("settings"));
        this.m_help = new Menu(resourceBundle.getString("help"));
        this.m_si = new CheckboxMenuItem(resourceBundle.getString("si"));
        this.m_cgse = new CheckboxMenuItem(resourceBundle.getString("cgse"));
        this.m_helpHelp = new MenuItem(resourceBundle.getString("help"));
        this.m_helpAbout = new MenuItem(resourceBundle.getString("about"));
        this.m_history = new Menu(resourceBundle.getString("history"));
        this.m_paste = new MenuItem(resourceBundle.getString("paste"));
        this.m_host = new MenuItem(resourceBundle.getString("host_name"));
        this.m_browser = new MenuItem(resourceBundle.getString("browser"));
        this.m_importMacro = new MenuItem(resourceBundle.getString("import_macro"));
        this.m_exportMacro = new MenuItem(resourceBundle.getString("export_macro"));
        this.m_save = new MenuItem(resourceBundle.getString("save"));
        this.m_saveAs = new MenuItem(resourceBundle.getString("save_as"));
        this.m_printLog = new MenuItem(resourceBundle.getString("print_log"));
        this.m_printGraph = new MenuItem(resourceBundle.getString("print_graph"));
        this.m_hint = new CheckboxMenuItem(resourceBundle.getString("show_hints"));
        this.m_autoSave = new CheckboxMenuItem(resourceBundle.getString("auto_save"));
        this.m_file.add(resourceBundle.getString("open"));
        this.m_file.add(this.m_save);
        this.m_file.add(this.m_saveAs);
        this.m_file.addSeparator();
        this.m_file.add(resourceBundle.getString("view"));
        this.m_file.addSeparator();
        this.m_file.add(this.m_importMacro);
        this.m_file.add(this.m_exportMacro);
        this.m_file.addSeparator();
        this.m_file.add(this.m_printLog);
        this.m_file.add(this.m_printGraph);
        this.m_file.addSeparator();
        this.m_file.add(resourceBundle.getString("exit"));
        this.add(this.m_file);
        this.m_file.addActionListener(this.m_frame);
        this.m_edit.add(resourceBundle.getString("cut"));
        this.m_edit.add(resourceBundle.getString("copy"));
        this.m_edit.add(this.m_paste);
        this.add(this.m_edit);
        this.m_edit.addActionListener(this.m_frame);
        this.add(this.m_history);
        this.m_history.addActionListener(this.m_frame);
        this.m_settings.add(this.m_si);
        this.m_si.addItemListener(this);
        this.m_settings.add(this.m_cgse);
        this.m_cgse.addItemListener(this);
        this.m_settings.addSeparator();
        this.m_settings.add(this.m_browser);
        this.m_settings.add(this.m_host);
        this.m_settings.addSeparator();
        this.m_settings.add(this.m_hint);
        this.m_settings.addSeparator();
        this.m_settings.add(new MenuItem(resourceBundle.getString("clear_history")));
        this.m_settings.add(new MenuItem(resourceBundle.getString("save_settings")));
        this.m_settings.add(this.m_autoSave);
        this.add(this.m_settings);
        this.m_settings.addActionListener(this.m_frame);
        this.m_hint.addItemListener(this.m_frame);
        this.m_help.add(this.m_helpHelp);
        this.m_help.addSeparator();
        this.m_help.add(this.m_helpAbout);
        this.setHelpMenu(this.m_help);
        this.add(this.m_help);
        this.m_help.addActionListener(this.m_frame);
        this.m_system = 0;
        this.m_si.setState(true);
        this.m_list = new String[15];
        this.m_length = 0;
        this.m_paste.setEnabled(false);
        this.m_clipboard = "";
        this.m_printGraph.setEnabled(false);
        this.enableLogItems(false);
    }

    public void enableLogItems(boolean bl) {
        this.m_printLog.setEnabled(bl);
        this.m_save.setEnabled(bl);
        this.m_saveAs.setEnabled(bl);
    }

    public void setSystem(int n) {
        if (this.m_system == n) {
            return;
        }
        this.m_system = n;
        if (this.m_system == 0) {
            this.m_cgse.setState(false);
            this.m_si.setState(true);
            return;
        }
        this.m_si.setState(false);
        this.m_cgse.setState(true);
    }

    public int getSystem() {
        return this.m_system;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        if (string.equals(this.m_frame.m_resource.getString("si"))) {
            this.setSystem(0);
            return;
        }
        if (string.equals(this.m_frame.m_resource.getString("cgse"))) {
            this.setSystem(1);
            return;
        }
    }

    void listStrings() {
        int n = this.m_history.getItemCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.m_history.remove(n2);
            --n2;
        }
        n2 = 0;
        while (n2 < this.m_length) {
            MenuItem menuItem = new MenuItem(this.m_list[n2]);
            this.m_history.add(menuItem);
            ++n2;
        }
    }

    void clearHistory() {
        int n = this.m_history.getItemCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            this.m_history.remove(n2);
            --n2;
        }
        this.m_length = 0;
    }

    boolean isNewExpression(String string) {
        int n = 0;
        while (n < this.m_length) {
            if (string.equals(this.m_list[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    void updateList(String string) {
        if (this.isNewExpression(string)) {
            if (this.m_length < 15) {
                this.m_list[this.m_length] = string;
                ++this.m_length;
                this.m_history.add(string);
                return;
            }
            int n = 0;
            while (n < this.m_length - 1) {
                this.m_list[n] = this.m_list[n + 1];
                ++n;
            }
            this.m_list[this.m_length - 1] = string;
            this.listStrings();
        }
    }

    void cut() {
        int n;
        MMfield mMfield = this.m_frame.m_focusHolder;
        if (mMfield == null) {
            return;
        }
        this.m_clipboard = mMfield.getSelectedText();
        int n2 = mMfield.getSelectionStart();
        if (n2 == (n = mMfield.getSelectionEnd())) {
            return;
        }
        String string = mMfield.getText();
        String string2 = String.valueOf(string.substring(0, n2)) + string.substring(n);
        ((TextComponent)mMfield).setText(string2);
        mMfield.requestFocus();
        mMfield.select(n2, n2);
        this.m_paste.setEnabled(true);
    }

    void copy() {
        MMfield mMfield = this.m_frame.m_focusHolder;
        if (mMfield == null) {
            return;
        }
        this.m_clipboard = mMfield.getSelectedText();
        this.m_paste.setEnabled(!this.m_clipboard.equals(""));
    }

    void paste() {
        MMfield mMfield = this.m_frame.m_focusHolder;
        if (mMfield == null || this.m_clipboard.equals("") || !this.m_paste.isEnabled()) {
            return;
        }
        int n = mMfield.getSelectionStart();
        int n2 = mMfield.getSelectionEnd();
        String string = mMfield.getText();
        String string2 = string.substring(0, n);
        string2 = String.valueOf(string2) + this.m_clipboard + string.substring(n2);
        ((TextComponent)mMfield).setText(string2);
        mMfield.requestFocus();
        mMfield.select(n2, n2);
    }
}

