/*
 * Decompiled with CFR 0.152.
 */
package mmguiclient;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import mathlib.DoubleFormat;
import mmguiclient.IParameters;
import mmguiclient.MMgraph;

class MMgraphFrame
extends Panel
implements IParameters {
    MMgraph m_graph;
    static final int TICK_HEIGHT = 4;
    static final int MARK_OFFSET = 8;
    double m_xmin;
    double m_xmax;
    double m_ymin;
    double m_ymax;
    int[] m_xTicks;
    int[] m_yTicks;
    int[] m_xSmallTicks;
    int[] m_ySmallTicks;
    String[] m_xMarks;
    String[] m_yMarks;
    String m_xTitle;
    String m_yTitle;
    Label m_info;

    public MMgraphFrame(MMgraph mMgraph) {
        this.m_graph = mMgraph;
        this.setBackground(IParameters.BACKGROUND_COLOR);
        ((Component)this).setFont(new Font("Dialog", 0, 11));
        this.m_info = new Label("", 1);
        this.m_info.setBounds(0, 7, 676, 15);
        this.add(this.m_info);
    }

    void setXTicks(double d, double d2) {
        this.m_xmin = d;
        this.m_xmax = d2;
        double d3 = this.m_xmax - this.m_xmin;
        if (d3 == 0.0) {
            if (this.m_yTicks == null) {
                this.m_xTicks = new int[2];
                this.m_xMarks = new String[2];
            }
            if (this.m_xTicks.length != 2) {
                this.m_xTicks = new int[2];
                this.m_xMarks = new String[2];
            }
            this.m_xTicks[0] = 40;
            this.m_xMarks[0] = DoubleFormat.represent(this.m_xmin, 3);
            this.m_xTicks[1] = this.getSize().width - 40;
            this.m_xMarks[1] = this.m_xMarks[0];
            this.m_xTitle = "x 1e0";
            this.m_graph.m_gPanel.setXAxis(-1);
            this.m_xSmallTicks = new int[0];
            return;
        }
        int n = this.getSize().width - 80;
        int n2 = (int)(Math.log(d3) / Math.log(10.0));
        this.m_xTitle = "x 1e" + n2;
        double d4 = Math.pow(10.0, n2);
        this.m_xmin /= d4;
        this.m_xmax /= d4;
        d3 = this.m_xmax - this.m_xmin;
        int n3 = (int)d3 + 1;
        d4 = (double)n / d3;
        this.m_xTicks = new int[n3];
        this.m_xMarks = new String[n3];
        int n4 = (int)Math.ceil(this.m_xmin);
        int n5 = (int)(((double)n4 - this.m_xmin) * d4) + 40;
        int n6 = d4 > 40.0 ? 9 : (d4 > 20.0 ? 4 : (d4 > 8.0 ? 1 : 0));
        this.m_xSmallTicks = new int[n6];
        int n7 = 0;
        while (n7 < n6) {
            this.m_xSmallTicks[n7] = (int)((double)(n7 + 1) * d4 / ((double)n6 + 1.0));
            ++n7;
        }
        this.m_graph.m_gPanel.setXAxis(-1);
        n7 = 0;
        while (n7 < n3) {
            int n8;
            this.m_xTicks[n7] = n8 = n5 + (int)((double)n7 * d4);
            if (n4 == 0) {
                this.m_graph.m_gPanel.setXAxis(n8 - 40);
            }
            this.m_xMarks[n7] = String.valueOf(n4);
            ++n4;
            ++n7;
        }
    }

    void setYTicks(double d, double d2) {
        this.m_ymin = d;
        this.m_ymax = d2;
        double d3 = this.m_ymax - this.m_ymin;
        if (d3 == 0.0) {
            if (this.m_yTicks == null) {
                this.m_yTicks = new int[1];
                this.m_yMarks = new String[1];
            }
            if (this.m_yTicks.length != 1) {
                this.m_yTicks = new int[1];
                this.m_yMarks = new String[1];
            }
            this.m_yTicks[0] = 60;
            this.m_yMarks[0] = DoubleFormat.represent(this.m_ymax, 3);
            this.m_yTitle = "x 1e0";
            this.m_graph.m_gPanel.setYAxis(-1);
            this.m_ySmallTicks = new int[0];
            return;
        }
        int n = this.getSize().height - 120;
        int n2 = (int)(Math.log(d3) / Math.log(10.0));
        this.m_yTitle = "x 1e" + n2;
        double d4 = Math.pow(10.0, n2);
        this.m_ymin /= d4;
        this.m_ymax /= d4;
        this.m_ymax += 0.001;
        d3 = this.m_ymax - this.m_ymin;
        int n3 = (int)d3 + 1;
        d4 = (double)n / d3;
        this.m_yTicks = new int[n3];
        this.m_yMarks = new String[n3];
        int n4 = (int)Math.floor(this.m_ymax);
        int n5 = (int)((this.m_ymax - (double)n4) * d4) + 60;
        int n6 = d4 > 40.0 ? 9 : (d4 > 20.0 ? 4 : (d4 > 8.0 ? 1 : 0));
        this.m_ySmallTicks = new int[n6];
        int n7 = 0;
        while (n7 < n6) {
            this.m_ySmallTicks[n7] = (int)((double)(n7 + 1) * d4 / ((double)n6 + 1.0));
            ++n7;
        }
        this.m_graph.m_gPanel.setYAxis(-1);
        n7 = 0;
        while (n7 < n3) {
            int n8;
            this.m_yTicks[n7] = n8 = n5 + (int)((double)n7 * d4);
            if (n4 == 0) {
                this.m_graph.m_gPanel.setYAxis(n8 - 30);
            }
            this.m_yMarks[n7] = String.valueOf(n4 < 0 ? "" : " ") + n4;
            --n4;
            ++n7;
        }
    }

    public void setInfo() {
        int n;
        double d;
        this.m_graph.m_gPanel.getSize();
        if (this.m_xTicks.length > 1) {
            d = this.m_xTicks[1] - this.m_xTicks[0];
        } else {
            n = this.m_xSmallTicks.length + 1;
            d = (double)n * (double)(this.m_xSmallTicks[1] - this.m_xSmallTicks[0]);
        }
        double d2 = this.m_yTicks.length > 1 ? (double)(this.m_yTicks[1] - this.m_yTicks[0]) : ((n = this.m_ySmallTicks.length + 1) > 2 ? (double)n * (double)(this.m_ySmallTicks[1] - this.m_ySmallTicks[0]) : 0.0);
        this.m_info.setText("X: " + this.m_xTitle + ", Y: " + this.m_yTitle + ", X/Y: " + (d2 == 0.0 ? "INF" : DoubleFormat.represent(d / d2, 3)));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.layOut(graphics, true);
    }

    void layOut(Graphics graphics, boolean bl) {
        int n;
        int n2;
        int n3;
        graphics.setColor(IParameters.BACKGROUND_COLOR);
        Rectangle rectangle = this.m_graph.m_gPanel.getBounds();
        if (bl) {
            graphics.draw3DRect(rectangle.x - 2, rectangle.y - 2, rectangle.width + 3, rectangle.height + 3, false);
        }
        if (this.m_xTitle == null || this.m_yTitle == null) {
            return;
        }
        int n4 = this.getSize().height - 30 + 2;
        int n5 = this.getSize().width - 40;
        graphics.setColor(IParameters.BLACK);
        if (this.m_xTicks != null) {
            n3 = 0;
            while (n3 < this.m_xSmallTicks.length) {
                n2 = this.m_xTicks[0] - this.m_xSmallTicks[n3];
                if (n2 >= 40) {
                    graphics.drawLine(n2, n4, n2, n4 + 2);
                }
                ++n3;
            }
            n = 0;
            while (n < this.m_xTicks.length) {
                n2 = this.m_xTicks[n];
                if (n2 < n5 && n2 >= 40) {
                    graphics.drawLine(n2, n4, n2, n4 + 4);
                    graphics.drawString(this.m_xMarks[n], n2 - 5, n4 + 8 + graphics.getFontMetrics().getAscent());
                }
                n3 = 0;
                while (n3 < this.m_xSmallTicks.length) {
                    n2 = this.m_xTicks[n] + this.m_xSmallTicks[n3];
                    if (n2 < n5) {
                        graphics.drawLine(n2, n4, n2, n4 + 2);
                    }
                    ++n3;
                }
                ++n;
            }
        }
        if (this.m_yTicks != null) {
            int n6 = 38;
            n3 = 0;
            while (n3 < this.m_ySmallTicks.length) {
                n2 = this.m_yTicks[0] - this.m_ySmallTicks[n3];
                if (n2 >= 30) {
                    graphics.drawLine(n6 - 2, n2, n6, n2);
                }
                ++n3;
            }
            n = 0;
            while (n < this.m_yTicks.length) {
                n2 = this.m_yTicks[n];
                if (n2 >= 30 && n2 < n4 - 2) {
                    graphics.drawLine(n6 - 4, n2, n6, n2);
                    graphics.drawString(this.m_yMarks[n], 14, n2);
                }
                n3 = 0;
                while (n3 < this.m_ySmallTicks.length) {
                    n2 = this.m_yTicks[n] + this.m_ySmallTicks[n3];
                    if (n2 < n4 - 2) {
                        graphics.drawLine(n6 - 2, n2, n6, n2);
                    }
                    ++n3;
                }
                ++n;
            }
        }
    }
}

