/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.presentation;

import com.edsdev.jconvert.util.Browser;
import com.edsdev.jconvert.util.Http;
import com.edsdev.jconvert.util.JConvertProperties;
import com.edsdev.jconvert.util.JConvertSettingsProperties;
import com.edsdev.jconvert.util.Logger;
import com.edsdev.jconvert.util.Messages;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;

public class UpgradeVersionChecker {
    private static final Logger log = Logger.getInstance(class$com$edsdev$jconvert$presentation$UpgradeVersionChecker == null ? (class$com$edsdev$jconvert$presentation$UpgradeVersionChecker = UpgradeVersionChecker.class$("com.edsdev.jconvert.presentation.UpgradeVersionChecker")) : class$com$edsdev$jconvert$presentation$UpgradeVersionChecker);
    private String currentVersion = "";
    private String webVersion = "";
    private JDialog dlg = null;
    private JTextArea messageLabel = null;
    private JButton yesBtn = null;
    private JButton noBtn = null;
    private JButton dontAskBtn = null;
    private ActionListener yesActionListener = null;
    private ActionListener noActionListener = null;
    static /* synthetic */ Class class$com$edsdev$jconvert$presentation$UpgradeVersionChecker;

    public static void main(String[] stringArray) {
        new UpgradeVersionChecker().checkForUpdates(null);
    }

    public void checkForUpdates(Frame frame) {
        if (this.isNewerVersionAvailable()) {
            log.debug("Newer version of JConvert found.");
            this.dlg = new JDialog(frame, Messages.getResource("newVersionTitle"), true);
            this.dlg.setDefaultCloseOperation(2);
            this.dlg.setSize(400, 200);
            this.dlg.setLocationRelativeTo(frame);
            this.dlg.getContentPane().setLayout(null);
            this.messageLabel = new JTextArea(Messages.getResource("newVersionMsg", this.webVersion, this.currentVersion));
            this.messageLabel.setBounds(5, 5, 385, 60);
            this.messageLabel.setEditable(false);
            JLabel jLabel = new JLabel("temp");
            this.messageLabel.setBackground(jLabel.getBackground());
            this.dlg.getContentPane().add(this.messageLabel);
            this.yesBtn = new JButton(Messages.getResource("yesButton"));
            this.yesBtn.setBounds(5, 70, 100, 22);
            this.yesActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UpgradeVersionChecker.this.openLinkToWeb();
                }
            };
            this.yesBtn.addActionListener(this.yesActionListener);
            this.dlg.getContentPane().add(this.yesBtn);
            this.noBtn = new JButton(Messages.getResource("noButton"));
            this.noBtn.setBounds(115, 70, 100, 22);
            this.noActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UpgradeVersionChecker.this.close();
                }
            };
            this.noBtn.addActionListener(this.noActionListener);
            this.dlg.getContentPane().add(this.noBtn);
            this.dontAskBtn = new JButton(Messages.getResource("dontAskButton"));
            this.dontAskBtn.setBounds(5, 100, 350, 22);
            this.dontAskBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    UpgradeVersionChecker.this.dontAskAnymore();
                    UpgradeVersionChecker.this.close();
                }
            });
            this.dlg.getContentPane().add(this.dontAskBtn);
            this.dlg.show();
        } else {
            log.debug("Newer version of JConvert not found.");
        }
    }

    private void close() {
        this.dlg.dispose();
    }

    private void dontAskAnymore() {
        JConvertSettingsProperties.setCheckForNewerVersion("No");
    }

    private void openLinkToWeb() {
        Browser.openURL("http://sourceforge.net/projects/jconvert/files/latest");
        this.messageLabel.setText(Messages.getResource("newVersionLaunchedMsg"));
        this.dontAskBtn.setVisible(false);
        this.yesBtn.removeActionListener(this.yesActionListener);
        this.noBtn.removeActionListener(this.noActionListener);
        this.yesActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UpgradeVersionChecker.this.close();
                System.exit(0);
            }
        };
        this.yesBtn.addActionListener(this.yesActionListener);
        this.noActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UpgradeVersionChecker.this.close();
            }
        };
        this.noBtn.addActionListener(this.noActionListener);
    }

    private boolean isNewerVersionAvailable() {
        Object object;
        if ("No".equals(JConvertSettingsProperties.getCheckForNewerVersion())) {
            return false;
        }
        this.currentVersion = JConvertProperties.getBuidVersion();
        Properties properties = null;
        StringBuffer stringBuffer = null;
        try {
            object = Http.getPage("http://jconvert.sourceforge.net/jconvert.properties");
            stringBuffer = Http.receivePage((URLConnection)object, "UTF-8");
            properties = new Properties();
            properties.load(new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF-8")));
            this.webVersion = properties.getProperty("MajorVersion") + "." + properties.getProperty("MinorVersion") + "." + properties.getProperty("Revision");
        }
        catch (IOException iOException) {
            log.info("Not able to check for the latest version of JConvert.");
            return false;
        }
        object = this.compare(properties.getProperty("MajorVersion"), JConvertProperties.getMajorVersion());
        if (object != null) {
            return (Boolean)object;
        }
        object = this.compare(properties.getProperty("MinorVersion"), JConvertProperties.getMinorVersion());
        if (object != null) {
            return (Boolean)object;
        }
        object = this.compare(properties.getProperty("Revision"), JConvertProperties.getRevision());
        if (object != null) {
            return (Boolean)object;
        }
        return false;
    }

    private Boolean compare(String string, String string2) {
        int n;
        int n2 = new Integer(string);
        if (n2 > (n = new Integer(string2).intValue())) {
            return Boolean.TRUE;
        }
        if (n2 < n) {
            return Boolean.FALSE;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

