/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.presentation;

import com.edsdev.jconvert.domain.Conversion;
import com.edsdev.jconvert.domain.ConversionType;
import com.edsdev.jconvert.presentation.ConversionUnitData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ConversionTypeData
implements Comparable {
    private ConversionType type;

    public ConversionTypeData(ConversionType conversionType) {
        this.setType(conversionType);
    }

    public String getTypeName() {
        return this.type.getTypeName();
    }

    public List getAllFromUnits() {
        Object object;
        HashSet<ConversionUnitData> hashSet = new HashSet<ConversionUnitData>();
        Iterator iterator = this.type.getConversions().iterator();
        while (iterator.hasNext()) {
            object = (Conversion)iterator.next();
            hashSet.add(new ConversionUnitData(((Conversion)object).getFromUnit(), ((Conversion)object).getFromUnitAbbr(), 0));
            hashSet.add(new ConversionUnitData(((Conversion)object).getToUnit(), ((Conversion)object).getToUnitAbbr(), 0));
        }
        object = new ArrayList();
        object.addAll(hashSet);
        Collections.sort(object);
        return object;
    }

    public List getToUnits(String string) {
        Object object;
        HashSet<ConversionUnitData> hashSet = new HashSet<ConversionUnitData>();
        Iterator iterator = this.type.getConversions().iterator();
        while (iterator.hasNext()) {
            object = (Conversion)iterator.next();
            String string2 = ((Conversion)object).getConversionPartner(string);
            if (string2 == null) continue;
            String string3 = ((Conversion)object).getConversionPartnerAbbrev(string);
            hashSet.add(new ConversionUnitData(string2, string3, ((Conversion)object).getGenerationAge()));
        }
        object = new ArrayList();
        object.addAll(hashSet);
        Collections.sort(object);
        return object;
    }

    public double convert(double d, String string, String string2) {
        float f = 1.0E7f;
        double d2 = 0.0;
        Iterator iterator = this.type.getConversions().iterator();
        while (iterator.hasNext()) {
            Conversion conversion = (Conversion)iterator.next();
            Double d3 = conversion.convertValue(d, string, string2);
            if (d3 == null) continue;
            float f2 = conversion.getGenerationAge();
            if (conversion.getFromUnit().equals(string)) {
                f2 -= 0.5f;
            }
            if (!(f > f2)) continue;
            d2 = d3;
            f = f2;
        }
        return d2;
    }

    public double convert(String string, String string2, String string3) {
        float f = 1.0E7f;
        double d = 0.0;
        string = this.cleanStartValue(string);
        Iterator iterator = this.type.getConversions().iterator();
        while (iterator.hasNext()) {
            Conversion conversion = (Conversion)iterator.next();
            Double d2 = conversion.convertValue(string, string2, string3);
            if (d2 == null) continue;
            float f2 = conversion.getGenerationAge();
            if (conversion.getFromUnit().equals(string2)) {
                f2 -= 0.5f;
            }
            if (!(f > f2)) continue;
            d = d2;
            f = f2;
        }
        return d;
    }

    private String cleanStartValue(String string) {
        int n = string.indexOf(" ");
        int n2 = string.indexOf("/");
        if (n2 > 0) {
            return string;
        }
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public String convertFraction(String string, String string2, String string3) {
        String string4 = "";
        string = this.cleanStartValue(string);
        Iterator iterator = this.type.getConversions().iterator();
        while (iterator.hasNext()) {
            Conversion conversion = (Conversion)iterator.next();
            string4 = conversion.convertFraction(string, string2, string3);
            if (string4 == null) continue;
            return string4;
        }
        return string4;
    }

    public ConversionType getType() {
        return this.type;
    }

    public void setType(ConversionType conversionType) {
        this.type = conversionType;
    }

    public int compareTo(Object object) {
        if (object instanceof ConversionTypeData) {
            return this.type.getTypeName().compareTo(((ConversionTypeData)object).getType().getTypeName());
        }
        return 0;
    }
}

