/*
 * Decompiled with CFR 0.152.
 */
package com.edsdev.jconvert.domain;

import com.edsdev.jconvert.domain.DecimalConversion;
import com.edsdev.jconvert.domain.FractionalConversion;
import java.math.BigInteger;

public abstract class Conversion
implements Comparable {
    private String fromUnit;
    private String fromUnitAbbr;
    private String toUnit;
    private String toUnitAbbr;
    private double fromToOffset = 0.0;
    private int generationAge = 0;

    protected Conversion() {
    }

    public static Conversion createInstance(String string, String string2, String string3, String string4, String string5, double d) {
        Conversion conversion = null;
        int n = (string5 = string5.trim()).indexOf("/");
        if (n > 0) {
            int n2 = string5.indexOf(" ");
            String string6 = "0";
            if (n2 > 0) {
                string6 = string5.substring(0, n2);
            }
            String string7 = string5.substring(n2 + 1, n);
            String string8 = string5.substring(n + 1);
            conversion = Conversion.isWholeNumber(string7) && Conversion.isWholeNumber(string8) && Conversion.isWholeNumber(string6) ? new FractionalConversion(string, string2, string3, string4, string5, d) : new DecimalConversion(string, string2, string3, string4, Double.parseDouble(string7) / Double.parseDouble(string8) + Double.parseDouble(string6) + "", d);
        } else {
            conversion = Conversion.isWholeNumber(string5) ? new FractionalConversion(string, string2, string3, string4, string5, d) : new DecimalConversion(string, string2, string3, string4, string5, d);
        }
        return conversion;
    }

    public static Conversion createEmptyInstance(String string, String string2, String string3, String string4) {
        return new DecimalConversion(string, string2, string3, string4, "1", 0.0);
    }

    protected Conversion(String string, String string2, String string3, String string4, String string5, double d) {
        this();
        this.fromUnit = string;
        this.fromUnitAbbr = string2;
        this.toUnit = string3;
        this.toUnitAbbr = string4;
        this.fromToOffset = d;
    }

    protected static boolean isWholeNumber(String string) {
        if (string.length() > 19) {
            return false;
        }
        int n = string.indexOf(".");
        if (n > 0) {
            for (int i = n + 1; i < string.length(); ++i) {
                if ("0".equals(string.subSequence(i, i + 1))) continue;
                return false;
            }
        }
        try {
            if (n < 0) {
                Long.parseLong(string.trim());
            } else {
                Long.parseLong(string.substring(0, n));
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected BigInteger getBigInteger(String string) {
        int n = string.indexOf(".");
        if (n < 0) {
            return new BigInteger(string.trim());
        }
        return new BigInteger(string.substring(0, n));
    }

    public int hashCode() {
        return this.fromUnit.hashCode() + this.toUnit.hashCode();
    }

    public String toString() {
        if (this instanceof FractionalConversion) {
            return this.hashCode() + ": " + this.fromUnit + ";" + this.toUnit + ";" + this.getFromToWholeNumber() + " " + this.getFromToTopFactor() + "/" + this.getFromToBottomFactor() + ";" + this.fromToOffset;
        }
        return this.hashCode() + ": " + this.fromUnit + ";" + this.toUnit + ";" + this.getFromToFactor() + ";" + this.fromToOffset;
    }

    public boolean equals(Object object) {
        if (object instanceof Conversion) {
            Conversion conversion = (Conversion)object;
            if (!this.areEqual(conversion.getFromUnit(), this.fromUnit)) {
                return false;
            }
            return this.areEqual(conversion.getToUnit(), this.toUnit);
        }
        return false;
    }

    private boolean areEqual(Object object, Object object2) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object2 == null) {
            return false;
        }
        return object.equals(object2);
    }

    public abstract double convertValue(double var1, String var3);

    public abstract String convertValue(BigInteger var1, BigInteger var2, String var3);

    protected double getRoundedResult(double d) {
        return d;
    }

    public Double convertValue(String string, String string2, String string3) {
        double d = 0.0;
        if (this.isFraction(string)) {
            d = this.getNumerator(string).doubleValue() * 1.0 / this.getDenominator(string).doubleValue();
            d += this.getWholeNum(string).doubleValue();
        } else {
            d = Double.parseDouble(string);
        }
        if (this.getFromUnit().equals(string2) && this.getToUnit().equals(string3)) {
            return new Double(this.convertValue(d, string2));
        }
        if (this.getFromUnit().equals(string3) && this.getToUnit().equals(string2)) {
            return new Double(this.convertValue(d, string2));
        }
        return null;
    }

    public Double convertValue(double d, String string, String string2) {
        if (this.getFromUnit().equals(string) && this.getToUnit().equals(string2)) {
            return new Double(this.convertValue(d, string));
        }
        if (this.getFromUnit().equals(string2) && this.getToUnit().equals(string)) {
            return new Double(this.convertValue(d, string));
        }
        return null;
    }

    public String convertFraction(String string, String string2, String string3) {
        if (!this.isFraction(string)) {
            return null;
        }
        BigInteger bigInteger = this.getNumerator(string).add(this.getDenominator(string).multiply(this.getWholeNum(string)));
        if (this.getFromUnit().equals(string2) && this.getToUnit().equals(string3)) {
            return this.convertValue(bigInteger, this.getDenominator(string), string2);
        }
        if (this.getFromUnit().equals(string3) && this.getToUnit().equals(string2)) {
            return this.convertValue(bigInteger, this.getDenominator(string), string2);
        }
        return null;
    }

    private BigInteger getNumerator(String string) {
        int n;
        int n2 = string.indexOf(" ");
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = string.indexOf("/")) > 0) {
            return this.getBigInteger(string.substring(n2, n).trim());
        }
        return this.getBigInteger(string);
    }

    private BigInteger getDenominator(String string) {
        int n = string.indexOf("/");
        if (n > 0) {
            if (string.length() == n + 1) {
                return BigInteger.ONE;
            }
            return this.getBigInteger(string.substring(n + 1));
        }
        return BigInteger.ONE;
    }

    private BigInteger getWholeNum(String string) {
        int n = string.indexOf(" ");
        if (n < 0) {
            return BigInteger.ZERO;
        }
        return this.getBigInteger(string.substring(0, n).trim());
    }

    public boolean isFraction(String string) {
        int n = string.indexOf("/");
        if (n > 0) {
            int n2 = string.indexOf(" ");
            if (n2 < 0) {
                n2 = 0;
            }
            String string2 = string.substring(n2, n).trim();
            String string3 = string.substring(n + 1).trim();
            String string4 = string.substring(0, n2).trim();
            if (string4.length() < 1) {
                string4 = "0";
            }
            if (string3.equals("")) {
                string3 = "1";
            }
            return Conversion.isWholeNumber(string2) && Conversion.isWholeNumber(string3) && Conversion.isWholeNumber(string4);
        }
        return Conversion.isWholeNumber(string);
    }

    public String getConversionPartner(String string) {
        if (this.getFromUnit().equals(string)) {
            return this.getToUnit();
        }
        if (this.getToUnit().equals(string)) {
            return this.getFromUnit();
        }
        return null;
    }

    public String getConversionPartnerAbbrev(String string) {
        if (this.getFromUnit().equals(string)) {
            return this.getToUnitAbbr();
        }
        if (this.getToUnit().equals(string)) {
            return this.getFromUnitAbbr();
        }
        return null;
    }

    public abstract String multiply(Conversion var1);

    public abstract String divide(Conversion var1);

    public abstract double getFromToFactor();

    public abstract void setFromToFactor(double var1);

    public double getFromToOffset() {
        return this.fromToOffset;
    }

    public void setFromToOffset(double d) {
        this.fromToOffset = d;
    }

    public String getFromUnit() {
        return this.fromUnit;
    }

    public void setFromUnit(String string) {
        this.fromUnit = string;
    }

    public String getFromUnitAbbr() {
        return this.fromUnitAbbr;
    }

    public void setFromUnitAbbr(String string) {
        this.fromUnitAbbr = string;
    }

    public String getToUnit() {
        return this.toUnit;
    }

    public void setToUnit(String string) {
        this.toUnit = string;
    }

    public String getToUnitAbbr() {
        return this.toUnitAbbr;
    }

    public void setToUnitAbbr(String string) {
        this.toUnitAbbr = string;
    }

    public int getGenerationAge() {
        return this.generationAge;
    }

    public void setGenerationAge(int n) {
        this.generationAge = n;
    }

    public int compareTo(Object object) {
        if (object instanceof Conversion) {
            Conversion conversion = (Conversion)object;
            int n = this.getFromUnit().compareTo(conversion.getFromUnit());
            if (n == 0) {
                return this.getToUnit().compareTo(conversion.getToUnit());
            }
            return n;
        }
        return -1;
    }

    public abstract BigInteger getFromToWholeNumber();

    public abstract void setFromToWholeNumber(BigInteger var1);

    public abstract BigInteger getFromToBottomFactor();

    public abstract void setFromToBottomFactor(BigInteger var1);

    public abstract BigInteger getFromToTopFactor();

    public abstract void setFromToTopFactor(BigInteger var1);

    public abstract void setFromToFactorString(String var1);

    public abstract String getFromToFactorString();
}

