/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.swing;

import com.fx702p.emulator.Console;
import com.fx702p.swing.Fx702pSwingKeyboardAndDisplay;
import com.fx702p.swing.IntelligentMenuItem;
import com.fx702p.swing.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class SwingConsole
extends JFrame
implements Console.Implementation {
    protected JTextPane textPane;
    protected Font textFont;
    protected long lastErrorTimeStamp = 0L;
    protected Fx702pSwingKeyboardAndDisplay positionProvider;
    protected MutableAttributeSet normalAttributes;
    protected MutableAttributeSet errorAttributes;
    protected JPopupMenu popupMenu;
    public static final int MAX_LINES = 1000;
    public static final int EXTRA_LINES = 100;
    public static final int DEFAULT_FONT_SIZE = 10;
    public static final int DEFAULT_COLUMNS = 64;
    public static final int DEFAULT_LINES = 25;
    public static final String NAME = "Fx702p Console";
    public static final String CLEAR_MENU_ITEM = "Clear";
    public static final long TIMESTAMP_DIFFERENCE = 1000L;

    public SwingConsole(Fx702pSwingKeyboardAndDisplay aPositionProvider) {
        super(NAME);
        this.positionProvider = aPositionProvider;
        JScrollPane scrollPane = new JScrollPane(22, 30);
        this.textPane = new JTextPane();
        this.textPane.setEditorKit(new WrapEditorKit());
        this.textPane.setEditable(false);
        scrollPane.setViewportView(this.textPane);
        JPanel panel = new JPanel();
        this.setContentPane(panel);
        panel.add(scrollPane);
        panel.setLayout(new BoxLayout(panel, 1));
        this.buildFontAttributes();
        this.setDimensions(64, 25);
        this.buildPopupMenu();
        PipedInputStream piOut = new PipedInputStream();
        PipedInputStream piErr = new PipedInputStream();
        PipedOutputStream poOut = new PipedOutputStream();
        PipedOutputStream poErr = new PipedOutputStream();
        piOut = new PipedInputStream();
        try {
            poOut = new PipedOutputStream(piOut);
            piErr = new PipedInputStream();
            poErr = new PipedOutputStream(piErr);
            System.setOut(new PrintStream(poOut, true));
            System.setErr(new PrintStream(poErr, true));
        }
        catch (IOException exception) {
            // empty catch block
        }
        new ConsoleReaderThread(piOut, "System.out redirecting", this.normalAttributes).start();
        new ConsoleReaderThread(piErr, "System.err redirecting", this.errorAttributes).start();
        this.pack();
        this.setVisible(false);
        this.setDefaultCloseOperation(1);
    }

    public SwingConsole() {
        super(NAME);
        JScrollPane scrollPane = new JScrollPane(22, 30);
        this.textPane = new JTextPane();
        this.textPane.setEditorKit(new WrapEditorKit());
        this.textPane.setEditable(false);
        scrollPane.setViewportView(this.textPane);
        JPanel panel = new JPanel();
        this.setContentPane(panel);
        panel.add(scrollPane);
        panel.setLayout(new BoxLayout(panel, 1));
        this.buildFontAttributes();
        this.setDimensions(64, 25);
        this.buildPopupMenu();
        PipedInputStream piOut = new PipedInputStream();
        PipedInputStream piErr = new PipedInputStream();
        PipedOutputStream poOut = new PipedOutputStream();
        PipedOutputStream poErr = new PipedOutputStream();
        piOut = new PipedInputStream();
        try {
            poOut = new PipedOutputStream(piOut);
            piErr = new PipedInputStream();
            poErr = new PipedOutputStream(piErr);
            System.setOut(new PrintStream(poOut, true));
            System.setErr(new PrintStream(poErr, true));
        }
        catch (IOException exception) {
            // empty catch block
        }
        new ConsoleReaderThread(piOut, "System.out redirecting", this.normalAttributes).start();
        new ConsoleReaderThread(piErr, "System.err redirecting", this.errorAttributes).start();
        this.pack();
        this.setVisible(false);
        this.setDefaultCloseOperation(1);
    }

    protected void buildPopupMenu() {
        this.popupMenu = SwingUtils.buildPopupMenu(this, this.textPane);
        this.popupMenu.add(this.buildClearMenuItem());
    }

    protected IntelligentMenuItem buildClearMenuItem() {
        IntelligentMenuItem clearMenuItem = new IntelligentMenuItem(CLEAR_MENU_ITEM);
        clearMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent anActionEvent) {
                SwingConsole.this.clear();
            }
        });
        return clearMenuItem;
    }

    protected void buildFontAttributes() {
        this.textFont = new Font("Monospaced", 0, 10);
        this.normalAttributes = new SimpleAttributeSet(this.textPane.getInputAttributes());
        StyleConstants.setFontFamily(this.normalAttributes, this.textFont.getFamily());
        StyleConstants.setFontSize(this.normalAttributes, this.textFont.getSize());
        StyleConstants.setItalic(this.normalAttributes, (this.textFont.getStyle() & 2) != 0);
        StyleConstants.setBold(this.normalAttributes, (this.textFont.getStyle() & 1) != 0);
        StyleConstants.setForeground(this.normalAttributes, Color.BLACK);
        StyledDocument document = this.textPane.getStyledDocument();
        this.errorAttributes = new SimpleAttributeSet(this.normalAttributes);
        StyleConstants.setForeground(this.errorAttributes, Color.RED);
    }

    public void clear() {
        try {
            this.textPane.getDocument().remove(0, this.textPane.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void reportError(String anError) {
        Date date = new Date();
        long timeStamp = date.getTime();
        if (timeStamp - this.lastErrorTimeStamp >= 1000L) {
            System.err.println(date + ": " + anError);
        } else {
            System.err.println(anError);
        }
        this.lastErrorTimeStamp = timeStamp;
    }

    public void setDimensions(int aColumnCount, int aRowCount) {
        StyleContext styleContext = StyleContext.getDefaultStyleContext();
        FontMetrics fontMetrics = styleContext.getFontMetrics(this.textFont);
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < aColumnCount; ++i) {
            buffer.append("w");
        }
        int width = fontMetrics.stringWidth(buffer.toString());
        int height = fontMetrics.getHeight() * aRowCount;
        Dimension preferredSize = new Dimension(width, height);
        this.textPane.setMinimumSize(preferredSize);
        this.textPane.setPreferredSize(preferredSize);
    }

    protected class ReturnFocusListener
    implements WindowFocusListener {
        protected ReturnFocusListener() {
        }

        public void windowLostFocus(WindowEvent aWindowEvent) {
        }

        public void windowGainedFocus(WindowEvent aWindowEvent) {
            if (aWindowEvent.getOppositeWindow() != null) {
                aWindowEvent.getOppositeWindow().toFront();
            }
            SwingConsole.this.removeWindowFocusListener(this);
        }
    }

    public static class WrapColumnFactory
    implements ViewFactory {
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new WrapLabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new NoWrapParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }

    public static class WrapEditorKit
    extends StyledEditorKit {
        ViewFactory defaultFactory = new WrapColumnFactory();
        public static final String LINE_BREAK_ATTRIBUTE_NAME = "line_break_attribute";

        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }

        public MutableAttributeSet getInputAttributes() {
            MutableAttributeSet mAttrs = super.getInputAttributes();
            mAttrs.removeAttribute(LINE_BREAK_ATTRIBUTE_NAME);
            return mAttrs;
        }
    }

    public static class WrapLabelView
    extends LabelView {
        public WrapLabelView(Element elem) {
            super(elem);
        }

        public int getBreakWeight(int axis, float pos, float len) {
            if (axis == 0) {
                this.checkPainter();
                int p0 = this.getStartOffset();
                int p1 = this.getGlyphPainter().getBoundedPosition(this, p0, pos, len);
                if (p1 == p0) {
                    return 0;
                }
                try {
                    if (this.getDocument().getText(p0, p1 - p0).indexOf("\r") >= 0) {
                        return 3000;
                    }
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
            return super.getBreakWeight(axis, pos, len);
        }

        public View breakView(int axis, int p0, float pos, float len) {
            if (axis == 0) {
                this.checkPainter();
                int p1 = this.getGlyphPainter().getBoundedPosition(this, p0, pos, len);
                try {
                    int index = this.getDocument().getText(p0, p1 - p0).indexOf("\r");
                    if (index >= 0) {
                        GlyphView v = (GlyphView)this.createFragment(p0, p0 + index + 1);
                        return v;
                    }
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
            return super.breakView(axis, p0, pos, len);
        }
    }

    public static class NoWrapParagraphView
    extends ParagraphView {
        public NoWrapParagraphView(Element elem) {
            super(elem);
        }

        public void layout(int width, int height) {
            super.layout(Short.MAX_VALUE, height);
        }

        public float getMinimumSpan(int axis) {
            return super.getPreferredSpan(axis);
        }
    }

    protected class ConsoleReaderThread
    extends Thread {
        protected int lineCount;
        protected PipedInputStream inputStream;
        protected AttributeSet attributeSet;

        ConsoleReaderThread(PipedInputStream anInputStream, String aName, AttributeSet anAttributeSet) {
            super(aName);
            this.lineCount = 0;
            this.inputStream = anInputStream;
            this.attributeSet = anAttributeSet;
        }

        public void run() {
            byte[] buffer = new byte[1024];
            try {
                while (true) {
                    int length;
                    if ((length = this.inputStream.read(buffer)) <= 0) {
                        continue;
                    }
                    SwingUtilities.invokeLater(new ConsoleWriter(buffer, length));
                }
            }
            catch (IOException iOException) {
                return;
            }
        }

        protected class ConsoleWriter
        implements Runnable {
            protected byte[] buffer;

            public ConsoleWriter(byte[] aBuffer, int aLength) {
                this.buffer = new byte[aLength];
                System.arraycopy(aBuffer, 0, this.buffer, 0, aLength);
            }

            public void run() {
                try {
                    SwingConsole.this.textPane.getDocument().insertString(SwingConsole.this.textPane.getDocument().getLength(), new String(this.buffer, 0, this.buffer.length), ConsoleReaderThread.this.attributeSet);
                    SwingConsole.this.textPane.setCaretPosition(SwingConsole.this.textPane.getDocument().getLength());
                    for (byte b : this.buffer) {
                        if (b != 10) continue;
                        ++ConsoleReaderThread.this.lineCount;
                    }
                    if (ConsoleReaderThread.this.lineCount > 1000) {
                        String text = SwingConsole.this.textPane.getText();
                        int lines = 0;
                        int position = 0;
                        while (lines < 100) {
                            if (text.charAt(position) == '\n') {
                                ++lines;
                            }
                            ++position;
                        }
                        SwingConsole.this.textPane.getDocument().remove(0, position);
                        ConsoleReaderThread.this.lineCount -= lines;
                    }
                    if (!SwingConsole.this.isVisible()) {
                        if (SwingConsole.this.positionProvider != null) {
                            SwingConsole.this.positionProvider.setConsolePosition(SwingConsole.this);
                        }
                        SwingConsole.this.addWindowFocusListener(new ReturnFocusListener());
                        SwingConsole.this.setVisible(true);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

