/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.swing;

import com.fx702p.emulator.Console;
import com.fx702p.emulator.Fx702pKey;
import com.fx702p.emulator.Fx702pKeyboardLayout;
import com.fx702p.swing.CursorManager;
import com.fx702p.swing.Fx702pLinePanel;
import com.fx702p.swing.Fx702pProgramStepsPanel;
import com.fx702p.swing.Fx702pSwingKeyboardAndDisplay;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Fx702pPanel
extends JLayeredPane {
    protected Fx702pSwingKeyboardAndDisplay swingKeyboardAndDisplay;
    protected BufferedImage fx702pImage;
    protected BufferedImage fx702pIcon;
    protected BufferedImage stopImage;
    protected BufferedImage runImage;
    protected BufferedImage wrtImage;
    protected BufferedImage traceImage;
    protected BufferedImage prtImage;
    protected BufferedImage degImage;
    protected BufferedImage radImage;
    protected BufferedImage grdImage;
    protected BufferedImage f1Image;
    protected BufferedImage f2Image;
    protected BufferedImage arcImage;
    protected BufferedImage hypImage;
    protected Dimension dimension;
    protected int cursorPosition = 0;
    protected int lastCursorPosition = 0;
    protected boolean lastCursorVisible = false;
    protected Fx702pImagePanel imagePanel;
    protected Fx702pLinePanel linePanel;
    protected Fx702pProgramStepsPanel programStepsPanel;
    protected char[] inputBuffer = new char[62];
    protected int inputBufferLength;
    protected int inputBufferWindowStart = 0;
    protected boolean degMode = true;
    protected boolean radMode = false;
    protected boolean grdMode = false;
    protected boolean stopMode = false;
    protected boolean runMode = true;
    protected boolean traceMode = false;
    protected boolean prtMode = false;
    protected boolean f1Prefix = false;
    protected boolean f2Prefix = false;
    protected boolean arcPrefix = false;
    protected boolean hypPrefix = false;
    protected boolean modePrefix = false;
    protected Point keyPressedPosition = null;
    protected CursorManager cursorManager;
    protected char characterUnderCursor = (char)32;
    protected JComponent[][] tooltipComponents;
    protected JComponent[][] f1TooltipComponents;
    public static final int INPUT_BUFFER_SIZE = 62;
    public static final Rectangle DEFAULT_LINE_RECTANGLE = new Rectangle(75, 47, 2, 2);
    public static final int DEFAULT_BOX_SPACE = 1;
    public static final int DEFAULT_CHARACTER_SPACE = 5;
    public static final Rectangle DEFAULT_STEPS_RECTANGLE = new Rectangle(484, 40, 55, 20);
    public static final String LINE_X_PROPERTY_NAME = "com.fx702p.swing.line.x";
    public static final String LINE_Y_PROPERTY_NAME = "com.fx702p.swing.line.y";
    public static final String LINE_WIDTH_PROPERTY_NAME = "com.fx702p.swing.line.width";
    public static final String LINE_HEIGHT_PROPERTY_NAME = "com.fx702p.swing.line.height";
    public static final String BOX_SPACE_PROPERTY_NAME = "com.fx702p.swing.line.box_space";
    public static final String CHARACTER_SPACE_PROPERTY_NAME = "com.fx702p.swing.line.character_space";
    public static final String STEPS_X_PROPERTY_NAME = "com.fx702p.swing.steps.x";
    public static final String STEPS_Y_PROPERTY_NAME = "com.fx702p.swing.steps.y";
    public static final String STEPS_WIDTH_PROPERTY_NAME = "com.fx702p.swing.steps.width";
    public static final String STEPS_HEIGHT_PROPERTY_NAME = "com.fx702p.swing.steps.height";
    public static final String FX702P_IMAGE = "/pictures/fx702p.jpg";
    public static final String FX702P_ICON = "/pictures/icon.jpg";
    public static final int STATUS_Y = 34;
    public static final String RUN_IMAGE = "/pictures/run.jpg";
    public static final Point RUN_POSITION = new Point(208, 34);
    public static final String WRT_IMAGE = "/pictures/wrt.jpg";
    public static final Point WRT_POSITION = new Point(232, 34);
    public static final String STOP_IMAGE = "/pictures/stop.jpg";
    public static final Point STOP_POSITION = new Point(258, 34);
    public static final String DEG_IMAGE = "/pictures/deg.jpg";
    public static final Point DEG_POSITION = new Point(311, 34);
    public static final String RAD_IMAGE = "/pictures/rad.jpg";
    public static final Point RAD_POSITION = new Point(339, 34);
    public static final String GRD_IMAGE = "/pictures/grd.jpg";
    public static final Point GRD_POSITION = new Point(360, 34);
    public static final String TRACE_IMAGE = "/pictures/trace.jpg";
    public static final Point TRACE_POSITION = new Point(396, 34);
    public static final String PRT_IMAGE = "/pictures/prt.jpg";
    public static final Point PRT_POSITION = new Point(438, 34);
    public static final String F1_IMAGE = "/pictures/f1.jpg";
    public static final Point F1_POSITION = new Point(94, 34);
    public static final String F2_IMAGE = "/pictures/f2.jpg";
    public static final Point F2_POSITION = new Point(110, 34);
    public static final String ARC_IMAGE = "/pictures/arc.jpg";
    public static final Point ARC_POSITION = new Point(133, 34);
    public static final String HYP_IMAGE = "/pictures/hyp.jpg";
    public static final Point HYP_POSITION = new Point(162, 34);
    public static final int FIRST_KEY_Y = 130;
    public static final int KEY_HEIGHT = 25;
    public static final int F1_LABEL_HEIGHT = 12;
    public static final int HEIGHT_BETWEEN_KEYS = 20;
    public static final int FIRST_KEY_X = 18;
    public static final int KEY_WIDTH = 38;
    public static final int WIDTH_BETWEEN_KEYS = 16;
    public static final KeyTooltip[] KEY_TOOLTIPS = new KeyTooltip[]{new KeyTooltip(0, 0, 112, 0, new KeyTooltip(89, 2)), new KeyTooltip(1, 0, 113, 0, new KeyTooltip(90, 2)), new KeyTooltip(7, 0, 79, 2), new KeyTooltip(9, 4, 69, 2), new KeyTooltip(10, 0, "^", 0), new KeyTooltip(11, 0, 8, 0, new KeyTooltip(72, 2)), new KeyTooltip(11, 1, 84, 2), new KeyTooltip(11, 2, 65, 2), new KeyTooltip(11, 4, 10, 0), new KeyTooltip(12, 0, 67, 2), new KeyTooltip(12, 1, 83, 2), new KeyTooltip(12, 2, 81, 2), new KeyTooltip(12, 3, 37, 0, new KeyTooltip(66, 2)), new KeyTooltip(12, 4, 39, 0, new KeyTooltip(70, 2))};
    public static final KeyTooltip[] F1_LABEL_TOOLTIPS = new KeyTooltip[]{new KeyTooltip(10, 0, "{", 0, new KeyTooltip(76, 2)), new KeyTooltip(10, 1, "}", 0, new KeyTooltip(71, 2)), new KeyTooltip(10, 2, "~", 0, new KeyTooltip(68, 2)), new KeyTooltip(9, 4, 80, 2)};

    public Fx702pPanel(Fx702pSwingKeyboardAndDisplay aSwingKeyboardAndDisplay) throws IOException {
        this.swingKeyboardAndDisplay = aSwingKeyboardAndDisplay;
        this.buildImages();
        this.dimension = new Dimension(this.fx702pImage.getWidth(), this.fx702pImage.getHeight());
        this.imagePanel = new Fx702pImagePanel();
        this.imagePanel.setBounds(0, 0, this.dimension.width, this.dimension.height);
        this.add((Component)this.imagePanel, JLayeredPane.DEFAULT_LAYER);
        int lineX = this.getIntegerProperty(LINE_X_PROPERTY_NAME, Fx702pPanel.DEFAULT_LINE_RECTANGLE.x);
        int lineY = this.getIntegerProperty(LINE_Y_PROPERTY_NAME, Fx702pPanel.DEFAULT_LINE_RECTANGLE.y);
        int lineWidth = this.getIntegerProperty(LINE_WIDTH_PROPERTY_NAME, Fx702pPanel.DEFAULT_LINE_RECTANGLE.width);
        int lineHeight = this.getIntegerProperty(LINE_HEIGHT_PROPERTY_NAME, Fx702pPanel.DEFAULT_LINE_RECTANGLE.height);
        int boxSpace = this.getIntegerProperty(BOX_SPACE_PROPERTY_NAME, 1);
        int characterSpace = this.getIntegerProperty(CHARACTER_SPACE_PROPERTY_NAME, 5);
        this.linePanel = new Fx702pLinePanel(lineWidth, lineHeight, boxSpace, characterSpace);
        this.linePanel.setOpaque(false);
        this.linePanel.setBounds(lineX, lineY, this.linePanel.getPreferredSize().width, this.linePanel.getPreferredSize().height);
        this.add(this.linePanel, JLayeredPane.PALETTE_LAYER, 0);
        int stepsX = this.getIntegerProperty(STEPS_X_PROPERTY_NAME, Fx702pPanel.DEFAULT_STEPS_RECTANGLE.x);
        int stepsY = this.getIntegerProperty(STEPS_Y_PROPERTY_NAME, Fx702pPanel.DEFAULT_STEPS_RECTANGLE.y);
        int stepsWidth = this.getIntegerProperty(STEPS_WIDTH_PROPERTY_NAME, Fx702pPanel.DEFAULT_STEPS_RECTANGLE.width);
        int stepsHeight = this.getIntegerProperty(STEPS_HEIGHT_PROPERTY_NAME, Fx702pPanel.DEFAULT_STEPS_RECTANGLE.height);
        this.programStepsPanel = new Fx702pProgramStepsPanel(new Rectangle(stepsX, stepsY, stepsWidth, stepsHeight));
        this.add(this.programStepsPanel, JLayeredPane.PALETTE_LAYER, 1);
        this.cursorManager = new CursorManager(this);
        this.clearDisplay();
    }

    public boolean isEmpty() {
        return this.linePanel.isEmpty();
    }

    public Image getIcon() {
        return this.fx702pIcon;
    }

    public void setSteps(int aSteps) {
        this.programStepsPanel.setSteps(aSteps);
    }

    public void showBusy(boolean aShowBusy) {
        this.programStepsPanel.showBusy(aShowBusy);
    }

    public void showSteps(boolean aShowSteps) {
        this.programStepsPanel.showSteps(aShowSteps);
    }

    public void keyPressed(Fx702pKey aKey, Point aKeyPosition) {
        if (aKey != Fx702pKey.MODE && aKey != Fx702pKey.F1 && aKey != Fx702pKey.F2) {
            this.keyPressedPosition = aKeyPosition;
            this.repaint();
        }
    }

    public void keyReleased(Fx702pKey aKey, Point aKeyPosition) {
        if (this.keyPressedPosition != null) {
            this.keyPressedPosition = null;
            this.repaint();
        }
    }

    protected void buildImages() throws IOException {
        this.fx702pImage = ImageIO.read(this.getClass().getResource(FX702P_IMAGE));
        this.fx702pIcon = ImageIO.read(this.getClass().getResource(FX702P_ICON));
        this.runImage = ImageIO.read(this.getClass().getResource(RUN_IMAGE));
        this.wrtImage = ImageIO.read(this.getClass().getResource(WRT_IMAGE));
        this.traceImage = ImageIO.read(this.getClass().getResource(TRACE_IMAGE));
        this.stopImage = ImageIO.read(this.getClass().getResource(STOP_IMAGE));
        this.degImage = ImageIO.read(this.getClass().getResource(DEG_IMAGE));
        this.radImage = ImageIO.read(this.getClass().getResource(RAD_IMAGE));
        this.grdImage = ImageIO.read(this.getClass().getResource(GRD_IMAGE));
        this.prtImage = ImageIO.read(this.getClass().getResource(PRT_IMAGE));
        this.f1Image = ImageIO.read(this.getClass().getResource(F1_IMAGE));
        this.f2Image = ImageIO.read(this.getClass().getResource(F2_IMAGE));
        this.arcImage = ImageIO.read(this.getClass().getResource(ARC_IMAGE));
        this.hypImage = ImageIO.read(this.getClass().getResource(HYP_IMAGE));
    }

    protected void clearDisplay() {
        this.setCursorPosition(0);
        this.linePanel.clear();
    }

    protected int getIntegerProperty(String aPropertyName, int aDefaultValue) {
        String value = System.getProperty(aPropertyName);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                Console.reportError("Bad format for integer " + aPropertyName + ": " + value);
            }
        }
        return aDefaultValue;
    }

    public Point getKeyCoordinates(int x, int y) {
        int keyY;
        int keyX;
        if (x >= 18 && y >= 130 && (keyX = (x - 18) / 54) < Fx702pKeyboardLayout.LAYOUT_WIDTH && (x - 18) % 54 <= 38 && (keyY = (y - 130) / 45) < Fx702pKeyboardLayout.LAYOUT_HEIGHT && (y - 130) % 45 <= 25) {
            return new Point(keyX, keyY);
        }
        return null;
    }

    public void print(char[] theCharacters) {
        this.cursorManager.suspendBlinking();
        this.linePanel.print(theCharacters);
        this.saveCharacterUnderCursor();
        this.cursorManager.restartBlinking();
    }

    public void setCursorVisible(boolean aCursorVisibleFlag) {
        this.cursorManager.setCursorVisible(aCursorVisibleFlag);
        if (!aCursorVisibleFlag) {
            this.showCursor(false);
        }
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int aCursorPosition) {
        if (aCursorPosition != this.cursorPosition) {
            this.cursorManager.suspendBlinking();
            this.restoreCharacterUnderCursor();
            this.cursorPosition = aCursorPosition;
            this.saveCharacterUnderCursor();
            this.cursorManager.restartBlinking();
        }
    }

    public void moveCursorRight() {
        if (this.cursorPosition < 19 && this.cursorPosition < this.linePanel.getPrintedSize()) {
            this.cursorManager.suspendBlinking();
            this.restoreCharacterUnderCursor();
            ++this.cursorPosition;
            this.saveCharacterUnderCursor();
            this.cursorManager.restartBlinking();
        }
    }

    public void moveCursorRight(int aCount) {
        int newCursorPosition;
        if (aCount > 0 && (newCursorPosition = Math.min(this.cursorPosition + aCount, Math.min(19, this.linePanel.getPrintedSize()))) != this.cursorPosition) {
            this.cursorManager.suspendBlinking();
            this.restoreCharacterUnderCursor();
            this.cursorPosition = newCursorPosition;
            this.saveCharacterUnderCursor();
            this.cursorManager.restartBlinking();
        }
    }

    public void moveCursorLeft() {
        if (this.cursorPosition > 0) {
            this.cursorManager.suspendBlinking();
            this.restoreCharacterUnderCursor();
            --this.cursorPosition;
            this.saveCharacterUnderCursor();
            this.cursorManager.restartBlinking();
        }
    }

    public void moveCursorLeft(int aCount) {
        int newCursorPosition;
        if (aCount > 0 && (newCursorPosition = Math.max(this.cursorPosition - aCount, 0)) != this.cursorPosition) {
            this.cursorManager.suspendBlinking();
            this.restoreCharacterUnderCursor();
            this.cursorPosition = Math.max(this.cursorPosition - aCount, 0);
            this.saveCharacterUnderCursor();
            this.cursorManager.restartBlinking();
        }
    }

    protected void restoreCharacterUnderCursor() {
        if (this.cursorPosition < 20 && this.linePanel.getCharAt(this.cursorPosition) == '_') {
            this.linePanel.setCharAt(this.cursorPosition, this.characterUnderCursor);
        }
    }

    protected void saveCharacterUnderCursor() {
        if (this.cursorPosition < 20) {
            this.characterUnderCursor = this.linePanel.getCharAt(this.cursorPosition);
        }
    }

    public void showCursor(boolean aCursorVisibleFlag) {
        if (this.cursorPosition < 20 && (aCursorVisibleFlag != this.lastCursorVisible || this.cursorPosition != this.lastCursorPosition)) {
            this.lastCursorVisible = aCursorVisibleFlag;
            this.lastCursorPosition = this.cursorPosition;
            if (aCursorVisibleFlag) {
                this.linePanel.setCursorAt(this.cursorPosition, '_');
            } else {
                this.linePanel.setCursorAt(this.cursorPosition, this.characterUnderCursor);
            }
        }
    }

    public void showPrefixes(boolean aF1Prefix, boolean aF2Prefix, boolean anArcPrefix, boolean anHypPrefix, boolean aModePrefix) {
        this.f1Prefix = aF1Prefix;
        this.f2Prefix = aF2Prefix;
        this.arcPrefix = anArcPrefix;
        this.hypPrefix = anHypPrefix;
        this.modePrefix = aModePrefix;
        this.repaint();
    }

    public void showDeg(boolean aFlag) {
        this.degMode = aFlag;
        if (this.degMode) {
            this.grdMode = false;
            this.radMode = false;
        }
        this.repaint();
    }

    public void showRad(boolean aFlag) {
        this.radMode = aFlag;
        if (this.radMode) {
            this.grdMode = false;
            this.degMode = false;
        }
        this.repaint();
    }

    public void showGrd(boolean aFlag) {
        this.grdMode = aFlag;
        if (this.grdMode) {
            this.radMode = false;
            this.degMode = false;
        }
        this.repaint();
    }

    public void showTrace(boolean aFlag) {
        this.traceMode = aFlag;
        this.repaint();
    }

    public void showPrt(boolean aFlag) {
        this.prtMode = aFlag;
        this.repaint();
    }

    public void showRun(boolean aFlag) {
        this.runMode = aFlag;
        this.repaint();
    }

    public void showStop(boolean aStopMode) {
        this.stopMode = aStopMode;
        this.repaint();
    }

    public void paintImage(Graphics aGraphics) {
        aGraphics.drawImage(this.fx702pImage, 0, 0, null);
        if (this.runMode) {
            aGraphics.drawImage(this.runImage, Fx702pPanel.RUN_POSITION.x, Fx702pPanel.RUN_POSITION.y, null);
        } else {
            aGraphics.drawImage(this.wrtImage, Fx702pPanel.RUN_POSITION.x, Fx702pPanel.RUN_POSITION.y, null);
        }
        if (this.stopMode) {
            aGraphics.drawImage(this.stopImage, Fx702pPanel.STOP_POSITION.x, Fx702pPanel.STOP_POSITION.y, null);
        }
        if (this.traceMode) {
            aGraphics.drawImage(this.traceImage, Fx702pPanel.TRACE_POSITION.x, Fx702pPanel.TRACE_POSITION.y, null);
        }
        if (this.degMode) {
            aGraphics.drawImage(this.degImage, Fx702pPanel.DEG_POSITION.x, Fx702pPanel.DEG_POSITION.y, null);
        }
        if (this.radMode) {
            aGraphics.drawImage(this.radImage, Fx702pPanel.RAD_POSITION.x, Fx702pPanel.RAD_POSITION.y, null);
        }
        if (this.grdMode) {
            aGraphics.drawImage(this.grdImage, Fx702pPanel.GRD_POSITION.x, Fx702pPanel.GRD_POSITION.y, null);
        }
        if (this.prtMode) {
            aGraphics.drawImage(this.prtImage, Fx702pPanel.PRT_POSITION.x, Fx702pPanel.PRT_POSITION.y, null);
        }
        if (this.f1Prefix) {
            aGraphics.drawImage(this.f1Image, Fx702pPanel.F1_POSITION.x, Fx702pPanel.F1_POSITION.y, null);
            this.invertKey(aGraphics, Fx702pKeyboardLayout.F1_KEY_POSITION.x, Fx702pKeyboardLayout.F1_KEY_POSITION.y);
        }
        if (this.f2Prefix) {
            aGraphics.drawImage(this.f2Image, Fx702pPanel.F2_POSITION.x, Fx702pPanel.F2_POSITION.y, null);
            this.invertKey(aGraphics, Fx702pKeyboardLayout.F2_KEY_POSITION.x, Fx702pKeyboardLayout.F2_KEY_POSITION.y);
        }
        if (this.arcPrefix) {
            aGraphics.drawImage(this.arcImage, Fx702pPanel.ARC_POSITION.x, Fx702pPanel.ARC_POSITION.y, null);
        }
        if (this.hypPrefix) {
            aGraphics.drawImage(this.hypImage, Fx702pPanel.HYP_POSITION.x, Fx702pPanel.HYP_POSITION.y, null);
        }
        if (this.modePrefix) {
            this.invertKey(aGraphics, Fx702pKeyboardLayout.MODE_KEY_POSITION.x, Fx702pKeyboardLayout.MODE_KEY_POSITION.y);
        }
        if (this.keyPressedPosition != null) {
            this.invertKey(aGraphics, this.keyPressedPosition.x, this.keyPressedPosition.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invertKey(Graphics aGraphics, int x, int y) {
        Graphics graphics = aGraphics.create();
        try {
            Rectangle rectangle = new Rectangle(18 + x * 54, 130 + y * 45, 38, 25);
            graphics.setColor(Color.WHITE);
            graphics.setXORMode(Color.BLACK);
            graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.width / 5, rectangle.height / 5);
        }
        finally {
            graphics.dispose();
        }
    }

    public Dimension getPreferredSize() {
        return this.dimension;
    }

    public Dimension getMinimumSize() {
        return this.dimension;
    }

    public Dimension getMaximumSize() {
        return this.dimension;
    }

    public static class KeyTooltip {
        public final int x;
        public final int y;
        public final KeyTooltip nextKeyKeyTooltip;
        private final String tooltipText;

        public KeyTooltip(int aKeycode, int aModifiers) {
            this(aKeycode, aModifiers, null);
        }

        public KeyTooltip(int aKeycode, int aModifiers, KeyTooltip aNextKeyTooltip) {
            this(-1, -1, aKeycode, aModifiers, aNextKeyTooltip);
        }

        public KeyTooltip(int anX, int anY, int aKeycode, int aModifiers) {
            this(anX, anY, aKeycode, aModifiers, null);
        }

        public KeyTooltip(int anX, int anY, int aKeycode, int aModifiers, KeyTooltip aNextKeyTooltip) {
            this(anX, anY, KeyEvent.getKeyText(aKeycode), KeyEvent.getKeyModifiersText(aModifiers), aNextKeyTooltip);
        }

        public KeyTooltip(int anX, int anY, String aKeyText, int aModifiers) {
            this(anX, anY, aKeyText, KeyEvent.getKeyModifiersText(aModifiers), null);
        }

        public KeyTooltip(int anX, int anY, String aKeyText, int aModifiers, KeyTooltip aNextKeyTooltip) {
            this(anX, anY, aKeyText, KeyEvent.getKeyModifiersText(aModifiers), aNextKeyTooltip);
        }

        public KeyTooltip(int anX, int anY, String aKeyText, String aModifiersText, KeyTooltip aNextKeyTooltip) {
            this.x = anX;
            this.y = anY;
            this.tooltipText = aModifiersText == null || aModifiersText.length() == 0 ? aKeyText : aModifiersText + '+' + aKeyText;
            this.nextKeyKeyTooltip = aNextKeyTooltip;
        }

        public String getTooltipText() {
            if (this.nextKeyKeyTooltip == null) {
                return this.tooltipText;
            }
            return this.tooltipText + " or " + this.nextKeyKeyTooltip.getTooltipText();
        }
    }

    protected class Fx702pImagePanel
    extends JPanel {
        public Fx702pImagePanel() {
            this.setFocusable(true);
            Fx702pPanel.this.swingKeyboardAndDisplay.getMainFrame().addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent aWindowEvent) {
                    Fx702pImagePanel.this.requestFocusInWindow();
                }
            });
            this.setLayout(null);
            this.buildTooltipComponents();
            this.setTooltips();
            this.enableEvents(8L);
        }

        protected void buildTooltipComponents() {
            Fx702pPanel.this.tooltipComponents = new JComponent[Fx702pKeyboardLayout.LAYOUT_WIDTH][];
            Fx702pPanel.this.f1TooltipComponents = new JComponent[Fx702pKeyboardLayout.LAYOUT_WIDTH][];
            for (int x = 0; x < Fx702pKeyboardLayout.LAYOUT_WIDTH; ++x) {
                Fx702pPanel.this.tooltipComponents[x] = new JComponent[Fx702pKeyboardLayout.LAYOUT_HEIGHT];
                Fx702pPanel.this.f1TooltipComponents[x] = new JComponent[Fx702pKeyboardLayout.LAYOUT_HEIGHT];
                for (int y = 0; y < Fx702pKeyboardLayout.LAYOUT_HEIGHT; ++y) {
                    Fx702pPanel.this.tooltipComponents[x][y] = new JComponent(){

                        protected void processEvent(AWTEvent anEvent) {
                            int id;
                            super.processEvent(anEvent);
                            if (anEvent instanceof MouseEvent && ((id = ((MouseEvent)anEvent).getID()) == 501 || id == 502)) {
                                Fx702pPanel.this.processEvent(SwingUtilities.convertMouseEvent(this, (MouseEvent)anEvent, Fx702pPanel.this));
                            }
                        }
                    };
                    this.add(Fx702pPanel.this.tooltipComponents[x][y]);
                    Fx702pPanel.this.tooltipComponents[x][y].setBounds(18 + x * 54, 130 + y * 45, 38, 25);
                    Fx702pPanel.this.f1TooltipComponents[x][y] = new JComponent(){};
                    this.add(Fx702pPanel.this.f1TooltipComponents[x][y]);
                    Fx702pPanel.this.f1TooltipComponents[x][y].setBounds(18 + x * 54, 130 + y * 45 - 12 - 1, 38, 12);
                }
            }
        }

        protected void setTooltips() {
            int i;
            for (i = 0; i < KEY_TOOLTIPS.length; ++i) {
                KeyTooltip keyTooltip = KEY_TOOLTIPS[i];
                Fx702pPanel.this.tooltipComponents[keyTooltip.x][keyTooltip.y].setToolTipText(keyTooltip.getTooltipText());
            }
            for (i = 0; i < F1_LABEL_TOOLTIPS.length; ++i) {
                KeyTooltip f1LabelTooltip = F1_LABEL_TOOLTIPS[i];
                Fx702pPanel.this.f1TooltipComponents[f1LabelTooltip.x][f1LabelTooltip.y].setToolTipText(f1LabelTooltip.getTooltipText());
            }
        }

        protected void processEvent(AWTEvent anEvent) {
            KeyEvent keyEvent;
            super.processEvent(anEvent);
            if (anEvent instanceof KeyEvent && !(keyEvent = (KeyEvent)anEvent).isConsumed() && (keyEvent.getID() == 401 || keyEvent.getID() == 402)) {
                Fx702pPanel.this.swingKeyboardAndDisplay.processKey(keyEvent);
            }
        }

        public void paint(Graphics aGraphics) {
            Fx702pPanel.this.paintImage(aGraphics);
        }
    }
}

