/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.interpreters;

import com.fx702p.interpreters.NormalFormatter;
import com.fx702p.interpreters.formatters.Fx702pDecimalFormat;
import java.math.BigDecimal;

public class PrintFormatter
extends NormalFormatter {
    protected String format;
    protected Fx702pDecimalFormat decimalFormat;
    protected boolean scientificFormat;
    protected double maxNumber;

    public PrintFormatter(String aFormat) {
        this.format = aFormat;
        if (this.format.endsWith("^")) {
            StringBuilder builder = new StringBuilder();
            builder.append("0");
            int index = this.format.indexOf(46);
            if (index > 0) {
                builder.append('.');
                int last = this.format.length() - index - 2;
                for (int i = 0; i < last; ++i) {
                    builder.append('0');
                }
            }
            builder.append("E00");
            this.decimalFormat = new Fx702pDecimalFormat(builder.toString());
            this.scientificFormat = true;
        } else {
            this.decimalFormat = new Fx702pDecimalFormat(this.format.replace('#', '0'));
            int index = this.format.indexOf(46);
            this.maxNumber = Math.pow(10.0, index > 0 ? (double)index : (double)this.format.length());
            this.scientificFormat = false;
        }
    }

    public String format(BigDecimal aNumber) {
        Fx702pDecimalFormat decimalFormat = this.getDecimalFormat(aNumber);
        if (this.scientificFormat) {
            return decimalFormat.format(aNumber);
        }
        if (aNumber.doubleValue() >= this.maxNumber) {
            return this.format;
        }
        char[] result = decimalFormat.format(aNumber).toCharArray();
        for (int i = 0; i < result.length - 1 && result[i] == '0' && result[i + 1] != '.'; ++i) {
            result[i] = 32;
        }
        return new String(result);
    }

    protected Fx702pDecimalFormat getDecimalFormat(BigDecimal aNumber) {
        this.prepareDecimalFormat(this.decimalFormat);
        return this.decimalFormat;
    }
}

