/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.emulator.implementation;

import com.fx702p.emulator.Fx702pDisplay;
import com.fx702p.emulator.Fx702pEmulator;
import com.fx702p.emulator.Fx702pKey;
import com.fx702p.emulator.commands.Command;
import com.fx702p.emulator.commands.FastScrollCommand;
import com.fx702p.emulator.commands.NormalScrollCommand;
import com.fx702p.emulator.commands.StringCommand;
import com.fx702p.emulator.implementation.Fx702pAbstractEmulatorComponent;
import com.fx702p.interpreters.Fx702pException;

public class Fx702pKeyboard
extends Fx702pAbstractEmulatorComponent {
    protected KeyboardBehavior behavior;
    protected Fx702pEmulator emulator;
    protected boolean clearPotentialKeyAfterRead;
    protected char potentialKey;
    protected long potentialKeyTime = 0L;
    public static final long NO_POTENTIAL_KEY = 0L;
    public static final long POTENTIAL_KEY_DELAY = 40L;
    public static final long KEY_EXTRA_SLEEP_TIME = 30L;
    protected final KeyboardBehavior NO_PREFIX_BEHAVIOR = new NoPrefixBehavior();
    protected final KeyboardBehavior F1_PREFIX_BEHAVIOR = new F1PrefixBehavior();
    protected final KeyboardBehavior F2_PREFIX_BEHAVIOR = new F2PrefixBehavior();
    protected final KeyboardBehavior MODE_PREFIX_BEHAVIOR = new ModePrefixBehavior();
    protected final KeyboardBehavior ARC_PREFIX_BEHAVIOR = new ArcPrefixBehavior();
    protected final KeyboardBehavior HYP_PREFIX_BEHAVIOR = new HypPrefixBehavior();
    protected final KeyboardBehavior ARC_HYP_PREFIX_BEHAVIOR = new ArcHypPrefixBehavior();
    protected final KeyboardBehavior PROGRAM_RUNNNING_BEHAVIOR = new ProgramRunningBehavior();
    protected final KeyboardBehavior ERROR_BEHAVIOR = new ErrorBehavior();

    public Fx702pKeyboard(Fx702pEmulator anEmulator) {
        this.emulator = anEmulator;
        this.behavior = this.NO_PREFIX_BEHAVIOR;
    }

    public void allClear() {
        this.behavior.allClear();
    }

    public void setRunMode() {
        this.setBehavior(this.NO_PREFIX_BEHAVIOR);
    }

    public void endScroll() {
        this.behavior.endScroll();
    }

    public void startScroll() {
        this.behavior.startScroll();
    }

    public void stop() {
        this.behavior.stop();
    }

    public void cont() {
        this.behavior.cont();
    }

    public void endProgram() {
        this.setRunMode();
    }

    public void input(String anInputPrompt) {
        this.setBehavior(this.NO_PREFIX_BEHAVIOR);
    }

    public void runProgram() {
        this.potentialKeyTime = 0L;
        this.setBehavior(this.PROGRAM_RUNNNING_BEHAVIOR);
    }

    public void waitAfterPrint(int aPrintWait, Command aCommand) {
    }

    public void endWaitAfterPrint() {
    }

    public void setWrtMode() {
        this.setBehavior(this.NO_PREFIX_BEHAVIOR);
    }

    protected void setPotentialKey(char aKey) {
        this.potentialKey = aKey;
        this.clearPotentialKeyAfterRead = false;
        this.potentialKeyTime = System.currentTimeMillis();
    }

    protected void endPotentialKey(char aKey) {
        this.potentialKey = aKey;
        this.clearPotentialKeyAfterRead = true;
        this.potentialKeyTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Character getKey() {
        try {
            if (this.potentialKeyTime != 0L) {
                if (this.clearPotentialKeyAfterRead) {
                    long delay = System.currentTimeMillis() - this.potentialKeyTime;
                    this.potentialKeyTime = 0L;
                    this.clearPotentialKeyAfterRead = false;
                    if (delay >= 40L) {
                        Character c = null;
                        return c;
                    }
                }
                Character c = Character.valueOf(this.potentialKey);
                return c;
            }
            this.potentialKeyTime = 0L;
            Character c = null;
            return c;
        }
        finally {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException exception) {}
        }
    }

    public void setBehavior(KeyboardBehavior aBehavior) {
        this.behavior = aBehavior;
        this.behavior.displayPrefixes(this.emulator.getDisplay());
    }

    public void clearPrefixes() {
        this.behavior.clearPrefixes();
    }

    public void keyPressed(Fx702pKey aKey) {
        this.behavior.keyPressed(aKey);
    }

    public void keyRepeated(Fx702pKey aKey) {
        this.behavior.keyRepeated(aKey);
    }

    public void keyReleased(Fx702pKey aKey) {
        this.behavior.keyReleased(aKey);
    }

    public void addCommand(Command aCommand) {
        this.emulator.addCommand(aCommand);
    }

    public void addCommand(Fx702pKey aKey, Command aCommand) {
        if (aCommand == null) {
            this.addCommand(aKey.getCommand());
        } else {
            this.addCommand(aCommand);
        }
    }

    public void f1Prefix() {
        this.behavior.f1Prefix();
    }

    public void f2Prefix() {
        this.behavior.f2Prefix();
    }

    public void modePrefix() {
        this.behavior.modePrefix();
    }

    public void arcPrefix() {
        this.behavior.arcPrefix();
    }

    public void hypPrefix() {
        this.behavior.hypPrefix();
    }

    public void contProgram() {
        this.behavior.contProgram();
    }

    public void stopProgram() {
        this.behavior.stopProgram();
    }

    public void reportFx702pError(Fx702pException anError) {
        this.behavior.reportFx702pError(anError);
    }

    protected class ScrollStoppedBehavior
    extends AbstractBehavior {
        protected KeyboardBehavior previousBehavior;

        public ScrollStoppedBehavior(KeyboardBehavior aPreviousBehavior) {
            this.previousBehavior = aPreviousBehavior;
        }

        public void keyPressed(Fx702pKey aKey) {
            if (aKey == Fx702pKey.ALL_CLEAR || aKey == Fx702pKey.CONT) {
                Fx702pKeyboard.this.addCommand(aKey.getCommand());
            }
        }

        public void cont() {
            Fx702pKeyboard.this.setBehavior(new ScrollBehavior(this.previousBehavior));
        }

        public void allClear() {
            Fx702pKeyboard.this.setBehavior(this.previousBehavior);
            Fx702pKeyboard.this.behavior.allClear();
        }

        public void endScroll() {
            Fx702pKeyboard.this.setBehavior(this.previousBehavior);
        }
    }

    protected class ScrollBehavior
    extends AbstractBehavior {
        protected KeyboardBehavior previousBehavior;

        public ScrollBehavior(KeyboardBehavior aPreviousBehavior) {
            this.previousBehavior = aPreviousBehavior;
        }

        public void keyPressed(Fx702pKey aKey) {
            if (aKey == Fx702pKey.CONT) {
                Fx702pKeyboard.this.addCommand(new FastScrollCommand());
            } else if (aKey == Fx702pKey.ALL_CLEAR || aKey == Fx702pKey.STOP) {
                Fx702pKeyboard.this.addCommand(aKey.getCommand());
            }
        }

        public void keyReleased(Fx702pKey aKey) {
            if (aKey == Fx702pKey.CONT) {
                Fx702pKeyboard.this.addCommand(new NormalScrollCommand());
            }
        }

        public void stop() {
            Fx702pKeyboard.this.setBehavior(new ScrollStoppedBehavior(this.previousBehavior));
        }

        public void allClear() {
            Fx702pKeyboard.this.setBehavior(this.previousBehavior);
            Fx702pKeyboard.this.behavior.allClear();
        }

        public void endScroll() {
            Fx702pKeyboard.this.setBehavior(this.previousBehavior);
        }
    }

    protected class ErrorBehavior
    extends AbstractBehavior {
        protected ErrorBehavior() {
        }

        public void allClear() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.NO_PREFIX_BEHAVIOR);
            Fx702pKeyboard.this.behavior.allClear();
        }

        public void keyPressed(Fx702pKey aKey) {
            if (aKey == Fx702pKey.ALL_CLEAR) {
                Fx702pKeyboard.this.addCommand(aKey.getCommand());
            }
        }
    }

    protected class ProgramRunningBehavior
    extends NoPrefixBehavior {
        protected ProgramRunningBehavior() {
        }

        public void keyPressed(Fx702pKey aKey) {
            Command command = aKey.getKeyCommand();
            if (command instanceof StringCommand) {
                String key = ((StringCommand)command).getString();
                if (key.length() == 1) {
                    Fx702pKeyboard.this.setPotentialKey(key.charAt(0));
                }
            } else {
                Fx702pKeyboard.this.addCommand(aKey.getKeyCommand());
            }
        }

        public void keyRepeated(Fx702pKey aKey) {
            this.keyPressed(aKey);
        }

        public void keyReleased(Fx702pKey aKey) {
            String key;
            Command command = aKey.getKeyCommand();
            if (command instanceof StringCommand && (key = ((StringCommand)command).getString()).length() == 1) {
                Fx702pKeyboard.this.endPotentialKey(key.charAt(0));
            }
        }

        public void f1Prefix() {
        }

        public void f2Prefix() {
        }

        public void modePrefix() {
        }

        public void arcPrefix() {
        }

        public void hypPrefix() {
        }

        public void clearPrefixes() {
        }

        public void allClear() {
        }

        public void suspendProgram() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.NO_PREFIX_BEHAVIOR);
        }
    }

    protected class ArcHypPrefixBehavior
    extends ArcPrefixBehavior {
        protected ArcHypPrefixBehavior() {
        }

        public void keyPressed(Fx702pKey aKey) {
            Fx702pKeyboard.this.addCommand(aKey, aKey.getArcHypCommand());
        }

        public void displayPrefixes(Fx702pDisplay aDisplay) {
            aDisplay.showPrefixes(true, false, true, true, false);
        }

        public void arcPrefix() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.HYP_PREFIX_BEHAVIOR);
        }

        public void hypPrefix() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.ARC_PREFIX_BEHAVIOR);
        }
    }

    protected class HypPrefixBehavior
    extends F1PrefixBehavior {
        protected HypPrefixBehavior() {
        }

        public void keyPressed(Fx702pKey aKey) {
            Fx702pKeyboard.this.addCommand(aKey, aKey.getHypCommand());
        }

        public void displayPrefixes(Fx702pDisplay aDisplay) {
            aDisplay.showPrefixes(true, false, false, true, false);
        }

        public void arcPrefix() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.ARC_HYP_PREFIX_BEHAVIOR);
        }

        public void hypPrefix() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.NO_PREFIX_BEHAVIOR);
        }
    }

    protected class ArcPrefixBehavior
    extends F1PrefixBehavior {
        protected ArcPrefixBehavior() {
        }

        public void keyPressed(Fx702pKey aKey) {
            Fx702pKeyboard.this.addCommand(aKey, aKey.getArcCommand());
        }

        public void displayPrefixes(Fx702pDisplay aDisplay) {
            aDisplay.showPrefixes(true, false, true, false, false);
        }

        public void arcPrefix() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.NO_PREFIX_BEHAVIOR);
        }

        public void hypPrefix() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.ARC_HYP_PREFIX_BEHAVIOR);
        }
    }

    protected class ModePrefixBehavior
    extends NoPrefixBehavior {
        protected ModePrefixBehavior() {
        }

        public void keyPressed(Fx702pKey aKey) {
            Fx702pKeyboard.this.addCommand(aKey, aKey.getModeCommand());
        }

        public void displayPrefixes(Fx702pDisplay aDisplay) {
            aDisplay.showPrefixes(false, false, false, false, true);
        }
    }

    protected class F2PrefixBehavior
    extends NoPrefixBehavior {
        protected F2PrefixBehavior() {
        }

        public void keyPressed(Fx702pKey aKey) {
            Fx702pKeyboard.this.addCommand(aKey, aKey.getF2Command());
        }

        public void displayPrefixes(Fx702pDisplay aDisplay) {
            aDisplay.showPrefixes(false, true, false, false, false);
        }

        public void f2Prefix() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.NO_PREFIX_BEHAVIOR);
        }
    }

    protected class F1PrefixBehavior
    extends NoPrefixBehavior {
        protected F1PrefixBehavior() {
        }

        public void keyPressed(Fx702pKey aKey) {
            Fx702pKeyboard.this.addCommand(aKey, aKey.getF1Command());
        }

        public void displayPrefixes(Fx702pDisplay aDisplay) {
            aDisplay.showPrefixes(true, false, false, false, false);
        }

        public void f1Prefix() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.NO_PREFIX_BEHAVIOR);
        }

        public void arcPrefix() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.ARC_PREFIX_BEHAVIOR);
        }

        public void hypPrefix() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.HYP_PREFIX_BEHAVIOR);
        }
    }

    protected class NoPrefixBehavior
    extends AbstractBehavior {
        protected NoPrefixBehavior() {
        }

        public void keyPressed(Fx702pKey aKey) {
            Fx702pKeyboard.this.addCommand(aKey.getCommand());
        }

        public void displayPrefixes(Fx702pDisplay aDisplay) {
            aDisplay.showPrefixes(false, false, false, false, false);
        }

        public void f1Prefix() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.F1_PREFIX_BEHAVIOR);
        }

        public void f2Prefix() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.F2_PREFIX_BEHAVIOR);
        }

        public void clearPrefixes() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.NO_PREFIX_BEHAVIOR);
        }

        public void allClear() {
            this.clearPrefixes();
        }

        public void reportFx702pError(Fx702pException anError) {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.ERROR_BEHAVIOR);
        }
    }

    protected class AbstractBehavior
    implements KeyboardBehavior {
        protected AbstractBehavior() {
        }

        public void allClear() {
        }

        public void arcPrefix() {
        }

        public void clearPrefixes() {
        }

        public void displayPrefixes(Fx702pDisplay aDisplay) {
        }

        public void f1Prefix() {
        }

        public void f2Prefix() {
        }

        public void hypPrefix() {
        }

        public void keyPressed(Fx702pKey aKey) {
        }

        public void keyRepeated(Fx702pKey aKey) {
            if (aKey == Fx702pKey.LEFT_ARROW || aKey == Fx702pKey.RIGHT_ARROW) {
                this.keyPressed(aKey);
            }
        }

        public void keyReleased(Fx702pKey aKey) {
        }

        public void modePrefix() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.MODE_PREFIX_BEHAVIOR);
        }

        public void reportFx702pError(Fx702pException anError) {
        }

        public void stop() {
        }

        public void cont() {
        }

        public void stopProgram() {
            Fx702pKeyboard.this.setRunMode();
        }

        public void contProgram() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.PROGRAM_RUNNNING_BEHAVIOR);
        }

        public void startScroll() {
            Fx702pKeyboard.this.setBehavior(new ScrollBehavior(this));
        }

        public void endScroll() {
            Fx702pKeyboard.this.setBehavior(Fx702pKeyboard.this.NO_PREFIX_BEHAVIOR);
        }
    }

    protected static interface KeyboardBehavior {
        public void keyPressed(Fx702pKey var1);

        public void keyRepeated(Fx702pKey var1);

        public void keyReleased(Fx702pKey var1);

        public void displayPrefixes(Fx702pDisplay var1);

        public void f1Prefix();

        public void f2Prefix();

        public void modePrefix();

        public void arcPrefix();

        public void hypPrefix();

        public void clearPrefixes();

        public void allClear();

        public void stop();

        public void cont();

        public void stopProgram();

        public void contProgram();

        public void startScroll();

        public void endScroll();

        public void reportFx702pError(Fx702pException var1);
    }
}

