/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.emulator.implementation;

import com.fx702p.emulator.Variable;
import com.fx702p.emulator.commands.Command;
import com.fx702p.emulator.implementation.Fx702pAbstractEmulatorComponent;
import com.fx702p.emulator.implementation.Fx702pDefaultEmulator;
import com.fx702p.emulator.implementation.Fx702pEmulatorComponent;
import com.fx702p.interpreters.Fx702pAbstractInterpreter;
import com.fx702p.interpreters.Fx702pBasicEditor;
import com.fx702p.interpreters.Fx702pBasicInterpreter;
import com.fx702p.interpreters.Fx702pCalculator;
import com.fx702p.interpreters.Fx702pException;

public class Fx702pInterpreterHolder
implements Fx702pEmulatorComponent {
    protected Fx702pDefaultEmulator emulator;
    protected InterpreterHolderBehavior behavior;
    protected Fx702pCalculator calculator;
    protected Fx702pBasicInterpreter basicInterpreter;
    protected Fx702pBasicEditor basicEditor;
    protected Fx702pAbstractInterpreter currentInterpreter;
    protected final CalculatorBehavior CALCULATOR_BEHAVIOR = new CalculatorBehavior();
    protected final ProgramRunningBehavior PROGRAM_RUNNING_BEHAVIOR = new ProgramRunningBehavior();
    protected final ProgramStoppedBehavior PROGRAM_STOPPPED_BEHAVIOR = new ProgramStoppedBehavior();
    protected final InputBehavior INPUT_BEHAVIOR = new InputBehavior();

    public Fx702pInterpreterHolder(Fx702pDefaultEmulator aFx702pDefaultEmulator) {
        this.emulator = aFx702pDefaultEmulator;
        this.calculator = new Fx702pCalculator(aFx702pDefaultEmulator);
        this.basicInterpreter = new Fx702pBasicInterpreter(aFx702pDefaultEmulator);
        this.basicEditor = new Fx702pBasicEditor(aFx702pDefaultEmulator);
        this.currentInterpreter = this.calculator;
        this.setInitialBehavior();
    }

    public void forwardCall(Fx702pEmulatorComponent.MethodCaller aMethodCaller) {
        aMethodCaller.callMethod(this);
        aMethodCaller.callMethod(this.getCurrentInterpreter());
    }

    protected void setInitialBehavior() {
        this.setBehavior(this.CALCULATOR_BEHAVIOR);
    }

    protected void setBehavior(InterpreterHolderBehavior aBehavior) {
        this.behavior = aBehavior;
    }

    public Fx702pCalculator getCalculator() {
        return this.calculator;
    }

    public Fx702pBasicInterpreter getBasicInterpreter() {
        return this.basicInterpreter;
    }

    public Fx702pBasicEditor getBasicEditor() {
        return this.basicEditor;
    }

    public Fx702pAbstractInterpreter getCurrentInterpreter() {
        return this.currentInterpreter;
    }

    public void allClear() {
        this.behavior.allClear();
    }

    public void home() {
    }

    public void enterString(String aString) {
        this.behavior.enterString(aString);
    }

    public void execute(String aString) {
        this.behavior.execute(aString);
    }

    public void input(String anInputPrompt) {
        this.behavior.input(anInputPrompt);
    }

    public void resultPrinted() {
        this.behavior.resultPrinted();
    }

    public void startMultiLinePrint() {
        this.behavior.startMultiLinePrint();
    }

    public void endMultiLinePrint() {
        this.behavior.endMultiLinePrint();
    }

    public void reportFx702pError(Fx702pException anError) {
        this.behavior.reportFx702pError(anError);
    }

    public void endWaitAfterPrint() {
        this.behavior.endWaitAfterPrint();
    }

    public void cancelWaitAfterPrint() {
        this.behavior.cancelWaitAfterPrint();
    }

    public void waitAfterPrint(int aPrintWait, Command aCommand) {
        this.behavior.waitAfterPrint(aPrintWait, null);
    }

    public void endProgram() {
        this.behavior.endProgram();
    }

    public void runProgram() {
        this.behavior.runProgram();
    }

    public void stopProgram() {
        this.behavior.stopProgram();
    }

    public void contProgram() {
        this.behavior.contProgram();
    }

    public void suspendProgram() {
        this.behavior.suspendProgram();
    }

    public void resumeProgram() {
        this.behavior.resumeProgram();
    }

    public void stepInProgram() {
        this.behavior.stepInProgram();
    }

    public void debugAndStepActiveProgram() {
        this.behavior.debugAndStepActiveProgram();
    }

    public void cont() {
        this.behavior.cont();
    }

    public void stop() {
        this.behavior.stop();
    }

    public void setRunMode() {
        this.behavior.setRunMode();
    }

    public void setWrtMode() {
        this.behavior.setWrtMode();
    }

    public void startScroll() {
        this.behavior.startScroll();
    }

    public void endScroll() {
        this.behavior.endScroll();
    }

    public void lastAnswer() {
        this.behavior.lastAnswer();
    }

    public void loadProgram(int aProgramIndex) {
    }

    public void clearProgram(int aProgramIndex) {
    }

    public void setActiveProgramIndex(int aProgramIndex) {
    }

    public void nextLoop(Variable aVariable) {
    }

    public void endLoop(Variable aVariable) {
    }

    protected class ErrorBehavior
    extends AbstractInterpreterHolderBehavior {
        protected InterpreterHolderBehavior previousBehavior;

        public ErrorBehavior(InterpreterHolderBehavior aPreviousBehavior) {
            this.previousBehavior = aPreviousBehavior;
        }

        public void allClear() {
            Fx702pInterpreterHolder.this.setBehavior(this.previousBehavior);
            Fx702pInterpreterHolder.this.behavior.allClear();
        }
    }

    protected class InputBehavior
    extends ProgramRunningBehavior {
        protected InputBehavior() {
        }

        public void allClear() {
        }

        public void contProgram() {
            Fx702pInterpreterHolder.this.setBehavior(Fx702pInterpreterHolder.this.PROGRAM_RUNNING_BEHAVIOR);
            Fx702pInterpreterHolder.this.currentInterpreter.cont();
            Fx702pInterpreterHolder.this.currentInterpreter = Fx702pInterpreterHolder.this.basicInterpreter;
        }

        public void stepInProgram() {
            this.contProgram();
        }

        public void lastAnswer() {
            Fx702pInterpreterHolder.this.currentInterpreter.lastAnswer();
        }
    }

    protected class ProgramStoppedBehavior
    extends CalculatorBehavior {
        protected ProgramStoppedBehavior() {
        }

        public void contProgram() {
            Fx702pInterpreterHolder.this.setBehavior(Fx702pInterpreterHolder.this.PROGRAM_RUNNING_BEHAVIOR);
            Fx702pInterpreterHolder.this.currentInterpreter.cont();
            Fx702pInterpreterHolder.this.currentInterpreter = Fx702pInterpreterHolder.this.basicInterpreter;
        }

        public void stepInProgram() {
            this.contProgram();
        }

        public void setRunMode() {
            Fx702pInterpreterHolder.this.setBehavior(Fx702pInterpreterHolder.this.CALCULATOR_BEHAVIOR);
            Fx702pInterpreterHolder.this.currentInterpreter.setRunMode();
            Fx702pInterpreterHolder.this.currentInterpreter = Fx702pInterpreterHolder.this.calculator;
        }
    }

    protected class ProgramRunningBehavior
    extends AbstractInterpreterHolderBehavior {
        protected ProgramRunningBehavior() {
        }

        public void setRunMode() {
            Fx702pInterpreterHolder.this.setBehavior(Fx702pInterpreterHolder.this.CALCULATOR_BEHAVIOR);
            Fx702pInterpreterHolder.this.currentInterpreter.setRunMode();
            Fx702pInterpreterHolder.this.currentInterpreter = Fx702pInterpreterHolder.this.calculator;
        }

        public void endProgram() {
            Fx702pInterpreterHolder.this.setBehavior(Fx702pInterpreterHolder.this.CALCULATOR_BEHAVIOR);
            Fx702pInterpreterHolder.this.currentInterpreter.endProgram();
            Fx702pInterpreterHolder.this.currentInterpreter = Fx702pInterpreterHolder.this.calculator;
        }

        public void stopProgram() {
            Fx702pInterpreterHolder.this.setBehavior(Fx702pInterpreterHolder.this.PROGRAM_STOPPPED_BEHAVIOR);
            Fx702pInterpreterHolder.this.currentInterpreter.stop();
            Fx702pInterpreterHolder.this.currentInterpreter = Fx702pInterpreterHolder.this.calculator;
        }

        public void allClear() {
            Fx702pInterpreterHolder.this.emulator.endProgram();
        }

        public void input(String anInputPrompt) {
            Fx702pInterpreterHolder.this.setBehavior(Fx702pInterpreterHolder.this.INPUT_BEHAVIOR);
        }
    }

    protected class CalculatorBehavior
    extends AbstractInterpreterHolderBehavior {
        protected CalculatorBehavior() {
        }

        public void runProgram() {
            Fx702pInterpreterHolder.this.setBehavior(Fx702pInterpreterHolder.this.PROGRAM_RUNNING_BEHAVIOR);
            Fx702pInterpreterHolder.this.currentInterpreter.runProgram();
            Fx702pInterpreterHolder.this.currentInterpreter = Fx702pInterpreterHolder.this.basicInterpreter;
        }

        public void setWrtMode() {
            Fx702pInterpreterHolder.this.currentInterpreter.setWrtMode();
            Fx702pInterpreterHolder.this.currentInterpreter = Fx702pInterpreterHolder.this.basicEditor;
        }

        public void lastAnswer() {
            Fx702pInterpreterHolder.this.currentInterpreter.lastAnswer();
        }
    }

    protected class AbstractInterpreterHolderBehavior
    extends Fx702pAbstractEmulatorComponent
    implements InterpreterHolderBehavior {
        protected AbstractInterpreterHolderBehavior() {
        }

        public void reportFx702pError(Fx702pException anError) {
            Fx702pInterpreterHolder.this.setBehavior(new ErrorBehavior(this));
        }

        public void lastAnswer() {
        }
    }

    protected static interface InterpreterHolderBehavior
    extends Fx702pEmulatorComponent {
        public void lastAnswer();
    }
}

