/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.emulator.implementation;

import com.fx702p.emulator.Fx702pDisplay;
import com.fx702p.emulator.Fx702pEmulator;
import com.fx702p.emulator.implementation.Fx702pAbstractEmulatorComponent;
import com.fx702p.emulator.implementation.Fx702pEmulatorComponent;
import com.fx702p.interpreters.Fx702pException;
import java.util.Arrays;

public class Fx702pInputBuffer
extends Fx702pAbstractEmulatorComponent {
    protected Fx702pEmulator emulator;
    protected InputBufferBehavior behavior;
    protected char[] inputBufferArray = new char[62];
    protected int inputBufferSize = 0;
    protected int inputBufferFirstDisplayedIndex = 0;
    protected final CalculatorBehavior CALCULATOR_BEHAVIOR = new CalculatorBehavior();
    protected final ProgramRunningBehavior PROGRAM_RUNNING_BEHAVIOR = new ProgramRunningBehavior();
    protected final ProgramStoppedBehavior PROGRAM_STOPPED_BEHAVIOR = new ProgramStoppedBehavior();
    protected final InputModeBehavior INPUT_BEHAVIOR = new InputModeBehavior();

    public Fx702pInputBuffer(Fx702pEmulator anEmulator) {
        this.emulator = anEmulator;
        this.setInitialBehavior();
    }

    protected void setInitialBehavior() {
        this.setBehavior(this.CALCULATOR_BEHAVIOR);
    }

    protected void setBehavior(InputBufferBehavior aBehavior) {
        this.behavior = aBehavior;
    }

    public String toString() {
        return new String(this.inputBufferArray, 0, this.inputBufferSize);
    }

    public void setRunMode() {
        this.behavior.setRunMode();
    }

    public void runProgram() {
        this.behavior.runProgram();
    }

    public void contProgram() {
        this.behavior.contProgram();
    }

    public void stopProgram() {
        this.behavior.stopProgram();
    }

    public void stop() {
        this.behavior.stop();
    }

    public void cont() {
        this.behavior.cont();
    }

    public void endProgram() {
        this.behavior.endProgram();
    }

    public void execute(String aString) {
        this.behavior.execute(aString);
    }

    public void enterString(String aString) {
        this.behavior.enterString(aString);
    }

    public void home() {
        this.behavior.home();
    }

    public void insertSpace() {
        this.behavior.insertSpace();
    }

    public void moveCursorRight() {
        this.behavior.moveCursorRight();
    }

    public void moveCursorLeft() {
        this.behavior.moveCursorLeft();
    }

    public void clear() {
        this.behavior.clear();
    }

    public void allClear() {
        this.behavior.allClear();
    }

    public void reportFx702pError(Fx702pException anError) {
        this.behavior.reportFx702pError(anError);
    }

    public void input(String anInputPrompt) {
        this.behavior.input(anInputPrompt);
    }

    protected Fx702pDisplay getDisplay() {
        return this.emulator.getDisplay();
    }

    protected int enterChar(char aChar, int aPosition) {
        if (this.inputBufferSize < 62) {
            int inputBufferCurrentPosition = this.inputBufferFirstDisplayedIndex + this.getDisplay().getCursorPosition() + aPosition;
            this.inputBufferArray[inputBufferCurrentPosition] = aChar;
            if (inputBufferCurrentPosition == this.inputBufferSize) {
                ++this.inputBufferSize;
            }
            if (this.getDisplay().getCursorPosition() < 19) {
                return 1;
            }
            ++this.inputBufferFirstDisplayedIndex;
            return 0;
        }
        return 0;
    }

    protected void displayInputBuffer() {
        this.displayInputBuffer(0);
    }

    protected void displayInputBuffer(int aCursorRightMoves) {
        int displayedLength = Math.min(this.inputBufferSize - this.inputBufferFirstDisplayedIndex, 20);
        char[] inputBufferToPrint = new char[displayedLength];
        System.arraycopy(this.inputBufferArray, this.inputBufferFirstDisplayedIndex, inputBufferToPrint, 0, displayedLength);
        this.getDisplay().print(inputBufferToPrint);
        this.getDisplay().moveCursorRight(aCursorRightMoves);
    }

    protected void clearInputBuffer() {
        Arrays.fill(this.inputBufferArray, 0, 62, ' ');
        this.inputBufferSize = 0;
        this.inputBufferFirstDisplayedIndex = 0;
    }

    protected class ErrorBehavior
    extends Fx702pAbstractEmulatorComponent
    implements InputBufferBehavior {
        protected InputBufferBehavior previousBehavior;

        public ErrorBehavior(InputBufferBehavior anInputBufferBehavior) {
            this.previousBehavior = anInputBufferBehavior;
        }

        public void allClear() {
            Fx702pInputBuffer.this.setBehavior(this.previousBehavior);
            Fx702pInputBuffer.this.behavior.allClear();
        }

        public void clear() {
        }

        public void home() {
        }

        public void insertSpace() {
        }

        public void moveCursorLeft() {
        }

        public void moveCursorRight() {
        }
    }

    protected class InputModeBehavior
    extends CalculatorBehavior {
        protected InputModeBehavior() {
        }

        public void stopProgram() {
            Fx702pInputBuffer.this.setBehavior(Fx702pInputBuffer.this.PROGRAM_STOPPED_BEHAVIOR);
        }

        public void contProgram() {
            Fx702pInputBuffer.this.setBehavior(Fx702pInputBuffer.this.PROGRAM_RUNNING_BEHAVIOR);
        }

        public void stepInProgram() {
            this.contProgram();
        }

        public void allClear() {
            Fx702pInputBuffer.this.clearInputBuffer();
            Fx702pInputBuffer.this.getDisplay().print("?".toCharArray());
        }

        public void home() {
            Fx702pInputBuffer.this.inputBufferFirstDisplayedIndex = 0;
            Fx702pInputBuffer.this.displayInputBuffer();
        }
    }

    protected class ProgramStoppedBehavior
    extends CalculatorBehavior {
        protected ProgramStoppedBehavior() {
        }

        public void contProgram() {
            Fx702pInputBuffer.this.setBehavior(Fx702pInputBuffer.this.PROGRAM_RUNNING_BEHAVIOR);
            Fx702pInputBuffer.this.clearInputBuffer();
        }

        public void stepInProgram() {
            this.contProgram();
        }
    }

    protected class ProgramRunningBehavior
    extends AbstractInputBufferBehavior {
        protected ProgramRunningBehavior() {
        }

        public void stopProgram() {
            Fx702pInputBuffer.this.setBehavior(Fx702pInputBuffer.this.PROGRAM_STOPPED_BEHAVIOR);
        }

        public void input(String anInputPrompt) {
            Fx702pInputBuffer.this.setBehavior(Fx702pInputBuffer.this.INPUT_BEHAVIOR);
            Fx702pInputBuffer.this.clearInputBuffer();
        }
    }

    protected class CalculatorBehavior
    extends AbstractInputBufferBehavior {
        protected CalculatorBehavior() {
        }

        public void execute(String aString) {
            Fx702pInputBuffer.this.clearInputBuffer();
        }

        public void enterString(String aString) {
            int cursorRightMoves = 0;
            int last = aString.length();
            for (int i = 0; i < last; ++i) {
                cursorRightMoves += Fx702pInputBuffer.this.enterChar(aString.charAt(i), cursorRightMoves);
            }
            Fx702pInputBuffer.this.displayInputBuffer(cursorRightMoves);
        }

        public void home() {
            Fx702pInputBuffer.this.inputBufferFirstDisplayedIndex = 0;
            Fx702pInputBuffer.this.displayInputBuffer();
        }

        public void insertSpace() {
            int inputBufferCurrentPosition;
            if (Fx702pInputBuffer.this.inputBufferSize > 0 && Fx702pInputBuffer.this.inputBufferSize < 62 && (inputBufferCurrentPosition = Fx702pInputBuffer.this.inputBufferFirstDisplayedIndex + Fx702pInputBuffer.this.getDisplay().getCursorPosition()) != Fx702pInputBuffer.this.inputBufferSize) {
                for (int i = Fx702pInputBuffer.this.inputBufferSize; i > inputBufferCurrentPosition; --i) {
                    Fx702pInputBuffer.this.inputBufferArray[i] = Fx702pInputBuffer.this.inputBufferArray[i - 1];
                }
                ++Fx702pInputBuffer.this.inputBufferSize;
                Fx702pInputBuffer.this.inputBufferArray[inputBufferCurrentPosition] = 32;
                Fx702pInputBuffer.this.displayInputBuffer();
            }
        }

        public void moveCursorRight() {
            if (Fx702pInputBuffer.this.getDisplay().getCursorPosition() == 19 && Fx702pInputBuffer.this.inputBufferFirstDisplayedIndex + 20 <= Fx702pInputBuffer.this.inputBufferSize) {
                ++Fx702pInputBuffer.this.inputBufferFirstDisplayedIndex;
                Fx702pInputBuffer.this.displayInputBuffer();
            } else if (Fx702pInputBuffer.this.getDisplay().getCursorPosition() < 20) {
                Fx702pInputBuffer.this.getDisplay().moveCursorRight();
            }
        }

        public void moveCursorLeft() {
            if (Fx702pInputBuffer.this.inputBufferFirstDisplayedIndex > 0) {
                --Fx702pInputBuffer.this.inputBufferFirstDisplayedIndex;
                Fx702pInputBuffer.this.displayInputBuffer();
            } else {
                Fx702pInputBuffer.this.getDisplay().moveCursorLeft();
            }
        }

        public void clear() {
            int inputBufferCurrentPosition = Fx702pInputBuffer.this.inputBufferFirstDisplayedIndex + Fx702pInputBuffer.this.getDisplay().getCursorPosition();
            if (inputBufferCurrentPosition > 0 && Fx702pInputBuffer.this.inputBufferSize > 0) {
                for (int i = inputBufferCurrentPosition; i < Fx702pInputBuffer.this.inputBufferSize; ++i) {
                    Fx702pInputBuffer.this.inputBufferArray[i - 1] = Fx702pInputBuffer.this.inputBufferArray[i];
                }
                --Fx702pInputBuffer.this.inputBufferSize;
                Fx702pInputBuffer.this.inputBufferArray[Fx702pInputBuffer.this.inputBufferSize] = 32;
                if (Fx702pInputBuffer.this.inputBufferFirstDisplayedIndex > 0) {
                    --Fx702pInputBuffer.this.inputBufferFirstDisplayedIndex;
                } else {
                    Fx702pInputBuffer.this.getDisplay().moveCursorLeft();
                }
                Fx702pInputBuffer.this.displayInputBuffer();
            }
        }

        public void allClear() {
            Fx702pInputBuffer.this.clearInputBuffer();
            Fx702pInputBuffer.this.displayInputBuffer();
        }
    }

    protected abstract class AbstractInputBufferBehavior
    extends Fx702pAbstractEmulatorComponent
    implements InputBufferBehavior {
        protected AbstractInputBufferBehavior() {
        }

        public void setRunMode() {
            Fx702pInputBuffer.this.setBehavior(Fx702pInputBuffer.this.CALCULATOR_BEHAVIOR);
            Fx702pInputBuffer.this.clearInputBuffer();
        }

        public void runProgram() {
            Fx702pInputBuffer.this.setBehavior(Fx702pInputBuffer.this.PROGRAM_RUNNING_BEHAVIOR);
            Fx702pInputBuffer.this.clearInputBuffer();
        }

        public void endProgram() {
            Fx702pInputBuffer.this.setBehavior(Fx702pInputBuffer.this.CALCULATOR_BEHAVIOR);
            Fx702pInputBuffer.this.clearInputBuffer();
        }

        public void reportFx702pError(Fx702pException anError) {
            Fx702pInputBuffer.this.setBehavior(new ErrorBehavior(this));
        }

        public void execute(String aString) {
        }

        public void enterString(String aString) {
        }

        public void home() {
        }

        public void insertSpace() {
        }

        public void moveCursorRight() {
        }

        public void moveCursorLeft() {
        }

        public void clear() {
        }
    }

    protected static interface InputBufferBehavior
    extends Fx702pEmulatorComponent {
        public void home();

        public void insertSpace();

        public void moveCursorRight();

        public void moveCursorLeft();

        public void clear();
    }
}

