/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.emulator.implementation;

import com.fx702p.emulator.Fx702pDisplay;
import com.fx702p.emulator.Fx702pEmulator;
import com.fx702p.emulator.commands.Command;
import com.fx702p.emulator.implementation.Fx702pAbstractEmulatorComponent;
import com.fx702p.emulator.implementation.Fx702pEmulatorComponent;
import com.fx702p.interpreters.Fx702pException;
import java.util.Arrays;

public class Fx702pDisplayBuffer
extends Fx702pAbstractEmulatorComponent {
    protected Fx702pEmulator emulator;
    protected char[] displayBufferArray = new char[20];
    protected DisplayBufferBehavior behavior;
    protected final PrintingBehavior PRINTING_BEHAVIOR = new PrintingBehavior();
    protected final ClearDisplayBeforeEnteringStringBehavior CLEAR_DISPLAY_BEFORE_ENTERING_STRING_BEHAVIOR = new ClearDisplayBeforeEnteringStringBehavior();
    protected final ClearDisplayBeforePrintOrEnterBehavior CLEAR_DISPLAY_BEFORE_PRINT_OR_ENTER_BEHAVIOR = new ClearDisplayBeforePrintOrEnterBehavior();
    protected final ProgramRunningBehavior PROGRAM_RUNNING_BEHAVIOR = new ProgramRunningBehavior();
    protected final StartInputBehavior START_INPUT_BEHAVIOR = new StartInputBehavior();
    protected final InputBehavior INPUT_BEHAVIOR = new InputBehavior();

    public Fx702pDisplayBuffer(Fx702pEmulator anEmulator) {
        this.emulator = anEmulator;
        this.setInitialBehavior();
        this.clearDisplayBuffer();
    }

    protected void setInitialBehavior() {
        this.setBehavior(this.PRINTING_BEHAVIOR);
    }

    protected void setBehavior(DisplayBufferBehavior aBehavior) {
        this.behavior = aBehavior;
    }

    public void clearDisplay() {
        this.behavior.clearDisplay();
    }

    protected void clearDisplayBuffer() {
        Arrays.fill(this.displayBufferArray, 0, 20, ' ');
    }

    public String print(String aString) {
        return this.behavior.print(aString);
    }

    public String printAndScroll(String aString) {
        return this.behavior.printAndScroll(aString);
    }

    public void setRunMode() {
        this.behavior.setRunMode();
    }

    public void resultPrinted() {
        this.behavior.resultPrinted();
    }

    public void reportFx702pError(Fx702pException anError) {
        this.behavior.reportFx702pError(anError);
    }

    public void enterString(String aString) {
        this.behavior.enterString(aString);
    }

    public void execute(String aString) {
        this.behavior.execute(aString);
    }

    public void input(String anInputPrompt) {
        this.behavior.input(anInputPrompt);
    }

    public void runProgram() {
        this.behavior.runProgram();
    }

    public void cont() {
        this.behavior.cont();
    }

    public void stop() {
        this.behavior.stop();
    }

    public void contProgram() {
        this.behavior.contProgram();
    }

    public void stopProgram() {
        this.behavior.stopProgram();
    }

    public void endProgram() {
        this.behavior.endProgram();
    }

    public void waitAfterPrint(int aPrintWait, Command aCommand) {
        this.behavior.waitAfterPrint(aPrintWait, null);
    }

    public void endWaitAfterPrint() {
        this.behavior.endWaitAfterPrint();
    }

    public void setWrtMode() {
        this.behavior.setWrtMode();
    }

    public void allClear() {
        this.behavior.allClear();
    }

    public void startScroll() {
        this.behavior.startScroll();
    }

    public void endScroll() {
        this.behavior.endScroll();
    }

    protected class ScrollBehavior
    extends PrintingBehavior {
        protected DisplayBufferBehavior previousBehavior;

        public ScrollBehavior(DisplayBufferBehavior aPreviousBehavior) {
            this.previousBehavior = aPreviousBehavior;
        }

        public void cont() {
        }

        public void stop() {
        }

        public void endScroll() {
            Fx702pDisplayBuffer.this.setBehavior(this.previousBehavior);
        }

        public void allClear() {
            Fx702pDisplayBuffer.this.setBehavior(this.previousBehavior);
        }

        public void resultPrinted() {
            this.previousBehavior = Fx702pDisplayBuffer.this.CLEAR_DISPLAY_BEFORE_ENTERING_STRING_BEHAVIOR;
        }
    }

    protected class ProgramErrorBehavior
    extends ErrorBehavior {
        public ProgramErrorBehavior(DisplayBufferBehavior aPreviousBehavior) {
            super(aPreviousBehavior);
        }

        public void allClear() {
            this.clearDisplay();
            super.allClear();
        }
    }

    protected class ErrorBehavior
    extends AbstractDisplayBufferBehavior {
        protected DisplayBufferBehavior previousBehavior;

        public ErrorBehavior(DisplayBufferBehavior aPreviousBehavior) {
            this.previousBehavior = aPreviousBehavior;
        }

        public void allClear() {
            Fx702pDisplayBuffer.this.setBehavior(this.previousBehavior);
            Fx702pDisplayBuffer.this.behavior.allClear();
        }
    }

    protected class InputBehavior
    extends PrintingBehavior {
        protected InputBehavior() {
        }

        public void contProgram() {
            Fx702pDisplayBuffer.this.setBehavior(Fx702pDisplayBuffer.this.PROGRAM_RUNNING_BEHAVIOR);
        }

        public void stepInProgram() {
            this.contProgram();
        }

        public void allClear() {
            this.clearDisplay();
        }

        public void endProgram() {
            Fx702pDisplayBuffer.this.setBehavior(Fx702pDisplayBuffer.this.CLEAR_DISPLAY_BEFORE_PRINT_OR_ENTER_BEHAVIOR);
            this.clearDisplay();
        }
    }

    protected class StartInputBehavior
    extends ClearDisplayBeforeEnteringStringBehavior {
        protected StartInputBehavior() {
        }

        public void enterString(String aString) {
            this.clearDisplay();
            Fx702pDisplayBuffer.this.setBehavior(Fx702pDisplayBuffer.this.INPUT_BEHAVIOR);
        }

        public void endProgram() {
            Fx702pDisplayBuffer.this.setBehavior(Fx702pDisplayBuffer.this.CLEAR_DISPLAY_BEFORE_PRINT_OR_ENTER_BEHAVIOR);
            this.clearDisplay();
        }
    }

    protected class ProgramRunningBehavior
    extends PrintingBehavior {
        protected ProgramRunningBehavior() {
        }

        public void resultPrinted() {
        }

        public void reportFx702pError(Fx702pException anError) {
            Fx702pDisplayBuffer.this.setBehavior(new ProgramErrorBehavior(this));
        }
    }

    protected class ClearDisplayBeforePrintOrEnterBehavior
    extends ClearDisplayBeforeEnteringStringBehavior {
        protected ClearDisplayBeforePrintOrEnterBehavior() {
        }

        public void allClear() {
            Fx702pDisplayBuffer.this.setBehavior(Fx702pDisplayBuffer.this.PRINTING_BEHAVIOR);
        }

        public String print(String aString) {
            this.clearDisplay();
            String stillToPrint = super.print(aString);
            Fx702pDisplayBuffer.this.setBehavior(Fx702pDisplayBuffer.this.PRINTING_BEHAVIOR);
            return stillToPrint;
        }
    }

    protected class ClearDisplayBeforeEnteringStringBehavior
    extends PrintingBehavior {
        protected ClearDisplayBeforeEnteringStringBehavior() {
        }

        public void enterString(String aString) {
            this.clearDisplay();
            Fx702pDisplayBuffer.this.setBehavior(Fx702pDisplayBuffer.this.PRINTING_BEHAVIOR);
        }
    }

    protected class PrintingBehavior
    extends AbstractDisplayBufferBehavior {
        protected PrintingBehavior() {
        }

        public void stopProgram() {
            Fx702pDisplayBuffer.this.setBehavior(Fx702pDisplayBuffer.this.CLEAR_DISPLAY_BEFORE_PRINT_OR_ENTER_BEHAVIOR);
        }

        public void endWaitAfterPrint() {
            Fx702pDisplayBuffer.this.setBehavior(Fx702pDisplayBuffer.this.CLEAR_DISPLAY_BEFORE_PRINT_OR_ENTER_BEHAVIOR);
        }

        public void endProgram() {
            Fx702pDisplayBuffer.this.setBehavior(Fx702pDisplayBuffer.this.CLEAR_DISPLAY_BEFORE_PRINT_OR_ENTER_BEHAVIOR);
        }
    }

    protected class AbstractDisplayBufferBehavior
    extends Fx702pAbstractEmulatorComponent
    implements DisplayBufferBehavior {
        protected AbstractDisplayBufferBehavior() {
        }

        public void clearDisplay() {
            Fx702pDisplayBuffer.this.clearDisplayBuffer();
            Fx702pDisplayBuffer.this.emulator.getDisplay().print(Fx702pDisplayBuffer.this.displayBufferArray);
            Fx702pDisplayBuffer.this.emulator.setCursorPosition(0);
        }

        public String print(String aString) {
            String stillToPrint = null;
            Fx702pDisplay display = Fx702pDisplayBuffer.this.emulator.getDisplay();
            int cursorPosition = display.getCursorPosition();
            int last = aString.length();
            for (int i = 0; i < last; ++i) {
                if (cursorPosition >= 20) {
                    stillToPrint = aString.substring(i);
                    break;
                }
                Fx702pDisplayBuffer.this.displayBufferArray[cursorPosition++] = aString.charAt(i);
            }
            display.print(Fx702pDisplayBuffer.this.displayBufferArray);
            display.setCursorPosition(cursorPosition);
            return stillToPrint;
        }

        public String printAndScroll(String aString) {
            String stillToPrint = null;
            System.arraycopy(Fx702pDisplayBuffer.this.displayBufferArray, 1, Fx702pDisplayBuffer.this.displayBufferArray, 0, 19);
            Fx702pDisplayBuffer.this.displayBufferArray[19] = aString.charAt(0);
            Fx702pDisplayBuffer.this.emulator.getDisplay().print(Fx702pDisplayBuffer.this.displayBufferArray);
            if (aString.length() > 1) {
                stillToPrint = aString.substring(1);
            }
            return stillToPrint;
        }

        public void resultPrinted() {
            Fx702pDisplayBuffer.this.setBehavior(Fx702pDisplayBuffer.this.CLEAR_DISPLAY_BEFORE_ENTERING_STRING_BEHAVIOR);
        }

        public void runProgram() {
            Fx702pDisplayBuffer.this.setBehavior(Fx702pDisplayBuffer.this.PROGRAM_RUNNING_BEHAVIOR);
            this.clearDisplay();
        }

        public void contProgram() {
            Fx702pDisplayBuffer.this.setBehavior(Fx702pDisplayBuffer.this.PROGRAM_RUNNING_BEHAVIOR);
            this.clearDisplay();
        }

        public void endProgram() {
            Fx702pDisplayBuffer.this.setBehavior(Fx702pDisplayBuffer.this.CLEAR_DISPLAY_BEFORE_ENTERING_STRING_BEHAVIOR);
            this.clearDisplay();
        }

        public void execute(String aString) {
            if (aString != null && aString.length() != 0) {
                this.clearDisplay();
            }
        }

        public void input(String anInputPrompt) {
            Fx702pDisplayBuffer.this.setBehavior(Fx702pDisplayBuffer.this.START_INPUT_BEHAVIOR);
        }

        public void reportFx702pError(Fx702pException anError) {
            Fx702pDisplayBuffer.this.setBehavior(new ErrorBehavior(this));
        }

        public void startScroll() {
            Fx702pDisplayBuffer.this.setBehavior(new ScrollBehavior(this));
        }
    }

    protected static interface DisplayBufferBehavior
    extends Fx702pEmulatorComponent {
        public void clearDisplay();

        public String print(String var1);

        public String printAndScroll(String var1);
    }
}

