/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.emulator.implementation;

import com.fx702p.emulator.Fx702pEmulator;
import com.fx702p.emulator.commands.Command;
import com.fx702p.emulator.implementation.Fx702pAbstractEmulatorComponent;
import com.fx702p.emulator.implementation.Fx702pEmulatorComponent;
import com.fx702p.interpreters.Fx702pException;

public class Fx702pCursor
extends Fx702pAbstractEmulatorComponent {
    protected Fx702pEmulator emulator;
    protected CursorBehavior behavior;
    protected final CalculatorBehavior CALCULATOR_BEHAVIOR = new CalculatorBehavior();
    protected final ProgramRunningBehavior PROGRAM_RUNNING_BEHAVIOR = new ProgramRunningBehavior();
    protected final ProgramStoppedBehavior PROGRAM_STOPPED_BEHAVIOR = new ProgramStoppedBehavior();
    protected final InputBehavior INPUT_BEHAVIOR = new InputBehavior();

    public Fx702pCursor(Fx702pEmulator anEmulator) {
        this.emulator = anEmulator;
        this.setInitialBehavior();
    }

    protected void setInitialBehavior() {
        this.setBehavior(this.CALCULATOR_BEHAVIOR);
    }

    protected void setBehavior(CursorBehavior aBehavior) {
        this.behavior = aBehavior;
    }

    protected void setCursorVisible() {
        this.emulator.getDisplay().setCursorVisible(true);
    }

    protected void setCursorInvisible() {
        this.emulator.getDisplay().setCursorVisible(false);
    }

    public void enterString(String aString) {
        this.behavior.enterString(aString);
    }

    public void input(String anInputPrompt) {
        this.behavior.input(anInputPrompt);
    }

    public void allClear() {
        this.behavior.allClear();
    }

    public void home() {
        this.behavior.home();
    }

    public void execute(String aString) {
        this.behavior.execute(aString);
    }

    public void reportFx702pError(Fx702pException anError) {
        this.behavior.reportFx702pError(anError);
    }

    public void cont() {
        this.behavior.cont();
    }

    public void stop() {
        this.behavior.stop();
    }

    public void endProgram() {
        this.behavior.endProgram();
    }

    public void runProgram() {
        this.behavior.runProgram();
    }

    public void contProgram() {
        this.behavior.contProgram();
    }

    public void stopProgram() {
        this.behavior.stopProgram();
    }

    public void setRunMode() {
        this.behavior.setRunMode();
    }

    public void endWaitAfterPrint() {
        this.behavior.endWaitAfterPrint();
    }

    public void setWrtMode() {
        this.behavior.setWrtMode();
    }

    public void waitAfterPrint(int aPrintWait, Command aCommand) {
        this.behavior.waitAfterPrint(aPrintWait, null);
    }

    public void resultPrinted() {
        this.behavior.resultPrinted();
    }

    public void startMultiLinePrint() {
        this.behavior.startMultiLinePrint();
    }

    protected class ErrorBehavior
    extends Fx702pAbstractEmulatorComponent
    implements CursorBehavior {
        protected CursorBehavior previousBehavior;

        public ErrorBehavior(CursorBehavior aPreviousBehavior) {
            this.previousBehavior = aPreviousBehavior;
        }

        public void allClear() {
            Fx702pCursor.this.setBehavior(this.previousBehavior);
            Fx702pCursor.this.behavior.allClear();
        }
    }

    protected class InputBehavior
    extends CalculatorBehavior {
        protected InputBehavior() {
        }

        public void stopProgram() {
            this.setCursorDefaultVisibility();
            Fx702pCursor.this.setBehavior(Fx702pCursor.this.PROGRAM_STOPPED_BEHAVIOR);
        }

        public void contProgram() {
            Fx702pCursor.this.setCursorInvisible();
            Fx702pCursor.this.setBehavior(Fx702pCursor.this.PROGRAM_RUNNING_BEHAVIOR);
        }

        public void stepInProgram() {
            this.contProgram();
        }

        public void allClear() {
            Fx702pCursor.this.setCursorInvisible();
        }
    }

    protected class ProgramStoppedBehavior
    extends CalculatorBehavior {
        protected ProgramStoppedBehavior() {
        }

        public void contProgram() {
            Fx702pCursor.this.setCursorInvisible();
            Fx702pCursor.this.setBehavior(Fx702pCursor.this.PROGRAM_RUNNING_BEHAVIOR);
        }

        public void stepInProgram() {
            this.contProgram();
        }
    }

    protected class ProgramRunningBehavior
    extends AbstractCursorBehavior {
        protected ProgramRunningBehavior() {
        }

        public void stopProgram() {
            this.setCursorDefaultVisibility();
            Fx702pCursor.this.setBehavior(Fx702pCursor.this.PROGRAM_STOPPED_BEHAVIOR);
        }
    }

    protected class CalculatorBehavior
    extends AbstractCursorBehavior {
        protected CalculatorBehavior() {
        }

        public void enterString(String aString) {
            Fx702pCursor.this.setCursorVisible();
        }

        public void resultPrinted() {
            Fx702pCursor.this.setCursorInvisible();
        }

        public void home() {
            Fx702pCursor.this.setCursorVisible();
        }
    }

    protected class AbstractCursorBehavior
    extends Fx702pAbstractEmulatorComponent
    implements CursorBehavior {
        protected AbstractCursorBehavior() {
        }

        public void setRunMode() {
            Fx702pCursor.this.setBehavior(Fx702pCursor.this.CALCULATOR_BEHAVIOR);
        }

        public void endProgram() {
            this.setCursorDefaultVisibility();
            Fx702pCursor.this.setBehavior(Fx702pCursor.this.CALCULATOR_BEHAVIOR);
        }

        public void runProgram() {
            Fx702pCursor.this.setCursorInvisible();
            Fx702pCursor.this.setBehavior(Fx702pCursor.this.PROGRAM_RUNNING_BEHAVIOR);
        }

        public void allClear() {
            this.setCursorDefaultVisibility();
            Fx702pCursor.this.emulator.setCursorPosition(0);
        }

        protected void setCursorDefaultVisibility() {
            if (Fx702pCursor.this.emulator.getDisplay().isEmpty()) {
                Fx702pCursor.this.setCursorVisible();
            }
        }

        public void input(String anInputPrompt) {
            Fx702pCursor.this.setBehavior(Fx702pCursor.this.INPUT_BEHAVIOR);
            Fx702pCursor.this.setCursorInvisible();
        }

        public void reportFx702pError(Fx702pException anError) {
            Fx702pCursor.this.setCursorInvisible();
            Fx702pCursor.this.setBehavior(new ErrorBehavior(this));
        }

        public void startMultiLinePrint() {
            Fx702pCursor.this.setCursorInvisible();
        }
    }

    protected static interface CursorBehavior
    extends Fx702pEmulatorComponent {
    }
}

