/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.emulator;

import com.fx702p.emulator.Fx702pBasicLine;
import com.fx702p.emulator.Fx702pBasicSourceCode;
import com.fx702p.parser.ASTLine;
import com.fx702p.parser.SimpleNode;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionBoundary {
    public int begin;
    public int end;

    public InstructionBoundary(int aBegin) {
        this.begin = aBegin;
    }

    public InstructionBoundary(int aBegin, int anEnd) {
        this.begin = aBegin;
        this.end = anEnd;
    }

    public String toString() {
        return "begin=" + this.begin + ", end=" + this.end;
    }

    public static void resynchronizeLinePositions(Fx702pBasicSourceCode aBasicSourceCode, int aLineIndexInSourceCode, List<InstructionBoundary> theInstructionBoundaries) {
        InstructionBoundary.resynchronizePositions(aBasicSourceCode, aLineIndexInSourceCode, theInstructionBoundaries, 1, null, null);
    }

    public static void resynchronizeInputOrPrintPositions(Fx702pBasicSourceCode aBasicSourceCode, int aLineIndexInSourceCode, List<InstructionBoundary> theInstructionBoundaries, SimpleNode aNode, ASTLine.LineInfos theLineInfos) {
        InstructionBoundary.resynchronizePositions(aBasicSourceCode, aLineIndexInSourceCode, theInstructionBoundaries, 0, aNode, theLineInfos);
    }

    private static void resynchronizePositions(Fx702pBasicSourceCode aBasicSourceCode, int aLineIndexInSourceCode, List<InstructionBoundary> theInstructionBoundaries, int anOffset, SimpleNode aNode, ASTLine.LineInfos theLineInfos) {
        Fx702pBasicLine basicLine = aBasicSourceCode.getLine(aLineIndexInSourceCode);
        int last = theInstructionBoundaries.size();
        for (int i = 0; i < last; ++i) {
            int end;
            InstructionBoundary instructionBoundary = theInstructionBoundaries.get(i);
            int begin = instructionBoundary.begin + anOffset;
            String basicLineAsString = basicLine.toString();
            if (i < last - 1) {
                end = theInstructionBoundaries.get((int)(i + 1)).begin;
            } else if (aNode != null && theLineInfos != null) {
                end = -1;
                theLineInfos.boundariesToFix.put(aNode, instructionBoundary);
            } else {
                end = basicLineAsString.length();
            }
            if (end >= 0) {
                char c;
                int j;
                for (j = begin; j < end; ++j) {
                    c = basicLineAsString.charAt(j);
                    if (c == ' ' || c == '\t') continue;
                    begin = j;
                    break;
                }
                for (j = end - 1; j >= begin; --j) {
                    c = basicLineAsString.charAt(j);
                    if (c == ' ' || c == '\t') continue;
                    end = j + 1;
                    break;
                }
            }
            instructionBoundary.begin = begin;
            instructionBoundary.end = end;
        }
    }
}

