/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.emulator;

import com.fx702p.emulator.Fx702pKeyConstants;
import com.fx702p.emulator.commands.AStatCommand;
import com.fx702p.emulator.commands.AllClearCommand;
import com.fx702p.emulator.commands.AnswerCommand;
import com.fx702p.emulator.commands.ArcCommand;
import com.fx702p.emulator.commands.ClearCommand;
import com.fx702p.emulator.commands.Command;
import com.fx702p.emulator.commands.ContCommand;
import com.fx702p.emulator.commands.DegModeCommand;
import com.fx702p.emulator.commands.DelCommand;
import com.fx702p.emulator.commands.ExeCommand;
import com.fx702p.emulator.commands.F1Command;
import com.fx702p.emulator.commands.F2Command;
import com.fx702p.emulator.commands.GraModeCommand;
import com.fx702p.emulator.commands.HomeCommand;
import com.fx702p.emulator.commands.HypCommand;
import com.fx702p.emulator.commands.InsertCommand;
import com.fx702p.emulator.commands.LeftArrowCommand;
import com.fx702p.emulator.commands.ModeCommand;
import com.fx702p.emulator.commands.PrintOffModeCommand;
import com.fx702p.emulator.commands.PrintOnModeCommand;
import com.fx702p.emulator.commands.RadModeCommand;
import com.fx702p.emulator.commands.ReuseResultCommand;
import com.fx702p.emulator.commands.RightArrowCommand;
import com.fx702p.emulator.commands.RunModeCommand;
import com.fx702p.emulator.commands.RunNumberedProgramCommand;
import com.fx702p.emulator.commands.SacCommand;
import com.fx702p.emulator.commands.StatCommand;
import com.fx702p.emulator.commands.StopCommand;
import com.fx702p.emulator.commands.StringCommand;
import com.fx702p.emulator.commands.TraceOffModeCommand;
import com.fx702p.emulator.commands.TraceOnModeCommand;
import com.fx702p.emulator.commands.WrtModeCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Fx702pKey {
    A("A", "LOG ", "IF "),
    B("B", "LN ", "THEN "),
    C("C", "EXP ", "GOTO "),
    D("D", "SQR ", "GSB "),
    E("E", "SGN ", "RET "),
    F("F", "INT ", "INP "),
    G("G", "FRAC ", "WAIT "),
    H("H", "ABS ", "RPC "),
    I("I", "RND(", "PRC "),
    J("J", "DEG(", "DMS "),
    K("K", "LEN(", "SET "),
    L("L", "CSR ", "VAC "),
    M("M", "MID(", "STOP "),
    N("N", "KEY ", "END "),
    O("O", "SDX ", "SAVE "),
    P("P", "SDY ", "LOAD "),
    Q("Q", "SDXN ", "PUT "),
    R("R", "SDYN ", "GET "),
    S("S", "LRA ", "VER "),
    T("T", "LRB ", "DEFM "),
    U("U", "COR ", "PASS "),
    V("V", "EOX ", "RUN "),
    W("W", "EOY ", "LIST "),
    X,
    Y,
    Z,
    DIGIT_0(Fx702pKey.StringCommand("0"), Fx702pKey.RunProgram(0), RunModeCommand.RUN_MODE_COMMAND),
    DIGIT_1(Fx702pKey.StringCommand("1"), Fx702pKey.RunProgram(1), WrtModeCommand.WRT_MODE_COMMAND),
    DIGIT_2(Fx702pKey.StringCommand("2"), Fx702pKey.RunProgram(2), TraceOnModeCommand.TRACE_ON_MODE_COMMAND),
    DIGIT_3(Fx702pKey.StringCommand("3"), Fx702pKey.RunProgram(3), TraceOffModeCommand.TRACE_OFF_MODE_COMMAND),
    DIGIT_4(Fx702pKey.StringCommand("4"), Fx702pKey.RunProgram(4), DegModeCommand.DEG_MODE_COMMAND),
    DIGIT_5(Fx702pKey.StringCommand("5"), Fx702pKey.RunProgram(5), RadModeCommand.RAD_MODE_COMMAND),
    DIGIT_6(Fx702pKey.StringCommand("6"), Fx702pKey.RunProgram(6), GraModeCommand.GRA_MODE_COMMAND),
    DIGIT_7(Fx702pKey.StringCommand("7"), Fx702pKey.RunProgram(7), PrintOnModeCommand.PRINT_ON_MODE_COMMAND),
    DIGIT_8(Fx702pKey.StringCommand("8"), Fx702pKey.RunProgram(8), PrintOffModeCommand.PRINT_OFF_MODE_COMMAND),
    DIGIT_9(Fx702pKey.StringCommand("9"), Fx702pKey.RunProgram(9)),
    SPACE(" "),
    PLUS(Fx702pKey.ReuseResultCommand("+"), Fx702pKey.StringCommand("?"), Fx702pKeyConstants.NULL_COMMAND),
    MINUS(Fx702pKey.ReuseResultCommand("-"), Fx702pKey.StringCommand("!"), Fx702pKeyConstants.NULL_COMMAND),
    STAR(Fx702pKey.ReuseResultCommand("*"), Fx702pKey.StringCommand("~"), Fx702pKeyConstants.NULL_COMMAND),
    SLASH(Fx702pKey.ReuseResultCommand("/"), Fx702pKey.StringCommand("}"), Fx702pKeyConstants.NULL_COMMAND),
    POWER(Fx702pKey.ReuseResultCommand("^"), Fx702pKey.StringCommand("{"), Fx702pKeyConstants.NULL_COMMAND),
    COMMA(Fx702pKey.StringCommand(","), SacCommand.SAC_COMMAND),
    DECIMAL_POINT(".", "RAN#"),
    DOUBLE_QUOTE(Fx702pKey.StringCommand("\""), ArcCommand.ARC_COMMAND, Fx702pKey.StringCommand("FOR "), Fx702pKeyConstants.NULL_ARC_COMMAND, ArcCommand.ARC_COMMAND, ArcCommand.ARC_COMMAND, ArcCommand.ARC_COMMAND),
    SHARP(Fx702pKey.StringCommand("#"), HypCommand.HYP_COMMAND, Fx702pKey.StringCommand("TO "), Fx702pKeyConstants.NULL_ARC_COMMAND, HypCommand.HYP_COMMAND, HypCommand.HYP_COMMAND, HypCommand.HYP_COMMAND),
    COLON(":", "COS ", "NEXT ", "ACS ", "HCS ", "AHC "),
    DOLLAR("$", "SIN ", "STEP ", "ASN ", "HSN ", "AHS "),
    SEMICOLON(";", "TAN ", "PRT ", "ATN ", "HTN ", "AHT "),
    EQUAL("="),
    GREATER(">"),
    LOWER("<"),
    GREATER_OR_EQUAL("}"),
    LOWER_OR_EQUAL("{"),
    DIFFERENT("~"),
    EXCLAMATION("!"),
    INTERROGATION("?"),
    PI("p"),
    EXPONENT("e", "p"),
    LEFT_PARENTHESIS("(", "<"),
    RIGHT_PARENTHESIS(")", ">"),
    LEFT_ARROW(LeftArrowCommand.LEFT_ARROW_COMMAND, HomeCommand.HOME_COMMAND, Fx702pKeyConstants.NULL_F2_COMMAND, Fx702pKeyConstants.NULL_MODE_COMMAND, Fx702pKeyConstants.NULL_ARC_COMMAND, Fx702pKeyConstants.NULL_HYP_COMMAND, Fx702pKeyConstants.NULL_ARC_HYP_COMMAND, Fx702pKeyConstants.NULL_KEY_COMMAND),
    RIGHT_ARROW(RightArrowCommand.RIGHT_ARROW_COMMAND, Fx702pKeyConstants.NULL_F2_COMMAND, Fx702pKeyConstants.NULL_MODE_COMMAND, Fx702pKeyConstants.NULL_ARC_COMMAND, Fx702pKeyConstants.NULL_HYP_COMMAND, Fx702pKeyConstants.NULL_ARC_HYP_COMMAND, Fx702pKeyConstants.NULL_KEY_COMMAND),
    F1(F1Command.F1_COMMAND, Fx702pKeyConstants.NULL_F2_COMMAND, Fx702pKeyConstants.NULL_MODE_COMMAND, Fx702pKeyConstants.NULL_ARC_COMMAND, Fx702pKeyConstants.NULL_HYP_COMMAND, Fx702pKeyConstants.NULL_ARC_HYP_COMMAND, Fx702pKeyConstants.NULL_KEY_COMMAND),
    F2(F2Command.F2_COMMAND, Fx702pKeyConstants.NULL_F2_COMMAND, Fx702pKeyConstants.NULL_MODE_COMMAND, Fx702pKeyConstants.NULL_ARC_COMMAND, Fx702pKeyConstants.NULL_HYP_COMMAND, Fx702pKeyConstants.NULL_ARC_HYP_COMMAND, Fx702pKeyConstants.NULL_KEY_COMMAND),
    MODE(ModeCommand.MODE_COMMAND, Fx702pKeyConstants.NULL_F2_COMMAND, Fx702pKeyConstants.NULL_MODE_COMMAND, Fx702pKeyConstants.NULL_ARC_COMMAND, Fx702pKeyConstants.NULL_HYP_COMMAND, Fx702pKeyConstants.NULL_ARC_HYP_COMMAND, Fx702pKeyConstants.NULL_KEY_COMMAND),
    CONT(ContCommand.CONT_COMMAND, Fx702pKeyConstants.NULL_F2_COMMAND, Fx702pKeyConstants.NULL_MODE_COMMAND, Fx702pKeyConstants.NULL_ARC_COMMAND, Fx702pKeyConstants.NULL_HYP_COMMAND, Fx702pKeyConstants.NULL_ARC_HYP_COMMAND, Fx702pKeyConstants.NULL_KEY_COMMAND),
    STOP(StopCommand.STOP_COMMAND, Fx702pKeyConstants.NULL_F2_COMMAND, Fx702pKeyConstants.NULL_MODE_COMMAND, Fx702pKeyConstants.NULL_ARC_COMMAND, Fx702pKeyConstants.NULL_HYP_COMMAND, Fx702pKeyConstants.NULL_ARC_HYP_COMMAND, StopCommand.STOP_COMMAND),
    EXE(ExeCommand.EXE_COMMAND, Fx702pKeyConstants.NULL_F2_COMMAND, Fx702pKeyConstants.NULL_MODE_COMMAND, Fx702pKeyConstants.NULL_ARC_COMMAND, Fx702pKeyConstants.NULL_HYP_COMMAND, Fx702pKeyConstants.NULL_ARC_HYP_COMMAND, Fx702pKeyConstants.NULL_KEY_COMMAND),
    CLEAR(ClearCommand.CLEAR_COMMAND, InsertCommand.INSERT_COMMAND, Fx702pKeyConstants.NULL_F2_COMMAND, Fx702pKeyConstants.NULL_MODE_COMMAND, Fx702pKeyConstants.NULL_ARC_COMMAND, Fx702pKeyConstants.NULL_HYP_COMMAND, Fx702pKeyConstants.NULL_ARC_HYP_COMMAND, Fx702pKeyConstants.NULL_KEY_COMMAND),
    ALL_CLEAR(AllClearCommand.ALL_CLEAR_COMMAND, Fx702pKeyConstants.NULL_F2_COMMAND, Fx702pKeyConstants.NULL_MODE_COMMAND, Fx702pKeyConstants.NULL_ARC_COMMAND, Fx702pKeyConstants.NULL_HYP_COMMAND, Fx702pKeyConstants.NULL_ARC_HYP_COMMAND, AllClearCommand.ALL_CLEAR_COMMAND),
    STAT(StatCommand.STAT_COMMAND, DelCommand.DEL_COMMAND, Fx702pKeyConstants.NULL_F2_COMMAND, Fx702pKeyConstants.NULL_MODE_COMMAND, Fx702pKeyConstants.NULL_ARC_COMMAND, Fx702pKeyConstants.NULL_HYP_COMMAND, Fx702pKeyConstants.NULL_ARC_HYP_COMMAND, Fx702pKeyConstants.NULL_KEY_COMMAND),
    ANS(AnswerCommand.ANSWER_COMMAND, AStatCommand.ASTAT_COMMAND, Fx702pKeyConstants.NULL_F2_COMMAND, Fx702pKeyConstants.NULL_MODE_COMMAND, Fx702pKeyConstants.NULL_ARC_COMMAND, Fx702pKeyConstants.NULL_HYP_COMMAND, Fx702pKeyConstants.NULL_ARC_HYP_COMMAND, Fx702pKeyConstants.NULL_KEY_COMMAND);

    private Command command = null;
    private Command f1Command = null;
    private Command f2Command = null;
    private Command modeCommand = null;
    private Command arcCommand = null;
    private Command hypCommand = null;
    private Command arcHypCommand = null;
    private Command keyCommand = null;

    private Fx702pKey() {
        this.command = Fx702pKey.StringCommand(this.toString());
    }

    private Fx702pKey(String aString) {
        this(Fx702pKey.StringCommand(aString));
    }

    private Fx702pKey(String aString, String aF1String) {
        this(Fx702pKey.StringCommand(aString), Fx702pKey.StringCommand(aF1String));
    }

    private Fx702pKey(String aString, String aF1String, String aF2String) {
        this(Fx702pKey.StringCommand(aString), Fx702pKey.StringCommand(aF1String), Fx702pKey.StringCommand(aF2String), null, null, null, null);
    }

    private Fx702pKey(String aString, String aF1String, String aF2String, String anArcString, String anHypString, String anArcHypString) {
        this(Fx702pKey.StringCommand(aString), Fx702pKey.StringCommand(aF1String), Fx702pKey.StringCommand(aF2String), null, Fx702pKey.StringCommand(anArcString), Fx702pKey.StringCommand(anHypString), Fx702pKey.StringCommand(anArcHypString));
    }

    private Fx702pKey(Command aCommand) {
        this(aCommand, null, null, null, null, null, null);
    }

    private Fx702pKey(Command aCommand, Command aF1Command) {
        this(aCommand, aF1Command, null, null, null, null, null);
    }

    private Fx702pKey(Command aCommand, Command aF1Command, Command aModeCommand) {
        this(aCommand, aF1Command, null, aModeCommand, null, null, null);
    }

    private Fx702pKey(Command aCommand, Command aF1Command, Command aF2Command, Command aModeCommand, Command anArcCommand, Command anHypCommand, Command anArcHypCommand) {
        this(aCommand, aF1Command, aF2Command, aModeCommand, anArcCommand, anHypCommand, anArcHypCommand, aCommand);
    }

    private Fx702pKey(Command aCommand, Command aF1Command, Command aF2Command, Command aModeCommand, Command anArcCommand, Command anHypCommand, Command anArcHypCommand, Command aKeyCommand) {
        this.command = aCommand;
        this.f1Command = aF1Command;
        this.f2Command = aF2Command;
        this.modeCommand = aModeCommand;
        this.arcCommand = anArcCommand;
        this.hypCommand = anHypCommand;
        this.arcHypCommand = anArcHypCommand;
        this.keyCommand = aKeyCommand;
    }

    public Command getCommand() {
        return this.command;
    }

    public Command getF1Command() {
        return this.f1Command;
    }

    public Command getF2Command() {
        return this.f2Command;
    }

    public Command getModeCommand() {
        return this.modeCommand;
    }

    public Command getArcCommand() {
        return this.arcCommand;
    }

    public Command getHypCommand() {
        return this.hypCommand;
    }

    public Command getArcHypCommand() {
        return this.arcHypCommand;
    }

    public Command getKeyCommand() {
        return this.keyCommand;
    }

    public static Command StringCommand(String aString) {
        return new StringCommand(aString);
    }

    public static Command RunProgram(int aProgramIndex) {
        return new RunNumberedProgramCommand(aProgramIndex);
    }

    public static Command ReuseResultCommand(String aString) {
        return new ReuseResultCommand(aString);
    }

    public static Fx702pKey convertCharToFx702pKey(char aChar) {
        switch (aChar) {
            case 'A': 
            case 'a': {
                return A;
            }
            case 'B': 
            case 'b': {
                return B;
            }
            case 'C': 
            case 'c': {
                return C;
            }
            case 'D': 
            case 'd': {
                return D;
            }
            case 'E': 
            case 'e': {
                return E;
            }
            case 'F': 
            case 'f': {
                return F;
            }
            case 'G': 
            case 'g': {
                return G;
            }
            case 'H': 
            case 'h': {
                return H;
            }
            case 'I': 
            case 'i': {
                return I;
            }
            case 'J': 
            case 'j': {
                return J;
            }
            case 'K': 
            case 'k': {
                return K;
            }
            case 'L': 
            case 'l': {
                return L;
            }
            case 'M': 
            case 'm': {
                return M;
            }
            case 'N': 
            case 'n': {
                return N;
            }
            case 'O': 
            case 'o': {
                return O;
            }
            case 'P': 
            case 'p': {
                return P;
            }
            case 'Q': 
            case 'q': {
                return Q;
            }
            case 'R': 
            case 'r': {
                return R;
            }
            case 'S': 
            case 's': {
                return S;
            }
            case 'T': 
            case 't': {
                return T;
            }
            case 'U': 
            case 'u': {
                return U;
            }
            case 'V': 
            case 'v': {
                return V;
            }
            case 'W': 
            case 'w': {
                return W;
            }
            case 'X': 
            case 'x': {
                return X;
            }
            case 'Y': 
            case 'y': {
                return Y;
            }
            case 'Z': 
            case 'z': {
                return Z;
            }
            case '0': {
                return DIGIT_0;
            }
            case '1': {
                return DIGIT_1;
            }
            case '2': {
                return DIGIT_2;
            }
            case '3': {
                return DIGIT_3;
            }
            case '4': {
                return DIGIT_4;
            }
            case '5': {
                return DIGIT_5;
            }
            case '6': {
                return DIGIT_6;
            }
            case '7': {
                return DIGIT_7;
            }
            case '8': {
                return DIGIT_8;
            }
            case '9': {
                return DIGIT_9;
            }
            case ' ': {
                return SPACE;
            }
            case '+': {
                return PLUS;
            }
            case '-': {
                return MINUS;
            }
            case '*': {
                return STAR;
            }
            case '/': {
                return SLASH;
            }
            case ',': {
                return COMMA;
            }
            case '.': {
                return DECIMAL_POINT;
            }
            case ':': {
                return COLON;
            }
            case ';': {
                return SEMICOLON;
            }
            case '\"': {
                return DOUBLE_QUOTE;
            }
            case '#': {
                return SHARP;
            }
            case '$': {
                return DOLLAR;
            }
            case '=': {
                return EQUAL;
            }
            case '>': {
                return GREATER;
            }
            case '<': {
                return LOWER;
            }
            case '\u0007': 
            case '}': {
                return GREATER_OR_EQUAL;
            }
            case '\f': 
            case '{': {
                return LOWER_OR_EQUAL;
            }
            case '\u0004': 
            case '~': {
                return DIFFERENT;
            }
            case '!': {
                return EXCLAMATION;
            }
            case '?': {
                return INTERROGATION;
            }
            case '\u0010': {
                return PI;
            }
            case '\u0005': {
                return EXPONENT;
            }
            case '(': {
                return LEFT_PARENTHESIS;
            }
            case ')': {
                return RIGHT_PARENTHESIS;
            }
            case '^': {
                return POWER;
            }
            case '\u0002': {
                return LEFT_ARROW;
            }
            case '\u0006': {
                return RIGHT_ARROW;
            }
            case '\u0011': {
                return CONT;
            }
            case '\u0013': {
                return STOP;
            }
            case '\n': {
                return EXE;
            }
            case '\b': {
                return CLEAR;
            }
            case '\u0003': {
                return ALL_CLEAR;
            }
            case '\u0014': {
                return STAT;
            }
            case '\u0001': {
                return ANS;
            }
            case '\u000f': {
                return MODE;
            }
            case '\u0019': {
                return F1;
            }
            case '\u001a': {
                return F2;
            }
        }
        return null;
    }
}

