/*
 * Decompiled with CFR 0.152.
 */
package com.fx702p.emulator;

import com.fx702p.emulator.Console;
import java.util.Hashtable;
import java.util.Map;

public class Characters {
    private static Map<Character, String[]> drawingsByChar = new Hashtable<Character, String[]>();
    public static final String CHARACTERS_ORDER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789 .e+-*/,;:!?()<>=\"#$^p{}~_'\"o";
    public static final String[][] CHARACTERS = new String[][]{{" XXX ", "X   X", "X   X", "XXXXX", "X   X", "X   X", "X   X"}, {"XXXX ", "X   X", "X   X", "XXXX ", "X   X", "X   X", "XXXX "}, {" XXX ", "X   X", "X    ", "X    ", "X    ", "X   X", " XXX "}, {"XXX  ", "X  X ", "X   X", "X   X", "X   X", "X  X ", "XXX  "}, {"XXXXX", "X    ", "X    ", "XXXX ", "X    ", "X    ", "XXXXX"}, {"XXXXX", "X    ", "X    ", "XXXX ", "X    ", "X    ", "X    "}, {" XXX ", "X   X", "X    ", "X XXX", "X   X", "X   X", " XXXX"}, {"X   X", "X   X", "X   X", "XXXXX", "X   X", "X   X", "X   X"}, {" XXX ", "  X  ", "  X  ", "  X  ", "  X  ", "  X  ", " XXX "}, {"  XXX", "   X ", "   X ", "   X ", "   X ", "X  X ", " XX  "}, {"X   X", "X  X ", "X X  ", "XX   ", "X X  ", "X  X ", "X   X"}, {"X    ", "X    ", "X    ", "X    ", "X    ", "X    ", "XXXXX"}, {"X   X", "XX XX", "X X X", "X X X", "X   X", "X   X", "X   X"}, {"X   X", "X   X", "XX  X", "X X X", "X  XX", "X   X", "X   X"}, {" XXX ", "X   X", "X   X", "X   X", "X   X", "X   X", " XXX "}, {"XXXX ", "X   X", "X   X", "XXXX ", "X    ", "X    ", "X    "}, {" XXX ", "X   X", "X   X", "X   X", "X X X", "X  X ", " XX X"}, {"XXXX ", "X   X", "X   X", "XXXX ", "X X  ", "X  X ", "X   X"}, {" XXX ", "X   X", "X    ", " XXX ", "    X", "X   X", " XXX "}, {"XXXXX", "  X  ", "  X  ", "  X  ", "  X  ", "  X  ", "  X  "}, {"X   X", "X   X", "X   X", "X   X", "X   X", "X   X", " XXX "}, {"X   X", "X   X", "X   X", "X   X", "X   X", " X X ", "  X  "}, {"X   X", "X   X", "X   X", "X X X", "X X X", "XX XX", "X   X"}, {"X   X", "X   X", " X X ", "  X  ", " X X ", "X   X", "X   X"}, {"X   X", "X   X", " X X ", "  X  ", "  X  ", "  X  ", "  X  "}, {"XXXXX", "    X", "   X ", "  X  ", " X   ", "X    ", "XXXXX"}, {" XXX ", "X   X", "X  XX", "X X X", "XX  X", "X   X", " XXX "}, {"  X  ", " XX  ", "  X  ", "  X  ", "  X  ", "  X  ", " XXX "}, {" XXX ", "X   X", "    X", "   X ", "  X  ", " X   ", "XXXXX"}, {"XXXXX", "   X ", "  X  ", "   X ", "    X", "X   X", " XXX "}, {"   X ", "  XX ", " X X ", "X  X ", "XXXXX", "   X ", "   X "}, {"XXXXX", "X    ", "XXXX ", "    X", "    X", "X   X", " XXX "}, {"  XX ", " X   ", "X    ", "XXXX ", "X   X", "X   X", " XXX "}, {"XXXXX", "    X", "   X ", "  X  ", "  X  ", "  X  ", "  X  "}, {" XXX ", "X   X", "X   X", " XXX ", "X   X", "X   X", " XXX "}, {" XXX ", "X   X", "X   X", " XXXX", "    X", "   X ", " XX  "}, {"     ", "     ", "     ", "     ", "     ", "     ", "     "}, {"     ", "     ", "     ", "     ", "     ", " XX  ", " XX  "}, {"     ", "     ", "XXXXX", "X    ", "XXXX ", "X    ", "XXXXX"}, {"     ", "  X  ", "  X  ", "XXXXX", "  X  ", "  X  ", "     "}, {"     ", "     ", "     ", "XXXXX", "     ", "     ", "     "}, {"     ", "  X  ", "X X X", " XXX ", "X X X", "  X  ", "     "}, {"     ", "    X", "   X ", "  X  ", " X   ", "X    ", "     "}, {"     ", "     ", "     ", "     ", " XX  ", "  X  ", " X   "}, {"     ", " XX  ", " XX  ", "     ", " XX  ", "  X  ", " X   "}, {"     ", " XX  ", " XX  ", "     ", " XX  ", " XX  ", "     "}, {"  X  ", "  X  ", "  X  ", "  X  ", "  X  ", "     ", "  X  "}, {" XXX ", "X   X", "    X", "   X ", "  X  ", "     ", "  X  "}, {"  X  ", " X   ", "X    ", "X    ", "X    ", " X   ", "  X  "}, {" X   ", "  X  ", "   X ", "   X ", "   X ", "  X  ", " X   "}, {"   X ", "  X  ", " X   ", "X    ", " X   ", "  X  ", "   X "}, {"X    ", " X   ", "  X  ", "   X ", "  X  ", " X   ", "X    "}, {"     ", "     ", "XXXXX", "     ", "XXXXX", "     ", "     "}, {"XX XX", " X  X", "X  X ", "     ", "     ", "     ", "     "}, {" X X ", " X X ", "XXXXX", " X X ", "XXXXX", " X X ", " X X "}, {"  X  ", " XXXX", "X X  ", " XXX ", "  X X", "XXXX ", "  X  "}, {"  X  ", " XXX ", "X X X", "  X  ", "  X  ", "  X  ", "  X  "}, {"     ", "     ", "XXXXX", " X X ", " X X ", " X X ", "X  XX"}, {"     ", "   X ", "  X  ", " X   ", "XXXXX", "     ", "XXXXX"}, {"     ", " X   ", "  X  ", "   X ", "XXXXX", "     ", "XXXXX"}, {"     ", " X   ", "XXXXX", "  X  ", "XXXXX", "   X ", "     "}, {"     ", "     ", "     ", "     ", "     ", "     ", "XXXXX"}, {" XX  ", "  X  ", " X   ", "     ", "     ", "     ", "     "}, {"XX XX", " X  X", "X  X ", "     ", "     ", "     ", "     "}, {" XX  ", "X  X ", "X  X ", " XX  ", "     ", "     ", "     "}};
    public static final char CURSOR_CHAR = '_';
    public static final int WIDTH = 5;
    public static final int HEIGHT = 7;

    public static boolean isDisplayable(char c) {
        return drawingsByChar.containsKey(Character.valueOf(c));
    }

    public static boolean isValidStringCharacter(char c) {
        return c != '\'' && c != '\"' && c != '_' && Characters.isDisplayable(c);
    }

    public static String[] getCharacterDrawings(char c) {
        String[] drawings = drawingsByChar.get(Character.valueOf(c));
        if (drawings == null) {
            Console.reportError("Cannot find drawings for character " + c + ", value=" + c);
            return drawingsByChar.get(Character.valueOf('?'));
        }
        return drawings;
    }

    static {
        int last = CHARACTERS_ORDER.length();
        for (int i = 0; i < last; ++i) {
            drawingsByChar.put(Character.valueOf(CHARACTERS_ORDER.charAt(i)), CHARACTERS[i]);
        }
    }
}

