///////////////////////////////////////////////////////////////////////////////
//
//  Purpose     : testing the OS/2 FTP-Library for XBase++
//
//  Version     : 1.0
//
//  Last Update : Thu 18.06.1998
//
//  File        : FtpTest.prg
//
//  Copyright   : homburg Softwaretechnik, (c) 1998. All rights reserved
//
//  Contact     : Internet : http://dienstleistungen.freepage.de/shomburg
//                eMail    : shomburg@ibm.net
//
//  !! NOTE !!  : before compile the source, please check
//                the <hostname>, <username> and <password>
//                in the function "ipFtpLogin" in sourceline 73
//
//  !! NOTE !!  : before compile the source, please check your access
//                rights on the remote machine for all path and filename
//                in sourceline 135,150,168,185,199,216,251,268,285 and 286
//
///////////////////////////////////////////////////////////////////////////////
#include "xbftp.ch"

REQUEST ipFtpInit, ipFtpDeInit, ipFtpSys, ipFtpLogin
REQUEST ipFtpLogoff, ipFtpPing, ipFtpVer, ipFtpLs
REQUEST ipFtpRmd, ipFtpMkd, ipFtpCd, ipFtpDelete, ipFtpDir, ipFtpPwd
REQUEST ipFtpGet, ipFtpPut, ipFtpPutUnique, ipFtpRename
REQUEST ipFtpTraceOn, ipFtpTraceOff, ipFtpSite, ipFtpQuote

PROCEDURE Main()
  local errorCode
  local FtpHandle
  local sysMessage
  local verMessage
  local pathMessage

  set printer to "ftptest.log"
  set device to printer
  set printer on

  //
  // initialize the FTP-Library
  //
  ? ""
  ? "call ipFtpInit()"
  errorCode = ipFtpInit()
  if (errorCode != 0)
    ? "error in ipFtpInit() occured : " + alltrim(str(errorCode))
    return
  endif
  ? "XbFtp-DLL initialized successfully"
  ? "press any key ..."
  inkey()

  //
  // start Trace to file "trace.txt" in append mode
  //
  ? ""
  ? "call ipFtpTraceOn()"
  errorCode := ipFtpTraceOn("trace.txt",MODE_APPEND)
  ? "starting trace-mode ..."
  ? "press any key ..."
  inkey(0)

  //
  // "login" into the requested FTP-Server
  //
  ? ""
  ? "call ipFtpLogin()"
  FtpHandle = ipFtpLogin("hostname","username","password")
  if (FtpHandle < 0)
    ? "error in ipFtpLogin() occured : " + alltrim(str(FtpHandle))
    ipFtpDeInit()
    return
  endif

  //
  // Stores the string containing the FTP server
  // description of the operating system running
  // on the host in a buffer
  //
  ? ""
  ? "call ipFtpSys()"
  errorCode := ipFtpSys(FtpHandle,@sysMessage)
  if (errorCode == 0)
    ? ""
    ? "FTP-Server returned following Message : "
    ? "-> " + sysMessage
    ? "press any key ..."
    inkey(0)
  endif

  //
  // Stores the string containing the FTP API version
  //
  ? ""
  ? "call ipFtpVer()"
  errorCode := ipFtpVer(FtpHandle,@verMessage)
  if (errorCode == 0)
    ? ""
    ? "Your System returned following Version-String : "
    ? "-> " + verMessage
    ? "press any key ..."
    inkey(0)
  endif


  //
  // Sends a ping to the remote host to determine
  // if the host is responding
  //
  ? ""
  ? "call ipFtpPing()"
  errorCode := ipFtpPing(FtpHandle,256)
  if (errorCode == 0)
    ? ""
    ? "the Ping to the FTP-Server was successfull"
  else
    ? ""
    ? "the Ping to the FTP-Server was NOT successfull"
    ? "and returned with errorcode : " + Alltrim(str(errorCode))
  endif
  ? "press any key ..."
  inkey(0)

  //
  // gets directory information in short format
  // from a remote host and writes it to a local file.
  //
  ? ""
  ? "call ipFtpLs()"
  errorCode := ipFtpLs(FtpHandle,"ftpdir1.txt","*")
  if (errorCode == 0)
    ? "the ls at the FTP-Server was successfull"
  else
    ? "the ls at the FTP-Server was NOT successfull"
    ? "and returned with errorcode : " + Alltrim(str(errorCode))
  endif
  ? "press any key ..."
  inkey(0)

  //
  // Changes the current working directory on a host
  //
  ? ""
  ? "call ipFtpCd()"
  errorCode := ipFtpCd(FtpHandle,"/etc")
  if (errorCode == 0)
    ? ""
    ? "the cd at the FTP-Server was successfull"
  else
    ? ""
    ? "the cd at the FTP-Server was NOT successfull"
    ? "and returned with errorcode : " + Alltrim(str(errorCode))
  endif
  ? "press any key ..."
  inkey(0)

  //
  // Gets a directory in wide format
  // from a remote host and writes it to a local file.
  //
  ? ""
  ? "call ipFtpDir()"
  errorCode := ipFtpDir(FtpHandle,"ftpdir2.txt","*")
  if (errorCode == 0)
    ? ""
    ? "the dir at the FTP-Server was successfull"
  else
    ? ""
    ? "the dir at the FTP-Server was NOT successfull"
    ? "and returned with errorcode : " + Alltrim(str(errorCode))
  endif
  ? "press any key ..."
  inkey(0)

  //
  // Transfers a file to an FTP server
  //
  ? ""
  ? "call ipFtpPut()"
  errorCode := ipFtpPut(FtpHandle,"xbftp.ch","/usr/tmp/xbftp.test")
  if (errorCode == 0)
    ? ""
    ? "the file-transfer to the FTP-Server was successfull"
  else
    ? ""
    ? "the file-transfer to the FTP-Server was NOT successfull"
    ? "and returned with errorcode : " + Alltrim(str(errorCode))
  endif
  ? "press any key ..."
  inkey(0)

  ? ""
  ? "call ipFtpPutUnique()"
  errorCode := ipFtpPutUnique(FtpHandle,"xbftp.ch","/usr/tmp/xbftp.test")
  if (errorCode == 0)
    ? ""
    ? "the unique-file-transfer to the FTP-Server was successfull"
  else
    ? ""
    ? "the unique-file-transfer to the FTP-Server was NOT successfull"
    ? "and returned with errorcode : " + Alltrim(str(errorCode))
  endif
  ? "press any key ..."
  inkey(0)

  //
  // appends information to a remote file.
  //
  ? ""
  ? "call ipFtpAppend()"
  errorCode := ipFtpAppend(FtpHandle,"c:/autoexec.bat","/usr/tmp/xbftp.test")
  if (errorCode == 0)
    ? ""
    ? "the file-append to the FTP-Server was successfull"
  else
    ? ""
    ? "the file-append to the FTP-Server was NOT successfull"
    ? "and returned with errorcode : " + Alltrim(str(errorCode))
  endif
  ? "press any key ..."
  inkey(0)

  //
  // returns the actual Path on remote host
  //
  ? ""
  ? "call ipFtpPwd()"
  errorCode := ipFtpPwd(FtpHandle,@pathMessage)
  if (errorCode == 0)
    ? ""
    ? "the pwd-command at the FTP-Server was successfull"
    ? "the actual path is : " + pathMessage
  else
    ? ""
    ? "the file-delete at the FTP-Server was NOT successfull"
    ? "and returned with errorcode : " + Alltrim(str(errorCode))
  endif
  ? "press any key ..."
  inkey(0)

  //
  // gets a file from the remote host
  //
  ? ""
  ? "call ipFtpGet()"
  errorCode := ipFtpGet(FtpHandle,"ftpget.test","/usr/tmp/xbftp.test","w")
  if (errorCode == 0)
    ? ""
    ? "the file-transfer from the FTP-Server was successfull"
  else
    ? ""
    ? "the file-transfer from the FTP-Server was NOT successfull"
    ? "and returned with errorcode : " + Alltrim(str(errorCode))
  endif
  ? "press any key ..."
  inkey(0)

  //
  // Renames a file on a remote host
  //
  ? ""
  ? "call ipFtpRename()"
  errorCode := ipFtpRename(FtpHandle,"/usr/tmp/xbftp.test","/usr/tmp/xbftp.test.xxx")
  if (errorCode == 0)
    ? ""
    ? "the file-rename at the FTP-Server was successfull"
  else
    ? ""
    ? "the file-rename at the FTP-Server was NOT successfull"
    ? "and returned with errorcode : " + Alltrim(str(errorCode))
  endif
  ? "press any key ..."
  inkey(0)

  //
  // Deletes files on a remote host
  //
  ? ""
  ? "call ipFtpDelete()"
  errorCode := ipFtpDelete(FtpHandle,"/usr/tmp/xbftp.test.xxx")
  errorCode := ipFtpDelete(FtpHandle,"/usr/tmp/xbftp.test.1")
  if (errorCode == 0)
    ? ""
    ? "the file-delete at the FTP-Server was successfull"
  else
    ? ""
    ? "the file-delete at the FTP-Server was NOT successfull"
    ? "and returned with errorcode : " + Alltrim(str(errorCode))
  endif
  ? "press any key ..."
  inkey(0)

  //
  // Executes the SITE command
  //
  ? ""
  ? "call ipFtpSite()"
  errorCode := ipFtpSite(FtpHandle,"idle 2000")
  if (errorCode == 0)
    ? ""
    ? "the sitecommand at the FTP-Server was successfull"
  else
    ? ""
    ? "the sitecommand at the FTP-Server was NOT successfull"
    ? "and returned with errorcode : " + Alltrim(str(errorCode))
  endif
  ? "press any key ..."
  inkey(0)

  //
  // Executes the QUOTE command
  //
  ? ""
  ? "call ipFtpQuote()"
  errorCode := ipFtpQuote(FtpHandle,"site idle 1500")
  if (errorCode == 0)
    ? ""
    ? "the quotecommand at the FTP-Server was successfull"
  else
    ? ""
    ? "the quotecommand at the FTP-Server was NOT successfull"
    ? "and returned with errorcode : " + Alltrim(str(errorCode))
  endif
  ? "press any key ..."
  inkey(0)

  //
  // Closes the current connections
  //
  ? ""
  ? "call ipFtpLogoff()"
  errorCode = ipFtpLogoff(FtpHandle)
  if (errorCode == 0)
    ? ""
    ? "the logoff  was successfull"
  else
    ? ""
    ? "the logoff was NOT successfull"
    ? "and returned with errorcode : " + Alltrim(str(errorCode))
  endif
  ? "press any key ..."
  inkey(0)

  //
  // Closes the trace file, and stops tracing of
  // the command and reply sequences that were
  // sent over the control connection between the
  // local and remote hosts
  //
  ? ""
  ? "call ipFtpTraceOff()"
  ipFtpTraceOff()

  //
  // Closes all current connections and deinit the library
  //
  ? ""
  ? "call ipFtpDeInit()"
  ipFtpDeInit()

  ? ""
  ? "ready with demo"
  ? "press any key to exit"
  inkey(0)

  return


